/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.bigquery.FormatOptions;
import com.google.common.base.MoreObjects;
import java.util.Objects;

public final class GoogleSheetsOptions
extends FormatOptions {
    private static final long serialVersionUID = 1837436979033106123L;
    private final Long skipLeadingRows;

    private GoogleSheetsOptions(Builder builder) {
        super("GOOGLE_SHEETS");
        this.skipLeadingRows = builder.skipLeadingRows;
    }

    public Long getSkipLeadingRows() {
        return this.skipLeadingRows;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.getType()).add("skipLeadingRows", (Object)this.skipLeadingRows).toString();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getType(), this.skipLeadingRows);
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj instanceof GoogleSheetsOptions && Objects.equals(this.toPb(), ((GoogleSheetsOptions)obj).toPb());
    }

    com.google.api.services.bigquery.model.GoogleSheetsOptions toPb() {
        com.google.api.services.bigquery.model.GoogleSheetsOptions options = new com.google.api.services.bigquery.model.GoogleSheetsOptions();
        options.setSkipLeadingRows(this.skipLeadingRows);
        return options;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    static GoogleSheetsOptions fromPb(com.google.api.services.bigquery.model.GoogleSheetsOptions options) {
        Builder builder = GoogleSheetsOptions.newBuilder();
        if (options.getSkipLeadingRows() != null) {
            builder.setSkipLeadingRows(options.getSkipLeadingRows());
        }
        return builder.build();
    }

    public static final class Builder {
        private Long skipLeadingRows;

        private Builder() {
        }

        private Builder(GoogleSheetsOptions options) {
            this.skipLeadingRows = options.skipLeadingRows;
        }

        public Builder setSkipLeadingRows(long skipLeadingRows) {
            this.skipLeadingRows = skipLeadingRows;
            return this;
        }

        public GoogleSheetsOptions build() {
            return new GoogleSheetsOptions(this);
        }
    }
}

