/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.JobReference;
import com.google.cloud.bigquery.AutoValue_JobId;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.UUID;
import javax.annotation.Nullable;

public abstract class JobId
implements Serializable {
    private static final long serialVersionUID = 1225914835379688977L;

    JobId() {
    }

    @Nullable
    public abstract String getProject();

    @Nullable
    public abstract String getJob();

    @Nullable
    abstract String getLocation();

    public abstract Builder toBuilder();

    public static Builder newBuilder() {
        return new AutoValue_JobId.Builder();
    }

    public static JobId of(String project, String job) {
        return JobId.newBuilder().setProject((String)Preconditions.checkNotNull((Object)project)).setJob((String)Preconditions.checkNotNull((Object)job)).build();
    }

    public static JobId of(String job) {
        return JobId.newBuilder().setJob((String)Preconditions.checkNotNull((Object)job)).build();
    }

    public static JobId of() {
        return JobId.newBuilder().setRandomJob().build();
    }

    JobId setProjectId(String projectId) {
        return this.getProject() != null ? this : this.toBuilder().setProject(projectId).build();
    }

    JobReference toPb() {
        return new JobReference().setProjectId(this.getProject()).setJobId(this.getJob()).setLocation(this.getLocation());
    }

    static JobId fromPb(JobReference jobRef) {
        return JobId.newBuilder().setProject(jobRef.getProjectId()).setJob(jobRef.getJobId()).setLocation(jobRef.getLocation()).build();
    }

    public static abstract class Builder {
        public abstract Builder setProject(String var1);

        public abstract Builder setJob(String var1);

        public Builder setRandomJob() {
            return this.setJob(UUID.randomUUID().toString());
        }

        abstract Builder setLocation(String var1);

        public abstract JobId build();
    }
}

