/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.gax.paging.Page;
import com.google.cloud.bigquery.FieldValueList;
import com.google.cloud.bigquery.Schema;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

public class TableResult
implements Page<FieldValueList>,
Serializable {
    private static final long serialVersionUID = -4831062717210349819L;
    @Nullable
    private final Schema schema;
    private final long totalRows;
    private final Page<FieldValueList> pageNoSchema;

    TableResult(Schema schema, long totalRows, Page<FieldValueList> pageNoSchema) {
        this.schema = schema;
        this.totalRows = totalRows;
        this.pageNoSchema = (Page)Preconditions.checkNotNull(pageNoSchema);
    }

    public Schema getSchema() {
        return this.schema;
    }

    public long getTotalRows() {
        return this.totalRows;
    }

    public boolean hasNextPage() {
        return this.pageNoSchema.hasNextPage();
    }

    public String getNextPageToken() {
        return this.pageNoSchema.getNextPageToken();
    }

    public TableResult getNextPage() {
        if (this.pageNoSchema.hasNextPage()) {
            return new TableResult(this.schema, this.totalRows, (Page<FieldValueList>)this.pageNoSchema.getNextPage());
        }
        return null;
    }

    public Iterable<FieldValueList> iterateAll() {
        return this.addSchema(this.pageNoSchema.iterateAll());
    }

    public Iterable<FieldValueList> getValues() {
        return this.addSchema(this.pageNoSchema.getValues());
    }

    private Iterable<FieldValueList> addSchema(Iterable<FieldValueList> iter) {
        if (this.schema == null) {
            return iter;
        }
        return Iterables.transform(iter, (Function)new Function<FieldValueList, FieldValueList>(){

            public FieldValueList apply(FieldValueList list) {
                return list.withSchema(TableResult.this.schema.getFields());
            }
        });
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("rows", this.getValues()).add("schema", (Object)this.schema).add("totalRows", this.totalRows).add("cursor", (Object)this.getNextPageToken()).toString();
    }

    public final int hashCode() {
        return Objects.hash(this.pageNoSchema, this.schema, this.totalRows);
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(TableResult.class)) {
            return false;
        }
        TableResult response = (TableResult)obj;
        return Objects.equals(this.getNextPageToken(), response.getNextPageToken()) && Iterators.elementsEqual(this.getValues().iterator(), response.getValues().iterator()) && Objects.equals(this.schema, response.schema) && this.totalRows == response.totalRows;
    }
}

