/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.ServiceDefaults;
import com.google.cloud.ServiceOptions;
import com.google.cloud.ServiceRpc;
import com.google.cloud.TransportOptions;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryFactory;
import com.google.cloud.bigquery.BigQueryImpl;
import com.google.cloud.bigquery.spi.BigQueryRpcFactory;
import com.google.cloud.bigquery.spi.v2.BigQueryRpc;
import com.google.cloud.bigquery.spi.v2.HttpBigQueryRpc;
import com.google.cloud.http.HttpTransportOptions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;

public class BigQueryOptions
extends ServiceOptions<BigQuery, BigQueryOptions> {
    private static final String API_SHORT_NAME = "BigQuery";
    private static final String BIGQUERY_SCOPE = "https://www.googleapis.com/auth/bigquery";
    private static final Set<String> SCOPES = ImmutableSet.of((Object)"https://www.googleapis.com/auth/bigquery");
    private static final long serialVersionUID = -2437598817433266049L;
    private final String location;
    private boolean setThrowNotFound;

    private BigQueryOptions(Builder builder) {
        super(BigQueryFactory.class, BigQueryRpcFactory.class, (ServiceOptions.Builder)builder, (ServiceDefaults)new BigQueryDefaults());
        this.location = builder.location;
    }

    public static HttpTransportOptions getDefaultHttpTransportOptions() {
        return HttpTransportOptions.newBuilder().build();
    }

    protected Set<String> getScopes() {
        return SCOPES;
    }

    protected BigQueryRpc getBigQueryRpcV2() {
        return (BigQueryRpc)this.getRpc();
    }

    public String getLocation() {
        return this.location;
    }

    public void setThrowNotFound(boolean setThrowNotFound) {
        this.setThrowNotFound = setThrowNotFound;
    }

    public boolean getThrowNotFound() {
        return this.setThrowNotFound;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public int hashCode() {
        return this.baseHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BigQueryOptions)) {
            return false;
        }
        BigQueryOptions other = (BigQueryOptions)((Object)obj);
        return this.baseEquals(other);
    }

    public static BigQueryOptions getDefaultInstance() {
        return BigQueryOptions.newBuilder().build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private static class BigQueryDefaults
    implements ServiceDefaults<BigQuery, BigQueryOptions> {
        private BigQueryDefaults() {
        }

        public BigQueryFactory getDefaultServiceFactory() {
            return DefaultBigQueryFactory.INSTANCE;
        }

        public BigQueryRpcFactory getDefaultRpcFactory() {
            return DefaultBigQueryRpcFactory.INSTANCE;
        }

        public TransportOptions getDefaultTransportOptions() {
            return BigQueryOptions.getDefaultHttpTransportOptions();
        }
    }

    public static class Builder
    extends ServiceOptions.Builder<BigQuery, BigQueryOptions, Builder> {
        private String location;

        private Builder() {
        }

        private Builder(BigQueryOptions options) {
            super((ServiceOptions)options);
        }

        public Builder setTransportOptions(TransportOptions transportOptions) {
            if (!(transportOptions instanceof HttpTransportOptions)) {
                throw new IllegalArgumentException("Only http transport is allowed for BigQuery.");
            }
            return (Builder)super.setTransportOptions(transportOptions);
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public BigQueryOptions build() {
            return new BigQueryOptions(this);
        }
    }

    public static class DefaultBigQueryRpcFactory
    implements BigQueryRpcFactory {
        private static final BigQueryRpcFactory INSTANCE = new DefaultBigQueryRpcFactory();

        public ServiceRpc create(BigQueryOptions options) {
            return new HttpBigQueryRpc(options);
        }
    }

    public static class DefaultBigQueryFactory
    implements BigQueryFactory {
        private static final BigQueryFactory INSTANCE = new DefaultBigQueryFactory();

        public BigQuery create(BigQueryOptions options) {
            return new BigQueryImpl(options);
        }
    }
}

