/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldList;
import com.google.cloud.bigquery.FieldValue;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FieldValueList
extends AbstractList<FieldValue>
implements Serializable {
    private static final long serialVersionUID = 2103346761764976902L;
    private final FieldList schema;
    private final List<FieldValue> row;

    private FieldValueList(List<FieldValue> row, FieldList schema) {
        if (schema != null && row.size() != schema.size()) {
            throw new IllegalArgumentException("Row size and fields schema sizes should match");
        }
        this.row = ImmutableList.copyOf(row);
        this.schema = schema;
    }

    @Override
    public FieldValue get(int index) {
        return this.row.get(index);
    }

    public FieldValue get(String name) {
        if (this.schema == null) {
            throw new UnsupportedOperationException("Retrieving field value by name is not supported when there is no fields schema provided");
        }
        return this.get(this.schema.getIndex(name));
    }

    public boolean hasSchema() {
        return this.schema != null;
    }

    @Override
    public int size() {
        return this.row.size();
    }

    static FieldValueList of(List<FieldValue> row, FieldList schema) {
        return new FieldValueList(row, schema);
    }

    static FieldValueList of(List<FieldValue> row, Field ... schema) {
        return FieldValueList.of(row, schema.length > 0 ? FieldList.of(schema) : null);
    }

    FieldValueList withSchema(FieldList schema) {
        return new FieldValueList(this.row, schema);
    }

    static FieldValueList fromPb(List<?> rowPb, FieldList schema) {
        ArrayList<FieldValue> row = new ArrayList<FieldValue>(rowPb.size());
        if (schema != null) {
            if (schema.size() != rowPb.size()) {
                throw new IllegalArgumentException("Row size and fields schema sizes should match");
            }
            Iterator schemaIter = schema.iterator();
            Iterator<?> rowPbIter = rowPb.iterator();
            while (rowPbIter.hasNext() && schemaIter.hasNext()) {
                row.add(FieldValue.fromPb(rowPbIter.next(), (Field)schemaIter.next()));
            }
        } else {
            for (Object cellPb : rowPb) {
                row.add(FieldValue.fromPb(cellPb, null));
            }
        }
        return FieldValueList.of(row, schema);
    }
}

