/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.BaseWriteChannel;
import com.google.cloud.Clock;
import com.google.cloud.ExceptionHandler;
import com.google.cloud.RestorableState;
import com.google.cloud.RetryHelper;
import com.google.cloud.RetryParams;
import com.google.cloud.ServiceOptions;
import com.google.cloud.WriteChannel;
import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.BigQueryImpl;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.WriteChannelConfiguration;
import com.google.cloud.bigquery.spi.BigQueryRpc;
import java.io.Serializable;
import java.util.concurrent.Executors;

class TableDataWriteChannel
extends BaseWriteChannel<BigQueryOptions, WriteChannelConfiguration> {
    TableDataWriteChannel(BigQueryOptions options, WriteChannelConfiguration writeChannelConfiguration) {
        this(options, writeChannelConfiguration, ((BigQueryRpc)options.rpc()).open(writeChannelConfiguration.toPb()));
    }

    TableDataWriteChannel(BigQueryOptions options, WriteChannelConfiguration config, String uploadId) {
        super((ServiceOptions)options, (Serializable)config, uploadId);
    }

    protected void flushBuffer(final int length, final boolean last) {
        try {
            RetryHelper.runWithRetries(Executors.callable(new Runnable(){

                @Override
                public void run() {
                    ((BigQueryRpc)((BigQueryOptions)TableDataWriteChannel.this.options()).rpc()).write(TableDataWriteChannel.this.uploadId(), TableDataWriteChannel.this.buffer(), 0, TableDataWriteChannel.this.position(), length, last);
                }
            }), (RetryParams)((BigQueryOptions)this.options()).retryParams(), (ExceptionHandler)BigQueryImpl.EXCEPTION_HANDLER, (Clock)((BigQueryOptions)this.options()).clock());
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    protected StateImpl.Builder stateBuilder() {
        return StateImpl.builder((BigQueryOptions)this.options(), (WriteChannelConfiguration)this.entity(), this.uploadId());
    }

    static class StateImpl
    extends BaseWriteChannel.BaseState<BigQueryOptions, WriteChannelConfiguration> {
        private static final long serialVersionUID = -787362105981823738L;

        StateImpl(Builder builder) {
            super((BaseWriteChannel.BaseState.Builder)builder);
        }

        static Builder builder(BigQueryOptions options, WriteChannelConfiguration config, String uploadId) {
            return new Builder(options, config, uploadId);
        }

        public WriteChannel restore() {
            TableDataWriteChannel channel = new TableDataWriteChannel((BigQueryOptions)this.serviceOptions, (WriteChannelConfiguration)this.entity, this.uploadId);
            channel.restore(this);
            return channel;
        }

        static class Builder
        extends BaseWriteChannel.BaseState.Builder<BigQueryOptions, WriteChannelConfiguration> {
            private Builder(BigQueryOptions options, WriteChannelConfiguration configuration, String uploadId) {
                super((ServiceOptions)options, (Serializable)configuration, uploadId);
            }

            public RestorableState<WriteChannel> build() {
                return new StateImpl(this);
            }
        }
    }
}

