/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.QueryParameter;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.QueryParameterValue;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class QueryRequest
implements Serializable {
    private static final long serialVersionUID = -8727328332415880852L;
    private final String query;
    private final ImmutableList<QueryParameterValue> positionalParameters;
    private final ImmutableMap<String, QueryParameterValue> namedParameters;
    private final Long pageSize;
    private final DatasetId defaultDataset;
    private final Long maxWaitTime;
    private final Boolean dryRun;
    private final Boolean useQueryCache;
    private final Boolean useLegacySql;
    static final Function<QueryParameter, QueryParameterValue> POSITIONAL_PARAMETER_FROM_PB_FUNCTION = new Function<QueryParameter, QueryParameterValue>(){

        public QueryParameterValue apply(QueryParameter pb) {
            return QueryRequest.positionalParameterFromPb(pb);
        }
    };
    static final Function<QueryParameterValue, QueryParameter> POSITIONAL_PARAMETER_TO_PB_FUNCTION = new Function<QueryParameterValue, QueryParameter>(){

        public QueryParameter apply(QueryParameterValue value) {
            return QueryRequest.positionalParameterToPb(value);
        }
    };
    static final Function<Map.Entry<String, QueryParameterValue>, QueryParameter> NAMED_PARAMETER_TO_PB_FUNCTION = new Function<Map.Entry<String, QueryParameterValue>, QueryParameter>(){

        public QueryParameter apply(Map.Entry<String, QueryParameterValue> value) {
            return QueryRequest.namedParameterToPb(value);
        }
    };

    private QueryRequest(Builder builder) {
        this.query = builder.query;
        Preconditions.checkNotNull((Object)builder.positionalParameters);
        Preconditions.checkNotNull((Object)builder.namedParameters);
        if (!builder.positionalParameters.isEmpty()) {
            Preconditions.checkArgument((boolean)builder.namedParameters.isEmpty());
        }
        if (!builder.namedParameters.isEmpty()) {
            Preconditions.checkArgument((boolean)builder.positionalParameters.isEmpty());
        }
        this.positionalParameters = ImmutableList.copyOf((Collection)builder.positionalParameters);
        this.namedParameters = ImmutableMap.copyOf((Map)builder.namedParameters);
        this.pageSize = builder.pageSize;
        this.defaultDataset = builder.defaultDataset;
        this.maxWaitTime = builder.maxWaitTime;
        this.dryRun = builder.dryRun;
        this.useQueryCache = builder.useQueryCache;
        this.useLegacySql = builder.useLegacySql;
    }

    public String getQuery() {
        return this.query;
    }

    public List<QueryParameterValue> getPositionalParameters() {
        return this.positionalParameters;
    }

    public Map<String, QueryParameterValue> getNamedParameters() {
        return this.namedParameters;
    }

    public Long getPageSize() {
        return this.pageSize;
    }

    public DatasetId getDefaultDataset() {
        return this.defaultDataset;
    }

    public Long getMaxWaitTime() {
        return this.maxWaitTime;
    }

    public Boolean dryRun() {
        return this.dryRun;
    }

    public Boolean useQueryCache() {
        return this.useQueryCache;
    }

    public Boolean useLegacySql() {
        return this.useLegacySql;
    }

    public Builder toBuilder() {
        return new Builder().setQuery(this.query).setPositionalParameters((Iterable<QueryParameterValue>)this.positionalParameters).setNamedParameters((Map<String, QueryParameterValue>)this.namedParameters).setPageSize(this.pageSize).setDefaultDataset(this.defaultDataset).setMaxWaitTime(this.maxWaitTime).setDryRun(this.dryRun).setUseQueryCache(this.useQueryCache).setUseLegacySql(this.useLegacySql);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("query", (Object)this.query).add("positionalParameters", this.positionalParameters).add("namedParameters", this.namedParameters).add("pageSize", (Object)this.pageSize).add("defaultDataset", (Object)this.defaultDataset).add("maxWaitTime", (Object)this.maxWaitTime).add("dryRun", (Object)this.dryRun).add("useQueryCache", (Object)this.useQueryCache).add("useLegacySql", (Object)this.useLegacySql).toString();
    }

    public int hashCode() {
        return Objects.hash(this.query, this.positionalParameters, this.namedParameters, this.pageSize, this.defaultDataset, this.maxWaitTime, this.dryRun, this.useQueryCache, this.useLegacySql);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof QueryRequest && Objects.equals(this.toPb(), ((QueryRequest)obj).toPb());
    }

    QueryRequest setProjectId(String projectId) {
        Builder builder = this.toBuilder();
        if (this.getDefaultDataset() != null) {
            builder.setDefaultDataset(this.getDefaultDataset().setProjectId(projectId));
        }
        return builder.build();
    }

    com.google.api.services.bigquery.model.QueryRequest toPb() {
        com.google.api.services.bigquery.model.QueryRequest queryRequestPb = new com.google.api.services.bigquery.model.QueryRequest().setQuery(this.query);
        if (!this.positionalParameters.isEmpty()) {
            List queryParametersPb = Lists.transform(this.positionalParameters, POSITIONAL_PARAMETER_TO_PB_FUNCTION);
            queryRequestPb.setQueryParameters(queryParametersPb);
        } else if (!this.namedParameters.isEmpty()) {
            List queryParametersPb = Lists.transform((List)this.namedParameters.entrySet().asList(), NAMED_PARAMETER_TO_PB_FUNCTION);
            queryRequestPb.setQueryParameters(queryParametersPb);
        }
        if (this.pageSize != null) {
            queryRequestPb.setMaxResults(this.pageSize);
        }
        if (this.defaultDataset != null) {
            queryRequestPb.setDefaultDataset(this.defaultDataset.toPb());
        }
        if (this.maxWaitTime != null) {
            queryRequestPb.setTimeoutMs(this.maxWaitTime);
        }
        if (this.dryRun != null) {
            queryRequestPb.setDryRun(this.dryRun);
        }
        if (this.useQueryCache != null) {
            queryRequestPb.setUseQueryCache(this.useQueryCache);
        }
        if (this.useLegacySql != null) {
            queryRequestPb.setUseLegacySql(this.useLegacySql);
        }
        return queryRequestPb;
    }

    public static Builder newBuilder(String query) {
        return new Builder().setQuery(query);
    }

    public static QueryRequest of(String query) {
        return new Builder().setQuery(query).build();
    }

    static QueryRequest fromPb(com.google.api.services.bigquery.model.QueryRequest queryRequestPb) {
        Builder builder = QueryRequest.newBuilder(queryRequestPb.getQuery());
        if (queryRequestPb.getQueryParameters() != null && !queryRequestPb.getQueryParameters().isEmpty()) {
            if (((QueryParameter)queryRequestPb.getQueryParameters().get(0)).getName() == null) {
                builder.setPositionalParameters(Lists.transform((List)queryRequestPb.getQueryParameters(), POSITIONAL_PARAMETER_FROM_PB_FUNCTION));
            } else {
                HashMap values = Maps.newHashMap();
                for (QueryParameter queryParameterPb : queryRequestPb.getQueryParameters()) {
                    Preconditions.checkNotNull((Object)queryParameterPb.getName());
                    QueryParameterValue value = QueryParameterValue.fromPb(queryParameterPb.getParameterValue(), queryParameterPb.getParameterType());
                    values.put(queryParameterPb.getName(), value);
                }
                builder.setNamedParameters(values);
            }
        }
        if (queryRequestPb.getMaxResults() != null) {
            builder.setPageSize(queryRequestPb.getMaxResults());
        }
        if (queryRequestPb.getDefaultDataset() != null) {
            builder.setDefaultDataset(DatasetId.fromPb(queryRequestPb.getDefaultDataset()));
        }
        if (queryRequestPb.getTimeoutMs() != null) {
            builder.setMaxWaitTime(queryRequestPb.getTimeoutMs());
        }
        if (queryRequestPb.getDryRun() != null) {
            builder.setDryRun(queryRequestPb.getDryRun());
        }
        if (queryRequestPb.getUseQueryCache() != null) {
            builder.setUseQueryCache(queryRequestPb.getUseQueryCache());
        }
        if (queryRequestPb.getUseLegacySql() != null) {
            builder.setUseLegacySql(queryRequestPb.getUseLegacySql());
        }
        return builder.build();
    }

    static QueryParameter namedParameterToPb(Map.Entry<String, QueryParameterValue> entry) {
        QueryParameter queryParameterPb = new QueryParameter();
        queryParameterPb.setName(entry.getKey());
        queryParameterPb.setParameterValue(entry.getValue().toValuePb());
        queryParameterPb.setParameterType(entry.getValue().toTypePb());
        return queryParameterPb;
    }

    static QueryParameter positionalParameterToPb(QueryParameterValue value) {
        QueryParameter queryParameterPb = new QueryParameter();
        queryParameterPb.setParameterValue(value.toValuePb());
        queryParameterPb.setParameterType(value.toTypePb());
        return queryParameterPb;
    }

    static QueryParameterValue positionalParameterFromPb(QueryParameter queryParameterPb) {
        Preconditions.checkArgument((queryParameterPb.getName() == null ? 1 : 0) != 0);
        return QueryParameterValue.fromPb(queryParameterPb.getParameterValue(), queryParameterPb.getParameterType());
    }

    public static final class Builder {
        private String query;
        private List<QueryParameterValue> positionalParameters = Lists.newArrayList();
        private Map<String, QueryParameterValue> namedParameters = Maps.newHashMap();
        private Long pageSize;
        private DatasetId defaultDataset;
        private Long maxWaitTime;
        private Boolean dryRun;
        private Boolean useQueryCache;
        private Boolean useLegacySql;

        private Builder() {
        }

        public Builder setQuery(String query) {
            this.query = (String)Preconditions.checkNotNull((Object)query);
            return this;
        }

        public Builder addPositionalParameter(QueryParameterValue value) {
            Preconditions.checkNotNull((Object)value);
            if (!this.namedParameters.isEmpty()) {
                throw new IllegalStateException("Positional parameters can't be combined with named parameters");
            }
            this.positionalParameters.add(value);
            return this;
        }

        public Builder setPositionalParameters(Iterable<QueryParameterValue> values) {
            if (values == null || Iterables.isEmpty(values)) {
                this.positionalParameters = Lists.newArrayList();
            } else {
                if (!this.namedParameters.isEmpty()) {
                    throw new IllegalStateException("Positional parameters can't be combined with named parameters");
                }
                this.positionalParameters = Lists.newArrayList(values);
            }
            return this;
        }

        public Builder addNamedParameter(String name, QueryParameterValue value) {
            Preconditions.checkNotNull((Object)value);
            if (!this.positionalParameters.isEmpty()) {
                throw new IllegalStateException("Named parameters can't be combined with positional parameters");
            }
            this.namedParameters.put(name, value);
            return this;
        }

        public Builder setNamedParameters(Map<String, QueryParameterValue> values) {
            if (values == null || values.isEmpty()) {
                this.namedParameters = Maps.newHashMap();
            } else {
                if (!this.positionalParameters.isEmpty()) {
                    throw new IllegalStateException("Named parameters can't be combined with positional parameters");
                }
                this.namedParameters = Maps.newHashMap(values);
            }
            return this;
        }

        public Builder setPageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Builder setDefaultDataset(DatasetId defaultDataset) {
            this.defaultDataset = defaultDataset;
            return this;
        }

        public Builder setDefaultDataset(String defaultDataset) {
            return this.setDefaultDataset(DatasetId.of(defaultDataset));
        }

        public Builder setMaxWaitTime(Long maxWaitTime) {
            this.maxWaitTime = maxWaitTime;
            return this;
        }

        public Builder setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public Builder setUseQueryCache(Boolean useQueryCache) {
            this.useQueryCache = useQueryCache;
            return this;
        }

        public Builder setUseLegacySql(Boolean useLegacySql) {
            this.useLegacySql = useLegacySql;
            return this;
        }

        public QueryRequest build() {
            return new QueryRequest(this);
        }
    }
}

