/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.JobConfigurationTableCopy;
import com.google.cloud.bigquery.JobConfiguration;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.TableId;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;

public final class CopyJobConfiguration
extends JobConfiguration {
    private static final long serialVersionUID = 1140509641399762967L;
    private final List<TableId> sourceTables;
    private final TableId destinationTable;
    private final JobInfo.CreateDisposition createDisposition;
    private final JobInfo.WriteDisposition writeDisposition;

    private CopyJobConfiguration(Builder builder) {
        super(builder);
        this.sourceTables = (List)Preconditions.checkNotNull((Object)builder.sourceTables);
        this.destinationTable = (TableId)Preconditions.checkNotNull((Object)builder.destinationTable);
        this.createDisposition = builder.createDisposition;
        this.writeDisposition = builder.writeDisposition;
    }

    public List<TableId> getSourceTables() {
        return this.sourceTables;
    }

    public TableId getDestinationTable() {
        return this.destinationTable;
    }

    public JobInfo.CreateDisposition getCreateDisposition() {
        return this.createDisposition;
    }

    public JobInfo.WriteDisposition getWriteDisposition() {
        return this.writeDisposition;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("sourceTables", this.sourceTables).add("destinationTable", (Object)this.destinationTable).add("createDisposition", (Object)this.createDisposition).add("writeDisposition", (Object)this.writeDisposition);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof CopyJobConfiguration && this.baseEquals((CopyJobConfiguration)obj);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.baseHashCode(), this.sourceTables, this.destinationTable, this.createDisposition, this.writeDisposition});
    }

    @Override
    CopyJobConfiguration setProjectId(final String projectId) {
        Builder builder = this.toBuilder();
        builder.setSourceTables(Lists.transform(this.getSourceTables(), (Function)new Function<TableId, TableId>(){

            public TableId apply(TableId tableId) {
                return tableId.setProjectId(projectId);
            }
        }));
        builder.setDestinationTable(this.getDestinationTable().setProjectId(projectId));
        return builder.build();
    }

    @Override
    com.google.api.services.bigquery.model.JobConfiguration toPb() {
        JobConfigurationTableCopy configurationPb = new JobConfigurationTableCopy();
        configurationPb.setDestinationTable(this.destinationTable.toPb());
        if (this.sourceTables.size() == 1) {
            configurationPb.setSourceTable(this.sourceTables.get(0).toPb());
        } else {
            configurationPb.setSourceTables(Lists.transform(this.sourceTables, TableId.TO_PB_FUNCTION));
        }
        if (this.createDisposition != null) {
            configurationPb.setCreateDisposition(this.createDisposition.toString());
        }
        if (this.writeDisposition != null) {
            configurationPb.setWriteDisposition(this.writeDisposition.toString());
        }
        return new com.google.api.services.bigquery.model.JobConfiguration().setCopy(configurationPb);
    }

    public static Builder newBuilder(TableId destinationTable, TableId sourceTable) {
        return CopyJobConfiguration.newBuilder(destinationTable, (List<TableId>)ImmutableList.of((Object)Preconditions.checkNotNull((Object)sourceTable)));
    }

    public static Builder newBuilder(TableId destinationTable, List<TableId> sourceTables) {
        return new Builder().setDestinationTable(destinationTable).setSourceTables(sourceTables);
    }

    public static CopyJobConfiguration of(TableId destinationTable, TableId sourceTable) {
        return CopyJobConfiguration.newBuilder(destinationTable, sourceTable).build();
    }

    public static CopyJobConfiguration of(TableId destinationTable, List<TableId> sourceTables) {
        return CopyJobConfiguration.newBuilder(destinationTable, sourceTables).build();
    }

    static CopyJobConfiguration fromPb(com.google.api.services.bigquery.model.JobConfiguration jobPb) {
        return new Builder(jobPb).build();
    }

    public static final class Builder
    extends JobConfiguration.Builder<CopyJobConfiguration, Builder> {
        private List<TableId> sourceTables;
        private TableId destinationTable;
        private JobInfo.CreateDisposition createDisposition;
        private JobInfo.WriteDisposition writeDisposition;

        private Builder() {
            super(JobConfiguration.Type.COPY);
        }

        private Builder(CopyJobConfiguration jobConfiguration) {
            this();
            this.sourceTables = jobConfiguration.sourceTables;
            this.destinationTable = jobConfiguration.destinationTable;
            this.createDisposition = jobConfiguration.createDisposition;
            this.writeDisposition = jobConfiguration.writeDisposition;
        }

        private Builder(com.google.api.services.bigquery.model.JobConfiguration configurationPb) {
            this();
            JobConfigurationTableCopy copyConfigurationPb = configurationPb.getCopy();
            this.destinationTable = TableId.fromPb(copyConfigurationPb.getDestinationTable());
            this.sourceTables = copyConfigurationPb.getSourceTables() != null ? Lists.transform((List)copyConfigurationPb.getSourceTables(), TableId.FROM_PB_FUNCTION) : ImmutableList.of((Object)TableId.fromPb(copyConfigurationPb.getSourceTable()));
            if (copyConfigurationPb.getCreateDisposition() != null) {
                this.createDisposition = JobInfo.CreateDisposition.valueOf(copyConfigurationPb.getCreateDisposition());
            }
            if (copyConfigurationPb.getWriteDisposition() != null) {
                this.writeDisposition = JobInfo.WriteDisposition.valueOf(copyConfigurationPb.getWriteDisposition());
            }
        }

        public Builder setSourceTables(List<TableId> sourceTables) {
            this.sourceTables = sourceTables != null ? ImmutableList.copyOf(sourceTables) : null;
            return this;
        }

        public Builder setDestinationTable(TableId destinationTable) {
            this.destinationTable = destinationTable;
            return this;
        }

        public Builder setCreateDisposition(JobInfo.CreateDisposition createDisposition) {
            this.createDisposition = createDisposition;
            return this;
        }

        public Builder setWriteDisposition(JobInfo.WriteDisposition writeDisposition) {
            this.writeDisposition = writeDisposition;
            return this;
        }

        @Override
        public CopyJobConfiguration build() {
            return new CopyJobConfiguration(this);
        }
    }
}

