/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.beyondcorp.clientgateways.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.beyondcorp.clientgateways.v1.ClientGateway;
import com.google.cloud.beyondcorp.clientgateways.v1.ClientGatewayOperationMetadata;
import com.google.cloud.beyondcorp.clientgateways.v1.ClientGatewaysServiceClient;
import com.google.cloud.beyondcorp.clientgateways.v1.CreateClientGatewayRequest;
import com.google.cloud.beyondcorp.clientgateways.v1.DeleteClientGatewayRequest;
import com.google.cloud.beyondcorp.clientgateways.v1.GetClientGatewayRequest;
import com.google.cloud.beyondcorp.clientgateways.v1.ListClientGatewaysRequest;
import com.google.cloud.beyondcorp.clientgateways.v1.ListClientGatewaysResponse;
import com.google.cloud.beyondcorp.clientgateways.v1.stub.ClientGatewaysServiceStub;
import com.google.cloud.beyondcorp.clientgateways.v1.stub.GrpcClientGatewaysServiceStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class ClientGatewaysServiceStubSettings
extends StubSettings<ClientGatewaysServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListClientGatewaysRequest, ListClientGatewaysResponse, ClientGatewaysServiceClient.ListClientGatewaysPagedResponse> listClientGatewaysSettings;
    private final UnaryCallSettings<GetClientGatewayRequest, ClientGateway> getClientGatewaySettings;
    private final UnaryCallSettings<CreateClientGatewayRequest, Operation> createClientGatewaySettings;
    private final OperationCallSettings<CreateClientGatewayRequest, ClientGateway, ClientGatewayOperationMetadata> createClientGatewayOperationSettings;
    private final UnaryCallSettings<DeleteClientGatewayRequest, Operation> deleteClientGatewaySettings;
    private final OperationCallSettings<DeleteClientGatewayRequest, Empty, ClientGatewayOperationMetadata> deleteClientGatewayOperationSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, ClientGatewaysServiceClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListClientGatewaysRequest, ListClientGatewaysResponse, ClientGateway> LIST_CLIENT_GATEWAYS_PAGE_STR_DESC = new PagedListDescriptor<ListClientGatewaysRequest, ListClientGatewaysResponse, ClientGateway>(){

        public String emptyToken() {
            return "";
        }

        public ListClientGatewaysRequest injectToken(ListClientGatewaysRequest payload, String token) {
            return ListClientGatewaysRequest.newBuilder((ListClientGatewaysRequest)payload).setPageToken(token).build();
        }

        public ListClientGatewaysRequest injectPageSize(ListClientGatewaysRequest payload, int pageSize) {
            return ListClientGatewaysRequest.newBuilder((ListClientGatewaysRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListClientGatewaysRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListClientGatewaysResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ClientGateway> extractResources(ListClientGatewaysResponse payload) {
            return payload.getClientGatewaysList() == null ? ImmutableList.of() : payload.getClientGatewaysList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList() == null ? ImmutableList.of() : payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListClientGatewaysRequest, ListClientGatewaysResponse, ClientGatewaysServiceClient.ListClientGatewaysPagedResponse> LIST_CLIENT_GATEWAYS_PAGE_STR_FACT = new PagedListResponseFactory<ListClientGatewaysRequest, ListClientGatewaysResponse, ClientGatewaysServiceClient.ListClientGatewaysPagedResponse>(){

        public ApiFuture<ClientGatewaysServiceClient.ListClientGatewaysPagedResponse> getFuturePagedResponse(UnaryCallable<ListClientGatewaysRequest, ListClientGatewaysResponse> callable, ListClientGatewaysRequest request, ApiCallContext context, ApiFuture<ListClientGatewaysResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CLIENT_GATEWAYS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ClientGatewaysServiceClient.ListClientGatewaysPagedResponse.createAsync((PageContext<ListClientGatewaysRequest, ListClientGatewaysResponse, ClientGateway>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, ClientGatewaysServiceClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, ClientGatewaysServiceClient.ListLocationsPagedResponse>(){

        public ApiFuture<ClientGatewaysServiceClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ClientGatewaysServiceClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListClientGatewaysRequest, ListClientGatewaysResponse, ClientGatewaysServiceClient.ListClientGatewaysPagedResponse> listClientGatewaysSettings() {
        return this.listClientGatewaysSettings;
    }

    public UnaryCallSettings<GetClientGatewayRequest, ClientGateway> getClientGatewaySettings() {
        return this.getClientGatewaySettings;
    }

    public UnaryCallSettings<CreateClientGatewayRequest, Operation> createClientGatewaySettings() {
        return this.createClientGatewaySettings;
    }

    public OperationCallSettings<CreateClientGatewayRequest, ClientGateway, ClientGatewayOperationMetadata> createClientGatewayOperationSettings() {
        return this.createClientGatewayOperationSettings;
    }

    public UnaryCallSettings<DeleteClientGatewayRequest, Operation> deleteClientGatewaySettings() {
        return this.deleteClientGatewaySettings;
    }

    public OperationCallSettings<DeleteClientGatewayRequest, Empty, ClientGatewayOperationMetadata> deleteClientGatewayOperationSettings() {
        return this.deleteClientGatewayOperationSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, ClientGatewaysServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public ClientGatewaysServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcClientGatewaysServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "beyondcorp";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "beyondcorp.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "beyondcorp.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ClientGatewaysServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ClientGatewaysServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ClientGatewaysServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listClientGatewaysSettings = settingsBuilder.listClientGatewaysSettings().build();
        this.getClientGatewaySettings = settingsBuilder.getClientGatewaySettings().build();
        this.createClientGatewaySettings = settingsBuilder.createClientGatewaySettings().build();
        this.createClientGatewayOperationSettings = settingsBuilder.createClientGatewayOperationSettings().build();
        this.deleteClientGatewaySettings = settingsBuilder.deleteClientGatewaySettings().build();
        this.deleteClientGatewayOperationSettings = settingsBuilder.deleteClientGatewayOperationSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ClientGatewaysServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListClientGatewaysRequest, ListClientGatewaysResponse, ClientGatewaysServiceClient.ListClientGatewaysPagedResponse> listClientGatewaysSettings;
        private final UnaryCallSettings.Builder<GetClientGatewayRequest, ClientGateway> getClientGatewaySettings;
        private final UnaryCallSettings.Builder<CreateClientGatewayRequest, Operation> createClientGatewaySettings;
        private final OperationCallSettings.Builder<CreateClientGatewayRequest, ClientGateway, ClientGatewayOperationMetadata> createClientGatewayOperationSettings;
        private final UnaryCallSettings.Builder<DeleteClientGatewayRequest, Operation> deleteClientGatewaySettings;
        private final OperationCallSettings.Builder<DeleteClientGatewayRequest, Empty, ClientGatewayOperationMetadata> deleteClientGatewayOperationSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, ClientGatewaysServiceClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listClientGatewaysSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CLIENT_GATEWAYS_PAGE_STR_FACT);
            this.getClientGatewaySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createClientGatewaySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createClientGatewayOperationSettings = OperationCallSettings.newBuilder();
            this.deleteClientGatewaySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteClientGatewayOperationSettings = OperationCallSettings.newBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listClientGatewaysSettings, this.getClientGatewaySettings, this.createClientGatewaySettings, this.deleteClientGatewaySettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(ClientGatewaysServiceStubSettings settings) {
            super((StubSettings)settings);
            this.listClientGatewaysSettings = settings.listClientGatewaysSettings.toBuilder();
            this.getClientGatewaySettings = settings.getClientGatewaySettings.toBuilder();
            this.createClientGatewaySettings = settings.createClientGatewaySettings.toBuilder();
            this.createClientGatewayOperationSettings = settings.createClientGatewayOperationSettings.toBuilder();
            this.deleteClientGatewaySettings = settings.deleteClientGatewaySettings.toBuilder();
            this.deleteClientGatewayOperationSettings = settings.deleteClientGatewayOperationSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listClientGatewaysSettings, this.getClientGatewaySettings, this.createClientGatewaySettings, this.deleteClientGatewaySettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ClientGatewaysServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ClientGatewaysServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ClientGatewaysServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(ClientGatewaysServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(ClientGatewaysServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listClientGatewaysSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getClientGatewaySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createClientGatewaySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteClientGatewaySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createClientGatewayOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ClientGateway.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(ClientGatewayOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteClientGatewayOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(ClientGatewayOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListClientGatewaysRequest, ListClientGatewaysResponse, ClientGatewaysServiceClient.ListClientGatewaysPagedResponse> listClientGatewaysSettings() {
            return this.listClientGatewaysSettings;
        }

        public UnaryCallSettings.Builder<GetClientGatewayRequest, ClientGateway> getClientGatewaySettings() {
            return this.getClientGatewaySettings;
        }

        public UnaryCallSettings.Builder<CreateClientGatewayRequest, Operation> createClientGatewaySettings() {
            return this.createClientGatewaySettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateClientGatewayRequest, ClientGateway, ClientGatewayOperationMetadata> createClientGatewayOperationSettings() {
            return this.createClientGatewayOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteClientGatewayRequest, Operation> deleteClientGatewaySettings() {
            return this.deleteClientGatewaySettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteClientGatewayRequest, Empty, ClientGatewayOperationMetadata> deleteClientGatewayOperationSettings() {
            return this.deleteClientGatewayOperationSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, ClientGatewaysServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public ClientGatewaysServiceStubSettings build() throws IOException {
            return new ClientGatewaysServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

