/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.beyondcorp.appgateways.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.beyondcorp.appgateways.v1.AppGateway;
import com.google.cloud.beyondcorp.appgateways.v1.AppGatewayOperationMetadata;
import com.google.cloud.beyondcorp.appgateways.v1.AppGatewaysServiceClient;
import com.google.cloud.beyondcorp.appgateways.v1.CreateAppGatewayRequest;
import com.google.cloud.beyondcorp.appgateways.v1.DeleteAppGatewayRequest;
import com.google.cloud.beyondcorp.appgateways.v1.GetAppGatewayRequest;
import com.google.cloud.beyondcorp.appgateways.v1.ListAppGatewaysRequest;
import com.google.cloud.beyondcorp.appgateways.v1.ListAppGatewaysResponse;
import com.google.cloud.beyondcorp.appgateways.v1.stub.AppGatewaysServiceStub;
import com.google.cloud.beyondcorp.appgateways.v1.stub.GrpcAppGatewaysServiceStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class AppGatewaysServiceStubSettings
extends StubSettings<AppGatewaysServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListAppGatewaysRequest, ListAppGatewaysResponse, AppGatewaysServiceClient.ListAppGatewaysPagedResponse> listAppGatewaysSettings;
    private final UnaryCallSettings<GetAppGatewayRequest, AppGateway> getAppGatewaySettings;
    private final UnaryCallSettings<CreateAppGatewayRequest, Operation> createAppGatewaySettings;
    private final OperationCallSettings<CreateAppGatewayRequest, AppGateway, AppGatewayOperationMetadata> createAppGatewayOperationSettings;
    private final UnaryCallSettings<DeleteAppGatewayRequest, Operation> deleteAppGatewaySettings;
    private final OperationCallSettings<DeleteAppGatewayRequest, Empty, AppGatewayOperationMetadata> deleteAppGatewayOperationSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, AppGatewaysServiceClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListAppGatewaysRequest, ListAppGatewaysResponse, AppGateway> LIST_APP_GATEWAYS_PAGE_STR_DESC = new PagedListDescriptor<ListAppGatewaysRequest, ListAppGatewaysResponse, AppGateway>(){

        public String emptyToken() {
            return "";
        }

        public ListAppGatewaysRequest injectToken(ListAppGatewaysRequest payload, String token) {
            return ListAppGatewaysRequest.newBuilder((ListAppGatewaysRequest)payload).setPageToken(token).build();
        }

        public ListAppGatewaysRequest injectPageSize(ListAppGatewaysRequest payload, int pageSize) {
            return ListAppGatewaysRequest.newBuilder((ListAppGatewaysRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListAppGatewaysRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListAppGatewaysResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<AppGateway> extractResources(ListAppGatewaysResponse payload) {
            return payload.getAppGatewaysList() == null ? ImmutableList.of() : payload.getAppGatewaysList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList() == null ? ImmutableList.of() : payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListAppGatewaysRequest, ListAppGatewaysResponse, AppGatewaysServiceClient.ListAppGatewaysPagedResponse> LIST_APP_GATEWAYS_PAGE_STR_FACT = new PagedListResponseFactory<ListAppGatewaysRequest, ListAppGatewaysResponse, AppGatewaysServiceClient.ListAppGatewaysPagedResponse>(){

        public ApiFuture<AppGatewaysServiceClient.ListAppGatewaysPagedResponse> getFuturePagedResponse(UnaryCallable<ListAppGatewaysRequest, ListAppGatewaysResponse> callable, ListAppGatewaysRequest request, ApiCallContext context, ApiFuture<ListAppGatewaysResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_APP_GATEWAYS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AppGatewaysServiceClient.ListAppGatewaysPagedResponse.createAsync((PageContext<ListAppGatewaysRequest, ListAppGatewaysResponse, AppGateway>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, AppGatewaysServiceClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, AppGatewaysServiceClient.ListLocationsPagedResponse>(){

        public ApiFuture<AppGatewaysServiceClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AppGatewaysServiceClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListAppGatewaysRequest, ListAppGatewaysResponse, AppGatewaysServiceClient.ListAppGatewaysPagedResponse> listAppGatewaysSettings() {
        return this.listAppGatewaysSettings;
    }

    public UnaryCallSettings<GetAppGatewayRequest, AppGateway> getAppGatewaySettings() {
        return this.getAppGatewaySettings;
    }

    public UnaryCallSettings<CreateAppGatewayRequest, Operation> createAppGatewaySettings() {
        return this.createAppGatewaySettings;
    }

    public OperationCallSettings<CreateAppGatewayRequest, AppGateway, AppGatewayOperationMetadata> createAppGatewayOperationSettings() {
        return this.createAppGatewayOperationSettings;
    }

    public UnaryCallSettings<DeleteAppGatewayRequest, Operation> deleteAppGatewaySettings() {
        return this.deleteAppGatewaySettings;
    }

    public OperationCallSettings<DeleteAppGatewayRequest, Empty, AppGatewayOperationMetadata> deleteAppGatewayOperationSettings() {
        return this.deleteAppGatewayOperationSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, AppGatewaysServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public AppGatewaysServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcAppGatewaysServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return AppGatewaysServiceStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "beyondcorp";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "beyondcorp.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "beyondcorp.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return AppGatewaysServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AppGatewaysServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected AppGatewaysServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listAppGatewaysSettings = settingsBuilder.listAppGatewaysSettings().build();
        this.getAppGatewaySettings = settingsBuilder.getAppGatewaySettings().build();
        this.createAppGatewaySettings = settingsBuilder.createAppGatewaySettings().build();
        this.createAppGatewayOperationSettings = settingsBuilder.createAppGatewayOperationSettings().build();
        this.deleteAppGatewaySettings = settingsBuilder.deleteAppGatewaySettings().build();
        this.deleteAppGatewayOperationSettings = settingsBuilder.deleteAppGatewayOperationSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<AppGatewaysServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListAppGatewaysRequest, ListAppGatewaysResponse, AppGatewaysServiceClient.ListAppGatewaysPagedResponse> listAppGatewaysSettings;
        private final UnaryCallSettings.Builder<GetAppGatewayRequest, AppGateway> getAppGatewaySettings;
        private final UnaryCallSettings.Builder<CreateAppGatewayRequest, Operation> createAppGatewaySettings;
        private final OperationCallSettings.Builder<CreateAppGatewayRequest, AppGateway, AppGatewayOperationMetadata> createAppGatewayOperationSettings;
        private final UnaryCallSettings.Builder<DeleteAppGatewayRequest, Operation> deleteAppGatewaySettings;
        private final OperationCallSettings.Builder<DeleteAppGatewayRequest, Empty, AppGatewayOperationMetadata> deleteAppGatewayOperationSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, AppGatewaysServiceClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listAppGatewaysSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_APP_GATEWAYS_PAGE_STR_FACT);
            this.getAppGatewaySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createAppGatewaySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createAppGatewayOperationSettings = OperationCallSettings.newBuilder();
            this.deleteAppGatewaySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteAppGatewayOperationSettings = OperationCallSettings.newBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listAppGatewaysSettings, this.getAppGatewaySettings, this.createAppGatewaySettings, this.deleteAppGatewaySettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(AppGatewaysServiceStubSettings settings) {
            super((StubSettings)settings);
            this.listAppGatewaysSettings = settings.listAppGatewaysSettings.toBuilder();
            this.getAppGatewaySettings = settings.getAppGatewaySettings.toBuilder();
            this.createAppGatewaySettings = settings.createAppGatewaySettings.toBuilder();
            this.createAppGatewayOperationSettings = settings.createAppGatewayOperationSettings.toBuilder();
            this.deleteAppGatewaySettings = settings.deleteAppGatewaySettings.toBuilder();
            this.deleteAppGatewayOperationSettings = settings.deleteAppGatewayOperationSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listAppGatewaysSettings, this.getAppGatewaySettings, this.createAppGatewaySettings, this.deleteAppGatewaySettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(AppGatewaysServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)AppGatewaysServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AppGatewaysServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(AppGatewaysServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listAppGatewaysSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getAppGatewaySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createAppGatewaySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteAppGatewaySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createAppGatewayOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(AppGateway.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(AppGatewayOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteAppGatewayOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(AppGatewayOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListAppGatewaysRequest, ListAppGatewaysResponse, AppGatewaysServiceClient.ListAppGatewaysPagedResponse> listAppGatewaysSettings() {
            return this.listAppGatewaysSettings;
        }

        public UnaryCallSettings.Builder<GetAppGatewayRequest, AppGateway> getAppGatewaySettings() {
            return this.getAppGatewaySettings;
        }

        public UnaryCallSettings.Builder<CreateAppGatewayRequest, Operation> createAppGatewaySettings() {
            return this.createAppGatewaySettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateAppGatewayRequest, AppGateway, AppGatewayOperationMetadata> createAppGatewayOperationSettings() {
            return this.createAppGatewayOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteAppGatewayRequest, Operation> deleteAppGatewaySettings() {
            return this.deleteAppGatewaySettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteAppGatewayRequest, Empty, AppGatewayOperationMetadata> deleteAppGatewayOperationSettings() {
            return this.deleteAppGatewayOperationSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, AppGatewaysServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return AppGatewaysServiceStubSettings.getDefaultEndpoint();
        }

        public AppGatewaysServiceStubSettings build() throws IOException {
            return new AppGatewaysServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

