/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.beyondcorp.appconnections.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.beyondcorp.appconnections.v1.AppConnection;
import com.google.cloud.beyondcorp.appconnections.v1.AppConnectionName;
import com.google.cloud.beyondcorp.appconnections.v1.AppConnectionOperationMetadata;
import com.google.cloud.beyondcorp.appconnections.v1.AppConnectionsServiceSettings;
import com.google.cloud.beyondcorp.appconnections.v1.CreateAppConnectionRequest;
import com.google.cloud.beyondcorp.appconnections.v1.DeleteAppConnectionRequest;
import com.google.cloud.beyondcorp.appconnections.v1.GetAppConnectionRequest;
import com.google.cloud.beyondcorp.appconnections.v1.ListAppConnectionsRequest;
import com.google.cloud.beyondcorp.appconnections.v1.ListAppConnectionsResponse;
import com.google.cloud.beyondcorp.appconnections.v1.LocationName;
import com.google.cloud.beyondcorp.appconnections.v1.ResolveAppConnectionsRequest;
import com.google.cloud.beyondcorp.appconnections.v1.ResolveAppConnectionsResponse;
import com.google.cloud.beyondcorp.appconnections.v1.UpdateAppConnectionRequest;
import com.google.cloud.beyondcorp.appconnections.v1.stub.AppConnectionsServiceStub;
import com.google.cloud.beyondcorp.appconnections.v1.stub.AppConnectionsServiceStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class AppConnectionsServiceClient
implements BackgroundResource {
    private final AppConnectionsServiceSettings settings;
    private final AppConnectionsServiceStub stub;
    private final OperationsClient operationsClient;

    public static final AppConnectionsServiceClient create() throws IOException {
        return AppConnectionsServiceClient.create(AppConnectionsServiceSettings.newBuilder().build());
    }

    public static final AppConnectionsServiceClient create(AppConnectionsServiceSettings settings) throws IOException {
        return new AppConnectionsServiceClient(settings);
    }

    public static final AppConnectionsServiceClient create(AppConnectionsServiceStub stub) {
        return new AppConnectionsServiceClient(stub);
    }

    protected AppConnectionsServiceClient(AppConnectionsServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AppConnectionsServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    protected AppConnectionsServiceClient(AppConnectionsServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final AppConnectionsServiceSettings getSettings() {
        return this.settings;
    }

    public AppConnectionsServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final ListAppConnectionsPagedResponse listAppConnections(LocationName parent) {
        ListAppConnectionsRequest request = ListAppConnectionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAppConnections(request);
    }

    public final ListAppConnectionsPagedResponse listAppConnections(String parent) {
        ListAppConnectionsRequest request = ListAppConnectionsRequest.newBuilder().setParent(parent).build();
        return this.listAppConnections(request);
    }

    public final ListAppConnectionsPagedResponse listAppConnections(ListAppConnectionsRequest request) {
        return (ListAppConnectionsPagedResponse)((Object)this.listAppConnectionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAppConnectionsRequest, ListAppConnectionsPagedResponse> listAppConnectionsPagedCallable() {
        return this.stub.listAppConnectionsPagedCallable();
    }

    public final UnaryCallable<ListAppConnectionsRequest, ListAppConnectionsResponse> listAppConnectionsCallable() {
        return this.stub.listAppConnectionsCallable();
    }

    public final AppConnection getAppConnection(AppConnectionName name) {
        GetAppConnectionRequest request = GetAppConnectionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAppConnection(request);
    }

    public final AppConnection getAppConnection(String name) {
        GetAppConnectionRequest request = GetAppConnectionRequest.newBuilder().setName(name).build();
        return this.getAppConnection(request);
    }

    public final AppConnection getAppConnection(GetAppConnectionRequest request) {
        return (AppConnection)this.getAppConnectionCallable().call((Object)request);
    }

    public final UnaryCallable<GetAppConnectionRequest, AppConnection> getAppConnectionCallable() {
        return this.stub.getAppConnectionCallable();
    }

    public final OperationFuture<AppConnection, AppConnectionOperationMetadata> createAppConnectionAsync(LocationName parent, AppConnection appConnection, String appConnectionId) {
        CreateAppConnectionRequest request = CreateAppConnectionRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setAppConnection(appConnection).setAppConnectionId(appConnectionId).build();
        return this.createAppConnectionAsync(request);
    }

    public final OperationFuture<AppConnection, AppConnectionOperationMetadata> createAppConnectionAsync(String parent, AppConnection appConnection, String appConnectionId) {
        CreateAppConnectionRequest request = CreateAppConnectionRequest.newBuilder().setParent(parent).setAppConnection(appConnection).setAppConnectionId(appConnectionId).build();
        return this.createAppConnectionAsync(request);
    }

    public final OperationFuture<AppConnection, AppConnectionOperationMetadata> createAppConnectionAsync(CreateAppConnectionRequest request) {
        return this.createAppConnectionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateAppConnectionRequest, AppConnection, AppConnectionOperationMetadata> createAppConnectionOperationCallable() {
        return this.stub.createAppConnectionOperationCallable();
    }

    public final UnaryCallable<CreateAppConnectionRequest, Operation> createAppConnectionCallable() {
        return this.stub.createAppConnectionCallable();
    }

    public final OperationFuture<AppConnection, AppConnectionOperationMetadata> updateAppConnectionAsync(AppConnection appConnection, FieldMask updateMask) {
        UpdateAppConnectionRequest request = UpdateAppConnectionRequest.newBuilder().setAppConnection(appConnection).setUpdateMask(updateMask).build();
        return this.updateAppConnectionAsync(request);
    }

    public final OperationFuture<AppConnection, AppConnectionOperationMetadata> updateAppConnectionAsync(UpdateAppConnectionRequest request) {
        return this.updateAppConnectionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateAppConnectionRequest, AppConnection, AppConnectionOperationMetadata> updateAppConnectionOperationCallable() {
        return this.stub.updateAppConnectionOperationCallable();
    }

    public final UnaryCallable<UpdateAppConnectionRequest, Operation> updateAppConnectionCallable() {
        return this.stub.updateAppConnectionCallable();
    }

    public final OperationFuture<Empty, AppConnectionOperationMetadata> deleteAppConnectionAsync(AppConnectionName name) {
        DeleteAppConnectionRequest request = DeleteAppConnectionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteAppConnectionAsync(request);
    }

    public final OperationFuture<Empty, AppConnectionOperationMetadata> deleteAppConnectionAsync(String name) {
        DeleteAppConnectionRequest request = DeleteAppConnectionRequest.newBuilder().setName(name).build();
        return this.deleteAppConnectionAsync(request);
    }

    public final OperationFuture<Empty, AppConnectionOperationMetadata> deleteAppConnectionAsync(DeleteAppConnectionRequest request) {
        return this.deleteAppConnectionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteAppConnectionRequest, Empty, AppConnectionOperationMetadata> deleteAppConnectionOperationCallable() {
        return this.stub.deleteAppConnectionOperationCallable();
    }

    public final UnaryCallable<DeleteAppConnectionRequest, Operation> deleteAppConnectionCallable() {
        return this.stub.deleteAppConnectionCallable();
    }

    public final ResolveAppConnectionsPagedResponse resolveAppConnections(LocationName parent) {
        ResolveAppConnectionsRequest request = ResolveAppConnectionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.resolveAppConnections(request);
    }

    public final ResolveAppConnectionsPagedResponse resolveAppConnections(String parent) {
        ResolveAppConnectionsRequest request = ResolveAppConnectionsRequest.newBuilder().setParent(parent).build();
        return this.resolveAppConnections(request);
    }

    public final ResolveAppConnectionsPagedResponse resolveAppConnections(ResolveAppConnectionsRequest request) {
        return (ResolveAppConnectionsPagedResponse)((Object)this.resolveAppConnectionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ResolveAppConnectionsRequest, ResolveAppConnectionsPagedResponse> resolveAppConnectionsPagedCallable() {
        return this.stub.resolveAppConnectionsPagedCallable();
    }

    public final UnaryCallable<ResolveAppConnectionsRequest, ResolveAppConnectionsResponse> resolveAppConnectionsCallable() {
        return this.stub.resolveAppConnectionsCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ResolveAppConnectionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ResolveAppConnectionsRequest, ResolveAppConnectionsResponse, ResolveAppConnectionsResponse.AppConnectionDetails, ResolveAppConnectionsPage, ResolveAppConnectionsFixedSizeCollection> {
        private ResolveAppConnectionsFixedSizeCollection(List<ResolveAppConnectionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ResolveAppConnectionsFixedSizeCollection createEmptyCollection() {
            return new ResolveAppConnectionsFixedSizeCollection(null, 0);
        }

        protected ResolveAppConnectionsFixedSizeCollection createCollection(List<ResolveAppConnectionsPage> pages, int collectionSize) {
            return new ResolveAppConnectionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ResolveAppConnectionsPage
    extends AbstractPage<ResolveAppConnectionsRequest, ResolveAppConnectionsResponse, ResolveAppConnectionsResponse.AppConnectionDetails, ResolveAppConnectionsPage> {
        private ResolveAppConnectionsPage(PageContext<ResolveAppConnectionsRequest, ResolveAppConnectionsResponse, ResolveAppConnectionsResponse.AppConnectionDetails> context, ResolveAppConnectionsResponse response) {
            super(context, (Object)response);
        }

        private static ResolveAppConnectionsPage createEmptyPage() {
            return new ResolveAppConnectionsPage(null, null);
        }

        protected ResolveAppConnectionsPage createPage(PageContext<ResolveAppConnectionsRequest, ResolveAppConnectionsResponse, ResolveAppConnectionsResponse.AppConnectionDetails> context, ResolveAppConnectionsResponse response) {
            return new ResolveAppConnectionsPage(context, response);
        }

        public ApiFuture<ResolveAppConnectionsPage> createPageAsync(PageContext<ResolveAppConnectionsRequest, ResolveAppConnectionsResponse, ResolveAppConnectionsResponse.AppConnectionDetails> context, ApiFuture<ResolveAppConnectionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ResolveAppConnectionsPagedResponse
    extends AbstractPagedListResponse<ResolveAppConnectionsRequest, ResolveAppConnectionsResponse, ResolveAppConnectionsResponse.AppConnectionDetails, ResolveAppConnectionsPage, ResolveAppConnectionsFixedSizeCollection> {
        public static ApiFuture<ResolveAppConnectionsPagedResponse> createAsync(PageContext<ResolveAppConnectionsRequest, ResolveAppConnectionsResponse, ResolveAppConnectionsResponse.AppConnectionDetails> context, ApiFuture<ResolveAppConnectionsResponse> futureResponse) {
            ApiFuture<ResolveAppConnectionsPage> futurePage = ResolveAppConnectionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ResolveAppConnectionsPagedResponse((ResolveAppConnectionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ResolveAppConnectionsPagedResponse(ResolveAppConnectionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ResolveAppConnectionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListAppConnectionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAppConnectionsRequest, ListAppConnectionsResponse, AppConnection, ListAppConnectionsPage, ListAppConnectionsFixedSizeCollection> {
        private ListAppConnectionsFixedSizeCollection(List<ListAppConnectionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAppConnectionsFixedSizeCollection createEmptyCollection() {
            return new ListAppConnectionsFixedSizeCollection(null, 0);
        }

        protected ListAppConnectionsFixedSizeCollection createCollection(List<ListAppConnectionsPage> pages, int collectionSize) {
            return new ListAppConnectionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAppConnectionsPage
    extends AbstractPage<ListAppConnectionsRequest, ListAppConnectionsResponse, AppConnection, ListAppConnectionsPage> {
        private ListAppConnectionsPage(PageContext<ListAppConnectionsRequest, ListAppConnectionsResponse, AppConnection> context, ListAppConnectionsResponse response) {
            super(context, (Object)response);
        }

        private static ListAppConnectionsPage createEmptyPage() {
            return new ListAppConnectionsPage(null, null);
        }

        protected ListAppConnectionsPage createPage(PageContext<ListAppConnectionsRequest, ListAppConnectionsResponse, AppConnection> context, ListAppConnectionsResponse response) {
            return new ListAppConnectionsPage(context, response);
        }

        public ApiFuture<ListAppConnectionsPage> createPageAsync(PageContext<ListAppConnectionsRequest, ListAppConnectionsResponse, AppConnection> context, ApiFuture<ListAppConnectionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAppConnectionsPagedResponse
    extends AbstractPagedListResponse<ListAppConnectionsRequest, ListAppConnectionsResponse, AppConnection, ListAppConnectionsPage, ListAppConnectionsFixedSizeCollection> {
        public static ApiFuture<ListAppConnectionsPagedResponse> createAsync(PageContext<ListAppConnectionsRequest, ListAppConnectionsResponse, AppConnection> context, ApiFuture<ListAppConnectionsResponse> futureResponse) {
            ApiFuture<ListAppConnectionsPage> futurePage = ListAppConnectionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAppConnectionsPagedResponse((ListAppConnectionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAppConnectionsPagedResponse(ListAppConnectionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAppConnectionsFixedSizeCollection.createEmptyCollection());
        }
    }
}

