/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.baremetalsolution.v2.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.baremetalsolution.v2.BareMetalSolutionClient;
import com.google.cloud.baremetalsolution.v2.DetachLunRequest;
import com.google.cloud.baremetalsolution.v2.GetInstanceRequest;
import com.google.cloud.baremetalsolution.v2.GetLunRequest;
import com.google.cloud.baremetalsolution.v2.GetNetworkRequest;
import com.google.cloud.baremetalsolution.v2.GetNfsShareRequest;
import com.google.cloud.baremetalsolution.v2.GetVolumeRequest;
import com.google.cloud.baremetalsolution.v2.Instance;
import com.google.cloud.baremetalsolution.v2.ListInstancesRequest;
import com.google.cloud.baremetalsolution.v2.ListInstancesResponse;
import com.google.cloud.baremetalsolution.v2.ListLunsRequest;
import com.google.cloud.baremetalsolution.v2.ListLunsResponse;
import com.google.cloud.baremetalsolution.v2.ListNetworkUsageRequest;
import com.google.cloud.baremetalsolution.v2.ListNetworkUsageResponse;
import com.google.cloud.baremetalsolution.v2.ListNetworksRequest;
import com.google.cloud.baremetalsolution.v2.ListNetworksResponse;
import com.google.cloud.baremetalsolution.v2.ListNfsSharesRequest;
import com.google.cloud.baremetalsolution.v2.ListNfsSharesResponse;
import com.google.cloud.baremetalsolution.v2.ListVolumesRequest;
import com.google.cloud.baremetalsolution.v2.ListVolumesResponse;
import com.google.cloud.baremetalsolution.v2.Lun;
import com.google.cloud.baremetalsolution.v2.Network;
import com.google.cloud.baremetalsolution.v2.NfsShare;
import com.google.cloud.baremetalsolution.v2.OperationMetadata;
import com.google.cloud.baremetalsolution.v2.ResetInstanceRequest;
import com.google.cloud.baremetalsolution.v2.ResetInstanceResponse;
import com.google.cloud.baremetalsolution.v2.ResizeVolumeRequest;
import com.google.cloud.baremetalsolution.v2.StartInstanceRequest;
import com.google.cloud.baremetalsolution.v2.StartInstanceResponse;
import com.google.cloud.baremetalsolution.v2.StopInstanceRequest;
import com.google.cloud.baremetalsolution.v2.StopInstanceResponse;
import com.google.cloud.baremetalsolution.v2.UpdateInstanceRequest;
import com.google.cloud.baremetalsolution.v2.UpdateNetworkRequest;
import com.google.cloud.baremetalsolution.v2.UpdateNfsShareRequest;
import com.google.cloud.baremetalsolution.v2.UpdateVolumeRequest;
import com.google.cloud.baremetalsolution.v2.Volume;
import com.google.cloud.baremetalsolution.v2.stub.BareMetalSolutionStub;
import com.google.cloud.baremetalsolution.v2.stub.BareMetalSolutionStubSettings;
import com.google.cloud.baremetalsolution.v2.stub.GrpcBareMetalSolutionCallableFactory;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcBareMetalSolutionStub
extends BareMetalSolutionStub {
    private static final MethodDescriptor<ListInstancesRequest, ListInstancesResponse> listInstancesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.baremetalsolution.v2.BareMetalSolution/ListInstances").setRequestMarshaller(ProtoUtils.marshaller((Message)ListInstancesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListInstancesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetInstanceRequest, Instance> getInstanceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.baremetalsolution.v2.BareMetalSolution/GetInstance").setRequestMarshaller(ProtoUtils.marshaller((Message)GetInstanceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Instance.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateInstanceRequest, Operation> updateInstanceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.baremetalsolution.v2.BareMetalSolution/UpdateInstance").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateInstanceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ResetInstanceRequest, Operation> resetInstanceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.baremetalsolution.v2.BareMetalSolution/ResetInstance").setRequestMarshaller(ProtoUtils.marshaller((Message)ResetInstanceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<StartInstanceRequest, Operation> startInstanceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.baremetalsolution.v2.BareMetalSolution/StartInstance").setRequestMarshaller(ProtoUtils.marshaller((Message)StartInstanceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<StopInstanceRequest, Operation> stopInstanceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.baremetalsolution.v2.BareMetalSolution/StopInstance").setRequestMarshaller(ProtoUtils.marshaller((Message)StopInstanceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DetachLunRequest, Operation> detachLunMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.baremetalsolution.v2.BareMetalSolution/DetachLun").setRequestMarshaller(ProtoUtils.marshaller((Message)DetachLunRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ListVolumesRequest, ListVolumesResponse> listVolumesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.baremetalsolution.v2.BareMetalSolution/ListVolumes").setRequestMarshaller(ProtoUtils.marshaller((Message)ListVolumesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListVolumesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetVolumeRequest, Volume> getVolumeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.baremetalsolution.v2.BareMetalSolution/GetVolume").setRequestMarshaller(ProtoUtils.marshaller((Message)GetVolumeRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Volume.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateVolumeRequest, Operation> updateVolumeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.baremetalsolution.v2.BareMetalSolution/UpdateVolume").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateVolumeRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ResizeVolumeRequest, Operation> resizeVolumeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.baremetalsolution.v2.BareMetalSolution/ResizeVolume").setRequestMarshaller(ProtoUtils.marshaller((Message)ResizeVolumeRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ListNetworksRequest, ListNetworksResponse> listNetworksMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.baremetalsolution.v2.BareMetalSolution/ListNetworks").setRequestMarshaller(ProtoUtils.marshaller((Message)ListNetworksRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListNetworksResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ListNetworkUsageRequest, ListNetworkUsageResponse> listNetworkUsageMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.baremetalsolution.v2.BareMetalSolution/ListNetworkUsage").setRequestMarshaller(ProtoUtils.marshaller((Message)ListNetworkUsageRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListNetworkUsageResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetNetworkRequest, Network> getNetworkMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.baremetalsolution.v2.BareMetalSolution/GetNetwork").setRequestMarshaller(ProtoUtils.marshaller((Message)GetNetworkRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Network.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateNetworkRequest, Operation> updateNetworkMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.baremetalsolution.v2.BareMetalSolution/UpdateNetwork").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateNetworkRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<GetLunRequest, Lun> getLunMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.baremetalsolution.v2.BareMetalSolution/GetLun").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLunRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Lun.getDefaultInstance())).build();
    private static final MethodDescriptor<ListLunsRequest, ListLunsResponse> listLunsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.baremetalsolution.v2.BareMetalSolution/ListLuns").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLunsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLunsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetNfsShareRequest, NfsShare> getNfsShareMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.baremetalsolution.v2.BareMetalSolution/GetNfsShare").setRequestMarshaller(ProtoUtils.marshaller((Message)GetNfsShareRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)NfsShare.getDefaultInstance())).build();
    private static final MethodDescriptor<ListNfsSharesRequest, ListNfsSharesResponse> listNfsSharesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.baremetalsolution.v2.BareMetalSolution/ListNfsShares").setRequestMarshaller(ProtoUtils.marshaller((Message)ListNfsSharesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListNfsSharesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateNfsShareRequest, Operation> updateNfsShareMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.baremetalsolution.v2.BareMetalSolution/UpdateNfsShare").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateNfsShareRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private final UnaryCallable<ListInstancesRequest, ListInstancesResponse> listInstancesCallable;
    private final UnaryCallable<ListInstancesRequest, BareMetalSolutionClient.ListInstancesPagedResponse> listInstancesPagedCallable;
    private final UnaryCallable<GetInstanceRequest, Instance> getInstanceCallable;
    private final UnaryCallable<UpdateInstanceRequest, Operation> updateInstanceCallable;
    private final OperationCallable<UpdateInstanceRequest, Instance, OperationMetadata> updateInstanceOperationCallable;
    private final UnaryCallable<ResetInstanceRequest, Operation> resetInstanceCallable;
    private final OperationCallable<ResetInstanceRequest, ResetInstanceResponse, OperationMetadata> resetInstanceOperationCallable;
    private final UnaryCallable<StartInstanceRequest, Operation> startInstanceCallable;
    private final OperationCallable<StartInstanceRequest, StartInstanceResponse, OperationMetadata> startInstanceOperationCallable;
    private final UnaryCallable<StopInstanceRequest, Operation> stopInstanceCallable;
    private final OperationCallable<StopInstanceRequest, StopInstanceResponse, OperationMetadata> stopInstanceOperationCallable;
    private final UnaryCallable<DetachLunRequest, Operation> detachLunCallable;
    private final OperationCallable<DetachLunRequest, Instance, OperationMetadata> detachLunOperationCallable;
    private final UnaryCallable<ListVolumesRequest, ListVolumesResponse> listVolumesCallable;
    private final UnaryCallable<ListVolumesRequest, BareMetalSolutionClient.ListVolumesPagedResponse> listVolumesPagedCallable;
    private final UnaryCallable<GetVolumeRequest, Volume> getVolumeCallable;
    private final UnaryCallable<UpdateVolumeRequest, Operation> updateVolumeCallable;
    private final OperationCallable<UpdateVolumeRequest, Volume, OperationMetadata> updateVolumeOperationCallable;
    private final UnaryCallable<ResizeVolumeRequest, Operation> resizeVolumeCallable;
    private final OperationCallable<ResizeVolumeRequest, Volume, OperationMetadata> resizeVolumeOperationCallable;
    private final UnaryCallable<ListNetworksRequest, ListNetworksResponse> listNetworksCallable;
    private final UnaryCallable<ListNetworksRequest, BareMetalSolutionClient.ListNetworksPagedResponse> listNetworksPagedCallable;
    private final UnaryCallable<ListNetworkUsageRequest, ListNetworkUsageResponse> listNetworkUsageCallable;
    private final UnaryCallable<GetNetworkRequest, Network> getNetworkCallable;
    private final UnaryCallable<UpdateNetworkRequest, Operation> updateNetworkCallable;
    private final OperationCallable<UpdateNetworkRequest, Network, OperationMetadata> updateNetworkOperationCallable;
    private final UnaryCallable<GetLunRequest, Lun> getLunCallable;
    private final UnaryCallable<ListLunsRequest, ListLunsResponse> listLunsCallable;
    private final UnaryCallable<ListLunsRequest, BareMetalSolutionClient.ListLunsPagedResponse> listLunsPagedCallable;
    private final UnaryCallable<GetNfsShareRequest, NfsShare> getNfsShareCallable;
    private final UnaryCallable<ListNfsSharesRequest, ListNfsSharesResponse> listNfsSharesCallable;
    private final UnaryCallable<ListNfsSharesRequest, BareMetalSolutionClient.ListNfsSharesPagedResponse> listNfsSharesPagedCallable;
    private final UnaryCallable<UpdateNfsShareRequest, Operation> updateNfsShareCallable;
    private final OperationCallable<UpdateNfsShareRequest, NfsShare, OperationMetadata> updateNfsShareOperationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcBareMetalSolutionStub create(BareMetalSolutionStubSettings settings) throws IOException {
        return new GrpcBareMetalSolutionStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcBareMetalSolutionStub create(ClientContext clientContext) throws IOException {
        return new GrpcBareMetalSolutionStub(BareMetalSolutionStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcBareMetalSolutionStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcBareMetalSolutionStub(BareMetalSolutionStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcBareMetalSolutionStub(BareMetalSolutionStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcBareMetalSolutionCallableFactory());
    }

    protected GrpcBareMetalSolutionStub(BareMetalSolutionStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listInstancesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listInstancesMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings getInstanceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getInstanceMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings updateInstanceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateInstanceMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"instance.name", (Object)String.valueOf(request.getInstance().getName()));
            return params.build();
        }).build();
        GrpcCallSettings resetInstanceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(resetInstanceMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings startInstanceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(startInstanceMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings stopInstanceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(stopInstanceMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings detachLunTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(detachLunMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"instance", (Object)String.valueOf(request.getInstance()));
            return params.build();
        }).build();
        GrpcCallSettings listVolumesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listVolumesMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings getVolumeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getVolumeMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings updateVolumeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateVolumeMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"volume.name", (Object)String.valueOf(request.getVolume().getName()));
            return params.build();
        }).build();
        GrpcCallSettings resizeVolumeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(resizeVolumeMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"volume", (Object)String.valueOf(request.getVolume()));
            return params.build();
        }).build();
        GrpcCallSettings listNetworksTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listNetworksMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings listNetworkUsageTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listNetworkUsageMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"location", (Object)String.valueOf(request.getLocation()));
            return params.build();
        }).build();
        GrpcCallSettings getNetworkTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getNetworkMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings updateNetworkTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateNetworkMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"network.name", (Object)String.valueOf(request.getNetwork().getName()));
            return params.build();
        }).build();
        GrpcCallSettings getLunTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLunMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings listLunsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLunsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings getNfsShareTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getNfsShareMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings listNfsSharesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listNfsSharesMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings updateNfsShareTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateNfsShareMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"nfs_share.name", (Object)String.valueOf(request.getNfsShare().getName()));
            return params.build();
        }).build();
        this.listInstancesCallable = callableFactory.createUnaryCallable(listInstancesTransportSettings, settings.listInstancesSettings(), clientContext);
        this.listInstancesPagedCallable = callableFactory.createPagedCallable(listInstancesTransportSettings, settings.listInstancesSettings(), clientContext);
        this.getInstanceCallable = callableFactory.createUnaryCallable(getInstanceTransportSettings, settings.getInstanceSettings(), clientContext);
        this.updateInstanceCallable = callableFactory.createUnaryCallable(updateInstanceTransportSettings, settings.updateInstanceSettings(), clientContext);
        this.updateInstanceOperationCallable = callableFactory.createOperationCallable(updateInstanceTransportSettings, settings.updateInstanceOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.resetInstanceCallable = callableFactory.createUnaryCallable(resetInstanceTransportSettings, settings.resetInstanceSettings(), clientContext);
        this.resetInstanceOperationCallable = callableFactory.createOperationCallable(resetInstanceTransportSettings, settings.resetInstanceOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.startInstanceCallable = callableFactory.createUnaryCallable(startInstanceTransportSettings, settings.startInstanceSettings(), clientContext);
        this.startInstanceOperationCallable = callableFactory.createOperationCallable(startInstanceTransportSettings, settings.startInstanceOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.stopInstanceCallable = callableFactory.createUnaryCallable(stopInstanceTransportSettings, settings.stopInstanceSettings(), clientContext);
        this.stopInstanceOperationCallable = callableFactory.createOperationCallable(stopInstanceTransportSettings, settings.stopInstanceOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.detachLunCallable = callableFactory.createUnaryCallable(detachLunTransportSettings, settings.detachLunSettings(), clientContext);
        this.detachLunOperationCallable = callableFactory.createOperationCallable(detachLunTransportSettings, settings.detachLunOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listVolumesCallable = callableFactory.createUnaryCallable(listVolumesTransportSettings, settings.listVolumesSettings(), clientContext);
        this.listVolumesPagedCallable = callableFactory.createPagedCallable(listVolumesTransportSettings, settings.listVolumesSettings(), clientContext);
        this.getVolumeCallable = callableFactory.createUnaryCallable(getVolumeTransportSettings, settings.getVolumeSettings(), clientContext);
        this.updateVolumeCallable = callableFactory.createUnaryCallable(updateVolumeTransportSettings, settings.updateVolumeSettings(), clientContext);
        this.updateVolumeOperationCallable = callableFactory.createOperationCallable(updateVolumeTransportSettings, settings.updateVolumeOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.resizeVolumeCallable = callableFactory.createUnaryCallable(resizeVolumeTransportSettings, settings.resizeVolumeSettings(), clientContext);
        this.resizeVolumeOperationCallable = callableFactory.createOperationCallable(resizeVolumeTransportSettings, settings.resizeVolumeOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listNetworksCallable = callableFactory.createUnaryCallable(listNetworksTransportSettings, settings.listNetworksSettings(), clientContext);
        this.listNetworksPagedCallable = callableFactory.createPagedCallable(listNetworksTransportSettings, settings.listNetworksSettings(), clientContext);
        this.listNetworkUsageCallable = callableFactory.createUnaryCallable(listNetworkUsageTransportSettings, settings.listNetworkUsageSettings(), clientContext);
        this.getNetworkCallable = callableFactory.createUnaryCallable(getNetworkTransportSettings, settings.getNetworkSettings(), clientContext);
        this.updateNetworkCallable = callableFactory.createUnaryCallable(updateNetworkTransportSettings, settings.updateNetworkSettings(), clientContext);
        this.updateNetworkOperationCallable = callableFactory.createOperationCallable(updateNetworkTransportSettings, settings.updateNetworkOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getLunCallable = callableFactory.createUnaryCallable(getLunTransportSettings, settings.getLunSettings(), clientContext);
        this.listLunsCallable = callableFactory.createUnaryCallable(listLunsTransportSettings, settings.listLunsSettings(), clientContext);
        this.listLunsPagedCallable = callableFactory.createPagedCallable(listLunsTransportSettings, settings.listLunsSettings(), clientContext);
        this.getNfsShareCallable = callableFactory.createUnaryCallable(getNfsShareTransportSettings, settings.getNfsShareSettings(), clientContext);
        this.listNfsSharesCallable = callableFactory.createUnaryCallable(listNfsSharesTransportSettings, settings.listNfsSharesSettings(), clientContext);
        this.listNfsSharesPagedCallable = callableFactory.createPagedCallable(listNfsSharesTransportSettings, settings.listNfsSharesSettings(), clientContext);
        this.updateNfsShareCallable = callableFactory.createUnaryCallable(updateNfsShareTransportSettings, settings.updateNfsShareSettings(), clientContext);
        this.updateNfsShareOperationCallable = callableFactory.createOperationCallable(updateNfsShareTransportSettings, settings.updateNfsShareOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListInstancesRequest, ListInstancesResponse> listInstancesCallable() {
        return this.listInstancesCallable;
    }

    @Override
    public UnaryCallable<ListInstancesRequest, BareMetalSolutionClient.ListInstancesPagedResponse> listInstancesPagedCallable() {
        return this.listInstancesPagedCallable;
    }

    @Override
    public UnaryCallable<GetInstanceRequest, Instance> getInstanceCallable() {
        return this.getInstanceCallable;
    }

    @Override
    public UnaryCallable<UpdateInstanceRequest, Operation> updateInstanceCallable() {
        return this.updateInstanceCallable;
    }

    @Override
    public OperationCallable<UpdateInstanceRequest, Instance, OperationMetadata> updateInstanceOperationCallable() {
        return this.updateInstanceOperationCallable;
    }

    @Override
    public UnaryCallable<ResetInstanceRequest, Operation> resetInstanceCallable() {
        return this.resetInstanceCallable;
    }

    @Override
    public OperationCallable<ResetInstanceRequest, ResetInstanceResponse, OperationMetadata> resetInstanceOperationCallable() {
        return this.resetInstanceOperationCallable;
    }

    @Override
    public UnaryCallable<StartInstanceRequest, Operation> startInstanceCallable() {
        return this.startInstanceCallable;
    }

    @Override
    public OperationCallable<StartInstanceRequest, StartInstanceResponse, OperationMetadata> startInstanceOperationCallable() {
        return this.startInstanceOperationCallable;
    }

    @Override
    public UnaryCallable<StopInstanceRequest, Operation> stopInstanceCallable() {
        return this.stopInstanceCallable;
    }

    @Override
    public OperationCallable<StopInstanceRequest, StopInstanceResponse, OperationMetadata> stopInstanceOperationCallable() {
        return this.stopInstanceOperationCallable;
    }

    @Override
    public UnaryCallable<DetachLunRequest, Operation> detachLunCallable() {
        return this.detachLunCallable;
    }

    @Override
    public OperationCallable<DetachLunRequest, Instance, OperationMetadata> detachLunOperationCallable() {
        return this.detachLunOperationCallable;
    }

    @Override
    public UnaryCallable<ListVolumesRequest, ListVolumesResponse> listVolumesCallable() {
        return this.listVolumesCallable;
    }

    @Override
    public UnaryCallable<ListVolumesRequest, BareMetalSolutionClient.ListVolumesPagedResponse> listVolumesPagedCallable() {
        return this.listVolumesPagedCallable;
    }

    @Override
    public UnaryCallable<GetVolumeRequest, Volume> getVolumeCallable() {
        return this.getVolumeCallable;
    }

    @Override
    public UnaryCallable<UpdateVolumeRequest, Operation> updateVolumeCallable() {
        return this.updateVolumeCallable;
    }

    @Override
    public OperationCallable<UpdateVolumeRequest, Volume, OperationMetadata> updateVolumeOperationCallable() {
        return this.updateVolumeOperationCallable;
    }

    @Override
    public UnaryCallable<ResizeVolumeRequest, Operation> resizeVolumeCallable() {
        return this.resizeVolumeCallable;
    }

    @Override
    public OperationCallable<ResizeVolumeRequest, Volume, OperationMetadata> resizeVolumeOperationCallable() {
        return this.resizeVolumeOperationCallable;
    }

    @Override
    public UnaryCallable<ListNetworksRequest, ListNetworksResponse> listNetworksCallable() {
        return this.listNetworksCallable;
    }

    @Override
    public UnaryCallable<ListNetworksRequest, BareMetalSolutionClient.ListNetworksPagedResponse> listNetworksPagedCallable() {
        return this.listNetworksPagedCallable;
    }

    @Override
    public UnaryCallable<ListNetworkUsageRequest, ListNetworkUsageResponse> listNetworkUsageCallable() {
        return this.listNetworkUsageCallable;
    }

    @Override
    public UnaryCallable<GetNetworkRequest, Network> getNetworkCallable() {
        return this.getNetworkCallable;
    }

    @Override
    public UnaryCallable<UpdateNetworkRequest, Operation> updateNetworkCallable() {
        return this.updateNetworkCallable;
    }

    @Override
    public OperationCallable<UpdateNetworkRequest, Network, OperationMetadata> updateNetworkOperationCallable() {
        return this.updateNetworkOperationCallable;
    }

    @Override
    public UnaryCallable<GetLunRequest, Lun> getLunCallable() {
        return this.getLunCallable;
    }

    @Override
    public UnaryCallable<ListLunsRequest, ListLunsResponse> listLunsCallable() {
        return this.listLunsCallable;
    }

    @Override
    public UnaryCallable<ListLunsRequest, BareMetalSolutionClient.ListLunsPagedResponse> listLunsPagedCallable() {
        return this.listLunsPagedCallable;
    }

    @Override
    public UnaryCallable<GetNfsShareRequest, NfsShare> getNfsShareCallable() {
        return this.getNfsShareCallable;
    }

    @Override
    public UnaryCallable<ListNfsSharesRequest, ListNfsSharesResponse> listNfsSharesCallable() {
        return this.listNfsSharesCallable;
    }

    @Override
    public UnaryCallable<ListNfsSharesRequest, BareMetalSolutionClient.ListNfsSharesPagedResponse> listNfsSharesPagedCallable() {
        return this.listNfsSharesPagedCallable;
    }

    @Override
    public UnaryCallable<UpdateNfsShareRequest, Operation> updateNfsShareCallable() {
        return this.updateNfsShareCallable;
    }

    @Override
    public OperationCallable<UpdateNfsShareRequest, NfsShare, OperationMetadata> updateNfsShareOperationCallable() {
        return this.updateNfsShareOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

