/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.baremetalsolution.v2.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.baremetalsolution.v2.BareMetalSolutionClient;
import com.google.cloud.baremetalsolution.v2.CreateSnapshotSchedulePolicyRequest;
import com.google.cloud.baremetalsolution.v2.CreateVolumeSnapshotRequest;
import com.google.cloud.baremetalsolution.v2.DeleteSnapshotSchedulePolicyRequest;
import com.google.cloud.baremetalsolution.v2.DeleteVolumeSnapshotRequest;
import com.google.cloud.baremetalsolution.v2.GetInstanceRequest;
import com.google.cloud.baremetalsolution.v2.GetLunRequest;
import com.google.cloud.baremetalsolution.v2.GetNetworkRequest;
import com.google.cloud.baremetalsolution.v2.GetSnapshotSchedulePolicyRequest;
import com.google.cloud.baremetalsolution.v2.GetVolumeRequest;
import com.google.cloud.baremetalsolution.v2.GetVolumeSnapshotRequest;
import com.google.cloud.baremetalsolution.v2.Instance;
import com.google.cloud.baremetalsolution.v2.ListInstancesRequest;
import com.google.cloud.baremetalsolution.v2.ListInstancesResponse;
import com.google.cloud.baremetalsolution.v2.ListLunsRequest;
import com.google.cloud.baremetalsolution.v2.ListLunsResponse;
import com.google.cloud.baremetalsolution.v2.ListNetworksRequest;
import com.google.cloud.baremetalsolution.v2.ListNetworksResponse;
import com.google.cloud.baremetalsolution.v2.ListSnapshotSchedulePoliciesRequest;
import com.google.cloud.baremetalsolution.v2.ListSnapshotSchedulePoliciesResponse;
import com.google.cloud.baremetalsolution.v2.ListVolumeSnapshotsRequest;
import com.google.cloud.baremetalsolution.v2.ListVolumeSnapshotsResponse;
import com.google.cloud.baremetalsolution.v2.ListVolumesRequest;
import com.google.cloud.baremetalsolution.v2.ListVolumesResponse;
import com.google.cloud.baremetalsolution.v2.Lun;
import com.google.cloud.baremetalsolution.v2.Network;
import com.google.cloud.baremetalsolution.v2.OperationMetadata;
import com.google.cloud.baremetalsolution.v2.ResetInstanceRequest;
import com.google.cloud.baremetalsolution.v2.ResetInstanceResponse;
import com.google.cloud.baremetalsolution.v2.RestoreVolumeSnapshotRequest;
import com.google.cloud.baremetalsolution.v2.SnapshotSchedulePolicy;
import com.google.cloud.baremetalsolution.v2.UpdateSnapshotSchedulePolicyRequest;
import com.google.cloud.baremetalsolution.v2.UpdateVolumeRequest;
import com.google.cloud.baremetalsolution.v2.Volume;
import com.google.cloud.baremetalsolution.v2.VolumeSnapshot;
import com.google.cloud.baremetalsolution.v2.stub.BareMetalSolutionStub;
import com.google.cloud.baremetalsolution.v2.stub.GrpcBareMetalSolutionStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class BareMetalSolutionStubSettings
extends StubSettings<BareMetalSolutionStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListInstancesRequest, ListInstancesResponse, BareMetalSolutionClient.ListInstancesPagedResponse> listInstancesSettings;
    private final UnaryCallSettings<GetInstanceRequest, Instance> getInstanceSettings;
    private final UnaryCallSettings<ResetInstanceRequest, Operation> resetInstanceSettings;
    private final OperationCallSettings<ResetInstanceRequest, ResetInstanceResponse, OperationMetadata> resetInstanceOperationSettings;
    private final PagedCallSettings<ListVolumesRequest, ListVolumesResponse, BareMetalSolutionClient.ListVolumesPagedResponse> listVolumesSettings;
    private final UnaryCallSettings<GetVolumeRequest, Volume> getVolumeSettings;
    private final UnaryCallSettings<UpdateVolumeRequest, Operation> updateVolumeSettings;
    private final OperationCallSettings<UpdateVolumeRequest, Volume, OperationMetadata> updateVolumeOperationSettings;
    private final PagedCallSettings<ListNetworksRequest, ListNetworksResponse, BareMetalSolutionClient.ListNetworksPagedResponse> listNetworksSettings;
    private final UnaryCallSettings<GetNetworkRequest, Network> getNetworkSettings;
    private final PagedCallSettings<ListSnapshotSchedulePoliciesRequest, ListSnapshotSchedulePoliciesResponse, BareMetalSolutionClient.ListSnapshotSchedulePoliciesPagedResponse> listSnapshotSchedulePoliciesSettings;
    private final UnaryCallSettings<GetSnapshotSchedulePolicyRequest, SnapshotSchedulePolicy> getSnapshotSchedulePolicySettings;
    private final UnaryCallSettings<CreateSnapshotSchedulePolicyRequest, SnapshotSchedulePolicy> createSnapshotSchedulePolicySettings;
    private final UnaryCallSettings<UpdateSnapshotSchedulePolicyRequest, SnapshotSchedulePolicy> updateSnapshotSchedulePolicySettings;
    private final UnaryCallSettings<DeleteSnapshotSchedulePolicyRequest, Empty> deleteSnapshotSchedulePolicySettings;
    private final UnaryCallSettings<CreateVolumeSnapshotRequest, VolumeSnapshot> createVolumeSnapshotSettings;
    private final UnaryCallSettings<RestoreVolumeSnapshotRequest, Operation> restoreVolumeSnapshotSettings;
    private final OperationCallSettings<RestoreVolumeSnapshotRequest, VolumeSnapshot, OperationMetadata> restoreVolumeSnapshotOperationSettings;
    private final UnaryCallSettings<DeleteVolumeSnapshotRequest, Empty> deleteVolumeSnapshotSettings;
    private final UnaryCallSettings<GetVolumeSnapshotRequest, VolumeSnapshot> getVolumeSnapshotSettings;
    private final PagedCallSettings<ListVolumeSnapshotsRequest, ListVolumeSnapshotsResponse, BareMetalSolutionClient.ListVolumeSnapshotsPagedResponse> listVolumeSnapshotsSettings;
    private final UnaryCallSettings<GetLunRequest, Lun> getLunSettings;
    private final PagedCallSettings<ListLunsRequest, ListLunsResponse, BareMetalSolutionClient.ListLunsPagedResponse> listLunsSettings;
    private static final PagedListDescriptor<ListInstancesRequest, ListInstancesResponse, Instance> LIST_INSTANCES_PAGE_STR_DESC = new PagedListDescriptor<ListInstancesRequest, ListInstancesResponse, Instance>(){

        public String emptyToken() {
            return "";
        }

        public ListInstancesRequest injectToken(ListInstancesRequest payload, String token) {
            return ListInstancesRequest.newBuilder((ListInstancesRequest)payload).setPageToken(token).build();
        }

        public ListInstancesRequest injectPageSize(ListInstancesRequest payload, int pageSize) {
            return ListInstancesRequest.newBuilder((ListInstancesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListInstancesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListInstancesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Instance> extractResources(ListInstancesResponse payload) {
            return payload.getInstancesList() == null ? ImmutableList.of() : payload.getInstancesList();
        }
    };
    private static final PagedListDescriptor<ListVolumesRequest, ListVolumesResponse, Volume> LIST_VOLUMES_PAGE_STR_DESC = new PagedListDescriptor<ListVolumesRequest, ListVolumesResponse, Volume>(){

        public String emptyToken() {
            return "";
        }

        public ListVolumesRequest injectToken(ListVolumesRequest payload, String token) {
            return ListVolumesRequest.newBuilder((ListVolumesRequest)payload).setPageToken(token).build();
        }

        public ListVolumesRequest injectPageSize(ListVolumesRequest payload, int pageSize) {
            return ListVolumesRequest.newBuilder((ListVolumesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListVolumesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListVolumesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Volume> extractResources(ListVolumesResponse payload) {
            return payload.getVolumesList() == null ? ImmutableList.of() : payload.getVolumesList();
        }
    };
    private static final PagedListDescriptor<ListNetworksRequest, ListNetworksResponse, Network> LIST_NETWORKS_PAGE_STR_DESC = new PagedListDescriptor<ListNetworksRequest, ListNetworksResponse, Network>(){

        public String emptyToken() {
            return "";
        }

        public ListNetworksRequest injectToken(ListNetworksRequest payload, String token) {
            return ListNetworksRequest.newBuilder((ListNetworksRequest)payload).setPageToken(token).build();
        }

        public ListNetworksRequest injectPageSize(ListNetworksRequest payload, int pageSize) {
            return ListNetworksRequest.newBuilder((ListNetworksRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListNetworksRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListNetworksResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Network> extractResources(ListNetworksResponse payload) {
            return payload.getNetworksList() == null ? ImmutableList.of() : payload.getNetworksList();
        }
    };
    private static final PagedListDescriptor<ListSnapshotSchedulePoliciesRequest, ListSnapshotSchedulePoliciesResponse, SnapshotSchedulePolicy> LIST_SNAPSHOT_SCHEDULE_POLICIES_PAGE_STR_DESC = new PagedListDescriptor<ListSnapshotSchedulePoliciesRequest, ListSnapshotSchedulePoliciesResponse, SnapshotSchedulePolicy>(){

        public String emptyToken() {
            return "";
        }

        public ListSnapshotSchedulePoliciesRequest injectToken(ListSnapshotSchedulePoliciesRequest payload, String token) {
            return ListSnapshotSchedulePoliciesRequest.newBuilder((ListSnapshotSchedulePoliciesRequest)payload).setPageToken(token).build();
        }

        public ListSnapshotSchedulePoliciesRequest injectPageSize(ListSnapshotSchedulePoliciesRequest payload, int pageSize) {
            return ListSnapshotSchedulePoliciesRequest.newBuilder((ListSnapshotSchedulePoliciesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListSnapshotSchedulePoliciesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListSnapshotSchedulePoliciesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<SnapshotSchedulePolicy> extractResources(ListSnapshotSchedulePoliciesResponse payload) {
            return payload.getSnapshotSchedulePoliciesList() == null ? ImmutableList.of() : payload.getSnapshotSchedulePoliciesList();
        }
    };
    private static final PagedListDescriptor<ListVolumeSnapshotsRequest, ListVolumeSnapshotsResponse, VolumeSnapshot> LIST_VOLUME_SNAPSHOTS_PAGE_STR_DESC = new PagedListDescriptor<ListVolumeSnapshotsRequest, ListVolumeSnapshotsResponse, VolumeSnapshot>(){

        public String emptyToken() {
            return "";
        }

        public ListVolumeSnapshotsRequest injectToken(ListVolumeSnapshotsRequest payload, String token) {
            return ListVolumeSnapshotsRequest.newBuilder((ListVolumeSnapshotsRequest)payload).setPageToken(token).build();
        }

        public ListVolumeSnapshotsRequest injectPageSize(ListVolumeSnapshotsRequest payload, int pageSize) {
            return ListVolumeSnapshotsRequest.newBuilder((ListVolumeSnapshotsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListVolumeSnapshotsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListVolumeSnapshotsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<VolumeSnapshot> extractResources(ListVolumeSnapshotsResponse payload) {
            return payload.getVolumeSnapshotsList() == null ? ImmutableList.of() : payload.getVolumeSnapshotsList();
        }
    };
    private static final PagedListDescriptor<ListLunsRequest, ListLunsResponse, Lun> LIST_LUNS_PAGE_STR_DESC = new PagedListDescriptor<ListLunsRequest, ListLunsResponse, Lun>(){

        public String emptyToken() {
            return "";
        }

        public ListLunsRequest injectToken(ListLunsRequest payload, String token) {
            return ListLunsRequest.newBuilder((ListLunsRequest)payload).setPageToken(token).build();
        }

        public ListLunsRequest injectPageSize(ListLunsRequest payload, int pageSize) {
            return ListLunsRequest.newBuilder((ListLunsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLunsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLunsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Lun> extractResources(ListLunsResponse payload) {
            return payload.getLunsList() == null ? ImmutableList.of() : payload.getLunsList();
        }
    };
    private static final PagedListResponseFactory<ListInstancesRequest, ListInstancesResponse, BareMetalSolutionClient.ListInstancesPagedResponse> LIST_INSTANCES_PAGE_STR_FACT = new PagedListResponseFactory<ListInstancesRequest, ListInstancesResponse, BareMetalSolutionClient.ListInstancesPagedResponse>(){

        public ApiFuture<BareMetalSolutionClient.ListInstancesPagedResponse> getFuturePagedResponse(UnaryCallable<ListInstancesRequest, ListInstancesResponse> callable, ListInstancesRequest request, ApiCallContext context, ApiFuture<ListInstancesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_INSTANCES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return BareMetalSolutionClient.ListInstancesPagedResponse.createAsync((PageContext<ListInstancesRequest, ListInstancesResponse, Instance>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListVolumesRequest, ListVolumesResponse, BareMetalSolutionClient.ListVolumesPagedResponse> LIST_VOLUMES_PAGE_STR_FACT = new PagedListResponseFactory<ListVolumesRequest, ListVolumesResponse, BareMetalSolutionClient.ListVolumesPagedResponse>(){

        public ApiFuture<BareMetalSolutionClient.ListVolumesPagedResponse> getFuturePagedResponse(UnaryCallable<ListVolumesRequest, ListVolumesResponse> callable, ListVolumesRequest request, ApiCallContext context, ApiFuture<ListVolumesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_VOLUMES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return BareMetalSolutionClient.ListVolumesPagedResponse.createAsync((PageContext<ListVolumesRequest, ListVolumesResponse, Volume>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListNetworksRequest, ListNetworksResponse, BareMetalSolutionClient.ListNetworksPagedResponse> LIST_NETWORKS_PAGE_STR_FACT = new PagedListResponseFactory<ListNetworksRequest, ListNetworksResponse, BareMetalSolutionClient.ListNetworksPagedResponse>(){

        public ApiFuture<BareMetalSolutionClient.ListNetworksPagedResponse> getFuturePagedResponse(UnaryCallable<ListNetworksRequest, ListNetworksResponse> callable, ListNetworksRequest request, ApiCallContext context, ApiFuture<ListNetworksResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_NETWORKS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return BareMetalSolutionClient.ListNetworksPagedResponse.createAsync((PageContext<ListNetworksRequest, ListNetworksResponse, Network>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListSnapshotSchedulePoliciesRequest, ListSnapshotSchedulePoliciesResponse, BareMetalSolutionClient.ListSnapshotSchedulePoliciesPagedResponse> LIST_SNAPSHOT_SCHEDULE_POLICIES_PAGE_STR_FACT = new PagedListResponseFactory<ListSnapshotSchedulePoliciesRequest, ListSnapshotSchedulePoliciesResponse, BareMetalSolutionClient.ListSnapshotSchedulePoliciesPagedResponse>(){

        public ApiFuture<BareMetalSolutionClient.ListSnapshotSchedulePoliciesPagedResponse> getFuturePagedResponse(UnaryCallable<ListSnapshotSchedulePoliciesRequest, ListSnapshotSchedulePoliciesResponse> callable, ListSnapshotSchedulePoliciesRequest request, ApiCallContext context, ApiFuture<ListSnapshotSchedulePoliciesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SNAPSHOT_SCHEDULE_POLICIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return BareMetalSolutionClient.ListSnapshotSchedulePoliciesPagedResponse.createAsync((PageContext<ListSnapshotSchedulePoliciesRequest, ListSnapshotSchedulePoliciesResponse, SnapshotSchedulePolicy>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListVolumeSnapshotsRequest, ListVolumeSnapshotsResponse, BareMetalSolutionClient.ListVolumeSnapshotsPagedResponse> LIST_VOLUME_SNAPSHOTS_PAGE_STR_FACT = new PagedListResponseFactory<ListVolumeSnapshotsRequest, ListVolumeSnapshotsResponse, BareMetalSolutionClient.ListVolumeSnapshotsPagedResponse>(){

        public ApiFuture<BareMetalSolutionClient.ListVolumeSnapshotsPagedResponse> getFuturePagedResponse(UnaryCallable<ListVolumeSnapshotsRequest, ListVolumeSnapshotsResponse> callable, ListVolumeSnapshotsRequest request, ApiCallContext context, ApiFuture<ListVolumeSnapshotsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_VOLUME_SNAPSHOTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return BareMetalSolutionClient.ListVolumeSnapshotsPagedResponse.createAsync((PageContext<ListVolumeSnapshotsRequest, ListVolumeSnapshotsResponse, VolumeSnapshot>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLunsRequest, ListLunsResponse, BareMetalSolutionClient.ListLunsPagedResponse> LIST_LUNS_PAGE_STR_FACT = new PagedListResponseFactory<ListLunsRequest, ListLunsResponse, BareMetalSolutionClient.ListLunsPagedResponse>(){

        public ApiFuture<BareMetalSolutionClient.ListLunsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLunsRequest, ListLunsResponse> callable, ListLunsRequest request, ApiCallContext context, ApiFuture<ListLunsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LUNS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return BareMetalSolutionClient.ListLunsPagedResponse.createAsync((PageContext<ListLunsRequest, ListLunsResponse, Lun>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListInstancesRequest, ListInstancesResponse, BareMetalSolutionClient.ListInstancesPagedResponse> listInstancesSettings() {
        return this.listInstancesSettings;
    }

    public UnaryCallSettings<GetInstanceRequest, Instance> getInstanceSettings() {
        return this.getInstanceSettings;
    }

    public UnaryCallSettings<ResetInstanceRequest, Operation> resetInstanceSettings() {
        return this.resetInstanceSettings;
    }

    public OperationCallSettings<ResetInstanceRequest, ResetInstanceResponse, OperationMetadata> resetInstanceOperationSettings() {
        return this.resetInstanceOperationSettings;
    }

    public PagedCallSettings<ListVolumesRequest, ListVolumesResponse, BareMetalSolutionClient.ListVolumesPagedResponse> listVolumesSettings() {
        return this.listVolumesSettings;
    }

    public UnaryCallSettings<GetVolumeRequest, Volume> getVolumeSettings() {
        return this.getVolumeSettings;
    }

    public UnaryCallSettings<UpdateVolumeRequest, Operation> updateVolumeSettings() {
        return this.updateVolumeSettings;
    }

    public OperationCallSettings<UpdateVolumeRequest, Volume, OperationMetadata> updateVolumeOperationSettings() {
        return this.updateVolumeOperationSettings;
    }

    public PagedCallSettings<ListNetworksRequest, ListNetworksResponse, BareMetalSolutionClient.ListNetworksPagedResponse> listNetworksSettings() {
        return this.listNetworksSettings;
    }

    public UnaryCallSettings<GetNetworkRequest, Network> getNetworkSettings() {
        return this.getNetworkSettings;
    }

    public PagedCallSettings<ListSnapshotSchedulePoliciesRequest, ListSnapshotSchedulePoliciesResponse, BareMetalSolutionClient.ListSnapshotSchedulePoliciesPagedResponse> listSnapshotSchedulePoliciesSettings() {
        return this.listSnapshotSchedulePoliciesSettings;
    }

    public UnaryCallSettings<GetSnapshotSchedulePolicyRequest, SnapshotSchedulePolicy> getSnapshotSchedulePolicySettings() {
        return this.getSnapshotSchedulePolicySettings;
    }

    public UnaryCallSettings<CreateSnapshotSchedulePolicyRequest, SnapshotSchedulePolicy> createSnapshotSchedulePolicySettings() {
        return this.createSnapshotSchedulePolicySettings;
    }

    public UnaryCallSettings<UpdateSnapshotSchedulePolicyRequest, SnapshotSchedulePolicy> updateSnapshotSchedulePolicySettings() {
        return this.updateSnapshotSchedulePolicySettings;
    }

    public UnaryCallSettings<DeleteSnapshotSchedulePolicyRequest, Empty> deleteSnapshotSchedulePolicySettings() {
        return this.deleteSnapshotSchedulePolicySettings;
    }

    public UnaryCallSettings<CreateVolumeSnapshotRequest, VolumeSnapshot> createVolumeSnapshotSettings() {
        return this.createVolumeSnapshotSettings;
    }

    public UnaryCallSettings<RestoreVolumeSnapshotRequest, Operation> restoreVolumeSnapshotSettings() {
        return this.restoreVolumeSnapshotSettings;
    }

    public OperationCallSettings<RestoreVolumeSnapshotRequest, VolumeSnapshot, OperationMetadata> restoreVolumeSnapshotOperationSettings() {
        return this.restoreVolumeSnapshotOperationSettings;
    }

    public UnaryCallSettings<DeleteVolumeSnapshotRequest, Empty> deleteVolumeSnapshotSettings() {
        return this.deleteVolumeSnapshotSettings;
    }

    public UnaryCallSettings<GetVolumeSnapshotRequest, VolumeSnapshot> getVolumeSnapshotSettings() {
        return this.getVolumeSnapshotSettings;
    }

    public PagedCallSettings<ListVolumeSnapshotsRequest, ListVolumeSnapshotsResponse, BareMetalSolutionClient.ListVolumeSnapshotsPagedResponse> listVolumeSnapshotsSettings() {
        return this.listVolumeSnapshotsSettings;
    }

    public UnaryCallSettings<GetLunRequest, Lun> getLunSettings() {
        return this.getLunSettings;
    }

    public PagedCallSettings<ListLunsRequest, ListLunsResponse, BareMetalSolutionClient.ListLunsPagedResponse> listLunsSettings() {
        return this.listLunsSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public BareMetalSolutionStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcBareMetalSolutionStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "baremetalsolution.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "baremetalsolution.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return BareMetalSolutionStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(BareMetalSolutionStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected BareMetalSolutionStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listInstancesSettings = settingsBuilder.listInstancesSettings().build();
        this.getInstanceSettings = settingsBuilder.getInstanceSettings().build();
        this.resetInstanceSettings = settingsBuilder.resetInstanceSettings().build();
        this.resetInstanceOperationSettings = settingsBuilder.resetInstanceOperationSettings().build();
        this.listVolumesSettings = settingsBuilder.listVolumesSettings().build();
        this.getVolumeSettings = settingsBuilder.getVolumeSettings().build();
        this.updateVolumeSettings = settingsBuilder.updateVolumeSettings().build();
        this.updateVolumeOperationSettings = settingsBuilder.updateVolumeOperationSettings().build();
        this.listNetworksSettings = settingsBuilder.listNetworksSettings().build();
        this.getNetworkSettings = settingsBuilder.getNetworkSettings().build();
        this.listSnapshotSchedulePoliciesSettings = settingsBuilder.listSnapshotSchedulePoliciesSettings().build();
        this.getSnapshotSchedulePolicySettings = settingsBuilder.getSnapshotSchedulePolicySettings().build();
        this.createSnapshotSchedulePolicySettings = settingsBuilder.createSnapshotSchedulePolicySettings().build();
        this.updateSnapshotSchedulePolicySettings = settingsBuilder.updateSnapshotSchedulePolicySettings().build();
        this.deleteSnapshotSchedulePolicySettings = settingsBuilder.deleteSnapshotSchedulePolicySettings().build();
        this.createVolumeSnapshotSettings = settingsBuilder.createVolumeSnapshotSettings().build();
        this.restoreVolumeSnapshotSettings = settingsBuilder.restoreVolumeSnapshotSettings().build();
        this.restoreVolumeSnapshotOperationSettings = settingsBuilder.restoreVolumeSnapshotOperationSettings().build();
        this.deleteVolumeSnapshotSettings = settingsBuilder.deleteVolumeSnapshotSettings().build();
        this.getVolumeSnapshotSettings = settingsBuilder.getVolumeSnapshotSettings().build();
        this.listVolumeSnapshotsSettings = settingsBuilder.listVolumeSnapshotsSettings().build();
        this.getLunSettings = settingsBuilder.getLunSettings().build();
        this.listLunsSettings = settingsBuilder.listLunsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<BareMetalSolutionStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListInstancesRequest, ListInstancesResponse, BareMetalSolutionClient.ListInstancesPagedResponse> listInstancesSettings;
        private final UnaryCallSettings.Builder<GetInstanceRequest, Instance> getInstanceSettings;
        private final UnaryCallSettings.Builder<ResetInstanceRequest, Operation> resetInstanceSettings;
        private final OperationCallSettings.Builder<ResetInstanceRequest, ResetInstanceResponse, OperationMetadata> resetInstanceOperationSettings;
        private final PagedCallSettings.Builder<ListVolumesRequest, ListVolumesResponse, BareMetalSolutionClient.ListVolumesPagedResponse> listVolumesSettings;
        private final UnaryCallSettings.Builder<GetVolumeRequest, Volume> getVolumeSettings;
        private final UnaryCallSettings.Builder<UpdateVolumeRequest, Operation> updateVolumeSettings;
        private final OperationCallSettings.Builder<UpdateVolumeRequest, Volume, OperationMetadata> updateVolumeOperationSettings;
        private final PagedCallSettings.Builder<ListNetworksRequest, ListNetworksResponse, BareMetalSolutionClient.ListNetworksPagedResponse> listNetworksSettings;
        private final UnaryCallSettings.Builder<GetNetworkRequest, Network> getNetworkSettings;
        private final PagedCallSettings.Builder<ListSnapshotSchedulePoliciesRequest, ListSnapshotSchedulePoliciesResponse, BareMetalSolutionClient.ListSnapshotSchedulePoliciesPagedResponse> listSnapshotSchedulePoliciesSettings;
        private final UnaryCallSettings.Builder<GetSnapshotSchedulePolicyRequest, SnapshotSchedulePolicy> getSnapshotSchedulePolicySettings;
        private final UnaryCallSettings.Builder<CreateSnapshotSchedulePolicyRequest, SnapshotSchedulePolicy> createSnapshotSchedulePolicySettings;
        private final UnaryCallSettings.Builder<UpdateSnapshotSchedulePolicyRequest, SnapshotSchedulePolicy> updateSnapshotSchedulePolicySettings;
        private final UnaryCallSettings.Builder<DeleteSnapshotSchedulePolicyRequest, Empty> deleteSnapshotSchedulePolicySettings;
        private final UnaryCallSettings.Builder<CreateVolumeSnapshotRequest, VolumeSnapshot> createVolumeSnapshotSettings;
        private final UnaryCallSettings.Builder<RestoreVolumeSnapshotRequest, Operation> restoreVolumeSnapshotSettings;
        private final OperationCallSettings.Builder<RestoreVolumeSnapshotRequest, VolumeSnapshot, OperationMetadata> restoreVolumeSnapshotOperationSettings;
        private final UnaryCallSettings.Builder<DeleteVolumeSnapshotRequest, Empty> deleteVolumeSnapshotSettings;
        private final UnaryCallSettings.Builder<GetVolumeSnapshotRequest, VolumeSnapshot> getVolumeSnapshotSettings;
        private final PagedCallSettings.Builder<ListVolumeSnapshotsRequest, ListVolumeSnapshotsResponse, BareMetalSolutionClient.ListVolumeSnapshotsPagedResponse> listVolumeSnapshotsSettings;
        private final UnaryCallSettings.Builder<GetLunRequest, Lun> getLunSettings;
        private final PagedCallSettings.Builder<ListLunsRequest, ListLunsResponse, BareMetalSolutionClient.ListLunsPagedResponse> listLunsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listInstancesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_INSTANCES_PAGE_STR_FACT);
            this.getInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.resetInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.resetInstanceOperationSettings = OperationCallSettings.newBuilder();
            this.listVolumesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_VOLUMES_PAGE_STR_FACT);
            this.getVolumeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateVolumeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateVolumeOperationSettings = OperationCallSettings.newBuilder();
            this.listNetworksSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_NETWORKS_PAGE_STR_FACT);
            this.getNetworkSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSnapshotSchedulePoliciesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SNAPSHOT_SCHEDULE_POLICIES_PAGE_STR_FACT);
            this.getSnapshotSchedulePolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createSnapshotSchedulePolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateSnapshotSchedulePolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteSnapshotSchedulePolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createVolumeSnapshotSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.restoreVolumeSnapshotSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.restoreVolumeSnapshotOperationSettings = OperationCallSettings.newBuilder();
            this.deleteVolumeSnapshotSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getVolumeSnapshotSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listVolumeSnapshotsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_VOLUME_SNAPSHOTS_PAGE_STR_FACT);
            this.getLunSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLunsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LUNS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listInstancesSettings, this.getInstanceSettings, this.resetInstanceSettings, this.listVolumesSettings, this.getVolumeSettings, this.updateVolumeSettings, this.listNetworksSettings, this.getNetworkSettings, this.listSnapshotSchedulePoliciesSettings, this.getSnapshotSchedulePolicySettings, this.createSnapshotSchedulePolicySettings, this.updateSnapshotSchedulePolicySettings, (Object[])new UnaryCallSettings.Builder[]{this.deleteSnapshotSchedulePolicySettings, this.createVolumeSnapshotSettings, this.restoreVolumeSnapshotSettings, this.deleteVolumeSnapshotSettings, this.getVolumeSnapshotSettings, this.listVolumeSnapshotsSettings, this.getLunSettings, this.listLunsSettings});
            Builder.initDefaults(this);
        }

        protected Builder(BareMetalSolutionStubSettings settings) {
            super((StubSettings)settings);
            this.listInstancesSettings = settings.listInstancesSettings.toBuilder();
            this.getInstanceSettings = settings.getInstanceSettings.toBuilder();
            this.resetInstanceSettings = settings.resetInstanceSettings.toBuilder();
            this.resetInstanceOperationSettings = settings.resetInstanceOperationSettings.toBuilder();
            this.listVolumesSettings = settings.listVolumesSettings.toBuilder();
            this.getVolumeSettings = settings.getVolumeSettings.toBuilder();
            this.updateVolumeSettings = settings.updateVolumeSettings.toBuilder();
            this.updateVolumeOperationSettings = settings.updateVolumeOperationSettings.toBuilder();
            this.listNetworksSettings = settings.listNetworksSettings.toBuilder();
            this.getNetworkSettings = settings.getNetworkSettings.toBuilder();
            this.listSnapshotSchedulePoliciesSettings = settings.listSnapshotSchedulePoliciesSettings.toBuilder();
            this.getSnapshotSchedulePolicySettings = settings.getSnapshotSchedulePolicySettings.toBuilder();
            this.createSnapshotSchedulePolicySettings = settings.createSnapshotSchedulePolicySettings.toBuilder();
            this.updateSnapshotSchedulePolicySettings = settings.updateSnapshotSchedulePolicySettings.toBuilder();
            this.deleteSnapshotSchedulePolicySettings = settings.deleteSnapshotSchedulePolicySettings.toBuilder();
            this.createVolumeSnapshotSettings = settings.createVolumeSnapshotSettings.toBuilder();
            this.restoreVolumeSnapshotSettings = settings.restoreVolumeSnapshotSettings.toBuilder();
            this.restoreVolumeSnapshotOperationSettings = settings.restoreVolumeSnapshotOperationSettings.toBuilder();
            this.deleteVolumeSnapshotSettings = settings.deleteVolumeSnapshotSettings.toBuilder();
            this.getVolumeSnapshotSettings = settings.getVolumeSnapshotSettings.toBuilder();
            this.listVolumeSnapshotsSettings = settings.listVolumeSnapshotsSettings.toBuilder();
            this.getLunSettings = settings.getLunSettings.toBuilder();
            this.listLunsSettings = settings.listLunsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listInstancesSettings, this.getInstanceSettings, this.resetInstanceSettings, this.listVolumesSettings, this.getVolumeSettings, this.updateVolumeSettings, this.listNetworksSettings, this.getNetworkSettings, this.listSnapshotSchedulePoliciesSettings, this.getSnapshotSchedulePolicySettings, this.createSnapshotSchedulePolicySettings, this.updateSnapshotSchedulePolicySettings, (Object[])new UnaryCallSettings.Builder[]{this.deleteSnapshotSchedulePolicySettings, this.createVolumeSnapshotSettings, this.restoreVolumeSnapshotSettings, this.deleteVolumeSnapshotSettings, this.getVolumeSnapshotSettings, this.listVolumeSnapshotsSettings, this.getLunSettings, this.listLunsSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(BareMetalSolutionStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)BareMetalSolutionStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)BareMetalSolutionStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(BareMetalSolutionStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(BareMetalSolutionStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listInstancesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.resetInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.listVolumesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getVolumeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.updateVolumeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.listNetworksSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getNetworkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.listSnapshotSchedulePoliciesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getSnapshotSchedulePolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createSnapshotSchedulePolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.updateSnapshotSchedulePolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.deleteSnapshotSchedulePolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createVolumeSnapshotSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.restoreVolumeSnapshotSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.deleteVolumeSnapshotSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getVolumeSnapshotSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.listVolumeSnapshotsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getLunSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.listLunsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.resetInstanceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ResetInstanceResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateVolumeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Volume.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.restoreVolumeSnapshotOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(VolumeSnapshot.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListInstancesRequest, ListInstancesResponse, BareMetalSolutionClient.ListInstancesPagedResponse> listInstancesSettings() {
            return this.listInstancesSettings;
        }

        public UnaryCallSettings.Builder<GetInstanceRequest, Instance> getInstanceSettings() {
            return this.getInstanceSettings;
        }

        public UnaryCallSettings.Builder<ResetInstanceRequest, Operation> resetInstanceSettings() {
            return this.resetInstanceSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<ResetInstanceRequest, ResetInstanceResponse, OperationMetadata> resetInstanceOperationSettings() {
            return this.resetInstanceOperationSettings;
        }

        public PagedCallSettings.Builder<ListVolumesRequest, ListVolumesResponse, BareMetalSolutionClient.ListVolumesPagedResponse> listVolumesSettings() {
            return this.listVolumesSettings;
        }

        public UnaryCallSettings.Builder<GetVolumeRequest, Volume> getVolumeSettings() {
            return this.getVolumeSettings;
        }

        public UnaryCallSettings.Builder<UpdateVolumeRequest, Operation> updateVolumeSettings() {
            return this.updateVolumeSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateVolumeRequest, Volume, OperationMetadata> updateVolumeOperationSettings() {
            return this.updateVolumeOperationSettings;
        }

        public PagedCallSettings.Builder<ListNetworksRequest, ListNetworksResponse, BareMetalSolutionClient.ListNetworksPagedResponse> listNetworksSettings() {
            return this.listNetworksSettings;
        }

        public UnaryCallSettings.Builder<GetNetworkRequest, Network> getNetworkSettings() {
            return this.getNetworkSettings;
        }

        public PagedCallSettings.Builder<ListSnapshotSchedulePoliciesRequest, ListSnapshotSchedulePoliciesResponse, BareMetalSolutionClient.ListSnapshotSchedulePoliciesPagedResponse> listSnapshotSchedulePoliciesSettings() {
            return this.listSnapshotSchedulePoliciesSettings;
        }

        public UnaryCallSettings.Builder<GetSnapshotSchedulePolicyRequest, SnapshotSchedulePolicy> getSnapshotSchedulePolicySettings() {
            return this.getSnapshotSchedulePolicySettings;
        }

        public UnaryCallSettings.Builder<CreateSnapshotSchedulePolicyRequest, SnapshotSchedulePolicy> createSnapshotSchedulePolicySettings() {
            return this.createSnapshotSchedulePolicySettings;
        }

        public UnaryCallSettings.Builder<UpdateSnapshotSchedulePolicyRequest, SnapshotSchedulePolicy> updateSnapshotSchedulePolicySettings() {
            return this.updateSnapshotSchedulePolicySettings;
        }

        public UnaryCallSettings.Builder<DeleteSnapshotSchedulePolicyRequest, Empty> deleteSnapshotSchedulePolicySettings() {
            return this.deleteSnapshotSchedulePolicySettings;
        }

        public UnaryCallSettings.Builder<CreateVolumeSnapshotRequest, VolumeSnapshot> createVolumeSnapshotSettings() {
            return this.createVolumeSnapshotSettings;
        }

        public UnaryCallSettings.Builder<RestoreVolumeSnapshotRequest, Operation> restoreVolumeSnapshotSettings() {
            return this.restoreVolumeSnapshotSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<RestoreVolumeSnapshotRequest, VolumeSnapshot, OperationMetadata> restoreVolumeSnapshotOperationSettings() {
            return this.restoreVolumeSnapshotOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteVolumeSnapshotRequest, Empty> deleteVolumeSnapshotSettings() {
            return this.deleteVolumeSnapshotSettings;
        }

        public UnaryCallSettings.Builder<GetVolumeSnapshotRequest, VolumeSnapshot> getVolumeSnapshotSettings() {
            return this.getVolumeSnapshotSettings;
        }

        public PagedCallSettings.Builder<ListVolumeSnapshotsRequest, ListVolumeSnapshotsResponse, BareMetalSolutionClient.ListVolumeSnapshotsPagedResponse> listVolumeSnapshotsSettings() {
            return this.listVolumeSnapshotsSettings;
        }

        public UnaryCallSettings.Builder<GetLunRequest, Lun> getLunSettings() {
            return this.getLunSettings;
        }

        public PagedCallSettings.Builder<ListLunsRequest, ListLunsResponse, BareMetalSolutionClient.ListLunsPagedResponse> listLunsSettings() {
            return this.listLunsSettings;
        }

        public BareMetalSolutionStubSettings build() throws IOException {
            return new BareMetalSolutionStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

