/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.baremetalsolution.v2;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.baremetalsolution.v2.BareMetalSolutionSettings;
import com.google.cloud.baremetalsolution.v2.CreateSnapshotSchedulePolicyRequest;
import com.google.cloud.baremetalsolution.v2.CreateVolumeSnapshotRequest;
import com.google.cloud.baremetalsolution.v2.DeleteSnapshotSchedulePolicyRequest;
import com.google.cloud.baremetalsolution.v2.DeleteVolumeSnapshotRequest;
import com.google.cloud.baremetalsolution.v2.GetInstanceRequest;
import com.google.cloud.baremetalsolution.v2.GetLunRequest;
import com.google.cloud.baremetalsolution.v2.GetNetworkRequest;
import com.google.cloud.baremetalsolution.v2.GetSnapshotSchedulePolicyRequest;
import com.google.cloud.baremetalsolution.v2.GetVolumeRequest;
import com.google.cloud.baremetalsolution.v2.GetVolumeSnapshotRequest;
import com.google.cloud.baremetalsolution.v2.Instance;
import com.google.cloud.baremetalsolution.v2.InstanceName;
import com.google.cloud.baremetalsolution.v2.ListInstancesRequest;
import com.google.cloud.baremetalsolution.v2.ListInstancesResponse;
import com.google.cloud.baremetalsolution.v2.ListLunsRequest;
import com.google.cloud.baremetalsolution.v2.ListLunsResponse;
import com.google.cloud.baremetalsolution.v2.ListNetworksRequest;
import com.google.cloud.baremetalsolution.v2.ListNetworksResponse;
import com.google.cloud.baremetalsolution.v2.ListSnapshotSchedulePoliciesRequest;
import com.google.cloud.baremetalsolution.v2.ListSnapshotSchedulePoliciesResponse;
import com.google.cloud.baremetalsolution.v2.ListVolumeSnapshotsRequest;
import com.google.cloud.baremetalsolution.v2.ListVolumeSnapshotsResponse;
import com.google.cloud.baremetalsolution.v2.ListVolumesRequest;
import com.google.cloud.baremetalsolution.v2.ListVolumesResponse;
import com.google.cloud.baremetalsolution.v2.LocationName;
import com.google.cloud.baremetalsolution.v2.Lun;
import com.google.cloud.baremetalsolution.v2.LunName;
import com.google.cloud.baremetalsolution.v2.Network;
import com.google.cloud.baremetalsolution.v2.NetworkName;
import com.google.cloud.baremetalsolution.v2.OperationMetadata;
import com.google.cloud.baremetalsolution.v2.ResetInstanceRequest;
import com.google.cloud.baremetalsolution.v2.ResetInstanceResponse;
import com.google.cloud.baremetalsolution.v2.RestoreVolumeSnapshotRequest;
import com.google.cloud.baremetalsolution.v2.SnapshotSchedulePolicy;
import com.google.cloud.baremetalsolution.v2.SnapshotSchedulePolicyName;
import com.google.cloud.baremetalsolution.v2.UpdateSnapshotSchedulePolicyRequest;
import com.google.cloud.baremetalsolution.v2.UpdateVolumeRequest;
import com.google.cloud.baremetalsolution.v2.Volume;
import com.google.cloud.baremetalsolution.v2.VolumeName;
import com.google.cloud.baremetalsolution.v2.VolumeSnapshot;
import com.google.cloud.baremetalsolution.v2.VolumeSnapshotName;
import com.google.cloud.baremetalsolution.v2.stub.BareMetalSolutionStub;
import com.google.cloud.baremetalsolution.v2.stub.BareMetalSolutionStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class BareMetalSolutionClient
implements BackgroundResource {
    private final BareMetalSolutionSettings settings;
    private final BareMetalSolutionStub stub;
    private final OperationsClient operationsClient;

    public static final BareMetalSolutionClient create() throws IOException {
        return BareMetalSolutionClient.create(BareMetalSolutionSettings.newBuilder().build());
    }

    public static final BareMetalSolutionClient create(BareMetalSolutionSettings settings) throws IOException {
        return new BareMetalSolutionClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final BareMetalSolutionClient create(BareMetalSolutionStub stub) {
        return new BareMetalSolutionClient(stub);
    }

    protected BareMetalSolutionClient(BareMetalSolutionSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((BareMetalSolutionStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected BareMetalSolutionClient(BareMetalSolutionStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final BareMetalSolutionSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public BareMetalSolutionStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final ListInstancesPagedResponse listInstances(LocationName parent) {
        ListInstancesRequest request = ListInstancesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listInstances(request);
    }

    public final ListInstancesPagedResponse listInstances(String parent) {
        ListInstancesRequest request = ListInstancesRequest.newBuilder().setParent(parent).build();
        return this.listInstances(request);
    }

    public final ListInstancesPagedResponse listInstances(ListInstancesRequest request) {
        return (ListInstancesPagedResponse)((Object)this.listInstancesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListInstancesRequest, ListInstancesPagedResponse> listInstancesPagedCallable() {
        return this.stub.listInstancesPagedCallable();
    }

    public final UnaryCallable<ListInstancesRequest, ListInstancesResponse> listInstancesCallable() {
        return this.stub.listInstancesCallable();
    }

    public final Instance getInstance(InstanceName name) {
        GetInstanceRequest request = GetInstanceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getInstance(request);
    }

    public final Instance getInstance(String name) {
        GetInstanceRequest request = GetInstanceRequest.newBuilder().setName(name).build();
        return this.getInstance(request);
    }

    public final Instance getInstance(GetInstanceRequest request) {
        return (Instance)this.getInstanceCallable().call((Object)request);
    }

    public final UnaryCallable<GetInstanceRequest, Instance> getInstanceCallable() {
        return this.stub.getInstanceCallable();
    }

    public final OperationFuture<ResetInstanceResponse, OperationMetadata> resetInstanceAsync(InstanceName name) {
        ResetInstanceRequest request = ResetInstanceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.resetInstanceAsync(request);
    }

    public final OperationFuture<ResetInstanceResponse, OperationMetadata> resetInstanceAsync(String name) {
        ResetInstanceRequest request = ResetInstanceRequest.newBuilder().setName(name).build();
        return this.resetInstanceAsync(request);
    }

    public final OperationFuture<ResetInstanceResponse, OperationMetadata> resetInstanceAsync(ResetInstanceRequest request) {
        return this.resetInstanceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ResetInstanceRequest, ResetInstanceResponse, OperationMetadata> resetInstanceOperationCallable() {
        return this.stub.resetInstanceOperationCallable();
    }

    public final UnaryCallable<ResetInstanceRequest, Operation> resetInstanceCallable() {
        return this.stub.resetInstanceCallable();
    }

    public final ListVolumesPagedResponse listVolumes(LocationName parent) {
        ListVolumesRequest request = ListVolumesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listVolumes(request);
    }

    public final ListVolumesPagedResponse listVolumes(String parent) {
        ListVolumesRequest request = ListVolumesRequest.newBuilder().setParent(parent).build();
        return this.listVolumes(request);
    }

    public final ListVolumesPagedResponse listVolumes(ListVolumesRequest request) {
        return (ListVolumesPagedResponse)((Object)this.listVolumesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListVolumesRequest, ListVolumesPagedResponse> listVolumesPagedCallable() {
        return this.stub.listVolumesPagedCallable();
    }

    public final UnaryCallable<ListVolumesRequest, ListVolumesResponse> listVolumesCallable() {
        return this.stub.listVolumesCallable();
    }

    public final Volume getVolume(VolumeName name) {
        GetVolumeRequest request = GetVolumeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getVolume(request);
    }

    public final Volume getVolume(String name) {
        GetVolumeRequest request = GetVolumeRequest.newBuilder().setName(name).build();
        return this.getVolume(request);
    }

    public final Volume getVolume(GetVolumeRequest request) {
        return (Volume)this.getVolumeCallable().call((Object)request);
    }

    public final UnaryCallable<GetVolumeRequest, Volume> getVolumeCallable() {
        return this.stub.getVolumeCallable();
    }

    public final OperationFuture<Volume, OperationMetadata> updateVolumeAsync(Volume volume, FieldMask updateMask) {
        UpdateVolumeRequest request = UpdateVolumeRequest.newBuilder().setVolume(volume).setUpdateMask(updateMask).build();
        return this.updateVolumeAsync(request);
    }

    public final OperationFuture<Volume, OperationMetadata> updateVolumeAsync(UpdateVolumeRequest request) {
        return this.updateVolumeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateVolumeRequest, Volume, OperationMetadata> updateVolumeOperationCallable() {
        return this.stub.updateVolumeOperationCallable();
    }

    public final UnaryCallable<UpdateVolumeRequest, Operation> updateVolumeCallable() {
        return this.stub.updateVolumeCallable();
    }

    public final ListNetworksPagedResponse listNetworks(LocationName parent) {
        ListNetworksRequest request = ListNetworksRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listNetworks(request);
    }

    public final ListNetworksPagedResponse listNetworks(String parent) {
        ListNetworksRequest request = ListNetworksRequest.newBuilder().setParent(parent).build();
        return this.listNetworks(request);
    }

    public final ListNetworksPagedResponse listNetworks(ListNetworksRequest request) {
        return (ListNetworksPagedResponse)((Object)this.listNetworksPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListNetworksRequest, ListNetworksPagedResponse> listNetworksPagedCallable() {
        return this.stub.listNetworksPagedCallable();
    }

    public final UnaryCallable<ListNetworksRequest, ListNetworksResponse> listNetworksCallable() {
        return this.stub.listNetworksCallable();
    }

    public final Network getNetwork(NetworkName name) {
        GetNetworkRequest request = GetNetworkRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getNetwork(request);
    }

    public final Network getNetwork(String name) {
        GetNetworkRequest request = GetNetworkRequest.newBuilder().setName(name).build();
        return this.getNetwork(request);
    }

    public final Network getNetwork(GetNetworkRequest request) {
        return (Network)this.getNetworkCallable().call((Object)request);
    }

    public final UnaryCallable<GetNetworkRequest, Network> getNetworkCallable() {
        return this.stub.getNetworkCallable();
    }

    public final ListSnapshotSchedulePoliciesPagedResponse listSnapshotSchedulePolicies(LocationName parent) {
        ListSnapshotSchedulePoliciesRequest request = ListSnapshotSchedulePoliciesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listSnapshotSchedulePolicies(request);
    }

    public final ListSnapshotSchedulePoliciesPagedResponse listSnapshotSchedulePolicies(String parent) {
        ListSnapshotSchedulePoliciesRequest request = ListSnapshotSchedulePoliciesRequest.newBuilder().setParent(parent).build();
        return this.listSnapshotSchedulePolicies(request);
    }

    public final ListSnapshotSchedulePoliciesPagedResponse listSnapshotSchedulePolicies(ListSnapshotSchedulePoliciesRequest request) {
        return (ListSnapshotSchedulePoliciesPagedResponse)((Object)this.listSnapshotSchedulePoliciesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSnapshotSchedulePoliciesRequest, ListSnapshotSchedulePoliciesPagedResponse> listSnapshotSchedulePoliciesPagedCallable() {
        return this.stub.listSnapshotSchedulePoliciesPagedCallable();
    }

    public final UnaryCallable<ListSnapshotSchedulePoliciesRequest, ListSnapshotSchedulePoliciesResponse> listSnapshotSchedulePoliciesCallable() {
        return this.stub.listSnapshotSchedulePoliciesCallable();
    }

    public final SnapshotSchedulePolicy getSnapshotSchedulePolicy(SnapshotSchedulePolicyName name) {
        GetSnapshotSchedulePolicyRequest request = GetSnapshotSchedulePolicyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSnapshotSchedulePolicy(request);
    }

    public final SnapshotSchedulePolicy getSnapshotSchedulePolicy(String name) {
        GetSnapshotSchedulePolicyRequest request = GetSnapshotSchedulePolicyRequest.newBuilder().setName(name).build();
        return this.getSnapshotSchedulePolicy(request);
    }

    public final SnapshotSchedulePolicy getSnapshotSchedulePolicy(GetSnapshotSchedulePolicyRequest request) {
        return (SnapshotSchedulePolicy)this.getSnapshotSchedulePolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetSnapshotSchedulePolicyRequest, SnapshotSchedulePolicy> getSnapshotSchedulePolicyCallable() {
        return this.stub.getSnapshotSchedulePolicyCallable();
    }

    public final SnapshotSchedulePolicy createSnapshotSchedulePolicy(LocationName parent, SnapshotSchedulePolicy snapshotSchedulePolicy, String snapshotSchedulePolicyId) {
        CreateSnapshotSchedulePolicyRequest request = CreateSnapshotSchedulePolicyRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setSnapshotSchedulePolicy(snapshotSchedulePolicy).setSnapshotSchedulePolicyId(snapshotSchedulePolicyId).build();
        return this.createSnapshotSchedulePolicy(request);
    }

    public final SnapshotSchedulePolicy createSnapshotSchedulePolicy(String parent, SnapshotSchedulePolicy snapshotSchedulePolicy, String snapshotSchedulePolicyId) {
        CreateSnapshotSchedulePolicyRequest request = CreateSnapshotSchedulePolicyRequest.newBuilder().setParent(parent).setSnapshotSchedulePolicy(snapshotSchedulePolicy).setSnapshotSchedulePolicyId(snapshotSchedulePolicyId).build();
        return this.createSnapshotSchedulePolicy(request);
    }

    public final SnapshotSchedulePolicy createSnapshotSchedulePolicy(CreateSnapshotSchedulePolicyRequest request) {
        return (SnapshotSchedulePolicy)this.createSnapshotSchedulePolicyCallable().call((Object)request);
    }

    public final UnaryCallable<CreateSnapshotSchedulePolicyRequest, SnapshotSchedulePolicy> createSnapshotSchedulePolicyCallable() {
        return this.stub.createSnapshotSchedulePolicyCallable();
    }

    public final SnapshotSchedulePolicy updateSnapshotSchedulePolicy(SnapshotSchedulePolicy snapshotSchedulePolicy, FieldMask updateMask) {
        UpdateSnapshotSchedulePolicyRequest request = UpdateSnapshotSchedulePolicyRequest.newBuilder().setSnapshotSchedulePolicy(snapshotSchedulePolicy).setUpdateMask(updateMask).build();
        return this.updateSnapshotSchedulePolicy(request);
    }

    public final SnapshotSchedulePolicy updateSnapshotSchedulePolicy(UpdateSnapshotSchedulePolicyRequest request) {
        return (SnapshotSchedulePolicy)this.updateSnapshotSchedulePolicyCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateSnapshotSchedulePolicyRequest, SnapshotSchedulePolicy> updateSnapshotSchedulePolicyCallable() {
        return this.stub.updateSnapshotSchedulePolicyCallable();
    }

    public final void deleteSnapshotSchedulePolicy(SnapshotSchedulePolicyName name) {
        DeleteSnapshotSchedulePolicyRequest request = DeleteSnapshotSchedulePolicyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteSnapshotSchedulePolicy(request);
    }

    public final void deleteSnapshotSchedulePolicy(String name) {
        DeleteSnapshotSchedulePolicyRequest request = DeleteSnapshotSchedulePolicyRequest.newBuilder().setName(name).build();
        this.deleteSnapshotSchedulePolicy(request);
    }

    public final void deleteSnapshotSchedulePolicy(DeleteSnapshotSchedulePolicyRequest request) {
        this.deleteSnapshotSchedulePolicyCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteSnapshotSchedulePolicyRequest, Empty> deleteSnapshotSchedulePolicyCallable() {
        return this.stub.deleteSnapshotSchedulePolicyCallable();
    }

    public final VolumeSnapshot createVolumeSnapshot(VolumeName parent, VolumeSnapshot volumeSnapshot) {
        CreateVolumeSnapshotRequest request = CreateVolumeSnapshotRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setVolumeSnapshot(volumeSnapshot).build();
        return this.createVolumeSnapshot(request);
    }

    public final VolumeSnapshot createVolumeSnapshot(String parent, VolumeSnapshot volumeSnapshot) {
        CreateVolumeSnapshotRequest request = CreateVolumeSnapshotRequest.newBuilder().setParent(parent).setVolumeSnapshot(volumeSnapshot).build();
        return this.createVolumeSnapshot(request);
    }

    public final VolumeSnapshot createVolumeSnapshot(CreateVolumeSnapshotRequest request) {
        return (VolumeSnapshot)this.createVolumeSnapshotCallable().call((Object)request);
    }

    public final UnaryCallable<CreateVolumeSnapshotRequest, VolumeSnapshot> createVolumeSnapshotCallable() {
        return this.stub.createVolumeSnapshotCallable();
    }

    public final OperationFuture<VolumeSnapshot, OperationMetadata> restoreVolumeSnapshotAsync(VolumeSnapshotName volumeSnapshot) {
        RestoreVolumeSnapshotRequest request = RestoreVolumeSnapshotRequest.newBuilder().setVolumeSnapshot(volumeSnapshot == null ? null : volumeSnapshot.toString()).build();
        return this.restoreVolumeSnapshotAsync(request);
    }

    public final OperationFuture<VolumeSnapshot, OperationMetadata> restoreVolumeSnapshotAsync(String volumeSnapshot) {
        RestoreVolumeSnapshotRequest request = RestoreVolumeSnapshotRequest.newBuilder().setVolumeSnapshot(volumeSnapshot).build();
        return this.restoreVolumeSnapshotAsync(request);
    }

    public final OperationFuture<VolumeSnapshot, OperationMetadata> restoreVolumeSnapshotAsync(RestoreVolumeSnapshotRequest request) {
        return this.restoreVolumeSnapshotOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RestoreVolumeSnapshotRequest, VolumeSnapshot, OperationMetadata> restoreVolumeSnapshotOperationCallable() {
        return this.stub.restoreVolumeSnapshotOperationCallable();
    }

    public final UnaryCallable<RestoreVolumeSnapshotRequest, Operation> restoreVolumeSnapshotCallable() {
        return this.stub.restoreVolumeSnapshotCallable();
    }

    public final void deleteVolumeSnapshot(VolumeSnapshotName name) {
        DeleteVolumeSnapshotRequest request = DeleteVolumeSnapshotRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteVolumeSnapshot(request);
    }

    public final void deleteVolumeSnapshot(String name) {
        DeleteVolumeSnapshotRequest request = DeleteVolumeSnapshotRequest.newBuilder().setName(name).build();
        this.deleteVolumeSnapshot(request);
    }

    public final void deleteVolumeSnapshot(DeleteVolumeSnapshotRequest request) {
        this.deleteVolumeSnapshotCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteVolumeSnapshotRequest, Empty> deleteVolumeSnapshotCallable() {
        return this.stub.deleteVolumeSnapshotCallable();
    }

    public final VolumeSnapshot getVolumeSnapshot(VolumeSnapshotName name) {
        GetVolumeSnapshotRequest request = GetVolumeSnapshotRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getVolumeSnapshot(request);
    }

    public final VolumeSnapshot getVolumeSnapshot(String name) {
        GetVolumeSnapshotRequest request = GetVolumeSnapshotRequest.newBuilder().setName(name).build();
        return this.getVolumeSnapshot(request);
    }

    public final VolumeSnapshot getVolumeSnapshot(GetVolumeSnapshotRequest request) {
        return (VolumeSnapshot)this.getVolumeSnapshotCallable().call((Object)request);
    }

    public final UnaryCallable<GetVolumeSnapshotRequest, VolumeSnapshot> getVolumeSnapshotCallable() {
        return this.stub.getVolumeSnapshotCallable();
    }

    public final ListVolumeSnapshotsPagedResponse listVolumeSnapshots(VolumeName parent) {
        ListVolumeSnapshotsRequest request = ListVolumeSnapshotsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listVolumeSnapshots(request);
    }

    public final ListVolumeSnapshotsPagedResponse listVolumeSnapshots(String parent) {
        ListVolumeSnapshotsRequest request = ListVolumeSnapshotsRequest.newBuilder().setParent(parent).build();
        return this.listVolumeSnapshots(request);
    }

    public final ListVolumeSnapshotsPagedResponse listVolumeSnapshots(ListVolumeSnapshotsRequest request) {
        return (ListVolumeSnapshotsPagedResponse)((Object)this.listVolumeSnapshotsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListVolumeSnapshotsRequest, ListVolumeSnapshotsPagedResponse> listVolumeSnapshotsPagedCallable() {
        return this.stub.listVolumeSnapshotsPagedCallable();
    }

    public final UnaryCallable<ListVolumeSnapshotsRequest, ListVolumeSnapshotsResponse> listVolumeSnapshotsCallable() {
        return this.stub.listVolumeSnapshotsCallable();
    }

    public final Lun getLun(LunName name) {
        GetLunRequest request = GetLunRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getLun(request);
    }

    public final Lun getLun(String name) {
        GetLunRequest request = GetLunRequest.newBuilder().setName(name).build();
        return this.getLun(request);
    }

    public final Lun getLun(GetLunRequest request) {
        return (Lun)this.getLunCallable().call((Object)request);
    }

    public final UnaryCallable<GetLunRequest, Lun> getLunCallable() {
        return this.stub.getLunCallable();
    }

    public final ListLunsPagedResponse listLuns(VolumeName parent) {
        ListLunsRequest request = ListLunsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listLuns(request);
    }

    public final ListLunsPagedResponse listLuns(String parent) {
        ListLunsRequest request = ListLunsRequest.newBuilder().setParent(parent).build();
        return this.listLuns(request);
    }

    public final ListLunsPagedResponse listLuns(ListLunsRequest request) {
        return (ListLunsPagedResponse)((Object)this.listLunsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLunsRequest, ListLunsPagedResponse> listLunsPagedCallable() {
        return this.stub.listLunsPagedCallable();
    }

    public final UnaryCallable<ListLunsRequest, ListLunsResponse> listLunsCallable() {
        return this.stub.listLunsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLunsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLunsRequest, ListLunsResponse, Lun, ListLunsPage, ListLunsFixedSizeCollection> {
        private ListLunsFixedSizeCollection(List<ListLunsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLunsFixedSizeCollection createEmptyCollection() {
            return new ListLunsFixedSizeCollection(null, 0);
        }

        protected ListLunsFixedSizeCollection createCollection(List<ListLunsPage> pages, int collectionSize) {
            return new ListLunsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLunsPage
    extends AbstractPage<ListLunsRequest, ListLunsResponse, Lun, ListLunsPage> {
        private ListLunsPage(PageContext<ListLunsRequest, ListLunsResponse, Lun> context, ListLunsResponse response) {
            super(context, (Object)response);
        }

        private static ListLunsPage createEmptyPage() {
            return new ListLunsPage(null, null);
        }

        protected ListLunsPage createPage(PageContext<ListLunsRequest, ListLunsResponse, Lun> context, ListLunsResponse response) {
            return new ListLunsPage(context, response);
        }

        public ApiFuture<ListLunsPage> createPageAsync(PageContext<ListLunsRequest, ListLunsResponse, Lun> context, ApiFuture<ListLunsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLunsPagedResponse
    extends AbstractPagedListResponse<ListLunsRequest, ListLunsResponse, Lun, ListLunsPage, ListLunsFixedSizeCollection> {
        public static ApiFuture<ListLunsPagedResponse> createAsync(PageContext<ListLunsRequest, ListLunsResponse, Lun> context, ApiFuture<ListLunsResponse> futureResponse) {
            ApiFuture<ListLunsPage> futurePage = ListLunsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLunsPagedResponse((ListLunsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLunsPagedResponse(ListLunsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLunsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListVolumeSnapshotsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListVolumeSnapshotsRequest, ListVolumeSnapshotsResponse, VolumeSnapshot, ListVolumeSnapshotsPage, ListVolumeSnapshotsFixedSizeCollection> {
        private ListVolumeSnapshotsFixedSizeCollection(List<ListVolumeSnapshotsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListVolumeSnapshotsFixedSizeCollection createEmptyCollection() {
            return new ListVolumeSnapshotsFixedSizeCollection(null, 0);
        }

        protected ListVolumeSnapshotsFixedSizeCollection createCollection(List<ListVolumeSnapshotsPage> pages, int collectionSize) {
            return new ListVolumeSnapshotsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListVolumeSnapshotsPage
    extends AbstractPage<ListVolumeSnapshotsRequest, ListVolumeSnapshotsResponse, VolumeSnapshot, ListVolumeSnapshotsPage> {
        private ListVolumeSnapshotsPage(PageContext<ListVolumeSnapshotsRequest, ListVolumeSnapshotsResponse, VolumeSnapshot> context, ListVolumeSnapshotsResponse response) {
            super(context, (Object)response);
        }

        private static ListVolumeSnapshotsPage createEmptyPage() {
            return new ListVolumeSnapshotsPage(null, null);
        }

        protected ListVolumeSnapshotsPage createPage(PageContext<ListVolumeSnapshotsRequest, ListVolumeSnapshotsResponse, VolumeSnapshot> context, ListVolumeSnapshotsResponse response) {
            return new ListVolumeSnapshotsPage(context, response);
        }

        public ApiFuture<ListVolumeSnapshotsPage> createPageAsync(PageContext<ListVolumeSnapshotsRequest, ListVolumeSnapshotsResponse, VolumeSnapshot> context, ApiFuture<ListVolumeSnapshotsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListVolumeSnapshotsPagedResponse
    extends AbstractPagedListResponse<ListVolumeSnapshotsRequest, ListVolumeSnapshotsResponse, VolumeSnapshot, ListVolumeSnapshotsPage, ListVolumeSnapshotsFixedSizeCollection> {
        public static ApiFuture<ListVolumeSnapshotsPagedResponse> createAsync(PageContext<ListVolumeSnapshotsRequest, ListVolumeSnapshotsResponse, VolumeSnapshot> context, ApiFuture<ListVolumeSnapshotsResponse> futureResponse) {
            ApiFuture<ListVolumeSnapshotsPage> futurePage = ListVolumeSnapshotsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListVolumeSnapshotsPagedResponse((ListVolumeSnapshotsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListVolumeSnapshotsPagedResponse(ListVolumeSnapshotsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListVolumeSnapshotsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListSnapshotSchedulePoliciesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSnapshotSchedulePoliciesRequest, ListSnapshotSchedulePoliciesResponse, SnapshotSchedulePolicy, ListSnapshotSchedulePoliciesPage, ListSnapshotSchedulePoliciesFixedSizeCollection> {
        private ListSnapshotSchedulePoliciesFixedSizeCollection(List<ListSnapshotSchedulePoliciesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSnapshotSchedulePoliciesFixedSizeCollection createEmptyCollection() {
            return new ListSnapshotSchedulePoliciesFixedSizeCollection(null, 0);
        }

        protected ListSnapshotSchedulePoliciesFixedSizeCollection createCollection(List<ListSnapshotSchedulePoliciesPage> pages, int collectionSize) {
            return new ListSnapshotSchedulePoliciesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSnapshotSchedulePoliciesPage
    extends AbstractPage<ListSnapshotSchedulePoliciesRequest, ListSnapshotSchedulePoliciesResponse, SnapshotSchedulePolicy, ListSnapshotSchedulePoliciesPage> {
        private ListSnapshotSchedulePoliciesPage(PageContext<ListSnapshotSchedulePoliciesRequest, ListSnapshotSchedulePoliciesResponse, SnapshotSchedulePolicy> context, ListSnapshotSchedulePoliciesResponse response) {
            super(context, (Object)response);
        }

        private static ListSnapshotSchedulePoliciesPage createEmptyPage() {
            return new ListSnapshotSchedulePoliciesPage(null, null);
        }

        protected ListSnapshotSchedulePoliciesPage createPage(PageContext<ListSnapshotSchedulePoliciesRequest, ListSnapshotSchedulePoliciesResponse, SnapshotSchedulePolicy> context, ListSnapshotSchedulePoliciesResponse response) {
            return new ListSnapshotSchedulePoliciesPage(context, response);
        }

        public ApiFuture<ListSnapshotSchedulePoliciesPage> createPageAsync(PageContext<ListSnapshotSchedulePoliciesRequest, ListSnapshotSchedulePoliciesResponse, SnapshotSchedulePolicy> context, ApiFuture<ListSnapshotSchedulePoliciesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSnapshotSchedulePoliciesPagedResponse
    extends AbstractPagedListResponse<ListSnapshotSchedulePoliciesRequest, ListSnapshotSchedulePoliciesResponse, SnapshotSchedulePolicy, ListSnapshotSchedulePoliciesPage, ListSnapshotSchedulePoliciesFixedSizeCollection> {
        public static ApiFuture<ListSnapshotSchedulePoliciesPagedResponse> createAsync(PageContext<ListSnapshotSchedulePoliciesRequest, ListSnapshotSchedulePoliciesResponse, SnapshotSchedulePolicy> context, ApiFuture<ListSnapshotSchedulePoliciesResponse> futureResponse) {
            ApiFuture<ListSnapshotSchedulePoliciesPage> futurePage = ListSnapshotSchedulePoliciesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListSnapshotSchedulePoliciesPagedResponse((ListSnapshotSchedulePoliciesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListSnapshotSchedulePoliciesPagedResponse(ListSnapshotSchedulePoliciesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSnapshotSchedulePoliciesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListNetworksFixedSizeCollection
    extends AbstractFixedSizeCollection<ListNetworksRequest, ListNetworksResponse, Network, ListNetworksPage, ListNetworksFixedSizeCollection> {
        private ListNetworksFixedSizeCollection(List<ListNetworksPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListNetworksFixedSizeCollection createEmptyCollection() {
            return new ListNetworksFixedSizeCollection(null, 0);
        }

        protected ListNetworksFixedSizeCollection createCollection(List<ListNetworksPage> pages, int collectionSize) {
            return new ListNetworksFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListNetworksPage
    extends AbstractPage<ListNetworksRequest, ListNetworksResponse, Network, ListNetworksPage> {
        private ListNetworksPage(PageContext<ListNetworksRequest, ListNetworksResponse, Network> context, ListNetworksResponse response) {
            super(context, (Object)response);
        }

        private static ListNetworksPage createEmptyPage() {
            return new ListNetworksPage(null, null);
        }

        protected ListNetworksPage createPage(PageContext<ListNetworksRequest, ListNetworksResponse, Network> context, ListNetworksResponse response) {
            return new ListNetworksPage(context, response);
        }

        public ApiFuture<ListNetworksPage> createPageAsync(PageContext<ListNetworksRequest, ListNetworksResponse, Network> context, ApiFuture<ListNetworksResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListNetworksPagedResponse
    extends AbstractPagedListResponse<ListNetworksRequest, ListNetworksResponse, Network, ListNetworksPage, ListNetworksFixedSizeCollection> {
        public static ApiFuture<ListNetworksPagedResponse> createAsync(PageContext<ListNetworksRequest, ListNetworksResponse, Network> context, ApiFuture<ListNetworksResponse> futureResponse) {
            ApiFuture<ListNetworksPage> futurePage = ListNetworksPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListNetworksPagedResponse((ListNetworksPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListNetworksPagedResponse(ListNetworksPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListNetworksFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListVolumesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListVolumesRequest, ListVolumesResponse, Volume, ListVolumesPage, ListVolumesFixedSizeCollection> {
        private ListVolumesFixedSizeCollection(List<ListVolumesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListVolumesFixedSizeCollection createEmptyCollection() {
            return new ListVolumesFixedSizeCollection(null, 0);
        }

        protected ListVolumesFixedSizeCollection createCollection(List<ListVolumesPage> pages, int collectionSize) {
            return new ListVolumesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListVolumesPage
    extends AbstractPage<ListVolumesRequest, ListVolumesResponse, Volume, ListVolumesPage> {
        private ListVolumesPage(PageContext<ListVolumesRequest, ListVolumesResponse, Volume> context, ListVolumesResponse response) {
            super(context, (Object)response);
        }

        private static ListVolumesPage createEmptyPage() {
            return new ListVolumesPage(null, null);
        }

        protected ListVolumesPage createPage(PageContext<ListVolumesRequest, ListVolumesResponse, Volume> context, ListVolumesResponse response) {
            return new ListVolumesPage(context, response);
        }

        public ApiFuture<ListVolumesPage> createPageAsync(PageContext<ListVolumesRequest, ListVolumesResponse, Volume> context, ApiFuture<ListVolumesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListVolumesPagedResponse
    extends AbstractPagedListResponse<ListVolumesRequest, ListVolumesResponse, Volume, ListVolumesPage, ListVolumesFixedSizeCollection> {
        public static ApiFuture<ListVolumesPagedResponse> createAsync(PageContext<ListVolumesRequest, ListVolumesResponse, Volume> context, ApiFuture<ListVolumesResponse> futureResponse) {
            ApiFuture<ListVolumesPage> futurePage = ListVolumesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListVolumesPagedResponse((ListVolumesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListVolumesPagedResponse(ListVolumesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListVolumesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListInstancesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListInstancesRequest, ListInstancesResponse, Instance, ListInstancesPage, ListInstancesFixedSizeCollection> {
        private ListInstancesFixedSizeCollection(List<ListInstancesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListInstancesFixedSizeCollection createEmptyCollection() {
            return new ListInstancesFixedSizeCollection(null, 0);
        }

        protected ListInstancesFixedSizeCollection createCollection(List<ListInstancesPage> pages, int collectionSize) {
            return new ListInstancesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListInstancesPage
    extends AbstractPage<ListInstancesRequest, ListInstancesResponse, Instance, ListInstancesPage> {
        private ListInstancesPage(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ListInstancesResponse response) {
            super(context, (Object)response);
        }

        private static ListInstancesPage createEmptyPage() {
            return new ListInstancesPage(null, null);
        }

        protected ListInstancesPage createPage(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ListInstancesResponse response) {
            return new ListInstancesPage(context, response);
        }

        public ApiFuture<ListInstancesPage> createPageAsync(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ApiFuture<ListInstancesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListInstancesPagedResponse
    extends AbstractPagedListResponse<ListInstancesRequest, ListInstancesResponse, Instance, ListInstancesPage, ListInstancesFixedSizeCollection> {
        public static ApiFuture<ListInstancesPagedResponse> createAsync(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ApiFuture<ListInstancesResponse> futureResponse) {
            ApiFuture<ListInstancesPage> futurePage = ListInstancesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListInstancesPagedResponse((ListInstancesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListInstancesPagedResponse(ListInstancesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListInstancesFixedSizeCollection.createEmptyCollection());
        }
    }
}

