/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.backupdr.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.backupdr.v1.BackupDRClient;
import com.google.cloud.backupdr.v1.CreateManagementServerRequest;
import com.google.cloud.backupdr.v1.DeleteManagementServerRequest;
import com.google.cloud.backupdr.v1.GetManagementServerRequest;
import com.google.cloud.backupdr.v1.ListManagementServersRequest;
import com.google.cloud.backupdr.v1.ListManagementServersResponse;
import com.google.cloud.backupdr.v1.ManagementServer;
import com.google.cloud.backupdr.v1.OperationMetadata;
import com.google.cloud.backupdr.v1.stub.BackupDRStub;
import com.google.cloud.backupdr.v1.stub.BackupDRStubSettings;
import com.google.cloud.backupdr.v1.stub.GrpcBackupDRCallableFactory;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcBackupDRStub
extends BackupDRStub {
    private static final MethodDescriptor<ListManagementServersRequest, ListManagementServersResponse> listManagementServersMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.backupdr.v1.BackupDR/ListManagementServers").setRequestMarshaller(ProtoUtils.marshaller((Message)ListManagementServersRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListManagementServersResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetManagementServerRequest, ManagementServer> getManagementServerMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.backupdr.v1.BackupDR/GetManagementServer").setRequestMarshaller(ProtoUtils.marshaller((Message)GetManagementServerRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ManagementServer.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateManagementServerRequest, Operation> createManagementServerMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.backupdr.v1.BackupDR/CreateManagementServer").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateManagementServerRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteManagementServerRequest, Operation> deleteManagementServerMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.backupdr.v1.BackupDR/DeleteManagementServer").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteManagementServerRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).build();
    private static final MethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/SetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)SetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/GetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)GetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/TestIamPermissions").setRequestMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsResponse.getDefaultInstance())).build();
    private final UnaryCallable<ListManagementServersRequest, ListManagementServersResponse> listManagementServersCallable;
    private final UnaryCallable<ListManagementServersRequest, BackupDRClient.ListManagementServersPagedResponse> listManagementServersPagedCallable;
    private final UnaryCallable<GetManagementServerRequest, ManagementServer> getManagementServerCallable;
    private final UnaryCallable<CreateManagementServerRequest, Operation> createManagementServerCallable;
    private final OperationCallable<CreateManagementServerRequest, ManagementServer, OperationMetadata> createManagementServerOperationCallable;
    private final UnaryCallable<DeleteManagementServerRequest, Operation> deleteManagementServerCallable;
    private final OperationCallable<DeleteManagementServerRequest, Empty, OperationMetadata> deleteManagementServerOperationCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, BackupDRClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcBackupDRStub create(BackupDRStubSettings settings) throws IOException {
        return new GrpcBackupDRStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcBackupDRStub create(ClientContext clientContext) throws IOException {
        return new GrpcBackupDRStub(BackupDRStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcBackupDRStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcBackupDRStub(BackupDRStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcBackupDRStub(BackupDRStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcBackupDRCallableFactory());
    }

    protected GrpcBackupDRStub(BackupDRStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listManagementServersTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listManagementServersMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getManagementServerTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getManagementServerMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createManagementServerTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createManagementServerMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteManagementServerTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteManagementServerMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings setIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings getIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings testIamPermissionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        this.listManagementServersCallable = callableFactory.createUnaryCallable(listManagementServersTransportSettings, settings.listManagementServersSettings(), clientContext);
        this.listManagementServersPagedCallable = callableFactory.createPagedCallable(listManagementServersTransportSettings, settings.listManagementServersSettings(), clientContext);
        this.getManagementServerCallable = callableFactory.createUnaryCallable(getManagementServerTransportSettings, settings.getManagementServerSettings(), clientContext);
        this.createManagementServerCallable = callableFactory.createUnaryCallable(createManagementServerTransportSettings, settings.createManagementServerSettings(), clientContext);
        this.createManagementServerOperationCallable = callableFactory.createOperationCallable(createManagementServerTransportSettings, settings.createManagementServerOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteManagementServerCallable = callableFactory.createUnaryCallable(deleteManagementServerTransportSettings, settings.deleteManagementServerSettings(), clientContext);
        this.deleteManagementServerOperationCallable = callableFactory.createOperationCallable(deleteManagementServerTransportSettings, settings.deleteManagementServerOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListManagementServersRequest, ListManagementServersResponse> listManagementServersCallable() {
        return this.listManagementServersCallable;
    }

    @Override
    public UnaryCallable<ListManagementServersRequest, BackupDRClient.ListManagementServersPagedResponse> listManagementServersPagedCallable() {
        return this.listManagementServersPagedCallable;
    }

    @Override
    public UnaryCallable<GetManagementServerRequest, ManagementServer> getManagementServerCallable() {
        return this.getManagementServerCallable;
    }

    @Override
    public UnaryCallable<CreateManagementServerRequest, Operation> createManagementServerCallable() {
        return this.createManagementServerCallable;
    }

    @Override
    public OperationCallable<CreateManagementServerRequest, ManagementServer, OperationMetadata> createManagementServerOperationCallable() {
        return this.createManagementServerOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteManagementServerRequest, Operation> deleteManagementServerCallable() {
        return this.deleteManagementServerCallable;
    }

    @Override
    public OperationCallable<DeleteManagementServerRequest, Empty, OperationMetadata> deleteManagementServerOperationCallable() {
        return this.deleteManagementServerOperationCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, BackupDRClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

