/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.backupdr.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.backupdr.v1.Backup;
import com.google.cloud.backupdr.v1.BackupDRClient;
import com.google.cloud.backupdr.v1.BackupPlan;
import com.google.cloud.backupdr.v1.BackupPlanAssociation;
import com.google.cloud.backupdr.v1.BackupVault;
import com.google.cloud.backupdr.v1.CreateBackupPlanAssociationRequest;
import com.google.cloud.backupdr.v1.CreateBackupPlanRequest;
import com.google.cloud.backupdr.v1.CreateBackupVaultRequest;
import com.google.cloud.backupdr.v1.CreateManagementServerRequest;
import com.google.cloud.backupdr.v1.DataSource;
import com.google.cloud.backupdr.v1.DeleteBackupPlanAssociationRequest;
import com.google.cloud.backupdr.v1.DeleteBackupPlanRequest;
import com.google.cloud.backupdr.v1.DeleteBackupRequest;
import com.google.cloud.backupdr.v1.DeleteBackupVaultRequest;
import com.google.cloud.backupdr.v1.DeleteManagementServerRequest;
import com.google.cloud.backupdr.v1.FetchUsableBackupVaultsRequest;
import com.google.cloud.backupdr.v1.FetchUsableBackupVaultsResponse;
import com.google.cloud.backupdr.v1.GetBackupPlanAssociationRequest;
import com.google.cloud.backupdr.v1.GetBackupPlanRequest;
import com.google.cloud.backupdr.v1.GetBackupRequest;
import com.google.cloud.backupdr.v1.GetBackupVaultRequest;
import com.google.cloud.backupdr.v1.GetDataSourceRequest;
import com.google.cloud.backupdr.v1.GetManagementServerRequest;
import com.google.cloud.backupdr.v1.InitializeServiceRequest;
import com.google.cloud.backupdr.v1.InitializeServiceResponse;
import com.google.cloud.backupdr.v1.ListBackupPlanAssociationsRequest;
import com.google.cloud.backupdr.v1.ListBackupPlanAssociationsResponse;
import com.google.cloud.backupdr.v1.ListBackupPlansRequest;
import com.google.cloud.backupdr.v1.ListBackupPlansResponse;
import com.google.cloud.backupdr.v1.ListBackupVaultsRequest;
import com.google.cloud.backupdr.v1.ListBackupVaultsResponse;
import com.google.cloud.backupdr.v1.ListBackupsRequest;
import com.google.cloud.backupdr.v1.ListBackupsResponse;
import com.google.cloud.backupdr.v1.ListDataSourcesRequest;
import com.google.cloud.backupdr.v1.ListDataSourcesResponse;
import com.google.cloud.backupdr.v1.ListManagementServersRequest;
import com.google.cloud.backupdr.v1.ListManagementServersResponse;
import com.google.cloud.backupdr.v1.ManagementServer;
import com.google.cloud.backupdr.v1.OperationMetadata;
import com.google.cloud.backupdr.v1.RestoreBackupRequest;
import com.google.cloud.backupdr.v1.RestoreBackupResponse;
import com.google.cloud.backupdr.v1.TriggerBackupRequest;
import com.google.cloud.backupdr.v1.UpdateBackupRequest;
import com.google.cloud.backupdr.v1.UpdateBackupVaultRequest;
import com.google.cloud.backupdr.v1.UpdateDataSourceRequest;
import com.google.cloud.backupdr.v1.stub.BackupDRStub;
import com.google.cloud.backupdr.v1.stub.GrpcBackupDRStub;
import com.google.cloud.backupdr.v1.stub.HttpJsonBackupDRStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class BackupDRStubSettings
extends StubSettings<BackupDRStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListManagementServersRequest, ListManagementServersResponse, BackupDRClient.ListManagementServersPagedResponse> listManagementServersSettings;
    private final UnaryCallSettings<GetManagementServerRequest, ManagementServer> getManagementServerSettings;
    private final UnaryCallSettings<CreateManagementServerRequest, Operation> createManagementServerSettings;
    private final OperationCallSettings<CreateManagementServerRequest, ManagementServer, OperationMetadata> createManagementServerOperationSettings;
    private final UnaryCallSettings<DeleteManagementServerRequest, Operation> deleteManagementServerSettings;
    private final OperationCallSettings<DeleteManagementServerRequest, Empty, OperationMetadata> deleteManagementServerOperationSettings;
    private final UnaryCallSettings<CreateBackupVaultRequest, Operation> createBackupVaultSettings;
    private final OperationCallSettings<CreateBackupVaultRequest, BackupVault, OperationMetadata> createBackupVaultOperationSettings;
    private final PagedCallSettings<ListBackupVaultsRequest, ListBackupVaultsResponse, BackupDRClient.ListBackupVaultsPagedResponse> listBackupVaultsSettings;
    private final PagedCallSettings<FetchUsableBackupVaultsRequest, FetchUsableBackupVaultsResponse, BackupDRClient.FetchUsableBackupVaultsPagedResponse> fetchUsableBackupVaultsSettings;
    private final UnaryCallSettings<GetBackupVaultRequest, BackupVault> getBackupVaultSettings;
    private final UnaryCallSettings<UpdateBackupVaultRequest, Operation> updateBackupVaultSettings;
    private final OperationCallSettings<UpdateBackupVaultRequest, BackupVault, OperationMetadata> updateBackupVaultOperationSettings;
    private final UnaryCallSettings<DeleteBackupVaultRequest, Operation> deleteBackupVaultSettings;
    private final OperationCallSettings<DeleteBackupVaultRequest, Empty, OperationMetadata> deleteBackupVaultOperationSettings;
    private final PagedCallSettings<ListDataSourcesRequest, ListDataSourcesResponse, BackupDRClient.ListDataSourcesPagedResponse> listDataSourcesSettings;
    private final UnaryCallSettings<GetDataSourceRequest, DataSource> getDataSourceSettings;
    private final UnaryCallSettings<UpdateDataSourceRequest, Operation> updateDataSourceSettings;
    private final OperationCallSettings<UpdateDataSourceRequest, DataSource, OperationMetadata> updateDataSourceOperationSettings;
    private final PagedCallSettings<ListBackupsRequest, ListBackupsResponse, BackupDRClient.ListBackupsPagedResponse> listBackupsSettings;
    private final UnaryCallSettings<GetBackupRequest, Backup> getBackupSettings;
    private final UnaryCallSettings<UpdateBackupRequest, Operation> updateBackupSettings;
    private final OperationCallSettings<UpdateBackupRequest, Backup, OperationMetadata> updateBackupOperationSettings;
    private final UnaryCallSettings<DeleteBackupRequest, Operation> deleteBackupSettings;
    private final OperationCallSettings<DeleteBackupRequest, Backup, OperationMetadata> deleteBackupOperationSettings;
    private final UnaryCallSettings<RestoreBackupRequest, Operation> restoreBackupSettings;
    private final OperationCallSettings<RestoreBackupRequest, RestoreBackupResponse, OperationMetadata> restoreBackupOperationSettings;
    private final UnaryCallSettings<CreateBackupPlanRequest, Operation> createBackupPlanSettings;
    private final OperationCallSettings<CreateBackupPlanRequest, BackupPlan, OperationMetadata> createBackupPlanOperationSettings;
    private final UnaryCallSettings<GetBackupPlanRequest, BackupPlan> getBackupPlanSettings;
    private final PagedCallSettings<ListBackupPlansRequest, ListBackupPlansResponse, BackupDRClient.ListBackupPlansPagedResponse> listBackupPlansSettings;
    private final UnaryCallSettings<DeleteBackupPlanRequest, Operation> deleteBackupPlanSettings;
    private final OperationCallSettings<DeleteBackupPlanRequest, Empty, OperationMetadata> deleteBackupPlanOperationSettings;
    private final UnaryCallSettings<CreateBackupPlanAssociationRequest, Operation> createBackupPlanAssociationSettings;
    private final OperationCallSettings<CreateBackupPlanAssociationRequest, BackupPlanAssociation, OperationMetadata> createBackupPlanAssociationOperationSettings;
    private final UnaryCallSettings<GetBackupPlanAssociationRequest, BackupPlanAssociation> getBackupPlanAssociationSettings;
    private final PagedCallSettings<ListBackupPlanAssociationsRequest, ListBackupPlanAssociationsResponse, BackupDRClient.ListBackupPlanAssociationsPagedResponse> listBackupPlanAssociationsSettings;
    private final UnaryCallSettings<DeleteBackupPlanAssociationRequest, Operation> deleteBackupPlanAssociationSettings;
    private final OperationCallSettings<DeleteBackupPlanAssociationRequest, Empty, OperationMetadata> deleteBackupPlanAssociationOperationSettings;
    private final UnaryCallSettings<TriggerBackupRequest, Operation> triggerBackupSettings;
    private final OperationCallSettings<TriggerBackupRequest, BackupPlanAssociation, OperationMetadata> triggerBackupOperationSettings;
    private final UnaryCallSettings<InitializeServiceRequest, Operation> initializeServiceSettings;
    private final OperationCallSettings<InitializeServiceRequest, InitializeServiceResponse, OperationMetadata> initializeServiceOperationSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, BackupDRClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListManagementServersRequest, ListManagementServersResponse, ManagementServer> LIST_MANAGEMENT_SERVERS_PAGE_STR_DESC = new PagedListDescriptor<ListManagementServersRequest, ListManagementServersResponse, ManagementServer>(){

        public String emptyToken() {
            return "";
        }

        public ListManagementServersRequest injectToken(ListManagementServersRequest payload, String token) {
            return ListManagementServersRequest.newBuilder((ListManagementServersRequest)payload).setPageToken(token).build();
        }

        public ListManagementServersRequest injectPageSize(ListManagementServersRequest payload, int pageSize) {
            return ListManagementServersRequest.newBuilder((ListManagementServersRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListManagementServersRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListManagementServersResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ManagementServer> extractResources(ListManagementServersResponse payload) {
            return payload.getManagementServersList();
        }
    };
    private static final PagedListDescriptor<ListBackupVaultsRequest, ListBackupVaultsResponse, BackupVault> LIST_BACKUP_VAULTS_PAGE_STR_DESC = new PagedListDescriptor<ListBackupVaultsRequest, ListBackupVaultsResponse, BackupVault>(){

        public String emptyToken() {
            return "";
        }

        public ListBackupVaultsRequest injectToken(ListBackupVaultsRequest payload, String token) {
            return ListBackupVaultsRequest.newBuilder((ListBackupVaultsRequest)payload).setPageToken(token).build();
        }

        public ListBackupVaultsRequest injectPageSize(ListBackupVaultsRequest payload, int pageSize) {
            return ListBackupVaultsRequest.newBuilder((ListBackupVaultsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListBackupVaultsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListBackupVaultsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<BackupVault> extractResources(ListBackupVaultsResponse payload) {
            return payload.getBackupVaultsList();
        }
    };
    private static final PagedListDescriptor<FetchUsableBackupVaultsRequest, FetchUsableBackupVaultsResponse, BackupVault> FETCH_USABLE_BACKUP_VAULTS_PAGE_STR_DESC = new PagedListDescriptor<FetchUsableBackupVaultsRequest, FetchUsableBackupVaultsResponse, BackupVault>(){

        public String emptyToken() {
            return "";
        }

        public FetchUsableBackupVaultsRequest injectToken(FetchUsableBackupVaultsRequest payload, String token) {
            return FetchUsableBackupVaultsRequest.newBuilder((FetchUsableBackupVaultsRequest)payload).setPageToken(token).build();
        }

        public FetchUsableBackupVaultsRequest injectPageSize(FetchUsableBackupVaultsRequest payload, int pageSize) {
            return FetchUsableBackupVaultsRequest.newBuilder((FetchUsableBackupVaultsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(FetchUsableBackupVaultsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(FetchUsableBackupVaultsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<BackupVault> extractResources(FetchUsableBackupVaultsResponse payload) {
            return payload.getBackupVaultsList();
        }
    };
    private static final PagedListDescriptor<ListDataSourcesRequest, ListDataSourcesResponse, DataSource> LIST_DATA_SOURCES_PAGE_STR_DESC = new PagedListDescriptor<ListDataSourcesRequest, ListDataSourcesResponse, DataSource>(){

        public String emptyToken() {
            return "";
        }

        public ListDataSourcesRequest injectToken(ListDataSourcesRequest payload, String token) {
            return ListDataSourcesRequest.newBuilder((ListDataSourcesRequest)payload).setPageToken(token).build();
        }

        public ListDataSourcesRequest injectPageSize(ListDataSourcesRequest payload, int pageSize) {
            return ListDataSourcesRequest.newBuilder((ListDataSourcesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDataSourcesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDataSourcesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<DataSource> extractResources(ListDataSourcesResponse payload) {
            return payload.getDataSourcesList();
        }
    };
    private static final PagedListDescriptor<ListBackupsRequest, ListBackupsResponse, Backup> LIST_BACKUPS_PAGE_STR_DESC = new PagedListDescriptor<ListBackupsRequest, ListBackupsResponse, Backup>(){

        public String emptyToken() {
            return "";
        }

        public ListBackupsRequest injectToken(ListBackupsRequest payload, String token) {
            return ListBackupsRequest.newBuilder((ListBackupsRequest)payload).setPageToken(token).build();
        }

        public ListBackupsRequest injectPageSize(ListBackupsRequest payload, int pageSize) {
            return ListBackupsRequest.newBuilder((ListBackupsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListBackupsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListBackupsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Backup> extractResources(ListBackupsResponse payload) {
            return payload.getBackupsList();
        }
    };
    private static final PagedListDescriptor<ListBackupPlansRequest, ListBackupPlansResponse, BackupPlan> LIST_BACKUP_PLANS_PAGE_STR_DESC = new PagedListDescriptor<ListBackupPlansRequest, ListBackupPlansResponse, BackupPlan>(){

        public String emptyToken() {
            return "";
        }

        public ListBackupPlansRequest injectToken(ListBackupPlansRequest payload, String token) {
            return ListBackupPlansRequest.newBuilder((ListBackupPlansRequest)payload).setPageToken(token).build();
        }

        public ListBackupPlansRequest injectPageSize(ListBackupPlansRequest payload, int pageSize) {
            return ListBackupPlansRequest.newBuilder((ListBackupPlansRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListBackupPlansRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListBackupPlansResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<BackupPlan> extractResources(ListBackupPlansResponse payload) {
            return payload.getBackupPlansList();
        }
    };
    private static final PagedListDescriptor<ListBackupPlanAssociationsRequest, ListBackupPlanAssociationsResponse, BackupPlanAssociation> LIST_BACKUP_PLAN_ASSOCIATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListBackupPlanAssociationsRequest, ListBackupPlanAssociationsResponse, BackupPlanAssociation>(){

        public String emptyToken() {
            return "";
        }

        public ListBackupPlanAssociationsRequest injectToken(ListBackupPlanAssociationsRequest payload, String token) {
            return ListBackupPlanAssociationsRequest.newBuilder((ListBackupPlanAssociationsRequest)payload).setPageToken(token).build();
        }

        public ListBackupPlanAssociationsRequest injectPageSize(ListBackupPlanAssociationsRequest payload, int pageSize) {
            return ListBackupPlanAssociationsRequest.newBuilder((ListBackupPlanAssociationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListBackupPlanAssociationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListBackupPlanAssociationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<BackupPlanAssociation> extractResources(ListBackupPlanAssociationsResponse payload) {
            return payload.getBackupPlanAssociationsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListManagementServersRequest, ListManagementServersResponse, BackupDRClient.ListManagementServersPagedResponse> LIST_MANAGEMENT_SERVERS_PAGE_STR_FACT = new PagedListResponseFactory<ListManagementServersRequest, ListManagementServersResponse, BackupDRClient.ListManagementServersPagedResponse>(){

        public ApiFuture<BackupDRClient.ListManagementServersPagedResponse> getFuturePagedResponse(UnaryCallable<ListManagementServersRequest, ListManagementServersResponse> callable, ListManagementServersRequest request, ApiCallContext context, ApiFuture<ListManagementServersResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_MANAGEMENT_SERVERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return BackupDRClient.ListManagementServersPagedResponse.createAsync((PageContext<ListManagementServersRequest, ListManagementServersResponse, ManagementServer>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListBackupVaultsRequest, ListBackupVaultsResponse, BackupDRClient.ListBackupVaultsPagedResponse> LIST_BACKUP_VAULTS_PAGE_STR_FACT = new PagedListResponseFactory<ListBackupVaultsRequest, ListBackupVaultsResponse, BackupDRClient.ListBackupVaultsPagedResponse>(){

        public ApiFuture<BackupDRClient.ListBackupVaultsPagedResponse> getFuturePagedResponse(UnaryCallable<ListBackupVaultsRequest, ListBackupVaultsResponse> callable, ListBackupVaultsRequest request, ApiCallContext context, ApiFuture<ListBackupVaultsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_BACKUP_VAULTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return BackupDRClient.ListBackupVaultsPagedResponse.createAsync((PageContext<ListBackupVaultsRequest, ListBackupVaultsResponse, BackupVault>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<FetchUsableBackupVaultsRequest, FetchUsableBackupVaultsResponse, BackupDRClient.FetchUsableBackupVaultsPagedResponse> FETCH_USABLE_BACKUP_VAULTS_PAGE_STR_FACT = new PagedListResponseFactory<FetchUsableBackupVaultsRequest, FetchUsableBackupVaultsResponse, BackupDRClient.FetchUsableBackupVaultsPagedResponse>(){

        public ApiFuture<BackupDRClient.FetchUsableBackupVaultsPagedResponse> getFuturePagedResponse(UnaryCallable<FetchUsableBackupVaultsRequest, FetchUsableBackupVaultsResponse> callable, FetchUsableBackupVaultsRequest request, ApiCallContext context, ApiFuture<FetchUsableBackupVaultsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)FETCH_USABLE_BACKUP_VAULTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return BackupDRClient.FetchUsableBackupVaultsPagedResponse.createAsync((PageContext<FetchUsableBackupVaultsRequest, FetchUsableBackupVaultsResponse, BackupVault>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListDataSourcesRequest, ListDataSourcesResponse, BackupDRClient.ListDataSourcesPagedResponse> LIST_DATA_SOURCES_PAGE_STR_FACT = new PagedListResponseFactory<ListDataSourcesRequest, ListDataSourcesResponse, BackupDRClient.ListDataSourcesPagedResponse>(){

        public ApiFuture<BackupDRClient.ListDataSourcesPagedResponse> getFuturePagedResponse(UnaryCallable<ListDataSourcesRequest, ListDataSourcesResponse> callable, ListDataSourcesRequest request, ApiCallContext context, ApiFuture<ListDataSourcesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DATA_SOURCES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return BackupDRClient.ListDataSourcesPagedResponse.createAsync((PageContext<ListDataSourcesRequest, ListDataSourcesResponse, DataSource>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListBackupsRequest, ListBackupsResponse, BackupDRClient.ListBackupsPagedResponse> LIST_BACKUPS_PAGE_STR_FACT = new PagedListResponseFactory<ListBackupsRequest, ListBackupsResponse, BackupDRClient.ListBackupsPagedResponse>(){

        public ApiFuture<BackupDRClient.ListBackupsPagedResponse> getFuturePagedResponse(UnaryCallable<ListBackupsRequest, ListBackupsResponse> callable, ListBackupsRequest request, ApiCallContext context, ApiFuture<ListBackupsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_BACKUPS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return BackupDRClient.ListBackupsPagedResponse.createAsync((PageContext<ListBackupsRequest, ListBackupsResponse, Backup>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListBackupPlansRequest, ListBackupPlansResponse, BackupDRClient.ListBackupPlansPagedResponse> LIST_BACKUP_PLANS_PAGE_STR_FACT = new PagedListResponseFactory<ListBackupPlansRequest, ListBackupPlansResponse, BackupDRClient.ListBackupPlansPagedResponse>(){

        public ApiFuture<BackupDRClient.ListBackupPlansPagedResponse> getFuturePagedResponse(UnaryCallable<ListBackupPlansRequest, ListBackupPlansResponse> callable, ListBackupPlansRequest request, ApiCallContext context, ApiFuture<ListBackupPlansResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_BACKUP_PLANS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return BackupDRClient.ListBackupPlansPagedResponse.createAsync((PageContext<ListBackupPlansRequest, ListBackupPlansResponse, BackupPlan>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListBackupPlanAssociationsRequest, ListBackupPlanAssociationsResponse, BackupDRClient.ListBackupPlanAssociationsPagedResponse> LIST_BACKUP_PLAN_ASSOCIATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListBackupPlanAssociationsRequest, ListBackupPlanAssociationsResponse, BackupDRClient.ListBackupPlanAssociationsPagedResponse>(){

        public ApiFuture<BackupDRClient.ListBackupPlanAssociationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListBackupPlanAssociationsRequest, ListBackupPlanAssociationsResponse> callable, ListBackupPlanAssociationsRequest request, ApiCallContext context, ApiFuture<ListBackupPlanAssociationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_BACKUP_PLAN_ASSOCIATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return BackupDRClient.ListBackupPlanAssociationsPagedResponse.createAsync((PageContext<ListBackupPlanAssociationsRequest, ListBackupPlanAssociationsResponse, BackupPlanAssociation>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, BackupDRClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, BackupDRClient.ListLocationsPagedResponse>(){

        public ApiFuture<BackupDRClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return BackupDRClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListManagementServersRequest, ListManagementServersResponse, BackupDRClient.ListManagementServersPagedResponse> listManagementServersSettings() {
        return this.listManagementServersSettings;
    }

    public UnaryCallSettings<GetManagementServerRequest, ManagementServer> getManagementServerSettings() {
        return this.getManagementServerSettings;
    }

    public UnaryCallSettings<CreateManagementServerRequest, Operation> createManagementServerSettings() {
        return this.createManagementServerSettings;
    }

    public OperationCallSettings<CreateManagementServerRequest, ManagementServer, OperationMetadata> createManagementServerOperationSettings() {
        return this.createManagementServerOperationSettings;
    }

    public UnaryCallSettings<DeleteManagementServerRequest, Operation> deleteManagementServerSettings() {
        return this.deleteManagementServerSettings;
    }

    public OperationCallSettings<DeleteManagementServerRequest, Empty, OperationMetadata> deleteManagementServerOperationSettings() {
        return this.deleteManagementServerOperationSettings;
    }

    public UnaryCallSettings<CreateBackupVaultRequest, Operation> createBackupVaultSettings() {
        return this.createBackupVaultSettings;
    }

    public OperationCallSettings<CreateBackupVaultRequest, BackupVault, OperationMetadata> createBackupVaultOperationSettings() {
        return this.createBackupVaultOperationSettings;
    }

    public PagedCallSettings<ListBackupVaultsRequest, ListBackupVaultsResponse, BackupDRClient.ListBackupVaultsPagedResponse> listBackupVaultsSettings() {
        return this.listBackupVaultsSettings;
    }

    public PagedCallSettings<FetchUsableBackupVaultsRequest, FetchUsableBackupVaultsResponse, BackupDRClient.FetchUsableBackupVaultsPagedResponse> fetchUsableBackupVaultsSettings() {
        return this.fetchUsableBackupVaultsSettings;
    }

    public UnaryCallSettings<GetBackupVaultRequest, BackupVault> getBackupVaultSettings() {
        return this.getBackupVaultSettings;
    }

    public UnaryCallSettings<UpdateBackupVaultRequest, Operation> updateBackupVaultSettings() {
        return this.updateBackupVaultSettings;
    }

    public OperationCallSettings<UpdateBackupVaultRequest, BackupVault, OperationMetadata> updateBackupVaultOperationSettings() {
        return this.updateBackupVaultOperationSettings;
    }

    public UnaryCallSettings<DeleteBackupVaultRequest, Operation> deleteBackupVaultSettings() {
        return this.deleteBackupVaultSettings;
    }

    public OperationCallSettings<DeleteBackupVaultRequest, Empty, OperationMetadata> deleteBackupVaultOperationSettings() {
        return this.deleteBackupVaultOperationSettings;
    }

    public PagedCallSettings<ListDataSourcesRequest, ListDataSourcesResponse, BackupDRClient.ListDataSourcesPagedResponse> listDataSourcesSettings() {
        return this.listDataSourcesSettings;
    }

    public UnaryCallSettings<GetDataSourceRequest, DataSource> getDataSourceSettings() {
        return this.getDataSourceSettings;
    }

    public UnaryCallSettings<UpdateDataSourceRequest, Operation> updateDataSourceSettings() {
        return this.updateDataSourceSettings;
    }

    public OperationCallSettings<UpdateDataSourceRequest, DataSource, OperationMetadata> updateDataSourceOperationSettings() {
        return this.updateDataSourceOperationSettings;
    }

    public PagedCallSettings<ListBackupsRequest, ListBackupsResponse, BackupDRClient.ListBackupsPagedResponse> listBackupsSettings() {
        return this.listBackupsSettings;
    }

    public UnaryCallSettings<GetBackupRequest, Backup> getBackupSettings() {
        return this.getBackupSettings;
    }

    public UnaryCallSettings<UpdateBackupRequest, Operation> updateBackupSettings() {
        return this.updateBackupSettings;
    }

    public OperationCallSettings<UpdateBackupRequest, Backup, OperationMetadata> updateBackupOperationSettings() {
        return this.updateBackupOperationSettings;
    }

    public UnaryCallSettings<DeleteBackupRequest, Operation> deleteBackupSettings() {
        return this.deleteBackupSettings;
    }

    public OperationCallSettings<DeleteBackupRequest, Backup, OperationMetadata> deleteBackupOperationSettings() {
        return this.deleteBackupOperationSettings;
    }

    public UnaryCallSettings<RestoreBackupRequest, Operation> restoreBackupSettings() {
        return this.restoreBackupSettings;
    }

    public OperationCallSettings<RestoreBackupRequest, RestoreBackupResponse, OperationMetadata> restoreBackupOperationSettings() {
        return this.restoreBackupOperationSettings;
    }

    public UnaryCallSettings<CreateBackupPlanRequest, Operation> createBackupPlanSettings() {
        return this.createBackupPlanSettings;
    }

    public OperationCallSettings<CreateBackupPlanRequest, BackupPlan, OperationMetadata> createBackupPlanOperationSettings() {
        return this.createBackupPlanOperationSettings;
    }

    public UnaryCallSettings<GetBackupPlanRequest, BackupPlan> getBackupPlanSettings() {
        return this.getBackupPlanSettings;
    }

    public PagedCallSettings<ListBackupPlansRequest, ListBackupPlansResponse, BackupDRClient.ListBackupPlansPagedResponse> listBackupPlansSettings() {
        return this.listBackupPlansSettings;
    }

    public UnaryCallSettings<DeleteBackupPlanRequest, Operation> deleteBackupPlanSettings() {
        return this.deleteBackupPlanSettings;
    }

    public OperationCallSettings<DeleteBackupPlanRequest, Empty, OperationMetadata> deleteBackupPlanOperationSettings() {
        return this.deleteBackupPlanOperationSettings;
    }

    public UnaryCallSettings<CreateBackupPlanAssociationRequest, Operation> createBackupPlanAssociationSettings() {
        return this.createBackupPlanAssociationSettings;
    }

    public OperationCallSettings<CreateBackupPlanAssociationRequest, BackupPlanAssociation, OperationMetadata> createBackupPlanAssociationOperationSettings() {
        return this.createBackupPlanAssociationOperationSettings;
    }

    public UnaryCallSettings<GetBackupPlanAssociationRequest, BackupPlanAssociation> getBackupPlanAssociationSettings() {
        return this.getBackupPlanAssociationSettings;
    }

    public PagedCallSettings<ListBackupPlanAssociationsRequest, ListBackupPlanAssociationsResponse, BackupDRClient.ListBackupPlanAssociationsPagedResponse> listBackupPlanAssociationsSettings() {
        return this.listBackupPlanAssociationsSettings;
    }

    public UnaryCallSettings<DeleteBackupPlanAssociationRequest, Operation> deleteBackupPlanAssociationSettings() {
        return this.deleteBackupPlanAssociationSettings;
    }

    public OperationCallSettings<DeleteBackupPlanAssociationRequest, Empty, OperationMetadata> deleteBackupPlanAssociationOperationSettings() {
        return this.deleteBackupPlanAssociationOperationSettings;
    }

    public UnaryCallSettings<TriggerBackupRequest, Operation> triggerBackupSettings() {
        return this.triggerBackupSettings;
    }

    public OperationCallSettings<TriggerBackupRequest, BackupPlanAssociation, OperationMetadata> triggerBackupOperationSettings() {
        return this.triggerBackupOperationSettings;
    }

    public UnaryCallSettings<InitializeServiceRequest, Operation> initializeServiceSettings() {
        return this.initializeServiceSettings;
    }

    public OperationCallSettings<InitializeServiceRequest, InitializeServiceResponse, OperationMetadata> initializeServiceOperationSettings() {
        return this.initializeServiceOperationSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, BackupDRClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public BackupDRStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcBackupDRStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonBackupDRStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "backupdr";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "backupdr.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "backupdr.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return BackupDRStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(BackupDRStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(BackupDRStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return BackupDRStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected BackupDRStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listManagementServersSettings = settingsBuilder.listManagementServersSettings().build();
        this.getManagementServerSettings = settingsBuilder.getManagementServerSettings().build();
        this.createManagementServerSettings = settingsBuilder.createManagementServerSettings().build();
        this.createManagementServerOperationSettings = settingsBuilder.createManagementServerOperationSettings().build();
        this.deleteManagementServerSettings = settingsBuilder.deleteManagementServerSettings().build();
        this.deleteManagementServerOperationSettings = settingsBuilder.deleteManagementServerOperationSettings().build();
        this.createBackupVaultSettings = settingsBuilder.createBackupVaultSettings().build();
        this.createBackupVaultOperationSettings = settingsBuilder.createBackupVaultOperationSettings().build();
        this.listBackupVaultsSettings = settingsBuilder.listBackupVaultsSettings().build();
        this.fetchUsableBackupVaultsSettings = settingsBuilder.fetchUsableBackupVaultsSettings().build();
        this.getBackupVaultSettings = settingsBuilder.getBackupVaultSettings().build();
        this.updateBackupVaultSettings = settingsBuilder.updateBackupVaultSettings().build();
        this.updateBackupVaultOperationSettings = settingsBuilder.updateBackupVaultOperationSettings().build();
        this.deleteBackupVaultSettings = settingsBuilder.deleteBackupVaultSettings().build();
        this.deleteBackupVaultOperationSettings = settingsBuilder.deleteBackupVaultOperationSettings().build();
        this.listDataSourcesSettings = settingsBuilder.listDataSourcesSettings().build();
        this.getDataSourceSettings = settingsBuilder.getDataSourceSettings().build();
        this.updateDataSourceSettings = settingsBuilder.updateDataSourceSettings().build();
        this.updateDataSourceOperationSettings = settingsBuilder.updateDataSourceOperationSettings().build();
        this.listBackupsSettings = settingsBuilder.listBackupsSettings().build();
        this.getBackupSettings = settingsBuilder.getBackupSettings().build();
        this.updateBackupSettings = settingsBuilder.updateBackupSettings().build();
        this.updateBackupOperationSettings = settingsBuilder.updateBackupOperationSettings().build();
        this.deleteBackupSettings = settingsBuilder.deleteBackupSettings().build();
        this.deleteBackupOperationSettings = settingsBuilder.deleteBackupOperationSettings().build();
        this.restoreBackupSettings = settingsBuilder.restoreBackupSettings().build();
        this.restoreBackupOperationSettings = settingsBuilder.restoreBackupOperationSettings().build();
        this.createBackupPlanSettings = settingsBuilder.createBackupPlanSettings().build();
        this.createBackupPlanOperationSettings = settingsBuilder.createBackupPlanOperationSettings().build();
        this.getBackupPlanSettings = settingsBuilder.getBackupPlanSettings().build();
        this.listBackupPlansSettings = settingsBuilder.listBackupPlansSettings().build();
        this.deleteBackupPlanSettings = settingsBuilder.deleteBackupPlanSettings().build();
        this.deleteBackupPlanOperationSettings = settingsBuilder.deleteBackupPlanOperationSettings().build();
        this.createBackupPlanAssociationSettings = settingsBuilder.createBackupPlanAssociationSettings().build();
        this.createBackupPlanAssociationOperationSettings = settingsBuilder.createBackupPlanAssociationOperationSettings().build();
        this.getBackupPlanAssociationSettings = settingsBuilder.getBackupPlanAssociationSettings().build();
        this.listBackupPlanAssociationsSettings = settingsBuilder.listBackupPlanAssociationsSettings().build();
        this.deleteBackupPlanAssociationSettings = settingsBuilder.deleteBackupPlanAssociationSettings().build();
        this.deleteBackupPlanAssociationOperationSettings = settingsBuilder.deleteBackupPlanAssociationOperationSettings().build();
        this.triggerBackupSettings = settingsBuilder.triggerBackupSettings().build();
        this.triggerBackupOperationSettings = settingsBuilder.triggerBackupOperationSettings().build();
        this.initializeServiceSettings = settingsBuilder.initializeServiceSettings().build();
        this.initializeServiceOperationSettings = settingsBuilder.initializeServiceOperationSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<BackupDRStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListManagementServersRequest, ListManagementServersResponse, BackupDRClient.ListManagementServersPagedResponse> listManagementServersSettings;
        private final UnaryCallSettings.Builder<GetManagementServerRequest, ManagementServer> getManagementServerSettings;
        private final UnaryCallSettings.Builder<CreateManagementServerRequest, Operation> createManagementServerSettings;
        private final OperationCallSettings.Builder<CreateManagementServerRequest, ManagementServer, OperationMetadata> createManagementServerOperationSettings;
        private final UnaryCallSettings.Builder<DeleteManagementServerRequest, Operation> deleteManagementServerSettings;
        private final OperationCallSettings.Builder<DeleteManagementServerRequest, Empty, OperationMetadata> deleteManagementServerOperationSettings;
        private final UnaryCallSettings.Builder<CreateBackupVaultRequest, Operation> createBackupVaultSettings;
        private final OperationCallSettings.Builder<CreateBackupVaultRequest, BackupVault, OperationMetadata> createBackupVaultOperationSettings;
        private final PagedCallSettings.Builder<ListBackupVaultsRequest, ListBackupVaultsResponse, BackupDRClient.ListBackupVaultsPagedResponse> listBackupVaultsSettings;
        private final PagedCallSettings.Builder<FetchUsableBackupVaultsRequest, FetchUsableBackupVaultsResponse, BackupDRClient.FetchUsableBackupVaultsPagedResponse> fetchUsableBackupVaultsSettings;
        private final UnaryCallSettings.Builder<GetBackupVaultRequest, BackupVault> getBackupVaultSettings;
        private final UnaryCallSettings.Builder<UpdateBackupVaultRequest, Operation> updateBackupVaultSettings;
        private final OperationCallSettings.Builder<UpdateBackupVaultRequest, BackupVault, OperationMetadata> updateBackupVaultOperationSettings;
        private final UnaryCallSettings.Builder<DeleteBackupVaultRequest, Operation> deleteBackupVaultSettings;
        private final OperationCallSettings.Builder<DeleteBackupVaultRequest, Empty, OperationMetadata> deleteBackupVaultOperationSettings;
        private final PagedCallSettings.Builder<ListDataSourcesRequest, ListDataSourcesResponse, BackupDRClient.ListDataSourcesPagedResponse> listDataSourcesSettings;
        private final UnaryCallSettings.Builder<GetDataSourceRequest, DataSource> getDataSourceSettings;
        private final UnaryCallSettings.Builder<UpdateDataSourceRequest, Operation> updateDataSourceSettings;
        private final OperationCallSettings.Builder<UpdateDataSourceRequest, DataSource, OperationMetadata> updateDataSourceOperationSettings;
        private final PagedCallSettings.Builder<ListBackupsRequest, ListBackupsResponse, BackupDRClient.ListBackupsPagedResponse> listBackupsSettings;
        private final UnaryCallSettings.Builder<GetBackupRequest, Backup> getBackupSettings;
        private final UnaryCallSettings.Builder<UpdateBackupRequest, Operation> updateBackupSettings;
        private final OperationCallSettings.Builder<UpdateBackupRequest, Backup, OperationMetadata> updateBackupOperationSettings;
        private final UnaryCallSettings.Builder<DeleteBackupRequest, Operation> deleteBackupSettings;
        private final OperationCallSettings.Builder<DeleteBackupRequest, Backup, OperationMetadata> deleteBackupOperationSettings;
        private final UnaryCallSettings.Builder<RestoreBackupRequest, Operation> restoreBackupSettings;
        private final OperationCallSettings.Builder<RestoreBackupRequest, RestoreBackupResponse, OperationMetadata> restoreBackupOperationSettings;
        private final UnaryCallSettings.Builder<CreateBackupPlanRequest, Operation> createBackupPlanSettings;
        private final OperationCallSettings.Builder<CreateBackupPlanRequest, BackupPlan, OperationMetadata> createBackupPlanOperationSettings;
        private final UnaryCallSettings.Builder<GetBackupPlanRequest, BackupPlan> getBackupPlanSettings;
        private final PagedCallSettings.Builder<ListBackupPlansRequest, ListBackupPlansResponse, BackupDRClient.ListBackupPlansPagedResponse> listBackupPlansSettings;
        private final UnaryCallSettings.Builder<DeleteBackupPlanRequest, Operation> deleteBackupPlanSettings;
        private final OperationCallSettings.Builder<DeleteBackupPlanRequest, Empty, OperationMetadata> deleteBackupPlanOperationSettings;
        private final UnaryCallSettings.Builder<CreateBackupPlanAssociationRequest, Operation> createBackupPlanAssociationSettings;
        private final OperationCallSettings.Builder<CreateBackupPlanAssociationRequest, BackupPlanAssociation, OperationMetadata> createBackupPlanAssociationOperationSettings;
        private final UnaryCallSettings.Builder<GetBackupPlanAssociationRequest, BackupPlanAssociation> getBackupPlanAssociationSettings;
        private final PagedCallSettings.Builder<ListBackupPlanAssociationsRequest, ListBackupPlanAssociationsResponse, BackupDRClient.ListBackupPlanAssociationsPagedResponse> listBackupPlanAssociationsSettings;
        private final UnaryCallSettings.Builder<DeleteBackupPlanAssociationRequest, Operation> deleteBackupPlanAssociationSettings;
        private final OperationCallSettings.Builder<DeleteBackupPlanAssociationRequest, Empty, OperationMetadata> deleteBackupPlanAssociationOperationSettings;
        private final UnaryCallSettings.Builder<TriggerBackupRequest, Operation> triggerBackupSettings;
        private final OperationCallSettings.Builder<TriggerBackupRequest, BackupPlanAssociation, OperationMetadata> triggerBackupOperationSettings;
        private final UnaryCallSettings.Builder<InitializeServiceRequest, Operation> initializeServiceSettings;
        private final OperationCallSettings.Builder<InitializeServiceRequest, InitializeServiceResponse, OperationMetadata> initializeServiceOperationSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, BackupDRClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listManagementServersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_MANAGEMENT_SERVERS_PAGE_STR_FACT);
            this.getManagementServerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createManagementServerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createManagementServerOperationSettings = OperationCallSettings.newBuilder();
            this.deleteManagementServerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteManagementServerOperationSettings = OperationCallSettings.newBuilder();
            this.createBackupVaultSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createBackupVaultOperationSettings = OperationCallSettings.newBuilder();
            this.listBackupVaultsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_BACKUP_VAULTS_PAGE_STR_FACT);
            this.fetchUsableBackupVaultsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)FETCH_USABLE_BACKUP_VAULTS_PAGE_STR_FACT);
            this.getBackupVaultSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateBackupVaultSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateBackupVaultOperationSettings = OperationCallSettings.newBuilder();
            this.deleteBackupVaultSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteBackupVaultOperationSettings = OperationCallSettings.newBuilder();
            this.listDataSourcesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DATA_SOURCES_PAGE_STR_FACT);
            this.getDataSourceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateDataSourceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateDataSourceOperationSettings = OperationCallSettings.newBuilder();
            this.listBackupsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_BACKUPS_PAGE_STR_FACT);
            this.getBackupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateBackupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateBackupOperationSettings = OperationCallSettings.newBuilder();
            this.deleteBackupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteBackupOperationSettings = OperationCallSettings.newBuilder();
            this.restoreBackupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.restoreBackupOperationSettings = OperationCallSettings.newBuilder();
            this.createBackupPlanSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createBackupPlanOperationSettings = OperationCallSettings.newBuilder();
            this.getBackupPlanSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listBackupPlansSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_BACKUP_PLANS_PAGE_STR_FACT);
            this.deleteBackupPlanSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteBackupPlanOperationSettings = OperationCallSettings.newBuilder();
            this.createBackupPlanAssociationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createBackupPlanAssociationOperationSettings = OperationCallSettings.newBuilder();
            this.getBackupPlanAssociationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listBackupPlanAssociationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_BACKUP_PLAN_ASSOCIATIONS_PAGE_STR_FACT);
            this.deleteBackupPlanAssociationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteBackupPlanAssociationOperationSettings = OperationCallSettings.newBuilder();
            this.triggerBackupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.triggerBackupOperationSettings = OperationCallSettings.newBuilder();
            this.initializeServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.initializeServiceOperationSettings = OperationCallSettings.newBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listManagementServersSettings, this.getManagementServerSettings, this.createManagementServerSettings, this.deleteManagementServerSettings, this.createBackupVaultSettings, this.listBackupVaultsSettings, this.fetchUsableBackupVaultsSettings, this.getBackupVaultSettings, this.updateBackupVaultSettings, this.deleteBackupVaultSettings, this.listDataSourcesSettings, this.getDataSourceSettings, (Object[])new UnaryCallSettings.Builder[]{this.updateDataSourceSettings, this.listBackupsSettings, this.getBackupSettings, this.updateBackupSettings, this.deleteBackupSettings, this.restoreBackupSettings, this.createBackupPlanSettings, this.getBackupPlanSettings, this.listBackupPlansSettings, this.deleteBackupPlanSettings, this.createBackupPlanAssociationSettings, this.getBackupPlanAssociationSettings, this.listBackupPlanAssociationsSettings, this.deleteBackupPlanAssociationSettings, this.triggerBackupSettings, this.initializeServiceSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
            Builder.initDefaults(this);
        }

        protected Builder(BackupDRStubSettings settings) {
            super((StubSettings)settings);
            this.listManagementServersSettings = settings.listManagementServersSettings.toBuilder();
            this.getManagementServerSettings = settings.getManagementServerSettings.toBuilder();
            this.createManagementServerSettings = settings.createManagementServerSettings.toBuilder();
            this.createManagementServerOperationSettings = settings.createManagementServerOperationSettings.toBuilder();
            this.deleteManagementServerSettings = settings.deleteManagementServerSettings.toBuilder();
            this.deleteManagementServerOperationSettings = settings.deleteManagementServerOperationSettings.toBuilder();
            this.createBackupVaultSettings = settings.createBackupVaultSettings.toBuilder();
            this.createBackupVaultOperationSettings = settings.createBackupVaultOperationSettings.toBuilder();
            this.listBackupVaultsSettings = settings.listBackupVaultsSettings.toBuilder();
            this.fetchUsableBackupVaultsSettings = settings.fetchUsableBackupVaultsSettings.toBuilder();
            this.getBackupVaultSettings = settings.getBackupVaultSettings.toBuilder();
            this.updateBackupVaultSettings = settings.updateBackupVaultSettings.toBuilder();
            this.updateBackupVaultOperationSettings = settings.updateBackupVaultOperationSettings.toBuilder();
            this.deleteBackupVaultSettings = settings.deleteBackupVaultSettings.toBuilder();
            this.deleteBackupVaultOperationSettings = settings.deleteBackupVaultOperationSettings.toBuilder();
            this.listDataSourcesSettings = settings.listDataSourcesSettings.toBuilder();
            this.getDataSourceSettings = settings.getDataSourceSettings.toBuilder();
            this.updateDataSourceSettings = settings.updateDataSourceSettings.toBuilder();
            this.updateDataSourceOperationSettings = settings.updateDataSourceOperationSettings.toBuilder();
            this.listBackupsSettings = settings.listBackupsSettings.toBuilder();
            this.getBackupSettings = settings.getBackupSettings.toBuilder();
            this.updateBackupSettings = settings.updateBackupSettings.toBuilder();
            this.updateBackupOperationSettings = settings.updateBackupOperationSettings.toBuilder();
            this.deleteBackupSettings = settings.deleteBackupSettings.toBuilder();
            this.deleteBackupOperationSettings = settings.deleteBackupOperationSettings.toBuilder();
            this.restoreBackupSettings = settings.restoreBackupSettings.toBuilder();
            this.restoreBackupOperationSettings = settings.restoreBackupOperationSettings.toBuilder();
            this.createBackupPlanSettings = settings.createBackupPlanSettings.toBuilder();
            this.createBackupPlanOperationSettings = settings.createBackupPlanOperationSettings.toBuilder();
            this.getBackupPlanSettings = settings.getBackupPlanSettings.toBuilder();
            this.listBackupPlansSettings = settings.listBackupPlansSettings.toBuilder();
            this.deleteBackupPlanSettings = settings.deleteBackupPlanSettings.toBuilder();
            this.deleteBackupPlanOperationSettings = settings.deleteBackupPlanOperationSettings.toBuilder();
            this.createBackupPlanAssociationSettings = settings.createBackupPlanAssociationSettings.toBuilder();
            this.createBackupPlanAssociationOperationSettings = settings.createBackupPlanAssociationOperationSettings.toBuilder();
            this.getBackupPlanAssociationSettings = settings.getBackupPlanAssociationSettings.toBuilder();
            this.listBackupPlanAssociationsSettings = settings.listBackupPlanAssociationsSettings.toBuilder();
            this.deleteBackupPlanAssociationSettings = settings.deleteBackupPlanAssociationSettings.toBuilder();
            this.deleteBackupPlanAssociationOperationSettings = settings.deleteBackupPlanAssociationOperationSettings.toBuilder();
            this.triggerBackupSettings = settings.triggerBackupSettings.toBuilder();
            this.triggerBackupOperationSettings = settings.triggerBackupOperationSettings.toBuilder();
            this.initializeServiceSettings = settings.initializeServiceSettings.toBuilder();
            this.initializeServiceOperationSettings = settings.initializeServiceOperationSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listManagementServersSettings, this.getManagementServerSettings, this.createManagementServerSettings, this.deleteManagementServerSettings, this.createBackupVaultSettings, this.listBackupVaultsSettings, this.fetchUsableBackupVaultsSettings, this.getBackupVaultSettings, this.updateBackupVaultSettings, this.deleteBackupVaultSettings, this.listDataSourcesSettings, this.getDataSourceSettings, (Object[])new UnaryCallSettings.Builder[]{this.updateDataSourceSettings, this.listBackupsSettings, this.getBackupSettings, this.updateBackupSettings, this.deleteBackupSettings, this.restoreBackupSettings, this.createBackupPlanSettings, this.getBackupPlanSettings, this.listBackupPlansSettings, this.deleteBackupPlanSettings, this.createBackupPlanAssociationSettings, this.getBackupPlanAssociationSettings, this.listBackupPlanAssociationsSettings, this.deleteBackupPlanAssociationSettings, this.triggerBackupSettings, this.initializeServiceSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(BackupDRStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)BackupDRStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)BackupDRStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(BackupDRStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)BackupDRStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)BackupDRStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)BackupDRStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(BackupDRStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listManagementServersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getManagementServerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createManagementServerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteManagementServerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.createBackupVaultSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listBackupVaultsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.fetchUsableBackupVaultsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getBackupVaultSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateBackupVaultSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteBackupVaultSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listDataSourcesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getDataSourceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateDataSourceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listBackupsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getBackupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateBackupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteBackupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.restoreBackupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.createBackupPlanSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getBackupPlanSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listBackupPlansSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteBackupPlanSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createBackupPlanAssociationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getBackupPlanAssociationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listBackupPlanAssociationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteBackupPlanAssociationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.triggerBackupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.initializeServiceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createManagementServerOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ManagementServer.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteManagementServerOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.createBackupVaultOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(BackupVault.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.updateBackupVaultOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(BackupVault.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteBackupVaultOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.updateDataSourceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(DataSource.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.updateBackupOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Backup.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteBackupOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Backup.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.restoreBackupOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(RestoreBackupResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.createBackupPlanOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(BackupPlan.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteBackupPlanOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.createBackupPlanAssociationOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(BackupPlanAssociation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteBackupPlanAssociationOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.triggerBackupOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(BackupPlanAssociation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.initializeServiceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(InitializeServiceResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListManagementServersRequest, ListManagementServersResponse, BackupDRClient.ListManagementServersPagedResponse> listManagementServersSettings() {
            return this.listManagementServersSettings;
        }

        public UnaryCallSettings.Builder<GetManagementServerRequest, ManagementServer> getManagementServerSettings() {
            return this.getManagementServerSettings;
        }

        public UnaryCallSettings.Builder<CreateManagementServerRequest, Operation> createManagementServerSettings() {
            return this.createManagementServerSettings;
        }

        public OperationCallSettings.Builder<CreateManagementServerRequest, ManagementServer, OperationMetadata> createManagementServerOperationSettings() {
            return this.createManagementServerOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteManagementServerRequest, Operation> deleteManagementServerSettings() {
            return this.deleteManagementServerSettings;
        }

        public OperationCallSettings.Builder<DeleteManagementServerRequest, Empty, OperationMetadata> deleteManagementServerOperationSettings() {
            return this.deleteManagementServerOperationSettings;
        }

        public UnaryCallSettings.Builder<CreateBackupVaultRequest, Operation> createBackupVaultSettings() {
            return this.createBackupVaultSettings;
        }

        public OperationCallSettings.Builder<CreateBackupVaultRequest, BackupVault, OperationMetadata> createBackupVaultOperationSettings() {
            return this.createBackupVaultOperationSettings;
        }

        public PagedCallSettings.Builder<ListBackupVaultsRequest, ListBackupVaultsResponse, BackupDRClient.ListBackupVaultsPagedResponse> listBackupVaultsSettings() {
            return this.listBackupVaultsSettings;
        }

        public PagedCallSettings.Builder<FetchUsableBackupVaultsRequest, FetchUsableBackupVaultsResponse, BackupDRClient.FetchUsableBackupVaultsPagedResponse> fetchUsableBackupVaultsSettings() {
            return this.fetchUsableBackupVaultsSettings;
        }

        public UnaryCallSettings.Builder<GetBackupVaultRequest, BackupVault> getBackupVaultSettings() {
            return this.getBackupVaultSettings;
        }

        public UnaryCallSettings.Builder<UpdateBackupVaultRequest, Operation> updateBackupVaultSettings() {
            return this.updateBackupVaultSettings;
        }

        public OperationCallSettings.Builder<UpdateBackupVaultRequest, BackupVault, OperationMetadata> updateBackupVaultOperationSettings() {
            return this.updateBackupVaultOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteBackupVaultRequest, Operation> deleteBackupVaultSettings() {
            return this.deleteBackupVaultSettings;
        }

        public OperationCallSettings.Builder<DeleteBackupVaultRequest, Empty, OperationMetadata> deleteBackupVaultOperationSettings() {
            return this.deleteBackupVaultOperationSettings;
        }

        public PagedCallSettings.Builder<ListDataSourcesRequest, ListDataSourcesResponse, BackupDRClient.ListDataSourcesPagedResponse> listDataSourcesSettings() {
            return this.listDataSourcesSettings;
        }

        public UnaryCallSettings.Builder<GetDataSourceRequest, DataSource> getDataSourceSettings() {
            return this.getDataSourceSettings;
        }

        public UnaryCallSettings.Builder<UpdateDataSourceRequest, Operation> updateDataSourceSettings() {
            return this.updateDataSourceSettings;
        }

        public OperationCallSettings.Builder<UpdateDataSourceRequest, DataSource, OperationMetadata> updateDataSourceOperationSettings() {
            return this.updateDataSourceOperationSettings;
        }

        public PagedCallSettings.Builder<ListBackupsRequest, ListBackupsResponse, BackupDRClient.ListBackupsPagedResponse> listBackupsSettings() {
            return this.listBackupsSettings;
        }

        public UnaryCallSettings.Builder<GetBackupRequest, Backup> getBackupSettings() {
            return this.getBackupSettings;
        }

        public UnaryCallSettings.Builder<UpdateBackupRequest, Operation> updateBackupSettings() {
            return this.updateBackupSettings;
        }

        public OperationCallSettings.Builder<UpdateBackupRequest, Backup, OperationMetadata> updateBackupOperationSettings() {
            return this.updateBackupOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteBackupRequest, Operation> deleteBackupSettings() {
            return this.deleteBackupSettings;
        }

        public OperationCallSettings.Builder<DeleteBackupRequest, Backup, OperationMetadata> deleteBackupOperationSettings() {
            return this.deleteBackupOperationSettings;
        }

        public UnaryCallSettings.Builder<RestoreBackupRequest, Operation> restoreBackupSettings() {
            return this.restoreBackupSettings;
        }

        public OperationCallSettings.Builder<RestoreBackupRequest, RestoreBackupResponse, OperationMetadata> restoreBackupOperationSettings() {
            return this.restoreBackupOperationSettings;
        }

        public UnaryCallSettings.Builder<CreateBackupPlanRequest, Operation> createBackupPlanSettings() {
            return this.createBackupPlanSettings;
        }

        public OperationCallSettings.Builder<CreateBackupPlanRequest, BackupPlan, OperationMetadata> createBackupPlanOperationSettings() {
            return this.createBackupPlanOperationSettings;
        }

        public UnaryCallSettings.Builder<GetBackupPlanRequest, BackupPlan> getBackupPlanSettings() {
            return this.getBackupPlanSettings;
        }

        public PagedCallSettings.Builder<ListBackupPlansRequest, ListBackupPlansResponse, BackupDRClient.ListBackupPlansPagedResponse> listBackupPlansSettings() {
            return this.listBackupPlansSettings;
        }

        public UnaryCallSettings.Builder<DeleteBackupPlanRequest, Operation> deleteBackupPlanSettings() {
            return this.deleteBackupPlanSettings;
        }

        public OperationCallSettings.Builder<DeleteBackupPlanRequest, Empty, OperationMetadata> deleteBackupPlanOperationSettings() {
            return this.deleteBackupPlanOperationSettings;
        }

        public UnaryCallSettings.Builder<CreateBackupPlanAssociationRequest, Operation> createBackupPlanAssociationSettings() {
            return this.createBackupPlanAssociationSettings;
        }

        public OperationCallSettings.Builder<CreateBackupPlanAssociationRequest, BackupPlanAssociation, OperationMetadata> createBackupPlanAssociationOperationSettings() {
            return this.createBackupPlanAssociationOperationSettings;
        }

        public UnaryCallSettings.Builder<GetBackupPlanAssociationRequest, BackupPlanAssociation> getBackupPlanAssociationSettings() {
            return this.getBackupPlanAssociationSettings;
        }

        public PagedCallSettings.Builder<ListBackupPlanAssociationsRequest, ListBackupPlanAssociationsResponse, BackupDRClient.ListBackupPlanAssociationsPagedResponse> listBackupPlanAssociationsSettings() {
            return this.listBackupPlanAssociationsSettings;
        }

        public UnaryCallSettings.Builder<DeleteBackupPlanAssociationRequest, Operation> deleteBackupPlanAssociationSettings() {
            return this.deleteBackupPlanAssociationSettings;
        }

        public OperationCallSettings.Builder<DeleteBackupPlanAssociationRequest, Empty, OperationMetadata> deleteBackupPlanAssociationOperationSettings() {
            return this.deleteBackupPlanAssociationOperationSettings;
        }

        public UnaryCallSettings.Builder<TriggerBackupRequest, Operation> triggerBackupSettings() {
            return this.triggerBackupSettings;
        }

        public OperationCallSettings.Builder<TriggerBackupRequest, BackupPlanAssociation, OperationMetadata> triggerBackupOperationSettings() {
            return this.triggerBackupOperationSettings;
        }

        public UnaryCallSettings.Builder<InitializeServiceRequest, Operation> initializeServiceSettings() {
            return this.initializeServiceSettings;
        }

        public OperationCallSettings.Builder<InitializeServiceRequest, InitializeServiceResponse, OperationMetadata> initializeServiceOperationSettings() {
            return this.initializeServiceOperationSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, BackupDRClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public BackupDRStubSettings build() throws IOException {
            return new BackupDRStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(10000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

