/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.backupdr.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.resourcenames.ResourceName;
import com.google.cloud.backupdr.v1.AbandonBackupRequest;
import com.google.cloud.backupdr.v1.Backup;
import com.google.cloud.backupdr.v1.BackupDRSettings;
import com.google.cloud.backupdr.v1.BackupName;
import com.google.cloud.backupdr.v1.BackupPlan;
import com.google.cloud.backupdr.v1.BackupPlanAssociation;
import com.google.cloud.backupdr.v1.BackupPlanAssociationName;
import com.google.cloud.backupdr.v1.BackupPlanName;
import com.google.cloud.backupdr.v1.BackupVault;
import com.google.cloud.backupdr.v1.BackupVaultName;
import com.google.cloud.backupdr.v1.CreateBackupPlanAssociationRequest;
import com.google.cloud.backupdr.v1.CreateBackupPlanRequest;
import com.google.cloud.backupdr.v1.CreateBackupVaultRequest;
import com.google.cloud.backupdr.v1.CreateManagementServerRequest;
import com.google.cloud.backupdr.v1.DataSource;
import com.google.cloud.backupdr.v1.DataSourceName;
import com.google.cloud.backupdr.v1.DeleteBackupPlanAssociationRequest;
import com.google.cloud.backupdr.v1.DeleteBackupPlanRequest;
import com.google.cloud.backupdr.v1.DeleteBackupRequest;
import com.google.cloud.backupdr.v1.DeleteBackupVaultRequest;
import com.google.cloud.backupdr.v1.DeleteManagementServerRequest;
import com.google.cloud.backupdr.v1.FetchAccessTokenRequest;
import com.google.cloud.backupdr.v1.FetchAccessTokenResponse;
import com.google.cloud.backupdr.v1.FetchUsableBackupVaultsRequest;
import com.google.cloud.backupdr.v1.FetchUsableBackupVaultsResponse;
import com.google.cloud.backupdr.v1.FinalizeBackupRequest;
import com.google.cloud.backupdr.v1.GetBackupPlanAssociationRequest;
import com.google.cloud.backupdr.v1.GetBackupPlanRequest;
import com.google.cloud.backupdr.v1.GetBackupRequest;
import com.google.cloud.backupdr.v1.GetBackupVaultRequest;
import com.google.cloud.backupdr.v1.GetDataSourceRequest;
import com.google.cloud.backupdr.v1.GetManagementServerRequest;
import com.google.cloud.backupdr.v1.InitiateBackupRequest;
import com.google.cloud.backupdr.v1.InitiateBackupResponse;
import com.google.cloud.backupdr.v1.ListBackupPlanAssociationsRequest;
import com.google.cloud.backupdr.v1.ListBackupPlanAssociationsResponse;
import com.google.cloud.backupdr.v1.ListBackupPlansRequest;
import com.google.cloud.backupdr.v1.ListBackupPlansResponse;
import com.google.cloud.backupdr.v1.ListBackupVaultsRequest;
import com.google.cloud.backupdr.v1.ListBackupVaultsResponse;
import com.google.cloud.backupdr.v1.ListBackupsRequest;
import com.google.cloud.backupdr.v1.ListBackupsResponse;
import com.google.cloud.backupdr.v1.ListDataSourcesRequest;
import com.google.cloud.backupdr.v1.ListDataSourcesResponse;
import com.google.cloud.backupdr.v1.ListManagementServersRequest;
import com.google.cloud.backupdr.v1.ListManagementServersResponse;
import com.google.cloud.backupdr.v1.LocationName;
import com.google.cloud.backupdr.v1.ManagementServer;
import com.google.cloud.backupdr.v1.ManagementServerName;
import com.google.cloud.backupdr.v1.OperationMetadata;
import com.google.cloud.backupdr.v1.RemoveDataSourceRequest;
import com.google.cloud.backupdr.v1.RestoreBackupRequest;
import com.google.cloud.backupdr.v1.RestoreBackupResponse;
import com.google.cloud.backupdr.v1.SetInternalStatusRequest;
import com.google.cloud.backupdr.v1.SetInternalStatusResponse;
import com.google.cloud.backupdr.v1.TriggerBackupRequest;
import com.google.cloud.backupdr.v1.UpdateBackupRequest;
import com.google.cloud.backupdr.v1.UpdateBackupVaultRequest;
import com.google.cloud.backupdr.v1.UpdateDataSourceRequest;
import com.google.cloud.backupdr.v1.stub.BackupDRStub;
import com.google.cloud.backupdr.v1.stub.BackupDRStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class BackupDRClient
implements BackgroundResource {
    private final BackupDRSettings settings;
    private final BackupDRStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final BackupDRClient create() throws IOException {
        return BackupDRClient.create(BackupDRSettings.newBuilder().build());
    }

    public static final BackupDRClient create(BackupDRSettings settings) throws IOException {
        return new BackupDRClient(settings);
    }

    public static final BackupDRClient create(BackupDRStub stub) {
        return new BackupDRClient(stub);
    }

    protected BackupDRClient(BackupDRSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((BackupDRStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected BackupDRClient(BackupDRStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final BackupDRSettings getSettings() {
        return this.settings;
    }

    public BackupDRStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final ListManagementServersPagedResponse listManagementServers(LocationName parent) {
        ListManagementServersRequest request = ListManagementServersRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listManagementServers(request);
    }

    public final ListManagementServersPagedResponse listManagementServers(String parent) {
        ListManagementServersRequest request = ListManagementServersRequest.newBuilder().setParent(parent).build();
        return this.listManagementServers(request);
    }

    public final ListManagementServersPagedResponse listManagementServers(ListManagementServersRequest request) {
        return (ListManagementServersPagedResponse)((Object)this.listManagementServersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListManagementServersRequest, ListManagementServersPagedResponse> listManagementServersPagedCallable() {
        return this.stub.listManagementServersPagedCallable();
    }

    public final UnaryCallable<ListManagementServersRequest, ListManagementServersResponse> listManagementServersCallable() {
        return this.stub.listManagementServersCallable();
    }

    public final ManagementServer getManagementServer(ManagementServerName name) {
        GetManagementServerRequest request = GetManagementServerRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getManagementServer(request);
    }

    public final ManagementServer getManagementServer(String name) {
        GetManagementServerRequest request = GetManagementServerRequest.newBuilder().setName(name).build();
        return this.getManagementServer(request);
    }

    public final ManagementServer getManagementServer(GetManagementServerRequest request) {
        return (ManagementServer)this.getManagementServerCallable().call((Object)request);
    }

    public final UnaryCallable<GetManagementServerRequest, ManagementServer> getManagementServerCallable() {
        return this.stub.getManagementServerCallable();
    }

    public final OperationFuture<ManagementServer, OperationMetadata> createManagementServerAsync(LocationName parent, ManagementServer managementServer, String managementServerId) {
        CreateManagementServerRequest request = CreateManagementServerRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setManagementServer(managementServer).setManagementServerId(managementServerId).build();
        return this.createManagementServerAsync(request);
    }

    public final OperationFuture<ManagementServer, OperationMetadata> createManagementServerAsync(String parent, ManagementServer managementServer, String managementServerId) {
        CreateManagementServerRequest request = CreateManagementServerRequest.newBuilder().setParent(parent).setManagementServer(managementServer).setManagementServerId(managementServerId).build();
        return this.createManagementServerAsync(request);
    }

    public final OperationFuture<ManagementServer, OperationMetadata> createManagementServerAsync(CreateManagementServerRequest request) {
        return this.createManagementServerOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateManagementServerRequest, ManagementServer, OperationMetadata> createManagementServerOperationCallable() {
        return this.stub.createManagementServerOperationCallable();
    }

    public final UnaryCallable<CreateManagementServerRequest, Operation> createManagementServerCallable() {
        return this.stub.createManagementServerCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteManagementServerAsync(ManagementServerName name) {
        DeleteManagementServerRequest request = DeleteManagementServerRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteManagementServerAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteManagementServerAsync(String name) {
        DeleteManagementServerRequest request = DeleteManagementServerRequest.newBuilder().setName(name).build();
        return this.deleteManagementServerAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteManagementServerAsync(DeleteManagementServerRequest request) {
        return this.deleteManagementServerOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteManagementServerRequest, Empty, OperationMetadata> deleteManagementServerOperationCallable() {
        return this.stub.deleteManagementServerOperationCallable();
    }

    public final UnaryCallable<DeleteManagementServerRequest, Operation> deleteManagementServerCallable() {
        return this.stub.deleteManagementServerCallable();
    }

    public final OperationFuture<BackupVault, OperationMetadata> createBackupVaultAsync(LocationName parent, BackupVault backupVault, String backupVaultId) {
        CreateBackupVaultRequest request = CreateBackupVaultRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setBackupVault(backupVault).setBackupVaultId(backupVaultId).build();
        return this.createBackupVaultAsync(request);
    }

    public final OperationFuture<BackupVault, OperationMetadata> createBackupVaultAsync(String parent, BackupVault backupVault, String backupVaultId) {
        CreateBackupVaultRequest request = CreateBackupVaultRequest.newBuilder().setParent(parent).setBackupVault(backupVault).setBackupVaultId(backupVaultId).build();
        return this.createBackupVaultAsync(request);
    }

    public final OperationFuture<BackupVault, OperationMetadata> createBackupVaultAsync(CreateBackupVaultRequest request) {
        return this.createBackupVaultOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateBackupVaultRequest, BackupVault, OperationMetadata> createBackupVaultOperationCallable() {
        return this.stub.createBackupVaultOperationCallable();
    }

    public final UnaryCallable<CreateBackupVaultRequest, Operation> createBackupVaultCallable() {
        return this.stub.createBackupVaultCallable();
    }

    public final ListBackupVaultsPagedResponse listBackupVaults(LocationName parent) {
        ListBackupVaultsRequest request = ListBackupVaultsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listBackupVaults(request);
    }

    public final ListBackupVaultsPagedResponse listBackupVaults(String parent) {
        ListBackupVaultsRequest request = ListBackupVaultsRequest.newBuilder().setParent(parent).build();
        return this.listBackupVaults(request);
    }

    public final ListBackupVaultsPagedResponse listBackupVaults(ListBackupVaultsRequest request) {
        return (ListBackupVaultsPagedResponse)((Object)this.listBackupVaultsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListBackupVaultsRequest, ListBackupVaultsPagedResponse> listBackupVaultsPagedCallable() {
        return this.stub.listBackupVaultsPagedCallable();
    }

    public final UnaryCallable<ListBackupVaultsRequest, ListBackupVaultsResponse> listBackupVaultsCallable() {
        return this.stub.listBackupVaultsCallable();
    }

    public final FetchUsableBackupVaultsPagedResponse fetchUsableBackupVaults(LocationName parent) {
        FetchUsableBackupVaultsRequest request = FetchUsableBackupVaultsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.fetchUsableBackupVaults(request);
    }

    public final FetchUsableBackupVaultsPagedResponse fetchUsableBackupVaults(String parent) {
        FetchUsableBackupVaultsRequest request = FetchUsableBackupVaultsRequest.newBuilder().setParent(parent).build();
        return this.fetchUsableBackupVaults(request);
    }

    public final FetchUsableBackupVaultsPagedResponse fetchUsableBackupVaults(FetchUsableBackupVaultsRequest request) {
        return (FetchUsableBackupVaultsPagedResponse)((Object)this.fetchUsableBackupVaultsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<FetchUsableBackupVaultsRequest, FetchUsableBackupVaultsPagedResponse> fetchUsableBackupVaultsPagedCallable() {
        return this.stub.fetchUsableBackupVaultsPagedCallable();
    }

    public final UnaryCallable<FetchUsableBackupVaultsRequest, FetchUsableBackupVaultsResponse> fetchUsableBackupVaultsCallable() {
        return this.stub.fetchUsableBackupVaultsCallable();
    }

    public final BackupVault getBackupVault(BackupVaultName name) {
        GetBackupVaultRequest request = GetBackupVaultRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getBackupVault(request);
    }

    public final BackupVault getBackupVault(String name) {
        GetBackupVaultRequest request = GetBackupVaultRequest.newBuilder().setName(name).build();
        return this.getBackupVault(request);
    }

    public final BackupVault getBackupVault(GetBackupVaultRequest request) {
        return (BackupVault)this.getBackupVaultCallable().call((Object)request);
    }

    public final UnaryCallable<GetBackupVaultRequest, BackupVault> getBackupVaultCallable() {
        return this.stub.getBackupVaultCallable();
    }

    public final OperationFuture<BackupVault, OperationMetadata> updateBackupVaultAsync(BackupVault backupVault, FieldMask updateMask) {
        UpdateBackupVaultRequest request = UpdateBackupVaultRequest.newBuilder().setBackupVault(backupVault).setUpdateMask(updateMask).build();
        return this.updateBackupVaultAsync(request);
    }

    public final OperationFuture<BackupVault, OperationMetadata> updateBackupVaultAsync(UpdateBackupVaultRequest request) {
        return this.updateBackupVaultOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateBackupVaultRequest, BackupVault, OperationMetadata> updateBackupVaultOperationCallable() {
        return this.stub.updateBackupVaultOperationCallable();
    }

    public final UnaryCallable<UpdateBackupVaultRequest, Operation> updateBackupVaultCallable() {
        return this.stub.updateBackupVaultCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteBackupVaultAsync(BackupVaultName name) {
        DeleteBackupVaultRequest request = DeleteBackupVaultRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteBackupVaultAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteBackupVaultAsync(String name) {
        DeleteBackupVaultRequest request = DeleteBackupVaultRequest.newBuilder().setName(name).build();
        return this.deleteBackupVaultAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteBackupVaultAsync(DeleteBackupVaultRequest request) {
        return this.deleteBackupVaultOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteBackupVaultRequest, Empty, OperationMetadata> deleteBackupVaultOperationCallable() {
        return this.stub.deleteBackupVaultOperationCallable();
    }

    public final UnaryCallable<DeleteBackupVaultRequest, Operation> deleteBackupVaultCallable() {
        return this.stub.deleteBackupVaultCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(ResourceName resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource == null ? null : resource.toString()).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(String resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final ListDataSourcesPagedResponse listDataSources(BackupVaultName parent) {
        ListDataSourcesRequest request = ListDataSourcesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDataSources(request);
    }

    public final ListDataSourcesPagedResponse listDataSources(String parent) {
        ListDataSourcesRequest request = ListDataSourcesRequest.newBuilder().setParent(parent).build();
        return this.listDataSources(request);
    }

    public final ListDataSourcesPagedResponse listDataSources(ListDataSourcesRequest request) {
        return (ListDataSourcesPagedResponse)((Object)this.listDataSourcesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDataSourcesRequest, ListDataSourcesPagedResponse> listDataSourcesPagedCallable() {
        return this.stub.listDataSourcesPagedCallable();
    }

    public final UnaryCallable<ListDataSourcesRequest, ListDataSourcesResponse> listDataSourcesCallable() {
        return this.stub.listDataSourcesCallable();
    }

    public final DataSource getDataSource(DataSourceName name) {
        GetDataSourceRequest request = GetDataSourceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDataSource(request);
    }

    public final DataSource getDataSource(String name) {
        GetDataSourceRequest request = GetDataSourceRequest.newBuilder().setName(name).build();
        return this.getDataSource(request);
    }

    public final DataSource getDataSource(GetDataSourceRequest request) {
        return (DataSource)this.getDataSourceCallable().call((Object)request);
    }

    public final UnaryCallable<GetDataSourceRequest, DataSource> getDataSourceCallable() {
        return this.stub.getDataSourceCallable();
    }

    public final OperationFuture<DataSource, OperationMetadata> updateDataSourceAsync(DataSource dataSource, FieldMask updateMask) {
        UpdateDataSourceRequest request = UpdateDataSourceRequest.newBuilder().setDataSource(dataSource).setUpdateMask(updateMask).build();
        return this.updateDataSourceAsync(request);
    }

    public final OperationFuture<DataSource, OperationMetadata> updateDataSourceAsync(UpdateDataSourceRequest request) {
        return this.updateDataSourceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateDataSourceRequest, DataSource, OperationMetadata> updateDataSourceOperationCallable() {
        return this.stub.updateDataSourceOperationCallable();
    }

    public final UnaryCallable<UpdateDataSourceRequest, Operation> updateDataSourceCallable() {
        return this.stub.updateDataSourceCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> removeDataSourceAsync(DataSourceName name) {
        RemoveDataSourceRequest request = RemoveDataSourceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.removeDataSourceAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> removeDataSourceAsync(String name) {
        RemoveDataSourceRequest request = RemoveDataSourceRequest.newBuilder().setName(name).build();
        return this.removeDataSourceAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> removeDataSourceAsync(RemoveDataSourceRequest request) {
        return this.removeDataSourceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RemoveDataSourceRequest, Empty, OperationMetadata> removeDataSourceOperationCallable() {
        return this.stub.removeDataSourceOperationCallable();
    }

    public final UnaryCallable<RemoveDataSourceRequest, Operation> removeDataSourceCallable() {
        return this.stub.removeDataSourceCallable();
    }

    public final OperationFuture<SetInternalStatusResponse, OperationMetadata> setInternalStatusAsync(DataSourceName dataSource) {
        SetInternalStatusRequest request = SetInternalStatusRequest.newBuilder().setDataSource(dataSource == null ? null : dataSource.toString()).build();
        return this.setInternalStatusAsync(request);
    }

    public final OperationFuture<SetInternalStatusResponse, OperationMetadata> setInternalStatusAsync(String dataSource) {
        SetInternalStatusRequest request = SetInternalStatusRequest.newBuilder().setDataSource(dataSource).build();
        return this.setInternalStatusAsync(request);
    }

    public final OperationFuture<SetInternalStatusResponse, OperationMetadata> setInternalStatusAsync(SetInternalStatusRequest request) {
        return this.setInternalStatusOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<SetInternalStatusRequest, SetInternalStatusResponse, OperationMetadata> setInternalStatusOperationCallable() {
        return this.stub.setInternalStatusOperationCallable();
    }

    public final UnaryCallable<SetInternalStatusRequest, Operation> setInternalStatusCallable() {
        return this.stub.setInternalStatusCallable();
    }

    public final InitiateBackupResponse initiateBackup(DataSourceName dataSource) {
        InitiateBackupRequest request = InitiateBackupRequest.newBuilder().setDataSource(dataSource == null ? null : dataSource.toString()).build();
        return this.initiateBackup(request);
    }

    public final InitiateBackupResponse initiateBackup(String dataSource) {
        InitiateBackupRequest request = InitiateBackupRequest.newBuilder().setDataSource(dataSource).build();
        return this.initiateBackup(request);
    }

    public final InitiateBackupResponse initiateBackup(InitiateBackupRequest request) {
        return (InitiateBackupResponse)this.initiateBackupCallable().call((Object)request);
    }

    public final UnaryCallable<InitiateBackupRequest, InitiateBackupResponse> initiateBackupCallable() {
        return this.stub.initiateBackupCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> abandonBackupAsync(DataSourceName dataSource) {
        AbandonBackupRequest request = AbandonBackupRequest.newBuilder().setDataSource(dataSource == null ? null : dataSource.toString()).build();
        return this.abandonBackupAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> abandonBackupAsync(String dataSource) {
        AbandonBackupRequest request = AbandonBackupRequest.newBuilder().setDataSource(dataSource).build();
        return this.abandonBackupAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> abandonBackupAsync(AbandonBackupRequest request) {
        return this.abandonBackupOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<AbandonBackupRequest, Empty, OperationMetadata> abandonBackupOperationCallable() {
        return this.stub.abandonBackupOperationCallable();
    }

    public final UnaryCallable<AbandonBackupRequest, Operation> abandonBackupCallable() {
        return this.stub.abandonBackupCallable();
    }

    public final OperationFuture<Backup, OperationMetadata> finalizeBackupAsync(DataSourceName dataSource) {
        FinalizeBackupRequest request = FinalizeBackupRequest.newBuilder().setDataSource(dataSource == null ? null : dataSource.toString()).build();
        return this.finalizeBackupAsync(request);
    }

    public final OperationFuture<Backup, OperationMetadata> finalizeBackupAsync(String dataSource) {
        FinalizeBackupRequest request = FinalizeBackupRequest.newBuilder().setDataSource(dataSource).build();
        return this.finalizeBackupAsync(request);
    }

    public final OperationFuture<Backup, OperationMetadata> finalizeBackupAsync(FinalizeBackupRequest request) {
        return this.finalizeBackupOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<FinalizeBackupRequest, Backup, OperationMetadata> finalizeBackupOperationCallable() {
        return this.stub.finalizeBackupOperationCallable();
    }

    public final UnaryCallable<FinalizeBackupRequest, Operation> finalizeBackupCallable() {
        return this.stub.finalizeBackupCallable();
    }

    public final FetchAccessTokenResponse fetchAccessToken(DataSourceName name) {
        FetchAccessTokenRequest request = FetchAccessTokenRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.fetchAccessToken(request);
    }

    public final FetchAccessTokenResponse fetchAccessToken(String name) {
        FetchAccessTokenRequest request = FetchAccessTokenRequest.newBuilder().setName(name).build();
        return this.fetchAccessToken(request);
    }

    public final FetchAccessTokenResponse fetchAccessToken(FetchAccessTokenRequest request) {
        return (FetchAccessTokenResponse)this.fetchAccessTokenCallable().call((Object)request);
    }

    public final UnaryCallable<FetchAccessTokenRequest, FetchAccessTokenResponse> fetchAccessTokenCallable() {
        return this.stub.fetchAccessTokenCallable();
    }

    public final ListBackupsPagedResponse listBackups(DataSourceName parent) {
        ListBackupsRequest request = ListBackupsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listBackups(request);
    }

    public final ListBackupsPagedResponse listBackups(String parent) {
        ListBackupsRequest request = ListBackupsRequest.newBuilder().setParent(parent).build();
        return this.listBackups(request);
    }

    public final ListBackupsPagedResponse listBackups(ListBackupsRequest request) {
        return (ListBackupsPagedResponse)((Object)this.listBackupsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListBackupsRequest, ListBackupsPagedResponse> listBackupsPagedCallable() {
        return this.stub.listBackupsPagedCallable();
    }

    public final UnaryCallable<ListBackupsRequest, ListBackupsResponse> listBackupsCallable() {
        return this.stub.listBackupsCallable();
    }

    public final Backup getBackup(BackupName name) {
        GetBackupRequest request = GetBackupRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getBackup(request);
    }

    public final Backup getBackup(String name) {
        GetBackupRequest request = GetBackupRequest.newBuilder().setName(name).build();
        return this.getBackup(request);
    }

    public final Backup getBackup(GetBackupRequest request) {
        return (Backup)this.getBackupCallable().call((Object)request);
    }

    public final UnaryCallable<GetBackupRequest, Backup> getBackupCallable() {
        return this.stub.getBackupCallable();
    }

    public final OperationFuture<Backup, OperationMetadata> updateBackupAsync(Backup backup, FieldMask updateMask) {
        UpdateBackupRequest request = UpdateBackupRequest.newBuilder().setBackup(backup).setUpdateMask(updateMask).build();
        return this.updateBackupAsync(request);
    }

    public final OperationFuture<Backup, OperationMetadata> updateBackupAsync(UpdateBackupRequest request) {
        return this.updateBackupOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateBackupRequest, Backup, OperationMetadata> updateBackupOperationCallable() {
        return this.stub.updateBackupOperationCallable();
    }

    public final UnaryCallable<UpdateBackupRequest, Operation> updateBackupCallable() {
        return this.stub.updateBackupCallable();
    }

    public final OperationFuture<Backup, OperationMetadata> deleteBackupAsync(BackupName name) {
        DeleteBackupRequest request = DeleteBackupRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteBackupAsync(request);
    }

    public final OperationFuture<Backup, OperationMetadata> deleteBackupAsync(String name) {
        DeleteBackupRequest request = DeleteBackupRequest.newBuilder().setName(name).build();
        return this.deleteBackupAsync(request);
    }

    public final OperationFuture<Backup, OperationMetadata> deleteBackupAsync(DeleteBackupRequest request) {
        return this.deleteBackupOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteBackupRequest, Backup, OperationMetadata> deleteBackupOperationCallable() {
        return this.stub.deleteBackupOperationCallable();
    }

    public final UnaryCallable<DeleteBackupRequest, Operation> deleteBackupCallable() {
        return this.stub.deleteBackupCallable();
    }

    public final OperationFuture<RestoreBackupResponse, OperationMetadata> restoreBackupAsync(BackupName name) {
        RestoreBackupRequest request = RestoreBackupRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.restoreBackupAsync(request);
    }

    public final OperationFuture<RestoreBackupResponse, OperationMetadata> restoreBackupAsync(String name) {
        RestoreBackupRequest request = RestoreBackupRequest.newBuilder().setName(name).build();
        return this.restoreBackupAsync(request);
    }

    public final OperationFuture<RestoreBackupResponse, OperationMetadata> restoreBackupAsync(RestoreBackupRequest request) {
        return this.restoreBackupOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RestoreBackupRequest, RestoreBackupResponse, OperationMetadata> restoreBackupOperationCallable() {
        return this.stub.restoreBackupOperationCallable();
    }

    public final UnaryCallable<RestoreBackupRequest, Operation> restoreBackupCallable() {
        return this.stub.restoreBackupCallable();
    }

    public final OperationFuture<BackupPlan, OperationMetadata> createBackupPlanAsync(LocationName parent, BackupPlan backupPlan, String backupPlanId) {
        CreateBackupPlanRequest request = CreateBackupPlanRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setBackupPlan(backupPlan).setBackupPlanId(backupPlanId).build();
        return this.createBackupPlanAsync(request);
    }

    public final OperationFuture<BackupPlan, OperationMetadata> createBackupPlanAsync(String parent, BackupPlan backupPlan, String backupPlanId) {
        CreateBackupPlanRequest request = CreateBackupPlanRequest.newBuilder().setParent(parent).setBackupPlan(backupPlan).setBackupPlanId(backupPlanId).build();
        return this.createBackupPlanAsync(request);
    }

    public final OperationFuture<BackupPlan, OperationMetadata> createBackupPlanAsync(CreateBackupPlanRequest request) {
        return this.createBackupPlanOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateBackupPlanRequest, BackupPlan, OperationMetadata> createBackupPlanOperationCallable() {
        return this.stub.createBackupPlanOperationCallable();
    }

    public final UnaryCallable<CreateBackupPlanRequest, Operation> createBackupPlanCallable() {
        return this.stub.createBackupPlanCallable();
    }

    public final BackupPlan getBackupPlan(BackupPlanName name) {
        GetBackupPlanRequest request = GetBackupPlanRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getBackupPlan(request);
    }

    public final BackupPlan getBackupPlan(String name) {
        GetBackupPlanRequest request = GetBackupPlanRequest.newBuilder().setName(name).build();
        return this.getBackupPlan(request);
    }

    public final BackupPlan getBackupPlan(GetBackupPlanRequest request) {
        return (BackupPlan)this.getBackupPlanCallable().call((Object)request);
    }

    public final UnaryCallable<GetBackupPlanRequest, BackupPlan> getBackupPlanCallable() {
        return this.stub.getBackupPlanCallable();
    }

    public final ListBackupPlansPagedResponse listBackupPlans(LocationName parent) {
        ListBackupPlansRequest request = ListBackupPlansRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listBackupPlans(request);
    }

    public final ListBackupPlansPagedResponse listBackupPlans(String parent) {
        ListBackupPlansRequest request = ListBackupPlansRequest.newBuilder().setParent(parent).build();
        return this.listBackupPlans(request);
    }

    public final ListBackupPlansPagedResponse listBackupPlans(ListBackupPlansRequest request) {
        return (ListBackupPlansPagedResponse)((Object)this.listBackupPlansPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListBackupPlansRequest, ListBackupPlansPagedResponse> listBackupPlansPagedCallable() {
        return this.stub.listBackupPlansPagedCallable();
    }

    public final UnaryCallable<ListBackupPlansRequest, ListBackupPlansResponse> listBackupPlansCallable() {
        return this.stub.listBackupPlansCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteBackupPlanAsync(BackupPlanName name) {
        DeleteBackupPlanRequest request = DeleteBackupPlanRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteBackupPlanAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteBackupPlanAsync(String name) {
        DeleteBackupPlanRequest request = DeleteBackupPlanRequest.newBuilder().setName(name).build();
        return this.deleteBackupPlanAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteBackupPlanAsync(DeleteBackupPlanRequest request) {
        return this.deleteBackupPlanOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteBackupPlanRequest, Empty, OperationMetadata> deleteBackupPlanOperationCallable() {
        return this.stub.deleteBackupPlanOperationCallable();
    }

    public final UnaryCallable<DeleteBackupPlanRequest, Operation> deleteBackupPlanCallable() {
        return this.stub.deleteBackupPlanCallable();
    }

    public final OperationFuture<BackupPlanAssociation, OperationMetadata> createBackupPlanAssociationAsync(LocationName parent, BackupPlanAssociation backupPlanAssociation, String backupPlanAssociationId) {
        CreateBackupPlanAssociationRequest request = CreateBackupPlanAssociationRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setBackupPlanAssociation(backupPlanAssociation).setBackupPlanAssociationId(backupPlanAssociationId).build();
        return this.createBackupPlanAssociationAsync(request);
    }

    public final OperationFuture<BackupPlanAssociation, OperationMetadata> createBackupPlanAssociationAsync(String parent, BackupPlanAssociation backupPlanAssociation, String backupPlanAssociationId) {
        CreateBackupPlanAssociationRequest request = CreateBackupPlanAssociationRequest.newBuilder().setParent(parent).setBackupPlanAssociation(backupPlanAssociation).setBackupPlanAssociationId(backupPlanAssociationId).build();
        return this.createBackupPlanAssociationAsync(request);
    }

    public final OperationFuture<BackupPlanAssociation, OperationMetadata> createBackupPlanAssociationAsync(CreateBackupPlanAssociationRequest request) {
        return this.createBackupPlanAssociationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateBackupPlanAssociationRequest, BackupPlanAssociation, OperationMetadata> createBackupPlanAssociationOperationCallable() {
        return this.stub.createBackupPlanAssociationOperationCallable();
    }

    public final UnaryCallable<CreateBackupPlanAssociationRequest, Operation> createBackupPlanAssociationCallable() {
        return this.stub.createBackupPlanAssociationCallable();
    }

    public final BackupPlanAssociation getBackupPlanAssociation(BackupPlanAssociationName name) {
        GetBackupPlanAssociationRequest request = GetBackupPlanAssociationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getBackupPlanAssociation(request);
    }

    public final BackupPlanAssociation getBackupPlanAssociation(String name) {
        GetBackupPlanAssociationRequest request = GetBackupPlanAssociationRequest.newBuilder().setName(name).build();
        return this.getBackupPlanAssociation(request);
    }

    public final BackupPlanAssociation getBackupPlanAssociation(GetBackupPlanAssociationRequest request) {
        return (BackupPlanAssociation)this.getBackupPlanAssociationCallable().call((Object)request);
    }

    public final UnaryCallable<GetBackupPlanAssociationRequest, BackupPlanAssociation> getBackupPlanAssociationCallable() {
        return this.stub.getBackupPlanAssociationCallable();
    }

    public final ListBackupPlanAssociationsPagedResponse listBackupPlanAssociations(LocationName parent) {
        ListBackupPlanAssociationsRequest request = ListBackupPlanAssociationsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listBackupPlanAssociations(request);
    }

    public final ListBackupPlanAssociationsPagedResponse listBackupPlanAssociations(String parent) {
        ListBackupPlanAssociationsRequest request = ListBackupPlanAssociationsRequest.newBuilder().setParent(parent).build();
        return this.listBackupPlanAssociations(request);
    }

    public final ListBackupPlanAssociationsPagedResponse listBackupPlanAssociations(ListBackupPlanAssociationsRequest request) {
        return (ListBackupPlanAssociationsPagedResponse)((Object)this.listBackupPlanAssociationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListBackupPlanAssociationsRequest, ListBackupPlanAssociationsPagedResponse> listBackupPlanAssociationsPagedCallable() {
        return this.stub.listBackupPlanAssociationsPagedCallable();
    }

    public final UnaryCallable<ListBackupPlanAssociationsRequest, ListBackupPlanAssociationsResponse> listBackupPlanAssociationsCallable() {
        return this.stub.listBackupPlanAssociationsCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteBackupPlanAssociationAsync(BackupPlanAssociationName name) {
        DeleteBackupPlanAssociationRequest request = DeleteBackupPlanAssociationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteBackupPlanAssociationAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteBackupPlanAssociationAsync(String name) {
        DeleteBackupPlanAssociationRequest request = DeleteBackupPlanAssociationRequest.newBuilder().setName(name).build();
        return this.deleteBackupPlanAssociationAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteBackupPlanAssociationAsync(DeleteBackupPlanAssociationRequest request) {
        return this.deleteBackupPlanAssociationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteBackupPlanAssociationRequest, Empty, OperationMetadata> deleteBackupPlanAssociationOperationCallable() {
        return this.stub.deleteBackupPlanAssociationOperationCallable();
    }

    public final UnaryCallable<DeleteBackupPlanAssociationRequest, Operation> deleteBackupPlanAssociationCallable() {
        return this.stub.deleteBackupPlanAssociationCallable();
    }

    public final OperationFuture<BackupPlanAssociation, OperationMetadata> triggerBackupAsync(BackupPlanAssociationName name, String ruleId) {
        TriggerBackupRequest request = TriggerBackupRequest.newBuilder().setName(name == null ? null : name.toString()).setRuleId(ruleId).build();
        return this.triggerBackupAsync(request);
    }

    public final OperationFuture<BackupPlanAssociation, OperationMetadata> triggerBackupAsync(String name, String ruleId) {
        TriggerBackupRequest request = TriggerBackupRequest.newBuilder().setName(name).setRuleId(ruleId).build();
        return this.triggerBackupAsync(request);
    }

    public final OperationFuture<BackupPlanAssociation, OperationMetadata> triggerBackupAsync(TriggerBackupRequest request) {
        return this.triggerBackupOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<TriggerBackupRequest, BackupPlanAssociation, OperationMetadata> triggerBackupOperationCallable() {
        return this.stub.triggerBackupOperationCallable();
    }

    public final UnaryCallable<TriggerBackupRequest, Operation> triggerBackupCallable() {
        return this.stub.triggerBackupCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListBackupPlanAssociationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListBackupPlanAssociationsRequest, ListBackupPlanAssociationsResponse, BackupPlanAssociation, ListBackupPlanAssociationsPage, ListBackupPlanAssociationsFixedSizeCollection> {
        private ListBackupPlanAssociationsFixedSizeCollection(List<ListBackupPlanAssociationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListBackupPlanAssociationsFixedSizeCollection createEmptyCollection() {
            return new ListBackupPlanAssociationsFixedSizeCollection(null, 0);
        }

        protected ListBackupPlanAssociationsFixedSizeCollection createCollection(List<ListBackupPlanAssociationsPage> pages, int collectionSize) {
            return new ListBackupPlanAssociationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListBackupPlanAssociationsPage
    extends AbstractPage<ListBackupPlanAssociationsRequest, ListBackupPlanAssociationsResponse, BackupPlanAssociation, ListBackupPlanAssociationsPage> {
        private ListBackupPlanAssociationsPage(PageContext<ListBackupPlanAssociationsRequest, ListBackupPlanAssociationsResponse, BackupPlanAssociation> context, ListBackupPlanAssociationsResponse response) {
            super(context, (Object)response);
        }

        private static ListBackupPlanAssociationsPage createEmptyPage() {
            return new ListBackupPlanAssociationsPage(null, null);
        }

        protected ListBackupPlanAssociationsPage createPage(PageContext<ListBackupPlanAssociationsRequest, ListBackupPlanAssociationsResponse, BackupPlanAssociation> context, ListBackupPlanAssociationsResponse response) {
            return new ListBackupPlanAssociationsPage(context, response);
        }

        public ApiFuture<ListBackupPlanAssociationsPage> createPageAsync(PageContext<ListBackupPlanAssociationsRequest, ListBackupPlanAssociationsResponse, BackupPlanAssociation> context, ApiFuture<ListBackupPlanAssociationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListBackupPlanAssociationsPagedResponse
    extends AbstractPagedListResponse<ListBackupPlanAssociationsRequest, ListBackupPlanAssociationsResponse, BackupPlanAssociation, ListBackupPlanAssociationsPage, ListBackupPlanAssociationsFixedSizeCollection> {
        public static ApiFuture<ListBackupPlanAssociationsPagedResponse> createAsync(PageContext<ListBackupPlanAssociationsRequest, ListBackupPlanAssociationsResponse, BackupPlanAssociation> context, ApiFuture<ListBackupPlanAssociationsResponse> futureResponse) {
            ApiFuture<ListBackupPlanAssociationsPage> futurePage = ListBackupPlanAssociationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListBackupPlanAssociationsPagedResponse((ListBackupPlanAssociationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListBackupPlanAssociationsPagedResponse(ListBackupPlanAssociationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListBackupPlanAssociationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListBackupPlansFixedSizeCollection
    extends AbstractFixedSizeCollection<ListBackupPlansRequest, ListBackupPlansResponse, BackupPlan, ListBackupPlansPage, ListBackupPlansFixedSizeCollection> {
        private ListBackupPlansFixedSizeCollection(List<ListBackupPlansPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListBackupPlansFixedSizeCollection createEmptyCollection() {
            return new ListBackupPlansFixedSizeCollection(null, 0);
        }

        protected ListBackupPlansFixedSizeCollection createCollection(List<ListBackupPlansPage> pages, int collectionSize) {
            return new ListBackupPlansFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListBackupPlansPage
    extends AbstractPage<ListBackupPlansRequest, ListBackupPlansResponse, BackupPlan, ListBackupPlansPage> {
        private ListBackupPlansPage(PageContext<ListBackupPlansRequest, ListBackupPlansResponse, BackupPlan> context, ListBackupPlansResponse response) {
            super(context, (Object)response);
        }

        private static ListBackupPlansPage createEmptyPage() {
            return new ListBackupPlansPage(null, null);
        }

        protected ListBackupPlansPage createPage(PageContext<ListBackupPlansRequest, ListBackupPlansResponse, BackupPlan> context, ListBackupPlansResponse response) {
            return new ListBackupPlansPage(context, response);
        }

        public ApiFuture<ListBackupPlansPage> createPageAsync(PageContext<ListBackupPlansRequest, ListBackupPlansResponse, BackupPlan> context, ApiFuture<ListBackupPlansResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListBackupPlansPagedResponse
    extends AbstractPagedListResponse<ListBackupPlansRequest, ListBackupPlansResponse, BackupPlan, ListBackupPlansPage, ListBackupPlansFixedSizeCollection> {
        public static ApiFuture<ListBackupPlansPagedResponse> createAsync(PageContext<ListBackupPlansRequest, ListBackupPlansResponse, BackupPlan> context, ApiFuture<ListBackupPlansResponse> futureResponse) {
            ApiFuture<ListBackupPlansPage> futurePage = ListBackupPlansPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListBackupPlansPagedResponse((ListBackupPlansPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListBackupPlansPagedResponse(ListBackupPlansPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListBackupPlansFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListBackupsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListBackupsRequest, ListBackupsResponse, Backup, ListBackupsPage, ListBackupsFixedSizeCollection> {
        private ListBackupsFixedSizeCollection(List<ListBackupsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListBackupsFixedSizeCollection createEmptyCollection() {
            return new ListBackupsFixedSizeCollection(null, 0);
        }

        protected ListBackupsFixedSizeCollection createCollection(List<ListBackupsPage> pages, int collectionSize) {
            return new ListBackupsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListBackupsPage
    extends AbstractPage<ListBackupsRequest, ListBackupsResponse, Backup, ListBackupsPage> {
        private ListBackupsPage(PageContext<ListBackupsRequest, ListBackupsResponse, Backup> context, ListBackupsResponse response) {
            super(context, (Object)response);
        }

        private static ListBackupsPage createEmptyPage() {
            return new ListBackupsPage(null, null);
        }

        protected ListBackupsPage createPage(PageContext<ListBackupsRequest, ListBackupsResponse, Backup> context, ListBackupsResponse response) {
            return new ListBackupsPage(context, response);
        }

        public ApiFuture<ListBackupsPage> createPageAsync(PageContext<ListBackupsRequest, ListBackupsResponse, Backup> context, ApiFuture<ListBackupsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListBackupsPagedResponse
    extends AbstractPagedListResponse<ListBackupsRequest, ListBackupsResponse, Backup, ListBackupsPage, ListBackupsFixedSizeCollection> {
        public static ApiFuture<ListBackupsPagedResponse> createAsync(PageContext<ListBackupsRequest, ListBackupsResponse, Backup> context, ApiFuture<ListBackupsResponse> futureResponse) {
            ApiFuture<ListBackupsPage> futurePage = ListBackupsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListBackupsPagedResponse((ListBackupsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListBackupsPagedResponse(ListBackupsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListBackupsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDataSourcesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDataSourcesRequest, ListDataSourcesResponse, DataSource, ListDataSourcesPage, ListDataSourcesFixedSizeCollection> {
        private ListDataSourcesFixedSizeCollection(List<ListDataSourcesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDataSourcesFixedSizeCollection createEmptyCollection() {
            return new ListDataSourcesFixedSizeCollection(null, 0);
        }

        protected ListDataSourcesFixedSizeCollection createCollection(List<ListDataSourcesPage> pages, int collectionSize) {
            return new ListDataSourcesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDataSourcesPage
    extends AbstractPage<ListDataSourcesRequest, ListDataSourcesResponse, DataSource, ListDataSourcesPage> {
        private ListDataSourcesPage(PageContext<ListDataSourcesRequest, ListDataSourcesResponse, DataSource> context, ListDataSourcesResponse response) {
            super(context, (Object)response);
        }

        private static ListDataSourcesPage createEmptyPage() {
            return new ListDataSourcesPage(null, null);
        }

        protected ListDataSourcesPage createPage(PageContext<ListDataSourcesRequest, ListDataSourcesResponse, DataSource> context, ListDataSourcesResponse response) {
            return new ListDataSourcesPage(context, response);
        }

        public ApiFuture<ListDataSourcesPage> createPageAsync(PageContext<ListDataSourcesRequest, ListDataSourcesResponse, DataSource> context, ApiFuture<ListDataSourcesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDataSourcesPagedResponse
    extends AbstractPagedListResponse<ListDataSourcesRequest, ListDataSourcesResponse, DataSource, ListDataSourcesPage, ListDataSourcesFixedSizeCollection> {
        public static ApiFuture<ListDataSourcesPagedResponse> createAsync(PageContext<ListDataSourcesRequest, ListDataSourcesResponse, DataSource> context, ApiFuture<ListDataSourcesResponse> futureResponse) {
            ApiFuture<ListDataSourcesPage> futurePage = ListDataSourcesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDataSourcesPagedResponse((ListDataSourcesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDataSourcesPagedResponse(ListDataSourcesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDataSourcesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class FetchUsableBackupVaultsFixedSizeCollection
    extends AbstractFixedSizeCollection<FetchUsableBackupVaultsRequest, FetchUsableBackupVaultsResponse, BackupVault, FetchUsableBackupVaultsPage, FetchUsableBackupVaultsFixedSizeCollection> {
        private FetchUsableBackupVaultsFixedSizeCollection(List<FetchUsableBackupVaultsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static FetchUsableBackupVaultsFixedSizeCollection createEmptyCollection() {
            return new FetchUsableBackupVaultsFixedSizeCollection(null, 0);
        }

        protected FetchUsableBackupVaultsFixedSizeCollection createCollection(List<FetchUsableBackupVaultsPage> pages, int collectionSize) {
            return new FetchUsableBackupVaultsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class FetchUsableBackupVaultsPage
    extends AbstractPage<FetchUsableBackupVaultsRequest, FetchUsableBackupVaultsResponse, BackupVault, FetchUsableBackupVaultsPage> {
        private FetchUsableBackupVaultsPage(PageContext<FetchUsableBackupVaultsRequest, FetchUsableBackupVaultsResponse, BackupVault> context, FetchUsableBackupVaultsResponse response) {
            super(context, (Object)response);
        }

        private static FetchUsableBackupVaultsPage createEmptyPage() {
            return new FetchUsableBackupVaultsPage(null, null);
        }

        protected FetchUsableBackupVaultsPage createPage(PageContext<FetchUsableBackupVaultsRequest, FetchUsableBackupVaultsResponse, BackupVault> context, FetchUsableBackupVaultsResponse response) {
            return new FetchUsableBackupVaultsPage(context, response);
        }

        public ApiFuture<FetchUsableBackupVaultsPage> createPageAsync(PageContext<FetchUsableBackupVaultsRequest, FetchUsableBackupVaultsResponse, BackupVault> context, ApiFuture<FetchUsableBackupVaultsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class FetchUsableBackupVaultsPagedResponse
    extends AbstractPagedListResponse<FetchUsableBackupVaultsRequest, FetchUsableBackupVaultsResponse, BackupVault, FetchUsableBackupVaultsPage, FetchUsableBackupVaultsFixedSizeCollection> {
        public static ApiFuture<FetchUsableBackupVaultsPagedResponse> createAsync(PageContext<FetchUsableBackupVaultsRequest, FetchUsableBackupVaultsResponse, BackupVault> context, ApiFuture<FetchUsableBackupVaultsResponse> futureResponse) {
            ApiFuture<FetchUsableBackupVaultsPage> futurePage = FetchUsableBackupVaultsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new FetchUsableBackupVaultsPagedResponse((FetchUsableBackupVaultsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private FetchUsableBackupVaultsPagedResponse(FetchUsableBackupVaultsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)FetchUsableBackupVaultsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListBackupVaultsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListBackupVaultsRequest, ListBackupVaultsResponse, BackupVault, ListBackupVaultsPage, ListBackupVaultsFixedSizeCollection> {
        private ListBackupVaultsFixedSizeCollection(List<ListBackupVaultsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListBackupVaultsFixedSizeCollection createEmptyCollection() {
            return new ListBackupVaultsFixedSizeCollection(null, 0);
        }

        protected ListBackupVaultsFixedSizeCollection createCollection(List<ListBackupVaultsPage> pages, int collectionSize) {
            return new ListBackupVaultsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListBackupVaultsPage
    extends AbstractPage<ListBackupVaultsRequest, ListBackupVaultsResponse, BackupVault, ListBackupVaultsPage> {
        private ListBackupVaultsPage(PageContext<ListBackupVaultsRequest, ListBackupVaultsResponse, BackupVault> context, ListBackupVaultsResponse response) {
            super(context, (Object)response);
        }

        private static ListBackupVaultsPage createEmptyPage() {
            return new ListBackupVaultsPage(null, null);
        }

        protected ListBackupVaultsPage createPage(PageContext<ListBackupVaultsRequest, ListBackupVaultsResponse, BackupVault> context, ListBackupVaultsResponse response) {
            return new ListBackupVaultsPage(context, response);
        }

        public ApiFuture<ListBackupVaultsPage> createPageAsync(PageContext<ListBackupVaultsRequest, ListBackupVaultsResponse, BackupVault> context, ApiFuture<ListBackupVaultsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListBackupVaultsPagedResponse
    extends AbstractPagedListResponse<ListBackupVaultsRequest, ListBackupVaultsResponse, BackupVault, ListBackupVaultsPage, ListBackupVaultsFixedSizeCollection> {
        public static ApiFuture<ListBackupVaultsPagedResponse> createAsync(PageContext<ListBackupVaultsRequest, ListBackupVaultsResponse, BackupVault> context, ApiFuture<ListBackupVaultsResponse> futureResponse) {
            ApiFuture<ListBackupVaultsPage> futurePage = ListBackupVaultsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListBackupVaultsPagedResponse((ListBackupVaultsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListBackupVaultsPagedResponse(ListBackupVaultsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListBackupVaultsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListManagementServersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListManagementServersRequest, ListManagementServersResponse, ManagementServer, ListManagementServersPage, ListManagementServersFixedSizeCollection> {
        private ListManagementServersFixedSizeCollection(List<ListManagementServersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListManagementServersFixedSizeCollection createEmptyCollection() {
            return new ListManagementServersFixedSizeCollection(null, 0);
        }

        protected ListManagementServersFixedSizeCollection createCollection(List<ListManagementServersPage> pages, int collectionSize) {
            return new ListManagementServersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListManagementServersPage
    extends AbstractPage<ListManagementServersRequest, ListManagementServersResponse, ManagementServer, ListManagementServersPage> {
        private ListManagementServersPage(PageContext<ListManagementServersRequest, ListManagementServersResponse, ManagementServer> context, ListManagementServersResponse response) {
            super(context, (Object)response);
        }

        private static ListManagementServersPage createEmptyPage() {
            return new ListManagementServersPage(null, null);
        }

        protected ListManagementServersPage createPage(PageContext<ListManagementServersRequest, ListManagementServersResponse, ManagementServer> context, ListManagementServersResponse response) {
            return new ListManagementServersPage(context, response);
        }

        public ApiFuture<ListManagementServersPage> createPageAsync(PageContext<ListManagementServersRequest, ListManagementServersResponse, ManagementServer> context, ApiFuture<ListManagementServersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListManagementServersPagedResponse
    extends AbstractPagedListResponse<ListManagementServersRequest, ListManagementServersResponse, ManagementServer, ListManagementServersPage, ListManagementServersFixedSizeCollection> {
        public static ApiFuture<ListManagementServersPagedResponse> createAsync(PageContext<ListManagementServersRequest, ListManagementServersResponse, ManagementServer> context, ApiFuture<ListManagementServersResponse> futureResponse) {
            ApiFuture<ListManagementServersPage> futurePage = ListManagementServersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListManagementServersPagedResponse((ListManagementServersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListManagementServersPagedResponse(ListManagementServersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListManagementServersFixedSizeCollection.createEmptyCollection());
        }
    }
}

