/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.assuredworkloads.v1beta1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.assuredworkloads.v1beta1.AnalyzeWorkloadMoveRequest;
import com.google.cloud.assuredworkloads.v1beta1.AnalyzeWorkloadMoveResponse;
import com.google.cloud.assuredworkloads.v1beta1.AssuredWorkloadsServiceClient;
import com.google.cloud.assuredworkloads.v1beta1.CreateWorkloadOperationMetadata;
import com.google.cloud.assuredworkloads.v1beta1.CreateWorkloadRequest;
import com.google.cloud.assuredworkloads.v1beta1.DeleteWorkloadRequest;
import com.google.cloud.assuredworkloads.v1beta1.GetWorkloadRequest;
import com.google.cloud.assuredworkloads.v1beta1.ListWorkloadsRequest;
import com.google.cloud.assuredworkloads.v1beta1.ListWorkloadsResponse;
import com.google.cloud.assuredworkloads.v1beta1.RestrictAllowedResourcesRequest;
import com.google.cloud.assuredworkloads.v1beta1.RestrictAllowedResourcesResponse;
import com.google.cloud.assuredworkloads.v1beta1.RestrictAllowedServicesRequest;
import com.google.cloud.assuredworkloads.v1beta1.RestrictAllowedServicesResponse;
import com.google.cloud.assuredworkloads.v1beta1.UpdateWorkloadRequest;
import com.google.cloud.assuredworkloads.v1beta1.Workload;
import com.google.cloud.assuredworkloads.v1beta1.stub.AssuredWorkloadsServiceStub;
import com.google.cloud.assuredworkloads.v1beta1.stub.GrpcAssuredWorkloadsServiceStub;
import com.google.cloud.assuredworkloads.v1beta1.stub.HttpJsonAssuredWorkloadsServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class AssuredWorkloadsServiceStubSettings
extends StubSettings<AssuredWorkloadsServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateWorkloadRequest, Operation> createWorkloadSettings;
    private final OperationCallSettings<CreateWorkloadRequest, Workload, CreateWorkloadOperationMetadata> createWorkloadOperationSettings;
    private final UnaryCallSettings<UpdateWorkloadRequest, Workload> updateWorkloadSettings;
    private final UnaryCallSettings<RestrictAllowedServicesRequest, RestrictAllowedServicesResponse> restrictAllowedServicesSettings;
    private final UnaryCallSettings<RestrictAllowedResourcesRequest, RestrictAllowedResourcesResponse> restrictAllowedResourcesSettings;
    private final UnaryCallSettings<DeleteWorkloadRequest, Empty> deleteWorkloadSettings;
    private final UnaryCallSettings<GetWorkloadRequest, Workload> getWorkloadSettings;
    private final UnaryCallSettings<AnalyzeWorkloadMoveRequest, AnalyzeWorkloadMoveResponse> analyzeWorkloadMoveSettings;
    private final PagedCallSettings<ListWorkloadsRequest, ListWorkloadsResponse, AssuredWorkloadsServiceClient.ListWorkloadsPagedResponse> listWorkloadsSettings;
    private static final PagedListDescriptor<ListWorkloadsRequest, ListWorkloadsResponse, Workload> LIST_WORKLOADS_PAGE_STR_DESC = new PagedListDescriptor<ListWorkloadsRequest, ListWorkloadsResponse, Workload>(){

        public String emptyToken() {
            return "";
        }

        public ListWorkloadsRequest injectToken(ListWorkloadsRequest payload, String token) {
            return ListWorkloadsRequest.newBuilder((ListWorkloadsRequest)payload).setPageToken(token).build();
        }

        public ListWorkloadsRequest injectPageSize(ListWorkloadsRequest payload, int pageSize) {
            return ListWorkloadsRequest.newBuilder((ListWorkloadsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListWorkloadsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListWorkloadsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Workload> extractResources(ListWorkloadsResponse payload) {
            return payload.getWorkloadsList() == null ? ImmutableList.of() : payload.getWorkloadsList();
        }
    };
    private static final PagedListResponseFactory<ListWorkloadsRequest, ListWorkloadsResponse, AssuredWorkloadsServiceClient.ListWorkloadsPagedResponse> LIST_WORKLOADS_PAGE_STR_FACT = new PagedListResponseFactory<ListWorkloadsRequest, ListWorkloadsResponse, AssuredWorkloadsServiceClient.ListWorkloadsPagedResponse>(){

        public ApiFuture<AssuredWorkloadsServiceClient.ListWorkloadsPagedResponse> getFuturePagedResponse(UnaryCallable<ListWorkloadsRequest, ListWorkloadsResponse> callable, ListWorkloadsRequest request, ApiCallContext context, ApiFuture<ListWorkloadsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_WORKLOADS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AssuredWorkloadsServiceClient.ListWorkloadsPagedResponse.createAsync((PageContext<ListWorkloadsRequest, ListWorkloadsResponse, Workload>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateWorkloadRequest, Operation> createWorkloadSettings() {
        return this.createWorkloadSettings;
    }

    public OperationCallSettings<CreateWorkloadRequest, Workload, CreateWorkloadOperationMetadata> createWorkloadOperationSettings() {
        return this.createWorkloadOperationSettings;
    }

    public UnaryCallSettings<UpdateWorkloadRequest, Workload> updateWorkloadSettings() {
        return this.updateWorkloadSettings;
    }

    public UnaryCallSettings<RestrictAllowedServicesRequest, RestrictAllowedServicesResponse> restrictAllowedServicesSettings() {
        return this.restrictAllowedServicesSettings;
    }

    public UnaryCallSettings<RestrictAllowedResourcesRequest, RestrictAllowedResourcesResponse> restrictAllowedResourcesSettings() {
        return this.restrictAllowedResourcesSettings;
    }

    public UnaryCallSettings<DeleteWorkloadRequest, Empty> deleteWorkloadSettings() {
        return this.deleteWorkloadSettings;
    }

    public UnaryCallSettings<GetWorkloadRequest, Workload> getWorkloadSettings() {
        return this.getWorkloadSettings;
    }

    public UnaryCallSettings<AnalyzeWorkloadMoveRequest, AnalyzeWorkloadMoveResponse> analyzeWorkloadMoveSettings() {
        return this.analyzeWorkloadMoveSettings;
    }

    public PagedCallSettings<ListWorkloadsRequest, ListWorkloadsResponse, AssuredWorkloadsServiceClient.ListWorkloadsPagedResponse> listWorkloadsSettings() {
        return this.listWorkloadsSettings;
    }

    public AssuredWorkloadsServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcAssuredWorkloadsServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonAssuredWorkloadsServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "assuredworkloads.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "assuredworkloads.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return AssuredWorkloadsServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AssuredWorkloadsServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AssuredWorkloadsServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return AssuredWorkloadsServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected AssuredWorkloadsServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createWorkloadSettings = settingsBuilder.createWorkloadSettings().build();
        this.createWorkloadOperationSettings = settingsBuilder.createWorkloadOperationSettings().build();
        this.updateWorkloadSettings = settingsBuilder.updateWorkloadSettings().build();
        this.restrictAllowedServicesSettings = settingsBuilder.restrictAllowedServicesSettings().build();
        this.restrictAllowedResourcesSettings = settingsBuilder.restrictAllowedResourcesSettings().build();
        this.deleteWorkloadSettings = settingsBuilder.deleteWorkloadSettings().build();
        this.getWorkloadSettings = settingsBuilder.getWorkloadSettings().build();
        this.analyzeWorkloadMoveSettings = settingsBuilder.analyzeWorkloadMoveSettings().build();
        this.listWorkloadsSettings = settingsBuilder.listWorkloadsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<AssuredWorkloadsServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateWorkloadRequest, Operation> createWorkloadSettings;
        private final OperationCallSettings.Builder<CreateWorkloadRequest, Workload, CreateWorkloadOperationMetadata> createWorkloadOperationSettings;
        private final UnaryCallSettings.Builder<UpdateWorkloadRequest, Workload> updateWorkloadSettings;
        private final UnaryCallSettings.Builder<RestrictAllowedServicesRequest, RestrictAllowedServicesResponse> restrictAllowedServicesSettings;
        private final UnaryCallSettings.Builder<RestrictAllowedResourcesRequest, RestrictAllowedResourcesResponse> restrictAllowedResourcesSettings;
        private final UnaryCallSettings.Builder<DeleteWorkloadRequest, Empty> deleteWorkloadSettings;
        private final UnaryCallSettings.Builder<GetWorkloadRequest, Workload> getWorkloadSettings;
        private final UnaryCallSettings.Builder<AnalyzeWorkloadMoveRequest, AnalyzeWorkloadMoveResponse> analyzeWorkloadMoveSettings;
        private final PagedCallSettings.Builder<ListWorkloadsRequest, ListWorkloadsResponse, AssuredWorkloadsServiceClient.ListWorkloadsPagedResponse> listWorkloadsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createWorkloadSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createWorkloadOperationSettings = OperationCallSettings.newBuilder();
            this.updateWorkloadSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.restrictAllowedServicesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.restrictAllowedResourcesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteWorkloadSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getWorkloadSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.analyzeWorkloadMoveSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listWorkloadsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_WORKLOADS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createWorkloadSettings, this.updateWorkloadSettings, this.restrictAllowedServicesSettings, this.restrictAllowedResourcesSettings, this.deleteWorkloadSettings, this.getWorkloadSettings, this.analyzeWorkloadMoveSettings, this.listWorkloadsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(AssuredWorkloadsServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createWorkloadSettings = settings.createWorkloadSettings.toBuilder();
            this.createWorkloadOperationSettings = settings.createWorkloadOperationSettings.toBuilder();
            this.updateWorkloadSettings = settings.updateWorkloadSettings.toBuilder();
            this.restrictAllowedServicesSettings = settings.restrictAllowedServicesSettings.toBuilder();
            this.restrictAllowedResourcesSettings = settings.restrictAllowedResourcesSettings.toBuilder();
            this.deleteWorkloadSettings = settings.deleteWorkloadSettings.toBuilder();
            this.getWorkloadSettings = settings.getWorkloadSettings.toBuilder();
            this.analyzeWorkloadMoveSettings = settings.analyzeWorkloadMoveSettings.toBuilder();
            this.listWorkloadsSettings = settings.listWorkloadsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createWorkloadSettings, this.updateWorkloadSettings, this.restrictAllowedServicesSettings, this.restrictAllowedResourcesSettings, this.deleteWorkloadSettings, this.getWorkloadSettings, this.analyzeWorkloadMoveSettings, this.listWorkloadsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(AssuredWorkloadsServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)AssuredWorkloadsServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AssuredWorkloadsServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(AssuredWorkloadsServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(AssuredWorkloadsServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)AssuredWorkloadsServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)AssuredWorkloadsServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AssuredWorkloadsServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(AssuredWorkloadsServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(AssuredWorkloadsServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createWorkloadSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.updateWorkloadSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.restrictAllowedServicesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.restrictAllowedResourcesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteWorkloadSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.getWorkloadSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.analyzeWorkloadMoveSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.listWorkloadsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.createWorkloadOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Workload.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CreateWorkloadOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateWorkloadRequest, Operation> createWorkloadSettings() {
            return this.createWorkloadSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateWorkloadRequest, Workload, CreateWorkloadOperationMetadata> createWorkloadOperationSettings() {
            return this.createWorkloadOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateWorkloadRequest, Workload> updateWorkloadSettings() {
            return this.updateWorkloadSettings;
        }

        public UnaryCallSettings.Builder<RestrictAllowedServicesRequest, RestrictAllowedServicesResponse> restrictAllowedServicesSettings() {
            return this.restrictAllowedServicesSettings;
        }

        public UnaryCallSettings.Builder<RestrictAllowedResourcesRequest, RestrictAllowedResourcesResponse> restrictAllowedResourcesSettings() {
            return this.restrictAllowedResourcesSettings;
        }

        public UnaryCallSettings.Builder<DeleteWorkloadRequest, Empty> deleteWorkloadSettings() {
            return this.deleteWorkloadSettings;
        }

        public UnaryCallSettings.Builder<GetWorkloadRequest, Workload> getWorkloadSettings() {
            return this.getWorkloadSettings;
        }

        public UnaryCallSettings.Builder<AnalyzeWorkloadMoveRequest, AnalyzeWorkloadMoveResponse> analyzeWorkloadMoveSettings() {
            return this.analyzeWorkloadMoveSettings;
        }

        public PagedCallSettings.Builder<ListWorkloadsRequest, ListWorkloadsResponse, AssuredWorkloadsServiceClient.ListWorkloadsPagedResponse> listWorkloadsSettings() {
            return this.listWorkloadsSettings;
        }

        public AssuredWorkloadsServiceStubSettings build() throws IOException {
            return new AssuredWorkloadsServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)200L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)30000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

