/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.asset.v1p7beta1.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.asset.v1p7beta1.ExportAssetsRequest;
import com.google.cloud.asset.v1p7beta1.ExportAssetsResponse;
import com.google.cloud.asset.v1p7beta1.stub.AssetServiceStub;
import com.google.cloud.asset.v1p7beta1.stub.AssetServiceStubSettings;
import com.google.cloud.asset.v1p7beta1.stub.GrpcAssetServiceCallableFactory;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcAssetServiceStub
extends AssetServiceStub {
    private static final MethodDescriptor<ExportAssetsRequest, Operation> exportAssetsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.asset.v1p7beta1.AssetService/ExportAssets").setRequestMarshaller(ProtoUtils.marshaller((Message)ExportAssetsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private final UnaryCallable<ExportAssetsRequest, Operation> exportAssetsCallable;
    private final OperationCallable<ExportAssetsRequest, ExportAssetsResponse, ExportAssetsRequest> exportAssetsOperationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcAssetServiceStub create(AssetServiceStubSettings settings) throws IOException {
        return new GrpcAssetServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcAssetServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcAssetServiceStub(AssetServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcAssetServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcAssetServiceStub(AssetServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcAssetServiceStub(AssetServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcAssetServiceCallableFactory());
    }

    protected GrpcAssetServiceStub(AssetServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings exportAssetsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(exportAssetsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        this.exportAssetsCallable = callableFactory.createUnaryCallable(exportAssetsTransportSettings, settings.exportAssetsSettings(), clientContext);
        this.exportAssetsOperationCallable = callableFactory.createOperationCallable(exportAssetsTransportSettings, settings.exportAssetsOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ExportAssetsRequest, Operation> exportAssetsCallable() {
        return this.exportAssetsCallable;
    }

    @Override
    public OperationCallable<ExportAssetsRequest, ExportAssetsResponse, ExportAssetsRequest> exportAssetsOperationCallable() {
        return this.exportAssetsOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

