/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.asset.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.asset.v1.AnalyzeIamPolicyLongrunningMetadata;
import com.google.cloud.asset.v1.AnalyzeIamPolicyLongrunningRequest;
import com.google.cloud.asset.v1.AnalyzeIamPolicyLongrunningResponse;
import com.google.cloud.asset.v1.AnalyzeIamPolicyRequest;
import com.google.cloud.asset.v1.AnalyzeIamPolicyResponse;
import com.google.cloud.asset.v1.AnalyzeMoveRequest;
import com.google.cloud.asset.v1.AnalyzeMoveResponse;
import com.google.cloud.asset.v1.AnalyzeOrgPoliciesRequest;
import com.google.cloud.asset.v1.AnalyzeOrgPoliciesResponse;
import com.google.cloud.asset.v1.AnalyzeOrgPolicyGovernedAssetsRequest;
import com.google.cloud.asset.v1.AnalyzeOrgPolicyGovernedAssetsResponse;
import com.google.cloud.asset.v1.AnalyzeOrgPolicyGovernedContainersRequest;
import com.google.cloud.asset.v1.AnalyzeOrgPolicyGovernedContainersResponse;
import com.google.cloud.asset.v1.Asset;
import com.google.cloud.asset.v1.AssetServiceClient;
import com.google.cloud.asset.v1.BatchGetAssetsHistoryRequest;
import com.google.cloud.asset.v1.BatchGetAssetsHistoryResponse;
import com.google.cloud.asset.v1.BatchGetEffectiveIamPoliciesRequest;
import com.google.cloud.asset.v1.BatchGetEffectiveIamPoliciesResponse;
import com.google.cloud.asset.v1.CreateFeedRequest;
import com.google.cloud.asset.v1.CreateSavedQueryRequest;
import com.google.cloud.asset.v1.DeleteFeedRequest;
import com.google.cloud.asset.v1.DeleteSavedQueryRequest;
import com.google.cloud.asset.v1.ExportAssetsRequest;
import com.google.cloud.asset.v1.ExportAssetsResponse;
import com.google.cloud.asset.v1.Feed;
import com.google.cloud.asset.v1.GetFeedRequest;
import com.google.cloud.asset.v1.GetSavedQueryRequest;
import com.google.cloud.asset.v1.IamPolicySearchResult;
import com.google.cloud.asset.v1.ListAssetsRequest;
import com.google.cloud.asset.v1.ListAssetsResponse;
import com.google.cloud.asset.v1.ListFeedsRequest;
import com.google.cloud.asset.v1.ListFeedsResponse;
import com.google.cloud.asset.v1.ListSavedQueriesRequest;
import com.google.cloud.asset.v1.ListSavedQueriesResponse;
import com.google.cloud.asset.v1.QueryAssetsRequest;
import com.google.cloud.asset.v1.QueryAssetsResponse;
import com.google.cloud.asset.v1.ResourceSearchResult;
import com.google.cloud.asset.v1.SavedQuery;
import com.google.cloud.asset.v1.SearchAllIamPoliciesRequest;
import com.google.cloud.asset.v1.SearchAllIamPoliciesResponse;
import com.google.cloud.asset.v1.SearchAllResourcesRequest;
import com.google.cloud.asset.v1.SearchAllResourcesResponse;
import com.google.cloud.asset.v1.UpdateFeedRequest;
import com.google.cloud.asset.v1.UpdateSavedQueryRequest;
import com.google.cloud.asset.v1.stub.AssetServiceStub;
import com.google.cloud.asset.v1.stub.GrpcAssetServiceStub;
import com.google.cloud.asset.v1.stub.HttpJsonAssetServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class AssetServiceStubSettings
extends StubSettings<AssetServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<ExportAssetsRequest, Operation> exportAssetsSettings;
    private final OperationCallSettings<ExportAssetsRequest, ExportAssetsResponse, ExportAssetsRequest> exportAssetsOperationSettings;
    private final PagedCallSettings<ListAssetsRequest, ListAssetsResponse, AssetServiceClient.ListAssetsPagedResponse> listAssetsSettings;
    private final UnaryCallSettings<BatchGetAssetsHistoryRequest, BatchGetAssetsHistoryResponse> batchGetAssetsHistorySettings;
    private final UnaryCallSettings<CreateFeedRequest, Feed> createFeedSettings;
    private final UnaryCallSettings<GetFeedRequest, Feed> getFeedSettings;
    private final UnaryCallSettings<ListFeedsRequest, ListFeedsResponse> listFeedsSettings;
    private final UnaryCallSettings<UpdateFeedRequest, Feed> updateFeedSettings;
    private final UnaryCallSettings<DeleteFeedRequest, Empty> deleteFeedSettings;
    private final PagedCallSettings<SearchAllResourcesRequest, SearchAllResourcesResponse, AssetServiceClient.SearchAllResourcesPagedResponse> searchAllResourcesSettings;
    private final PagedCallSettings<SearchAllIamPoliciesRequest, SearchAllIamPoliciesResponse, AssetServiceClient.SearchAllIamPoliciesPagedResponse> searchAllIamPoliciesSettings;
    private final UnaryCallSettings<AnalyzeIamPolicyRequest, AnalyzeIamPolicyResponse> analyzeIamPolicySettings;
    private final UnaryCallSettings<AnalyzeIamPolicyLongrunningRequest, Operation> analyzeIamPolicyLongrunningSettings;
    private final OperationCallSettings<AnalyzeIamPolicyLongrunningRequest, AnalyzeIamPolicyLongrunningResponse, AnalyzeIamPolicyLongrunningMetadata> analyzeIamPolicyLongrunningOperationSettings;
    private final UnaryCallSettings<AnalyzeMoveRequest, AnalyzeMoveResponse> analyzeMoveSettings;
    private final UnaryCallSettings<QueryAssetsRequest, QueryAssetsResponse> queryAssetsSettings;
    private final UnaryCallSettings<CreateSavedQueryRequest, SavedQuery> createSavedQuerySettings;
    private final UnaryCallSettings<GetSavedQueryRequest, SavedQuery> getSavedQuerySettings;
    private final PagedCallSettings<ListSavedQueriesRequest, ListSavedQueriesResponse, AssetServiceClient.ListSavedQueriesPagedResponse> listSavedQueriesSettings;
    private final UnaryCallSettings<UpdateSavedQueryRequest, SavedQuery> updateSavedQuerySettings;
    private final UnaryCallSettings<DeleteSavedQueryRequest, Empty> deleteSavedQuerySettings;
    private final UnaryCallSettings<BatchGetEffectiveIamPoliciesRequest, BatchGetEffectiveIamPoliciesResponse> batchGetEffectiveIamPoliciesSettings;
    private final PagedCallSettings<AnalyzeOrgPoliciesRequest, AnalyzeOrgPoliciesResponse, AssetServiceClient.AnalyzeOrgPoliciesPagedResponse> analyzeOrgPoliciesSettings;
    private final PagedCallSettings<AnalyzeOrgPolicyGovernedContainersRequest, AnalyzeOrgPolicyGovernedContainersResponse, AssetServiceClient.AnalyzeOrgPolicyGovernedContainersPagedResponse> analyzeOrgPolicyGovernedContainersSettings;
    private final PagedCallSettings<AnalyzeOrgPolicyGovernedAssetsRequest, AnalyzeOrgPolicyGovernedAssetsResponse, AssetServiceClient.AnalyzeOrgPolicyGovernedAssetsPagedResponse> analyzeOrgPolicyGovernedAssetsSettings;
    private static final PagedListDescriptor<ListAssetsRequest, ListAssetsResponse, Asset> LIST_ASSETS_PAGE_STR_DESC = new PagedListDescriptor<ListAssetsRequest, ListAssetsResponse, Asset>(){

        public String emptyToken() {
            return "";
        }

        public ListAssetsRequest injectToken(ListAssetsRequest payload, String token) {
            return ListAssetsRequest.newBuilder((ListAssetsRequest)payload).setPageToken(token).build();
        }

        public ListAssetsRequest injectPageSize(ListAssetsRequest payload, int pageSize) {
            return ListAssetsRequest.newBuilder((ListAssetsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListAssetsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListAssetsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Asset> extractResources(ListAssetsResponse payload) {
            return payload.getAssetsList() == null ? ImmutableList.of() : payload.getAssetsList();
        }
    };
    private static final PagedListDescriptor<SearchAllResourcesRequest, SearchAllResourcesResponse, ResourceSearchResult> SEARCH_ALL_RESOURCES_PAGE_STR_DESC = new PagedListDescriptor<SearchAllResourcesRequest, SearchAllResourcesResponse, ResourceSearchResult>(){

        public String emptyToken() {
            return "";
        }

        public SearchAllResourcesRequest injectToken(SearchAllResourcesRequest payload, String token) {
            return SearchAllResourcesRequest.newBuilder((SearchAllResourcesRequest)payload).setPageToken(token).build();
        }

        public SearchAllResourcesRequest injectPageSize(SearchAllResourcesRequest payload, int pageSize) {
            return SearchAllResourcesRequest.newBuilder((SearchAllResourcesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(SearchAllResourcesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(SearchAllResourcesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ResourceSearchResult> extractResources(SearchAllResourcesResponse payload) {
            return payload.getResultsList() == null ? ImmutableList.of() : payload.getResultsList();
        }
    };
    private static final PagedListDescriptor<SearchAllIamPoliciesRequest, SearchAllIamPoliciesResponse, IamPolicySearchResult> SEARCH_ALL_IAM_POLICIES_PAGE_STR_DESC = new PagedListDescriptor<SearchAllIamPoliciesRequest, SearchAllIamPoliciesResponse, IamPolicySearchResult>(){

        public String emptyToken() {
            return "";
        }

        public SearchAllIamPoliciesRequest injectToken(SearchAllIamPoliciesRequest payload, String token) {
            return SearchAllIamPoliciesRequest.newBuilder((SearchAllIamPoliciesRequest)payload).setPageToken(token).build();
        }

        public SearchAllIamPoliciesRequest injectPageSize(SearchAllIamPoliciesRequest payload, int pageSize) {
            return SearchAllIamPoliciesRequest.newBuilder((SearchAllIamPoliciesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(SearchAllIamPoliciesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(SearchAllIamPoliciesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<IamPolicySearchResult> extractResources(SearchAllIamPoliciesResponse payload) {
            return payload.getResultsList() == null ? ImmutableList.of() : payload.getResultsList();
        }
    };
    private static final PagedListDescriptor<ListSavedQueriesRequest, ListSavedQueriesResponse, SavedQuery> LIST_SAVED_QUERIES_PAGE_STR_DESC = new PagedListDescriptor<ListSavedQueriesRequest, ListSavedQueriesResponse, SavedQuery>(){

        public String emptyToken() {
            return "";
        }

        public ListSavedQueriesRequest injectToken(ListSavedQueriesRequest payload, String token) {
            return ListSavedQueriesRequest.newBuilder((ListSavedQueriesRequest)payload).setPageToken(token).build();
        }

        public ListSavedQueriesRequest injectPageSize(ListSavedQueriesRequest payload, int pageSize) {
            return ListSavedQueriesRequest.newBuilder((ListSavedQueriesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListSavedQueriesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListSavedQueriesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<SavedQuery> extractResources(ListSavedQueriesResponse payload) {
            return payload.getSavedQueriesList() == null ? ImmutableList.of() : payload.getSavedQueriesList();
        }
    };
    private static final PagedListDescriptor<AnalyzeOrgPoliciesRequest, AnalyzeOrgPoliciesResponse, AnalyzeOrgPoliciesResponse.OrgPolicyResult> ANALYZE_ORG_POLICIES_PAGE_STR_DESC = new PagedListDescriptor<AnalyzeOrgPoliciesRequest, AnalyzeOrgPoliciesResponse, AnalyzeOrgPoliciesResponse.OrgPolicyResult>(){

        public String emptyToken() {
            return "";
        }

        public AnalyzeOrgPoliciesRequest injectToken(AnalyzeOrgPoliciesRequest payload, String token) {
            return AnalyzeOrgPoliciesRequest.newBuilder((AnalyzeOrgPoliciesRequest)payload).setPageToken(token).build();
        }

        public AnalyzeOrgPoliciesRequest injectPageSize(AnalyzeOrgPoliciesRequest payload, int pageSize) {
            return AnalyzeOrgPoliciesRequest.newBuilder((AnalyzeOrgPoliciesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(AnalyzeOrgPoliciesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(AnalyzeOrgPoliciesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<AnalyzeOrgPoliciesResponse.OrgPolicyResult> extractResources(AnalyzeOrgPoliciesResponse payload) {
            return payload.getOrgPolicyResultsList() == null ? ImmutableList.of() : payload.getOrgPolicyResultsList();
        }
    };
    private static final PagedListDescriptor<AnalyzeOrgPolicyGovernedContainersRequest, AnalyzeOrgPolicyGovernedContainersResponse, AnalyzeOrgPolicyGovernedContainersResponse.GovernedContainer> ANALYZE_ORG_POLICY_GOVERNED_CONTAINERS_PAGE_STR_DESC = new PagedListDescriptor<AnalyzeOrgPolicyGovernedContainersRequest, AnalyzeOrgPolicyGovernedContainersResponse, AnalyzeOrgPolicyGovernedContainersResponse.GovernedContainer>(){

        public String emptyToken() {
            return "";
        }

        public AnalyzeOrgPolicyGovernedContainersRequest injectToken(AnalyzeOrgPolicyGovernedContainersRequest payload, String token) {
            return AnalyzeOrgPolicyGovernedContainersRequest.newBuilder((AnalyzeOrgPolicyGovernedContainersRequest)payload).setPageToken(token).build();
        }

        public AnalyzeOrgPolicyGovernedContainersRequest injectPageSize(AnalyzeOrgPolicyGovernedContainersRequest payload, int pageSize) {
            return AnalyzeOrgPolicyGovernedContainersRequest.newBuilder((AnalyzeOrgPolicyGovernedContainersRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(AnalyzeOrgPolicyGovernedContainersRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(AnalyzeOrgPolicyGovernedContainersResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<AnalyzeOrgPolicyGovernedContainersResponse.GovernedContainer> extractResources(AnalyzeOrgPolicyGovernedContainersResponse payload) {
            return payload.getGovernedContainersList() == null ? ImmutableList.of() : payload.getGovernedContainersList();
        }
    };
    private static final PagedListDescriptor<AnalyzeOrgPolicyGovernedAssetsRequest, AnalyzeOrgPolicyGovernedAssetsResponse, AnalyzeOrgPolicyGovernedAssetsResponse.GovernedAsset> ANALYZE_ORG_POLICY_GOVERNED_ASSETS_PAGE_STR_DESC = new PagedListDescriptor<AnalyzeOrgPolicyGovernedAssetsRequest, AnalyzeOrgPolicyGovernedAssetsResponse, AnalyzeOrgPolicyGovernedAssetsResponse.GovernedAsset>(){

        public String emptyToken() {
            return "";
        }

        public AnalyzeOrgPolicyGovernedAssetsRequest injectToken(AnalyzeOrgPolicyGovernedAssetsRequest payload, String token) {
            return AnalyzeOrgPolicyGovernedAssetsRequest.newBuilder((AnalyzeOrgPolicyGovernedAssetsRequest)payload).setPageToken(token).build();
        }

        public AnalyzeOrgPolicyGovernedAssetsRequest injectPageSize(AnalyzeOrgPolicyGovernedAssetsRequest payload, int pageSize) {
            return AnalyzeOrgPolicyGovernedAssetsRequest.newBuilder((AnalyzeOrgPolicyGovernedAssetsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(AnalyzeOrgPolicyGovernedAssetsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(AnalyzeOrgPolicyGovernedAssetsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<AnalyzeOrgPolicyGovernedAssetsResponse.GovernedAsset> extractResources(AnalyzeOrgPolicyGovernedAssetsResponse payload) {
            return payload.getGovernedAssetsList() == null ? ImmutableList.of() : payload.getGovernedAssetsList();
        }
    };
    private static final PagedListResponseFactory<ListAssetsRequest, ListAssetsResponse, AssetServiceClient.ListAssetsPagedResponse> LIST_ASSETS_PAGE_STR_FACT = new PagedListResponseFactory<ListAssetsRequest, ListAssetsResponse, AssetServiceClient.ListAssetsPagedResponse>(){

        public ApiFuture<AssetServiceClient.ListAssetsPagedResponse> getFuturePagedResponse(UnaryCallable<ListAssetsRequest, ListAssetsResponse> callable, ListAssetsRequest request, ApiCallContext context, ApiFuture<ListAssetsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ASSETS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AssetServiceClient.ListAssetsPagedResponse.createAsync((PageContext<ListAssetsRequest, ListAssetsResponse, Asset>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<SearchAllResourcesRequest, SearchAllResourcesResponse, AssetServiceClient.SearchAllResourcesPagedResponse> SEARCH_ALL_RESOURCES_PAGE_STR_FACT = new PagedListResponseFactory<SearchAllResourcesRequest, SearchAllResourcesResponse, AssetServiceClient.SearchAllResourcesPagedResponse>(){

        public ApiFuture<AssetServiceClient.SearchAllResourcesPagedResponse> getFuturePagedResponse(UnaryCallable<SearchAllResourcesRequest, SearchAllResourcesResponse> callable, SearchAllResourcesRequest request, ApiCallContext context, ApiFuture<SearchAllResourcesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)SEARCH_ALL_RESOURCES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AssetServiceClient.SearchAllResourcesPagedResponse.createAsync((PageContext<SearchAllResourcesRequest, SearchAllResourcesResponse, ResourceSearchResult>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<SearchAllIamPoliciesRequest, SearchAllIamPoliciesResponse, AssetServiceClient.SearchAllIamPoliciesPagedResponse> SEARCH_ALL_IAM_POLICIES_PAGE_STR_FACT = new PagedListResponseFactory<SearchAllIamPoliciesRequest, SearchAllIamPoliciesResponse, AssetServiceClient.SearchAllIamPoliciesPagedResponse>(){

        public ApiFuture<AssetServiceClient.SearchAllIamPoliciesPagedResponse> getFuturePagedResponse(UnaryCallable<SearchAllIamPoliciesRequest, SearchAllIamPoliciesResponse> callable, SearchAllIamPoliciesRequest request, ApiCallContext context, ApiFuture<SearchAllIamPoliciesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)SEARCH_ALL_IAM_POLICIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AssetServiceClient.SearchAllIamPoliciesPagedResponse.createAsync((PageContext<SearchAllIamPoliciesRequest, SearchAllIamPoliciesResponse, IamPolicySearchResult>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListSavedQueriesRequest, ListSavedQueriesResponse, AssetServiceClient.ListSavedQueriesPagedResponse> LIST_SAVED_QUERIES_PAGE_STR_FACT = new PagedListResponseFactory<ListSavedQueriesRequest, ListSavedQueriesResponse, AssetServiceClient.ListSavedQueriesPagedResponse>(){

        public ApiFuture<AssetServiceClient.ListSavedQueriesPagedResponse> getFuturePagedResponse(UnaryCallable<ListSavedQueriesRequest, ListSavedQueriesResponse> callable, ListSavedQueriesRequest request, ApiCallContext context, ApiFuture<ListSavedQueriesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SAVED_QUERIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AssetServiceClient.ListSavedQueriesPagedResponse.createAsync((PageContext<ListSavedQueriesRequest, ListSavedQueriesResponse, SavedQuery>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<AnalyzeOrgPoliciesRequest, AnalyzeOrgPoliciesResponse, AssetServiceClient.AnalyzeOrgPoliciesPagedResponse> ANALYZE_ORG_POLICIES_PAGE_STR_FACT = new PagedListResponseFactory<AnalyzeOrgPoliciesRequest, AnalyzeOrgPoliciesResponse, AssetServiceClient.AnalyzeOrgPoliciesPagedResponse>(){

        public ApiFuture<AssetServiceClient.AnalyzeOrgPoliciesPagedResponse> getFuturePagedResponse(UnaryCallable<AnalyzeOrgPoliciesRequest, AnalyzeOrgPoliciesResponse> callable, AnalyzeOrgPoliciesRequest request, ApiCallContext context, ApiFuture<AnalyzeOrgPoliciesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)ANALYZE_ORG_POLICIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AssetServiceClient.AnalyzeOrgPoliciesPagedResponse.createAsync((PageContext<AnalyzeOrgPoliciesRequest, AnalyzeOrgPoliciesResponse, AnalyzeOrgPoliciesResponse.OrgPolicyResult>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<AnalyzeOrgPolicyGovernedContainersRequest, AnalyzeOrgPolicyGovernedContainersResponse, AssetServiceClient.AnalyzeOrgPolicyGovernedContainersPagedResponse> ANALYZE_ORG_POLICY_GOVERNED_CONTAINERS_PAGE_STR_FACT = new PagedListResponseFactory<AnalyzeOrgPolicyGovernedContainersRequest, AnalyzeOrgPolicyGovernedContainersResponse, AssetServiceClient.AnalyzeOrgPolicyGovernedContainersPagedResponse>(){

        public ApiFuture<AssetServiceClient.AnalyzeOrgPolicyGovernedContainersPagedResponse> getFuturePagedResponse(UnaryCallable<AnalyzeOrgPolicyGovernedContainersRequest, AnalyzeOrgPolicyGovernedContainersResponse> callable, AnalyzeOrgPolicyGovernedContainersRequest request, ApiCallContext context, ApiFuture<AnalyzeOrgPolicyGovernedContainersResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)ANALYZE_ORG_POLICY_GOVERNED_CONTAINERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AssetServiceClient.AnalyzeOrgPolicyGovernedContainersPagedResponse.createAsync((PageContext<AnalyzeOrgPolicyGovernedContainersRequest, AnalyzeOrgPolicyGovernedContainersResponse, AnalyzeOrgPolicyGovernedContainersResponse.GovernedContainer>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<AnalyzeOrgPolicyGovernedAssetsRequest, AnalyzeOrgPolicyGovernedAssetsResponse, AssetServiceClient.AnalyzeOrgPolicyGovernedAssetsPagedResponse> ANALYZE_ORG_POLICY_GOVERNED_ASSETS_PAGE_STR_FACT = new PagedListResponseFactory<AnalyzeOrgPolicyGovernedAssetsRequest, AnalyzeOrgPolicyGovernedAssetsResponse, AssetServiceClient.AnalyzeOrgPolicyGovernedAssetsPagedResponse>(){

        public ApiFuture<AssetServiceClient.AnalyzeOrgPolicyGovernedAssetsPagedResponse> getFuturePagedResponse(UnaryCallable<AnalyzeOrgPolicyGovernedAssetsRequest, AnalyzeOrgPolicyGovernedAssetsResponse> callable, AnalyzeOrgPolicyGovernedAssetsRequest request, ApiCallContext context, ApiFuture<AnalyzeOrgPolicyGovernedAssetsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)ANALYZE_ORG_POLICY_GOVERNED_ASSETS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AssetServiceClient.AnalyzeOrgPolicyGovernedAssetsPagedResponse.createAsync((PageContext<AnalyzeOrgPolicyGovernedAssetsRequest, AnalyzeOrgPolicyGovernedAssetsResponse, AnalyzeOrgPolicyGovernedAssetsResponse.GovernedAsset>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<ExportAssetsRequest, Operation> exportAssetsSettings() {
        return this.exportAssetsSettings;
    }

    public OperationCallSettings<ExportAssetsRequest, ExportAssetsResponse, ExportAssetsRequest> exportAssetsOperationSettings() {
        return this.exportAssetsOperationSettings;
    }

    public PagedCallSettings<ListAssetsRequest, ListAssetsResponse, AssetServiceClient.ListAssetsPagedResponse> listAssetsSettings() {
        return this.listAssetsSettings;
    }

    public UnaryCallSettings<BatchGetAssetsHistoryRequest, BatchGetAssetsHistoryResponse> batchGetAssetsHistorySettings() {
        return this.batchGetAssetsHistorySettings;
    }

    public UnaryCallSettings<CreateFeedRequest, Feed> createFeedSettings() {
        return this.createFeedSettings;
    }

    public UnaryCallSettings<GetFeedRequest, Feed> getFeedSettings() {
        return this.getFeedSettings;
    }

    public UnaryCallSettings<ListFeedsRequest, ListFeedsResponse> listFeedsSettings() {
        return this.listFeedsSettings;
    }

    public UnaryCallSettings<UpdateFeedRequest, Feed> updateFeedSettings() {
        return this.updateFeedSettings;
    }

    public UnaryCallSettings<DeleteFeedRequest, Empty> deleteFeedSettings() {
        return this.deleteFeedSettings;
    }

    public PagedCallSettings<SearchAllResourcesRequest, SearchAllResourcesResponse, AssetServiceClient.SearchAllResourcesPagedResponse> searchAllResourcesSettings() {
        return this.searchAllResourcesSettings;
    }

    public PagedCallSettings<SearchAllIamPoliciesRequest, SearchAllIamPoliciesResponse, AssetServiceClient.SearchAllIamPoliciesPagedResponse> searchAllIamPoliciesSettings() {
        return this.searchAllIamPoliciesSettings;
    }

    public UnaryCallSettings<AnalyzeIamPolicyRequest, AnalyzeIamPolicyResponse> analyzeIamPolicySettings() {
        return this.analyzeIamPolicySettings;
    }

    public UnaryCallSettings<AnalyzeIamPolicyLongrunningRequest, Operation> analyzeIamPolicyLongrunningSettings() {
        return this.analyzeIamPolicyLongrunningSettings;
    }

    public OperationCallSettings<AnalyzeIamPolicyLongrunningRequest, AnalyzeIamPolicyLongrunningResponse, AnalyzeIamPolicyLongrunningMetadata> analyzeIamPolicyLongrunningOperationSettings() {
        return this.analyzeIamPolicyLongrunningOperationSettings;
    }

    public UnaryCallSettings<AnalyzeMoveRequest, AnalyzeMoveResponse> analyzeMoveSettings() {
        return this.analyzeMoveSettings;
    }

    public UnaryCallSettings<QueryAssetsRequest, QueryAssetsResponse> queryAssetsSettings() {
        return this.queryAssetsSettings;
    }

    public UnaryCallSettings<CreateSavedQueryRequest, SavedQuery> createSavedQuerySettings() {
        return this.createSavedQuerySettings;
    }

    public UnaryCallSettings<GetSavedQueryRequest, SavedQuery> getSavedQuerySettings() {
        return this.getSavedQuerySettings;
    }

    public PagedCallSettings<ListSavedQueriesRequest, ListSavedQueriesResponse, AssetServiceClient.ListSavedQueriesPagedResponse> listSavedQueriesSettings() {
        return this.listSavedQueriesSettings;
    }

    public UnaryCallSettings<UpdateSavedQueryRequest, SavedQuery> updateSavedQuerySettings() {
        return this.updateSavedQuerySettings;
    }

    public UnaryCallSettings<DeleteSavedQueryRequest, Empty> deleteSavedQuerySettings() {
        return this.deleteSavedQuerySettings;
    }

    public UnaryCallSettings<BatchGetEffectiveIamPoliciesRequest, BatchGetEffectiveIamPoliciesResponse> batchGetEffectiveIamPoliciesSettings() {
        return this.batchGetEffectiveIamPoliciesSettings;
    }

    public PagedCallSettings<AnalyzeOrgPoliciesRequest, AnalyzeOrgPoliciesResponse, AssetServiceClient.AnalyzeOrgPoliciesPagedResponse> analyzeOrgPoliciesSettings() {
        return this.analyzeOrgPoliciesSettings;
    }

    public PagedCallSettings<AnalyzeOrgPolicyGovernedContainersRequest, AnalyzeOrgPolicyGovernedContainersResponse, AssetServiceClient.AnalyzeOrgPolicyGovernedContainersPagedResponse> analyzeOrgPolicyGovernedContainersSettings() {
        return this.analyzeOrgPolicyGovernedContainersSettings;
    }

    public PagedCallSettings<AnalyzeOrgPolicyGovernedAssetsRequest, AnalyzeOrgPolicyGovernedAssetsResponse, AssetServiceClient.AnalyzeOrgPolicyGovernedAssetsPagedResponse> analyzeOrgPolicyGovernedAssetsSettings() {
        return this.analyzeOrgPolicyGovernedAssetsSettings;
    }

    public AssetServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcAssetServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonAssetServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return AssetServiceStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "cloudasset";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "cloudasset.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "cloudasset.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return AssetServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AssetServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AssetServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return AssetServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected AssetServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.exportAssetsSettings = settingsBuilder.exportAssetsSettings().build();
        this.exportAssetsOperationSettings = settingsBuilder.exportAssetsOperationSettings().build();
        this.listAssetsSettings = settingsBuilder.listAssetsSettings().build();
        this.batchGetAssetsHistorySettings = settingsBuilder.batchGetAssetsHistorySettings().build();
        this.createFeedSettings = settingsBuilder.createFeedSettings().build();
        this.getFeedSettings = settingsBuilder.getFeedSettings().build();
        this.listFeedsSettings = settingsBuilder.listFeedsSettings().build();
        this.updateFeedSettings = settingsBuilder.updateFeedSettings().build();
        this.deleteFeedSettings = settingsBuilder.deleteFeedSettings().build();
        this.searchAllResourcesSettings = settingsBuilder.searchAllResourcesSettings().build();
        this.searchAllIamPoliciesSettings = settingsBuilder.searchAllIamPoliciesSettings().build();
        this.analyzeIamPolicySettings = settingsBuilder.analyzeIamPolicySettings().build();
        this.analyzeIamPolicyLongrunningSettings = settingsBuilder.analyzeIamPolicyLongrunningSettings().build();
        this.analyzeIamPolicyLongrunningOperationSettings = settingsBuilder.analyzeIamPolicyLongrunningOperationSettings().build();
        this.analyzeMoveSettings = settingsBuilder.analyzeMoveSettings().build();
        this.queryAssetsSettings = settingsBuilder.queryAssetsSettings().build();
        this.createSavedQuerySettings = settingsBuilder.createSavedQuerySettings().build();
        this.getSavedQuerySettings = settingsBuilder.getSavedQuerySettings().build();
        this.listSavedQueriesSettings = settingsBuilder.listSavedQueriesSettings().build();
        this.updateSavedQuerySettings = settingsBuilder.updateSavedQuerySettings().build();
        this.deleteSavedQuerySettings = settingsBuilder.deleteSavedQuerySettings().build();
        this.batchGetEffectiveIamPoliciesSettings = settingsBuilder.batchGetEffectiveIamPoliciesSettings().build();
        this.analyzeOrgPoliciesSettings = settingsBuilder.analyzeOrgPoliciesSettings().build();
        this.analyzeOrgPolicyGovernedContainersSettings = settingsBuilder.analyzeOrgPolicyGovernedContainersSettings().build();
        this.analyzeOrgPolicyGovernedAssetsSettings = settingsBuilder.analyzeOrgPolicyGovernedAssetsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<AssetServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<ExportAssetsRequest, Operation> exportAssetsSettings;
        private final OperationCallSettings.Builder<ExportAssetsRequest, ExportAssetsResponse, ExportAssetsRequest> exportAssetsOperationSettings;
        private final PagedCallSettings.Builder<ListAssetsRequest, ListAssetsResponse, AssetServiceClient.ListAssetsPagedResponse> listAssetsSettings;
        private final UnaryCallSettings.Builder<BatchGetAssetsHistoryRequest, BatchGetAssetsHistoryResponse> batchGetAssetsHistorySettings;
        private final UnaryCallSettings.Builder<CreateFeedRequest, Feed> createFeedSettings;
        private final UnaryCallSettings.Builder<GetFeedRequest, Feed> getFeedSettings;
        private final UnaryCallSettings.Builder<ListFeedsRequest, ListFeedsResponse> listFeedsSettings;
        private final UnaryCallSettings.Builder<UpdateFeedRequest, Feed> updateFeedSettings;
        private final UnaryCallSettings.Builder<DeleteFeedRequest, Empty> deleteFeedSettings;
        private final PagedCallSettings.Builder<SearchAllResourcesRequest, SearchAllResourcesResponse, AssetServiceClient.SearchAllResourcesPagedResponse> searchAllResourcesSettings;
        private final PagedCallSettings.Builder<SearchAllIamPoliciesRequest, SearchAllIamPoliciesResponse, AssetServiceClient.SearchAllIamPoliciesPagedResponse> searchAllIamPoliciesSettings;
        private final UnaryCallSettings.Builder<AnalyzeIamPolicyRequest, AnalyzeIamPolicyResponse> analyzeIamPolicySettings;
        private final UnaryCallSettings.Builder<AnalyzeIamPolicyLongrunningRequest, Operation> analyzeIamPolicyLongrunningSettings;
        private final OperationCallSettings.Builder<AnalyzeIamPolicyLongrunningRequest, AnalyzeIamPolicyLongrunningResponse, AnalyzeIamPolicyLongrunningMetadata> analyzeIamPolicyLongrunningOperationSettings;
        private final UnaryCallSettings.Builder<AnalyzeMoveRequest, AnalyzeMoveResponse> analyzeMoveSettings;
        private final UnaryCallSettings.Builder<QueryAssetsRequest, QueryAssetsResponse> queryAssetsSettings;
        private final UnaryCallSettings.Builder<CreateSavedQueryRequest, SavedQuery> createSavedQuerySettings;
        private final UnaryCallSettings.Builder<GetSavedQueryRequest, SavedQuery> getSavedQuerySettings;
        private final PagedCallSettings.Builder<ListSavedQueriesRequest, ListSavedQueriesResponse, AssetServiceClient.ListSavedQueriesPagedResponse> listSavedQueriesSettings;
        private final UnaryCallSettings.Builder<UpdateSavedQueryRequest, SavedQuery> updateSavedQuerySettings;
        private final UnaryCallSettings.Builder<DeleteSavedQueryRequest, Empty> deleteSavedQuerySettings;
        private final UnaryCallSettings.Builder<BatchGetEffectiveIamPoliciesRequest, BatchGetEffectiveIamPoliciesResponse> batchGetEffectiveIamPoliciesSettings;
        private final PagedCallSettings.Builder<AnalyzeOrgPoliciesRequest, AnalyzeOrgPoliciesResponse, AssetServiceClient.AnalyzeOrgPoliciesPagedResponse> analyzeOrgPoliciesSettings;
        private final PagedCallSettings.Builder<AnalyzeOrgPolicyGovernedContainersRequest, AnalyzeOrgPolicyGovernedContainersResponse, AssetServiceClient.AnalyzeOrgPolicyGovernedContainersPagedResponse> analyzeOrgPolicyGovernedContainersSettings;
        private final PagedCallSettings.Builder<AnalyzeOrgPolicyGovernedAssetsRequest, AnalyzeOrgPolicyGovernedAssetsResponse, AssetServiceClient.AnalyzeOrgPolicyGovernedAssetsPagedResponse> analyzeOrgPolicyGovernedAssetsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.exportAssetsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.exportAssetsOperationSettings = OperationCallSettings.newBuilder();
            this.listAssetsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ASSETS_PAGE_STR_FACT);
            this.batchGetAssetsHistorySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createFeedSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getFeedSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listFeedsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateFeedSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteFeedSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.searchAllResourcesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)SEARCH_ALL_RESOURCES_PAGE_STR_FACT);
            this.searchAllIamPoliciesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)SEARCH_ALL_IAM_POLICIES_PAGE_STR_FACT);
            this.analyzeIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.analyzeIamPolicyLongrunningSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.analyzeIamPolicyLongrunningOperationSettings = OperationCallSettings.newBuilder();
            this.analyzeMoveSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.queryAssetsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createSavedQuerySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getSavedQuerySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSavedQueriesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SAVED_QUERIES_PAGE_STR_FACT);
            this.updateSavedQuerySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteSavedQuerySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchGetEffectiveIamPoliciesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.analyzeOrgPoliciesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)ANALYZE_ORG_POLICIES_PAGE_STR_FACT);
            this.analyzeOrgPolicyGovernedContainersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)ANALYZE_ORG_POLICY_GOVERNED_CONTAINERS_PAGE_STR_FACT);
            this.analyzeOrgPolicyGovernedAssetsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)ANALYZE_ORG_POLICY_GOVERNED_ASSETS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.exportAssetsSettings, this.listAssetsSettings, this.batchGetAssetsHistorySettings, this.createFeedSettings, this.getFeedSettings, this.listFeedsSettings, this.updateFeedSettings, this.deleteFeedSettings, this.searchAllResourcesSettings, this.searchAllIamPoliciesSettings, this.analyzeIamPolicySettings, this.analyzeIamPolicyLongrunningSettings, (Object[])new UnaryCallSettings.Builder[]{this.analyzeMoveSettings, this.queryAssetsSettings, this.createSavedQuerySettings, this.getSavedQuerySettings, this.listSavedQueriesSettings, this.updateSavedQuerySettings, this.deleteSavedQuerySettings, this.batchGetEffectiveIamPoliciesSettings, this.analyzeOrgPoliciesSettings, this.analyzeOrgPolicyGovernedContainersSettings, this.analyzeOrgPolicyGovernedAssetsSettings});
            Builder.initDefaults(this);
        }

        protected Builder(AssetServiceStubSettings settings) {
            super((StubSettings)settings);
            this.exportAssetsSettings = settings.exportAssetsSettings.toBuilder();
            this.exportAssetsOperationSettings = settings.exportAssetsOperationSettings.toBuilder();
            this.listAssetsSettings = settings.listAssetsSettings.toBuilder();
            this.batchGetAssetsHistorySettings = settings.batchGetAssetsHistorySettings.toBuilder();
            this.createFeedSettings = settings.createFeedSettings.toBuilder();
            this.getFeedSettings = settings.getFeedSettings.toBuilder();
            this.listFeedsSettings = settings.listFeedsSettings.toBuilder();
            this.updateFeedSettings = settings.updateFeedSettings.toBuilder();
            this.deleteFeedSettings = settings.deleteFeedSettings.toBuilder();
            this.searchAllResourcesSettings = settings.searchAllResourcesSettings.toBuilder();
            this.searchAllIamPoliciesSettings = settings.searchAllIamPoliciesSettings.toBuilder();
            this.analyzeIamPolicySettings = settings.analyzeIamPolicySettings.toBuilder();
            this.analyzeIamPolicyLongrunningSettings = settings.analyzeIamPolicyLongrunningSettings.toBuilder();
            this.analyzeIamPolicyLongrunningOperationSettings = settings.analyzeIamPolicyLongrunningOperationSettings.toBuilder();
            this.analyzeMoveSettings = settings.analyzeMoveSettings.toBuilder();
            this.queryAssetsSettings = settings.queryAssetsSettings.toBuilder();
            this.createSavedQuerySettings = settings.createSavedQuerySettings.toBuilder();
            this.getSavedQuerySettings = settings.getSavedQuerySettings.toBuilder();
            this.listSavedQueriesSettings = settings.listSavedQueriesSettings.toBuilder();
            this.updateSavedQuerySettings = settings.updateSavedQuerySettings.toBuilder();
            this.deleteSavedQuerySettings = settings.deleteSavedQuerySettings.toBuilder();
            this.batchGetEffectiveIamPoliciesSettings = settings.batchGetEffectiveIamPoliciesSettings.toBuilder();
            this.analyzeOrgPoliciesSettings = settings.analyzeOrgPoliciesSettings.toBuilder();
            this.analyzeOrgPolicyGovernedContainersSettings = settings.analyzeOrgPolicyGovernedContainersSettings.toBuilder();
            this.analyzeOrgPolicyGovernedAssetsSettings = settings.analyzeOrgPolicyGovernedAssetsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.exportAssetsSettings, this.listAssetsSettings, this.batchGetAssetsHistorySettings, this.createFeedSettings, this.getFeedSettings, this.listFeedsSettings, this.updateFeedSettings, this.deleteFeedSettings, this.searchAllResourcesSettings, this.searchAllIamPoliciesSettings, this.analyzeIamPolicySettings, this.analyzeIamPolicyLongrunningSettings, (Object[])new UnaryCallSettings.Builder[]{this.analyzeMoveSettings, this.queryAssetsSettings, this.createSavedQuerySettings, this.getSavedQuerySettings, this.listSavedQueriesSettings, this.updateSavedQuerySettings, this.deleteSavedQuerySettings, this.batchGetEffectiveIamPoliciesSettings, this.analyzeOrgPoliciesSettings, this.analyzeOrgPolicyGovernedContainersSettings, this.analyzeOrgPolicyGovernedAssetsSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(AssetServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)AssetServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AssetServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(AssetServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)AssetServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)AssetServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AssetServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(AssetServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.exportAssetsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.listAssetsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.batchGetAssetsHistorySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.createFeedSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getFeedSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.listFeedsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.updateFeedSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.deleteFeedSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.searchAllResourcesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params"));
            builder.searchAllIamPoliciesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params"));
            builder.analyzeIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_3_params"));
            builder.analyzeIamPolicyLongrunningSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.analyzeMoveSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.queryAssetsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_4_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_4_params"));
            builder.createSavedQuerySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getSavedQuerySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.listSavedQueriesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.updateSavedQuerySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.deleteSavedQuerySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.batchGetEffectiveIamPoliciesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_6_params"));
            builder.analyzeOrgPoliciesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.analyzeOrgPolicyGovernedContainersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.analyzeOrgPolicyGovernedAssetsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.exportAssetsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ExportAssetsResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(ExportAssetsRequest.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.analyzeIamPolicyLongrunningOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(AnalyzeIamPolicyLongrunningResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(AnalyzeIamPolicyLongrunningMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<ExportAssetsRequest, Operation> exportAssetsSettings() {
            return this.exportAssetsSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<ExportAssetsRequest, ExportAssetsResponse, ExportAssetsRequest> exportAssetsOperationSettings() {
            return this.exportAssetsOperationSettings;
        }

        public PagedCallSettings.Builder<ListAssetsRequest, ListAssetsResponse, AssetServiceClient.ListAssetsPagedResponse> listAssetsSettings() {
            return this.listAssetsSettings;
        }

        public UnaryCallSettings.Builder<BatchGetAssetsHistoryRequest, BatchGetAssetsHistoryResponse> batchGetAssetsHistorySettings() {
            return this.batchGetAssetsHistorySettings;
        }

        public UnaryCallSettings.Builder<CreateFeedRequest, Feed> createFeedSettings() {
            return this.createFeedSettings;
        }

        public UnaryCallSettings.Builder<GetFeedRequest, Feed> getFeedSettings() {
            return this.getFeedSettings;
        }

        public UnaryCallSettings.Builder<ListFeedsRequest, ListFeedsResponse> listFeedsSettings() {
            return this.listFeedsSettings;
        }

        public UnaryCallSettings.Builder<UpdateFeedRequest, Feed> updateFeedSettings() {
            return this.updateFeedSettings;
        }

        public UnaryCallSettings.Builder<DeleteFeedRequest, Empty> deleteFeedSettings() {
            return this.deleteFeedSettings;
        }

        public PagedCallSettings.Builder<SearchAllResourcesRequest, SearchAllResourcesResponse, AssetServiceClient.SearchAllResourcesPagedResponse> searchAllResourcesSettings() {
            return this.searchAllResourcesSettings;
        }

        public PagedCallSettings.Builder<SearchAllIamPoliciesRequest, SearchAllIamPoliciesResponse, AssetServiceClient.SearchAllIamPoliciesPagedResponse> searchAllIamPoliciesSettings() {
            return this.searchAllIamPoliciesSettings;
        }

        public UnaryCallSettings.Builder<AnalyzeIamPolicyRequest, AnalyzeIamPolicyResponse> analyzeIamPolicySettings() {
            return this.analyzeIamPolicySettings;
        }

        public UnaryCallSettings.Builder<AnalyzeIamPolicyLongrunningRequest, Operation> analyzeIamPolicyLongrunningSettings() {
            return this.analyzeIamPolicyLongrunningSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<AnalyzeIamPolicyLongrunningRequest, AnalyzeIamPolicyLongrunningResponse, AnalyzeIamPolicyLongrunningMetadata> analyzeIamPolicyLongrunningOperationSettings() {
            return this.analyzeIamPolicyLongrunningOperationSettings;
        }

        public UnaryCallSettings.Builder<AnalyzeMoveRequest, AnalyzeMoveResponse> analyzeMoveSettings() {
            return this.analyzeMoveSettings;
        }

        public UnaryCallSettings.Builder<QueryAssetsRequest, QueryAssetsResponse> queryAssetsSettings() {
            return this.queryAssetsSettings;
        }

        public UnaryCallSettings.Builder<CreateSavedQueryRequest, SavedQuery> createSavedQuerySettings() {
            return this.createSavedQuerySettings;
        }

        public UnaryCallSettings.Builder<GetSavedQueryRequest, SavedQuery> getSavedQuerySettings() {
            return this.getSavedQuerySettings;
        }

        public PagedCallSettings.Builder<ListSavedQueriesRequest, ListSavedQueriesResponse, AssetServiceClient.ListSavedQueriesPagedResponse> listSavedQueriesSettings() {
            return this.listSavedQueriesSettings;
        }

        public UnaryCallSettings.Builder<UpdateSavedQueryRequest, SavedQuery> updateSavedQuerySettings() {
            return this.updateSavedQuerySettings;
        }

        public UnaryCallSettings.Builder<DeleteSavedQueryRequest, Empty> deleteSavedQuerySettings() {
            return this.deleteSavedQuerySettings;
        }

        public UnaryCallSettings.Builder<BatchGetEffectiveIamPoliciesRequest, BatchGetEffectiveIamPoliciesResponse> batchGetEffectiveIamPoliciesSettings() {
            return this.batchGetEffectiveIamPoliciesSettings;
        }

        public PagedCallSettings.Builder<AnalyzeOrgPoliciesRequest, AnalyzeOrgPoliciesResponse, AssetServiceClient.AnalyzeOrgPoliciesPagedResponse> analyzeOrgPoliciesSettings() {
            return this.analyzeOrgPoliciesSettings;
        }

        public PagedCallSettings.Builder<AnalyzeOrgPolicyGovernedContainersRequest, AnalyzeOrgPolicyGovernedContainersResponse, AssetServiceClient.AnalyzeOrgPolicyGovernedContainersPagedResponse> analyzeOrgPolicyGovernedContainersSettings() {
            return this.analyzeOrgPolicyGovernedContainersSettings;
        }

        public PagedCallSettings.Builder<AnalyzeOrgPolicyGovernedAssetsRequest, AnalyzeOrgPolicyGovernedAssetsResponse, AssetServiceClient.AnalyzeOrgPolicyGovernedAssetsPagedResponse> analyzeOrgPolicyGovernedAssetsSettings() {
            return this.analyzeOrgPolicyGovernedAssetsSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return AssetServiceStubSettings.getDefaultEndpoint();
        }

        public AssetServiceStubSettings build() throws IOException {
            return new AssetServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"retry_policy_2_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"retry_policy_3_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_4_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"retry_policy_6_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)30000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)30000L)).setTotalTimeout(Duration.ofMillis((long)30000L)).build();
            definitions.put((Object)"retry_policy_2_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)300000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)300000L)).setTotalTimeout(Duration.ofMillis((long)300000L)).build();
            definitions.put((Object)"retry_policy_3_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)200000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)200000L)).setTotalTimeout(Duration.ofMillis((long)200000L)).build();
            definitions.put((Object)"retry_policy_4_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)300000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)300000L)).setTotalTimeout(Duration.ofMillis((long)300000L)).build();
            definitions.put((Object)"retry_policy_6_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

