/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.asset.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.asset.v1.AnalyzeIamPolicyLongrunningRequest;
import com.google.cloud.asset.v1.AnalyzeIamPolicyLongrunningResponse;
import com.google.cloud.asset.v1.AnalyzeIamPolicyRequest;
import com.google.cloud.asset.v1.AnalyzeIamPolicyResponse;
import com.google.cloud.asset.v1.AssetServiceSettings;
import com.google.cloud.asset.v1.BatchGetAssetsHistoryRequest;
import com.google.cloud.asset.v1.BatchGetAssetsHistoryResponse;
import com.google.cloud.asset.v1.CreateFeedRequest;
import com.google.cloud.asset.v1.DeleteFeedRequest;
import com.google.cloud.asset.v1.ExportAssetsRequest;
import com.google.cloud.asset.v1.ExportAssetsResponse;
import com.google.cloud.asset.v1.Feed;
import com.google.cloud.asset.v1.FeedName;
import com.google.cloud.asset.v1.GetFeedRequest;
import com.google.cloud.asset.v1.IamPolicySearchResult;
import com.google.cloud.asset.v1.ListFeedsRequest;
import com.google.cloud.asset.v1.ListFeedsResponse;
import com.google.cloud.asset.v1.ResourceSearchResult;
import com.google.cloud.asset.v1.SearchAllIamPoliciesRequest;
import com.google.cloud.asset.v1.SearchAllIamPoliciesResponse;
import com.google.cloud.asset.v1.SearchAllResourcesRequest;
import com.google.cloud.asset.v1.SearchAllResourcesResponse;
import com.google.cloud.asset.v1.UpdateFeedRequest;
import com.google.cloud.asset.v1.stub.AssetServiceStub;
import com.google.cloud.asset.v1.stub.AssetServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class AssetServiceClient
implements BackgroundResource {
    private final AssetServiceSettings settings;
    private final AssetServiceStub stub;
    private final OperationsClient operationsClient;

    public static final AssetServiceClient create() throws IOException {
        return AssetServiceClient.create(AssetServiceSettings.newBuilder().build());
    }

    public static final AssetServiceClient create(AssetServiceSettings settings) throws IOException {
        return new AssetServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final AssetServiceClient create(AssetServiceStub stub) {
        return new AssetServiceClient(stub);
    }

    protected AssetServiceClient(AssetServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AssetServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected AssetServiceClient(AssetServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final AssetServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public AssetServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final OperationFuture<ExportAssetsResponse, ExportAssetsRequest> exportAssetsAsync(ExportAssetsRequest request) {
        return this.exportAssetsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ExportAssetsRequest, ExportAssetsResponse, ExportAssetsRequest> exportAssetsOperationCallable() {
        return this.stub.exportAssetsOperationCallable();
    }

    public final UnaryCallable<ExportAssetsRequest, Operation> exportAssetsCallable() {
        return this.stub.exportAssetsCallable();
    }

    public final BatchGetAssetsHistoryResponse batchGetAssetsHistory(BatchGetAssetsHistoryRequest request) {
        return (BatchGetAssetsHistoryResponse)this.batchGetAssetsHistoryCallable().call((Object)request);
    }

    public final UnaryCallable<BatchGetAssetsHistoryRequest, BatchGetAssetsHistoryResponse> batchGetAssetsHistoryCallable() {
        return this.stub.batchGetAssetsHistoryCallable();
    }

    public final Feed createFeed(String parent) {
        CreateFeedRequest request = CreateFeedRequest.newBuilder().setParent(parent).build();
        return this.createFeed(request);
    }

    public final Feed createFeed(CreateFeedRequest request) {
        return (Feed)this.createFeedCallable().call((Object)request);
    }

    public final UnaryCallable<CreateFeedRequest, Feed> createFeedCallable() {
        return this.stub.createFeedCallable();
    }

    public final Feed getFeed(FeedName name) {
        GetFeedRequest request = GetFeedRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getFeed(request);
    }

    public final Feed getFeed(String name) {
        GetFeedRequest request = GetFeedRequest.newBuilder().setName(name).build();
        return this.getFeed(request);
    }

    public final Feed getFeed(GetFeedRequest request) {
        return (Feed)this.getFeedCallable().call((Object)request);
    }

    public final UnaryCallable<GetFeedRequest, Feed> getFeedCallable() {
        return this.stub.getFeedCallable();
    }

    public final ListFeedsResponse listFeeds(String parent) {
        ListFeedsRequest request = ListFeedsRequest.newBuilder().setParent(parent).build();
        return this.listFeeds(request);
    }

    public final ListFeedsResponse listFeeds(ListFeedsRequest request) {
        return (ListFeedsResponse)this.listFeedsCallable().call((Object)request);
    }

    public final UnaryCallable<ListFeedsRequest, ListFeedsResponse> listFeedsCallable() {
        return this.stub.listFeedsCallable();
    }

    public final Feed updateFeed(Feed feed) {
        UpdateFeedRequest request = UpdateFeedRequest.newBuilder().setFeed(feed).build();
        return this.updateFeed(request);
    }

    public final Feed updateFeed(UpdateFeedRequest request) {
        return (Feed)this.updateFeedCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateFeedRequest, Feed> updateFeedCallable() {
        return this.stub.updateFeedCallable();
    }

    public final void deleteFeed(FeedName name) {
        DeleteFeedRequest request = DeleteFeedRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteFeed(request);
    }

    public final void deleteFeed(String name) {
        DeleteFeedRequest request = DeleteFeedRequest.newBuilder().setName(name).build();
        this.deleteFeed(request);
    }

    public final void deleteFeed(DeleteFeedRequest request) {
        this.deleteFeedCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteFeedRequest, Empty> deleteFeedCallable() {
        return this.stub.deleteFeedCallable();
    }

    public final SearchAllResourcesPagedResponse searchAllResources(String scope, String query, List<String> assetTypes) {
        SearchAllResourcesRequest request = SearchAllResourcesRequest.newBuilder().setScope(scope).setQuery(query).addAllAssetTypes(assetTypes).build();
        return this.searchAllResources(request);
    }

    public final SearchAllResourcesPagedResponse searchAllResources(SearchAllResourcesRequest request) {
        return (SearchAllResourcesPagedResponse)((Object)this.searchAllResourcesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<SearchAllResourcesRequest, SearchAllResourcesPagedResponse> searchAllResourcesPagedCallable() {
        return this.stub.searchAllResourcesPagedCallable();
    }

    public final UnaryCallable<SearchAllResourcesRequest, SearchAllResourcesResponse> searchAllResourcesCallable() {
        return this.stub.searchAllResourcesCallable();
    }

    public final SearchAllIamPoliciesPagedResponse searchAllIamPolicies(String scope, String query) {
        SearchAllIamPoliciesRequest request = SearchAllIamPoliciesRequest.newBuilder().setScope(scope).setQuery(query).build();
        return this.searchAllIamPolicies(request);
    }

    public final SearchAllIamPoliciesPagedResponse searchAllIamPolicies(SearchAllIamPoliciesRequest request) {
        return (SearchAllIamPoliciesPagedResponse)((Object)this.searchAllIamPoliciesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<SearchAllIamPoliciesRequest, SearchAllIamPoliciesPagedResponse> searchAllIamPoliciesPagedCallable() {
        return this.stub.searchAllIamPoliciesPagedCallable();
    }

    public final UnaryCallable<SearchAllIamPoliciesRequest, SearchAllIamPoliciesResponse> searchAllIamPoliciesCallable() {
        return this.stub.searchAllIamPoliciesCallable();
    }

    public final AnalyzeIamPolicyResponse analyzeIamPolicy(AnalyzeIamPolicyRequest request) {
        return (AnalyzeIamPolicyResponse)this.analyzeIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<AnalyzeIamPolicyRequest, AnalyzeIamPolicyResponse> analyzeIamPolicyCallable() {
        return this.stub.analyzeIamPolicyCallable();
    }

    public final OperationFuture<AnalyzeIamPolicyLongrunningResponse, AnalyzeIamPolicyLongrunningRequest> analyzeIamPolicyLongrunningAsync(AnalyzeIamPolicyLongrunningRequest request) {
        return this.analyzeIamPolicyLongrunningOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<AnalyzeIamPolicyLongrunningRequest, AnalyzeIamPolicyLongrunningResponse, AnalyzeIamPolicyLongrunningRequest> analyzeIamPolicyLongrunningOperationCallable() {
        return this.stub.analyzeIamPolicyLongrunningOperationCallable();
    }

    public final UnaryCallable<AnalyzeIamPolicyLongrunningRequest, Operation> analyzeIamPolicyLongrunningCallable() {
        return this.stub.analyzeIamPolicyLongrunningCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class SearchAllIamPoliciesFixedSizeCollection
    extends AbstractFixedSizeCollection<SearchAllIamPoliciesRequest, SearchAllIamPoliciesResponse, IamPolicySearchResult, SearchAllIamPoliciesPage, SearchAllIamPoliciesFixedSizeCollection> {
        private SearchAllIamPoliciesFixedSizeCollection(List<SearchAllIamPoliciesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static SearchAllIamPoliciesFixedSizeCollection createEmptyCollection() {
            return new SearchAllIamPoliciesFixedSizeCollection(null, 0);
        }

        protected SearchAllIamPoliciesFixedSizeCollection createCollection(List<SearchAllIamPoliciesPage> pages, int collectionSize) {
            return new SearchAllIamPoliciesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class SearchAllIamPoliciesPage
    extends AbstractPage<SearchAllIamPoliciesRequest, SearchAllIamPoliciesResponse, IamPolicySearchResult, SearchAllIamPoliciesPage> {
        private SearchAllIamPoliciesPage(PageContext<SearchAllIamPoliciesRequest, SearchAllIamPoliciesResponse, IamPolicySearchResult> context, SearchAllIamPoliciesResponse response) {
            super(context, (Object)response);
        }

        private static SearchAllIamPoliciesPage createEmptyPage() {
            return new SearchAllIamPoliciesPage(null, null);
        }

        protected SearchAllIamPoliciesPage createPage(PageContext<SearchAllIamPoliciesRequest, SearchAllIamPoliciesResponse, IamPolicySearchResult> context, SearchAllIamPoliciesResponse response) {
            return new SearchAllIamPoliciesPage(context, response);
        }

        public ApiFuture<SearchAllIamPoliciesPage> createPageAsync(PageContext<SearchAllIamPoliciesRequest, SearchAllIamPoliciesResponse, IamPolicySearchResult> context, ApiFuture<SearchAllIamPoliciesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class SearchAllIamPoliciesPagedResponse
    extends AbstractPagedListResponse<SearchAllIamPoliciesRequest, SearchAllIamPoliciesResponse, IamPolicySearchResult, SearchAllIamPoliciesPage, SearchAllIamPoliciesFixedSizeCollection> {
        public static ApiFuture<SearchAllIamPoliciesPagedResponse> createAsync(PageContext<SearchAllIamPoliciesRequest, SearchAllIamPoliciesResponse, IamPolicySearchResult> context, ApiFuture<SearchAllIamPoliciesResponse> futureResponse) {
            ApiFuture<SearchAllIamPoliciesPage> futurePage = SearchAllIamPoliciesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<SearchAllIamPoliciesPage, SearchAllIamPoliciesPagedResponse>(){

                public SearchAllIamPoliciesPagedResponse apply(SearchAllIamPoliciesPage input) {
                    return new SearchAllIamPoliciesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private SearchAllIamPoliciesPagedResponse(SearchAllIamPoliciesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)SearchAllIamPoliciesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class SearchAllResourcesFixedSizeCollection
    extends AbstractFixedSizeCollection<SearchAllResourcesRequest, SearchAllResourcesResponse, ResourceSearchResult, SearchAllResourcesPage, SearchAllResourcesFixedSizeCollection> {
        private SearchAllResourcesFixedSizeCollection(List<SearchAllResourcesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static SearchAllResourcesFixedSizeCollection createEmptyCollection() {
            return new SearchAllResourcesFixedSizeCollection(null, 0);
        }

        protected SearchAllResourcesFixedSizeCollection createCollection(List<SearchAllResourcesPage> pages, int collectionSize) {
            return new SearchAllResourcesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class SearchAllResourcesPage
    extends AbstractPage<SearchAllResourcesRequest, SearchAllResourcesResponse, ResourceSearchResult, SearchAllResourcesPage> {
        private SearchAllResourcesPage(PageContext<SearchAllResourcesRequest, SearchAllResourcesResponse, ResourceSearchResult> context, SearchAllResourcesResponse response) {
            super(context, (Object)response);
        }

        private static SearchAllResourcesPage createEmptyPage() {
            return new SearchAllResourcesPage(null, null);
        }

        protected SearchAllResourcesPage createPage(PageContext<SearchAllResourcesRequest, SearchAllResourcesResponse, ResourceSearchResult> context, SearchAllResourcesResponse response) {
            return new SearchAllResourcesPage(context, response);
        }

        public ApiFuture<SearchAllResourcesPage> createPageAsync(PageContext<SearchAllResourcesRequest, SearchAllResourcesResponse, ResourceSearchResult> context, ApiFuture<SearchAllResourcesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class SearchAllResourcesPagedResponse
    extends AbstractPagedListResponse<SearchAllResourcesRequest, SearchAllResourcesResponse, ResourceSearchResult, SearchAllResourcesPage, SearchAllResourcesFixedSizeCollection> {
        public static ApiFuture<SearchAllResourcesPagedResponse> createAsync(PageContext<SearchAllResourcesRequest, SearchAllResourcesResponse, ResourceSearchResult> context, ApiFuture<SearchAllResourcesResponse> futureResponse) {
            ApiFuture<SearchAllResourcesPage> futurePage = SearchAllResourcesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<SearchAllResourcesPage, SearchAllResourcesPagedResponse>(){

                public SearchAllResourcesPagedResponse apply(SearchAllResourcesPage input) {
                    return new SearchAllResourcesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private SearchAllResourcesPagedResponse(SearchAllResourcesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)SearchAllResourcesFixedSizeCollection.createEmptyCollection());
        }
    }
}

