/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.asset.v1p2beta1;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.asset.v1p2beta1.AssetServiceSettings;
import com.google.cloud.asset.v1p2beta1.CreateFeedRequest;
import com.google.cloud.asset.v1p2beta1.DeleteFeedRequest;
import com.google.cloud.asset.v1p2beta1.Feed;
import com.google.cloud.asset.v1p2beta1.FeedName;
import com.google.cloud.asset.v1p2beta1.GetFeedRequest;
import com.google.cloud.asset.v1p2beta1.ListFeedsRequest;
import com.google.cloud.asset.v1p2beta1.ListFeedsResponse;
import com.google.cloud.asset.v1p2beta1.UpdateFeedRequest;
import com.google.cloud.asset.v1p2beta1.stub.AssetServiceStub;
import com.google.cloud.asset.v1p2beta1.stub.AssetServiceStubSettings;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class AssetServiceClient
implements BackgroundResource {
    private final AssetServiceSettings settings;
    private final AssetServiceStub stub;

    public static final AssetServiceClient create() throws IOException {
        return AssetServiceClient.create(AssetServiceSettings.newBuilder().build());
    }

    public static final AssetServiceClient create(AssetServiceSettings settings) throws IOException {
        return new AssetServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final AssetServiceClient create(AssetServiceStub stub) {
        return new AssetServiceClient(stub);
    }

    protected AssetServiceClient(AssetServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AssetServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected AssetServiceClient(AssetServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final AssetServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public AssetServiceStub getStub() {
        return this.stub;
    }

    public final void deleteFeed(FeedName name) {
        DeleteFeedRequest request = DeleteFeedRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteFeed(request);
    }

    public final void deleteFeed(String name) {
        DeleteFeedRequest request = DeleteFeedRequest.newBuilder().setName(name).build();
        this.deleteFeed(request);
    }

    public final void deleteFeed(DeleteFeedRequest request) {
        this.deleteFeedCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteFeedRequest, Empty> deleteFeedCallable() {
        return this.stub.deleteFeedCallable();
    }

    public final Feed createFeed(String parent) {
        CreateFeedRequest request = CreateFeedRequest.newBuilder().setParent(parent).build();
        return this.createFeed(request);
    }

    public final Feed createFeed(CreateFeedRequest request) {
        return (Feed)this.createFeedCallable().call((Object)request);
    }

    public final UnaryCallable<CreateFeedRequest, Feed> createFeedCallable() {
        return this.stub.createFeedCallable();
    }

    public final Feed getFeed(FeedName name) {
        GetFeedRequest request = GetFeedRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getFeed(request);
    }

    public final Feed getFeed(String name) {
        GetFeedRequest request = GetFeedRequest.newBuilder().setName(name).build();
        return this.getFeed(request);
    }

    public final Feed getFeed(GetFeedRequest request) {
        return (Feed)this.getFeedCallable().call((Object)request);
    }

    public final UnaryCallable<GetFeedRequest, Feed> getFeedCallable() {
        return this.stub.getFeedCallable();
    }

    public final ListFeedsResponse listFeeds(String parent) {
        ListFeedsRequest request = ListFeedsRequest.newBuilder().setParent(parent).build();
        return this.listFeeds(request);
    }

    public final ListFeedsResponse listFeeds(ListFeedsRequest request) {
        return (ListFeedsResponse)this.listFeedsCallable().call((Object)request);
    }

    public final UnaryCallable<ListFeedsRequest, ListFeedsResponse> listFeedsCallable() {
        return this.stub.listFeedsCallable();
    }

    public final Feed updateFeed(Feed feed) {
        UpdateFeedRequest request = UpdateFeedRequest.newBuilder().setFeed(feed).build();
        return this.updateFeed(request);
    }

    public final Feed updateFeed(UpdateFeedRequest request) {
        return (Feed)this.updateFeedCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateFeedRequest, Feed> updateFeedCallable() {
        return this.stub.updateFeedCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

