/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.asset.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.asset.v1.AssetServiceSettings;
import com.google.cloud.asset.v1.BatchGetAssetsHistoryRequest;
import com.google.cloud.asset.v1.BatchGetAssetsHistoryResponse;
import com.google.cloud.asset.v1.CreateFeedRequest;
import com.google.cloud.asset.v1.DeleteFeedRequest;
import com.google.cloud.asset.v1.ExportAssetsRequest;
import com.google.cloud.asset.v1.ExportAssetsResponse;
import com.google.cloud.asset.v1.Feed;
import com.google.cloud.asset.v1.GetFeedRequest;
import com.google.cloud.asset.v1.ListFeedsRequest;
import com.google.cloud.asset.v1.ListFeedsResponse;
import com.google.cloud.asset.v1.UpdateFeedRequest;
import com.google.cloud.asset.v1.stub.AssetServiceStub;
import com.google.cloud.asset.v1.stub.AssetServiceStubSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class AssetServiceClient
implements BackgroundResource {
    private final AssetServiceSettings settings;
    private final AssetServiceStub stub;
    private final OperationsClient operationsClient;

    public static final AssetServiceClient create() throws IOException {
        return AssetServiceClient.create(AssetServiceSettings.newBuilder().build());
    }

    public static final AssetServiceClient create(AssetServiceSettings settings) throws IOException {
        return new AssetServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final AssetServiceClient create(AssetServiceStub stub) {
        return new AssetServiceClient(stub);
    }

    protected AssetServiceClient(AssetServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AssetServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected AssetServiceClient(AssetServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final AssetServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public AssetServiceStub getStub() {
        return this.stub;
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<ExportAssetsResponse, ExportAssetsRequest> exportAssetsAsync(ExportAssetsRequest request) {
        return this.exportAssetsOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<ExportAssetsRequest, ExportAssetsResponse, ExportAssetsRequest> exportAssetsOperationCallable() {
        return this.stub.exportAssetsOperationCallable();
    }

    public final UnaryCallable<ExportAssetsRequest, Operation> exportAssetsCallable() {
        return this.stub.exportAssetsCallable();
    }

    public final BatchGetAssetsHistoryResponse batchGetAssetsHistory(BatchGetAssetsHistoryRequest request) {
        return (BatchGetAssetsHistoryResponse)this.batchGetAssetsHistoryCallable().call((Object)request);
    }

    public final UnaryCallable<BatchGetAssetsHistoryRequest, BatchGetAssetsHistoryResponse> batchGetAssetsHistoryCallable() {
        return this.stub.batchGetAssetsHistoryCallable();
    }

    public final Feed createFeed(String parent) {
        CreateFeedRequest request = CreateFeedRequest.newBuilder().setParent(parent).build();
        return this.createFeed(request);
    }

    public final Feed createFeed(CreateFeedRequest request) {
        return (Feed)this.createFeedCallable().call((Object)request);
    }

    public final UnaryCallable<CreateFeedRequest, Feed> createFeedCallable() {
        return this.stub.createFeedCallable();
    }

    public final Feed getFeed(String name) {
        GetFeedRequest request = GetFeedRequest.newBuilder().setName(name).build();
        return this.getFeed(request);
    }

    public final Feed getFeed(GetFeedRequest request) {
        return (Feed)this.getFeedCallable().call((Object)request);
    }

    public final UnaryCallable<GetFeedRequest, Feed> getFeedCallable() {
        return this.stub.getFeedCallable();
    }

    public final ListFeedsResponse listFeeds(String parent) {
        ListFeedsRequest request = ListFeedsRequest.newBuilder().setParent(parent).build();
        return this.listFeeds(request);
    }

    public final ListFeedsResponse listFeeds(ListFeedsRequest request) {
        return (ListFeedsResponse)this.listFeedsCallable().call((Object)request);
    }

    public final UnaryCallable<ListFeedsRequest, ListFeedsResponse> listFeedsCallable() {
        return this.stub.listFeedsCallable();
    }

    public final Feed updateFeed(Feed feed) {
        UpdateFeedRequest request = UpdateFeedRequest.newBuilder().setFeed(feed).build();
        return this.updateFeed(request);
    }

    public final Feed updateFeed(UpdateFeedRequest request) {
        return (Feed)this.updateFeedCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateFeedRequest, Feed> updateFeedCallable() {
        return this.stub.updateFeedCallable();
    }

    public final void deleteFeed(String name) {
        DeleteFeedRequest request = DeleteFeedRequest.newBuilder().setName(name).build();
        this.deleteFeed(request);
    }

    public final void deleteFeed(DeleteFeedRequest request) {
        this.deleteFeedCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteFeedRequest, Empty> deleteFeedCallable() {
        return this.stub.deleteFeedCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

