/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.artifactregistry.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableMap;
import com.google.devtools.artifactregistry.v1.ArtifactRegistryClient;
import com.google.devtools.artifactregistry.v1.GetRepositoryRequest;
import com.google.devtools.artifactregistry.v1.ListDockerImagesRequest;
import com.google.devtools.artifactregistry.v1.ListDockerImagesResponse;
import com.google.devtools.artifactregistry.v1.ListRepositoriesRequest;
import com.google.devtools.artifactregistry.v1.ListRepositoriesResponse;
import com.google.devtools.artifactregistry.v1.Repository;
import com.google.devtools.artifactregistry.v1.stub.ArtifactRegistryStub;
import com.google.devtools.artifactregistry.v1.stub.ArtifactRegistryStubSettings;
import com.google.devtools.artifactregistry.v1.stub.GrpcArtifactRegistryCallableFactory;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcArtifactRegistryStub
extends ArtifactRegistryStub {
    private static final MethodDescriptor<ListDockerImagesRequest, ListDockerImagesResponse> listDockerImagesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.devtools.artifactregistry.v1.ArtifactRegistry/ListDockerImages").setRequestMarshaller(ProtoUtils.marshaller((Message)ListDockerImagesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListDockerImagesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ListRepositoriesRequest, ListRepositoriesResponse> listRepositoriesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.devtools.artifactregistry.v1.ArtifactRegistry/ListRepositories").setRequestMarshaller(ProtoUtils.marshaller((Message)ListRepositoriesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListRepositoriesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetRepositoryRequest, Repository> getRepositoryMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.devtools.artifactregistry.v1.ArtifactRegistry/GetRepository").setRequestMarshaller(ProtoUtils.marshaller((Message)GetRepositoryRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Repository.getDefaultInstance())).build();
    private final UnaryCallable<ListDockerImagesRequest, ListDockerImagesResponse> listDockerImagesCallable;
    private final UnaryCallable<ListDockerImagesRequest, ArtifactRegistryClient.ListDockerImagesPagedResponse> listDockerImagesPagedCallable;
    private final UnaryCallable<ListRepositoriesRequest, ListRepositoriesResponse> listRepositoriesCallable;
    private final UnaryCallable<ListRepositoriesRequest, ArtifactRegistryClient.ListRepositoriesPagedResponse> listRepositoriesPagedCallable;
    private final UnaryCallable<GetRepositoryRequest, Repository> getRepositoryCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcArtifactRegistryStub create(ArtifactRegistryStubSettings settings) throws IOException {
        return new GrpcArtifactRegistryStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcArtifactRegistryStub create(ClientContext clientContext) throws IOException {
        return new GrpcArtifactRegistryStub(ArtifactRegistryStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcArtifactRegistryStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcArtifactRegistryStub(ArtifactRegistryStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcArtifactRegistryStub(ArtifactRegistryStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcArtifactRegistryCallableFactory());
    }

    protected GrpcArtifactRegistryStub(ArtifactRegistryStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listDockerImagesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listDockerImagesMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings listRepositoriesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listRepositoriesMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings getRepositoryTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getRepositoryMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        this.listDockerImagesCallable = callableFactory.createUnaryCallable(listDockerImagesTransportSettings, settings.listDockerImagesSettings(), clientContext);
        this.listDockerImagesPagedCallable = callableFactory.createPagedCallable(listDockerImagesTransportSettings, settings.listDockerImagesSettings(), clientContext);
        this.listRepositoriesCallable = callableFactory.createUnaryCallable(listRepositoriesTransportSettings, settings.listRepositoriesSettings(), clientContext);
        this.listRepositoriesPagedCallable = callableFactory.createPagedCallable(listRepositoriesTransportSettings, settings.listRepositoriesSettings(), clientContext);
        this.getRepositoryCallable = callableFactory.createUnaryCallable(getRepositoryTransportSettings, settings.getRepositorySettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListDockerImagesRequest, ListDockerImagesResponse> listDockerImagesCallable() {
        return this.listDockerImagesCallable;
    }

    @Override
    public UnaryCallable<ListDockerImagesRequest, ArtifactRegistryClient.ListDockerImagesPagedResponse> listDockerImagesPagedCallable() {
        return this.listDockerImagesPagedCallable;
    }

    @Override
    public UnaryCallable<ListRepositoriesRequest, ListRepositoriesResponse> listRepositoriesCallable() {
        return this.listRepositoriesCallable;
    }

    @Override
    public UnaryCallable<ListRepositoriesRequest, ArtifactRegistryClient.ListRepositoriesPagedResponse> listRepositoriesPagedCallable() {
        return this.listRepositoriesPagedCallable;
    }

    @Override
    public UnaryCallable<GetRepositoryRequest, Repository> getRepositoryCallable() {
        return this.getRepositoryCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

