/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.artifactregistry.v1beta2.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.devtools.artifactregistry.v1beta2.ArtifactRegistryClient;
import com.google.devtools.artifactregistry.v1beta2.CreateRepositoryRequest;
import com.google.devtools.artifactregistry.v1beta2.CreateTagRequest;
import com.google.devtools.artifactregistry.v1beta2.DeletePackageRequest;
import com.google.devtools.artifactregistry.v1beta2.DeleteRepositoryRequest;
import com.google.devtools.artifactregistry.v1beta2.DeleteTagRequest;
import com.google.devtools.artifactregistry.v1beta2.DeleteVersionRequest;
import com.google.devtools.artifactregistry.v1beta2.File;
import com.google.devtools.artifactregistry.v1beta2.GetFileRequest;
import com.google.devtools.artifactregistry.v1beta2.GetPackageRequest;
import com.google.devtools.artifactregistry.v1beta2.GetRepositoryRequest;
import com.google.devtools.artifactregistry.v1beta2.GetTagRequest;
import com.google.devtools.artifactregistry.v1beta2.GetVersionRequest;
import com.google.devtools.artifactregistry.v1beta2.ListFilesRequest;
import com.google.devtools.artifactregistry.v1beta2.ListFilesResponse;
import com.google.devtools.artifactregistry.v1beta2.ListPackagesRequest;
import com.google.devtools.artifactregistry.v1beta2.ListPackagesResponse;
import com.google.devtools.artifactregistry.v1beta2.ListRepositoriesRequest;
import com.google.devtools.artifactregistry.v1beta2.ListRepositoriesResponse;
import com.google.devtools.artifactregistry.v1beta2.ListTagsRequest;
import com.google.devtools.artifactregistry.v1beta2.ListTagsResponse;
import com.google.devtools.artifactregistry.v1beta2.ListVersionsRequest;
import com.google.devtools.artifactregistry.v1beta2.ListVersionsResponse;
import com.google.devtools.artifactregistry.v1beta2.OperationMetadata;
import com.google.devtools.artifactregistry.v1beta2.Package;
import com.google.devtools.artifactregistry.v1beta2.Repository;
import com.google.devtools.artifactregistry.v1beta2.Tag;
import com.google.devtools.artifactregistry.v1beta2.UpdateRepositoryRequest;
import com.google.devtools.artifactregistry.v1beta2.UpdateTagRequest;
import com.google.devtools.artifactregistry.v1beta2.Version;
import com.google.devtools.artifactregistry.v1beta2.stub.ArtifactRegistryStub;
import com.google.devtools.artifactregistry.v1beta2.stub.GrpcArtifactRegistryStub;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class ArtifactRegistryStubSettings
extends StubSettings<ArtifactRegistryStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/cloud-platform.read-only").build();
    private final PagedCallSettings<ListRepositoriesRequest, ListRepositoriesResponse, ArtifactRegistryClient.ListRepositoriesPagedResponse> listRepositoriesSettings;
    private final UnaryCallSettings<GetRepositoryRequest, Repository> getRepositorySettings;
    private final UnaryCallSettings<CreateRepositoryRequest, Operation> createRepositorySettings;
    private final OperationCallSettings<CreateRepositoryRequest, Repository, OperationMetadata> createRepositoryOperationSettings;
    private final UnaryCallSettings<UpdateRepositoryRequest, Repository> updateRepositorySettings;
    private final UnaryCallSettings<DeleteRepositoryRequest, Operation> deleteRepositorySettings;
    private final OperationCallSettings<DeleteRepositoryRequest, Empty, OperationMetadata> deleteRepositoryOperationSettings;
    private final PagedCallSettings<ListPackagesRequest, ListPackagesResponse, ArtifactRegistryClient.ListPackagesPagedResponse> listPackagesSettings;
    private final UnaryCallSettings<GetPackageRequest, Package> getPackageSettings;
    private final UnaryCallSettings<DeletePackageRequest, Operation> deletePackageSettings;
    private final OperationCallSettings<DeletePackageRequest, Empty, OperationMetadata> deletePackageOperationSettings;
    private final PagedCallSettings<ListVersionsRequest, ListVersionsResponse, ArtifactRegistryClient.ListVersionsPagedResponse> listVersionsSettings;
    private final UnaryCallSettings<GetVersionRequest, Version> getVersionSettings;
    private final UnaryCallSettings<DeleteVersionRequest, Operation> deleteVersionSettings;
    private final OperationCallSettings<DeleteVersionRequest, Empty, OperationMetadata> deleteVersionOperationSettings;
    private final PagedCallSettings<ListFilesRequest, ListFilesResponse, ArtifactRegistryClient.ListFilesPagedResponse> listFilesSettings;
    private final UnaryCallSettings<GetFileRequest, File> getFileSettings;
    private final PagedCallSettings<ListTagsRequest, ListTagsResponse, ArtifactRegistryClient.ListTagsPagedResponse> listTagsSettings;
    private final UnaryCallSettings<GetTagRequest, Tag> getTagSettings;
    private final UnaryCallSettings<CreateTagRequest, Tag> createTagSettings;
    private final UnaryCallSettings<UpdateTagRequest, Tag> updateTagSettings;
    private final UnaryCallSettings<DeleteTagRequest, Empty> deleteTagSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListRepositoriesRequest, ListRepositoriesResponse, Repository> LIST_REPOSITORIES_PAGE_STR_DESC = new PagedListDescriptor<ListRepositoriesRequest, ListRepositoriesResponse, Repository>(){

        public String emptyToken() {
            return "";
        }

        public ListRepositoriesRequest injectToken(ListRepositoriesRequest payload, String token) {
            return ListRepositoriesRequest.newBuilder((ListRepositoriesRequest)payload).setPageToken(token).build();
        }

        public ListRepositoriesRequest injectPageSize(ListRepositoriesRequest payload, int pageSize) {
            return ListRepositoriesRequest.newBuilder((ListRepositoriesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListRepositoriesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListRepositoriesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Repository> extractResources(ListRepositoriesResponse payload) {
            return payload.getRepositoriesList() == null ? ImmutableList.of() : payload.getRepositoriesList();
        }
    };
    private static final PagedListDescriptor<ListPackagesRequest, ListPackagesResponse, Package> LIST_PACKAGES_PAGE_STR_DESC = new PagedListDescriptor<ListPackagesRequest, ListPackagesResponse, Package>(){

        public String emptyToken() {
            return "";
        }

        public ListPackagesRequest injectToken(ListPackagesRequest payload, String token) {
            return ListPackagesRequest.newBuilder((ListPackagesRequest)payload).setPageToken(token).build();
        }

        public ListPackagesRequest injectPageSize(ListPackagesRequest payload, int pageSize) {
            return ListPackagesRequest.newBuilder((ListPackagesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListPackagesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListPackagesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Package> extractResources(ListPackagesResponse payload) {
            return payload.getPackagesList() == null ? ImmutableList.of() : payload.getPackagesList();
        }
    };
    private static final PagedListDescriptor<ListVersionsRequest, ListVersionsResponse, Version> LIST_VERSIONS_PAGE_STR_DESC = new PagedListDescriptor<ListVersionsRequest, ListVersionsResponse, Version>(){

        public String emptyToken() {
            return "";
        }

        public ListVersionsRequest injectToken(ListVersionsRequest payload, String token) {
            return ListVersionsRequest.newBuilder((ListVersionsRequest)payload).setPageToken(token).build();
        }

        public ListVersionsRequest injectPageSize(ListVersionsRequest payload, int pageSize) {
            return ListVersionsRequest.newBuilder((ListVersionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListVersionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListVersionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Version> extractResources(ListVersionsResponse payload) {
            return payload.getVersionsList() == null ? ImmutableList.of() : payload.getVersionsList();
        }
    };
    private static final PagedListDescriptor<ListFilesRequest, ListFilesResponse, File> LIST_FILES_PAGE_STR_DESC = new PagedListDescriptor<ListFilesRequest, ListFilesResponse, File>(){

        public String emptyToken() {
            return "";
        }

        public ListFilesRequest injectToken(ListFilesRequest payload, String token) {
            return ListFilesRequest.newBuilder((ListFilesRequest)payload).setPageToken(token).build();
        }

        public ListFilesRequest injectPageSize(ListFilesRequest payload, int pageSize) {
            return ListFilesRequest.newBuilder((ListFilesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListFilesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListFilesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<File> extractResources(ListFilesResponse payload) {
            return payload.getFilesList() == null ? ImmutableList.of() : payload.getFilesList();
        }
    };
    private static final PagedListDescriptor<ListTagsRequest, ListTagsResponse, Tag> LIST_TAGS_PAGE_STR_DESC = new PagedListDescriptor<ListTagsRequest, ListTagsResponse, Tag>(){

        public String emptyToken() {
            return "";
        }

        public ListTagsRequest injectToken(ListTagsRequest payload, String token) {
            return ListTagsRequest.newBuilder((ListTagsRequest)payload).setPageToken(token).build();
        }

        public ListTagsRequest injectPageSize(ListTagsRequest payload, int pageSize) {
            return ListTagsRequest.newBuilder((ListTagsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListTagsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListTagsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Tag> extractResources(ListTagsResponse payload) {
            return payload.getTagsList() == null ? ImmutableList.of() : payload.getTagsList();
        }
    };
    private static final PagedListResponseFactory<ListRepositoriesRequest, ListRepositoriesResponse, ArtifactRegistryClient.ListRepositoriesPagedResponse> LIST_REPOSITORIES_PAGE_STR_FACT = new PagedListResponseFactory<ListRepositoriesRequest, ListRepositoriesResponse, ArtifactRegistryClient.ListRepositoriesPagedResponse>(){

        public ApiFuture<ArtifactRegistryClient.ListRepositoriesPagedResponse> getFuturePagedResponse(UnaryCallable<ListRepositoriesRequest, ListRepositoriesResponse> callable, ListRepositoriesRequest request, ApiCallContext context, ApiFuture<ListRepositoriesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_REPOSITORIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ArtifactRegistryClient.ListRepositoriesPagedResponse.createAsync((PageContext<ListRepositoriesRequest, ListRepositoriesResponse, Repository>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListPackagesRequest, ListPackagesResponse, ArtifactRegistryClient.ListPackagesPagedResponse> LIST_PACKAGES_PAGE_STR_FACT = new PagedListResponseFactory<ListPackagesRequest, ListPackagesResponse, ArtifactRegistryClient.ListPackagesPagedResponse>(){

        public ApiFuture<ArtifactRegistryClient.ListPackagesPagedResponse> getFuturePagedResponse(UnaryCallable<ListPackagesRequest, ListPackagesResponse> callable, ListPackagesRequest request, ApiCallContext context, ApiFuture<ListPackagesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PACKAGES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ArtifactRegistryClient.ListPackagesPagedResponse.createAsync((PageContext<ListPackagesRequest, ListPackagesResponse, Package>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListVersionsRequest, ListVersionsResponse, ArtifactRegistryClient.ListVersionsPagedResponse> LIST_VERSIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListVersionsRequest, ListVersionsResponse, ArtifactRegistryClient.ListVersionsPagedResponse>(){

        public ApiFuture<ArtifactRegistryClient.ListVersionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListVersionsRequest, ListVersionsResponse> callable, ListVersionsRequest request, ApiCallContext context, ApiFuture<ListVersionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_VERSIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ArtifactRegistryClient.ListVersionsPagedResponse.createAsync((PageContext<ListVersionsRequest, ListVersionsResponse, Version>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListFilesRequest, ListFilesResponse, ArtifactRegistryClient.ListFilesPagedResponse> LIST_FILES_PAGE_STR_FACT = new PagedListResponseFactory<ListFilesRequest, ListFilesResponse, ArtifactRegistryClient.ListFilesPagedResponse>(){

        public ApiFuture<ArtifactRegistryClient.ListFilesPagedResponse> getFuturePagedResponse(UnaryCallable<ListFilesRequest, ListFilesResponse> callable, ListFilesRequest request, ApiCallContext context, ApiFuture<ListFilesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_FILES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ArtifactRegistryClient.ListFilesPagedResponse.createAsync((PageContext<ListFilesRequest, ListFilesResponse, File>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListTagsRequest, ListTagsResponse, ArtifactRegistryClient.ListTagsPagedResponse> LIST_TAGS_PAGE_STR_FACT = new PagedListResponseFactory<ListTagsRequest, ListTagsResponse, ArtifactRegistryClient.ListTagsPagedResponse>(){

        public ApiFuture<ArtifactRegistryClient.ListTagsPagedResponse> getFuturePagedResponse(UnaryCallable<ListTagsRequest, ListTagsResponse> callable, ListTagsRequest request, ApiCallContext context, ApiFuture<ListTagsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TAGS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ArtifactRegistryClient.ListTagsPagedResponse.createAsync((PageContext<ListTagsRequest, ListTagsResponse, Tag>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListRepositoriesRequest, ListRepositoriesResponse, ArtifactRegistryClient.ListRepositoriesPagedResponse> listRepositoriesSettings() {
        return this.listRepositoriesSettings;
    }

    public UnaryCallSettings<GetRepositoryRequest, Repository> getRepositorySettings() {
        return this.getRepositorySettings;
    }

    public UnaryCallSettings<CreateRepositoryRequest, Operation> createRepositorySettings() {
        return this.createRepositorySettings;
    }

    public OperationCallSettings<CreateRepositoryRequest, Repository, OperationMetadata> createRepositoryOperationSettings() {
        return this.createRepositoryOperationSettings;
    }

    public UnaryCallSettings<UpdateRepositoryRequest, Repository> updateRepositorySettings() {
        return this.updateRepositorySettings;
    }

    public UnaryCallSettings<DeleteRepositoryRequest, Operation> deleteRepositorySettings() {
        return this.deleteRepositorySettings;
    }

    public OperationCallSettings<DeleteRepositoryRequest, Empty, OperationMetadata> deleteRepositoryOperationSettings() {
        return this.deleteRepositoryOperationSettings;
    }

    public PagedCallSettings<ListPackagesRequest, ListPackagesResponse, ArtifactRegistryClient.ListPackagesPagedResponse> listPackagesSettings() {
        return this.listPackagesSettings;
    }

    public UnaryCallSettings<GetPackageRequest, Package> getPackageSettings() {
        return this.getPackageSettings;
    }

    public UnaryCallSettings<DeletePackageRequest, Operation> deletePackageSettings() {
        return this.deletePackageSettings;
    }

    public OperationCallSettings<DeletePackageRequest, Empty, OperationMetadata> deletePackageOperationSettings() {
        return this.deletePackageOperationSettings;
    }

    public PagedCallSettings<ListVersionsRequest, ListVersionsResponse, ArtifactRegistryClient.ListVersionsPagedResponse> listVersionsSettings() {
        return this.listVersionsSettings;
    }

    public UnaryCallSettings<GetVersionRequest, Version> getVersionSettings() {
        return this.getVersionSettings;
    }

    public UnaryCallSettings<DeleteVersionRequest, Operation> deleteVersionSettings() {
        return this.deleteVersionSettings;
    }

    public OperationCallSettings<DeleteVersionRequest, Empty, OperationMetadata> deleteVersionOperationSettings() {
        return this.deleteVersionOperationSettings;
    }

    public PagedCallSettings<ListFilesRequest, ListFilesResponse, ArtifactRegistryClient.ListFilesPagedResponse> listFilesSettings() {
        return this.listFilesSettings;
    }

    public UnaryCallSettings<GetFileRequest, File> getFileSettings() {
        return this.getFileSettings;
    }

    public PagedCallSettings<ListTagsRequest, ListTagsResponse, ArtifactRegistryClient.ListTagsPagedResponse> listTagsSettings() {
        return this.listTagsSettings;
    }

    public UnaryCallSettings<GetTagRequest, Tag> getTagSettings() {
        return this.getTagSettings;
    }

    public UnaryCallSettings<CreateTagRequest, Tag> createTagSettings() {
        return this.createTagSettings;
    }

    public UnaryCallSettings<UpdateTagRequest, Tag> updateTagSettings() {
        return this.updateTagSettings;
    }

    public UnaryCallSettings<DeleteTagRequest, Empty> deleteTagSettings() {
        return this.deleteTagSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ArtifactRegistryStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcArtifactRegistryStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "artifactregistry.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "artifactregistry.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ArtifactRegistryStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ArtifactRegistryStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ArtifactRegistryStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listRepositoriesSettings = settingsBuilder.listRepositoriesSettings().build();
        this.getRepositorySettings = settingsBuilder.getRepositorySettings().build();
        this.createRepositorySettings = settingsBuilder.createRepositorySettings().build();
        this.createRepositoryOperationSettings = settingsBuilder.createRepositoryOperationSettings().build();
        this.updateRepositorySettings = settingsBuilder.updateRepositorySettings().build();
        this.deleteRepositorySettings = settingsBuilder.deleteRepositorySettings().build();
        this.deleteRepositoryOperationSettings = settingsBuilder.deleteRepositoryOperationSettings().build();
        this.listPackagesSettings = settingsBuilder.listPackagesSettings().build();
        this.getPackageSettings = settingsBuilder.getPackageSettings().build();
        this.deletePackageSettings = settingsBuilder.deletePackageSettings().build();
        this.deletePackageOperationSettings = settingsBuilder.deletePackageOperationSettings().build();
        this.listVersionsSettings = settingsBuilder.listVersionsSettings().build();
        this.getVersionSettings = settingsBuilder.getVersionSettings().build();
        this.deleteVersionSettings = settingsBuilder.deleteVersionSettings().build();
        this.deleteVersionOperationSettings = settingsBuilder.deleteVersionOperationSettings().build();
        this.listFilesSettings = settingsBuilder.listFilesSettings().build();
        this.getFileSettings = settingsBuilder.getFileSettings().build();
        this.listTagsSettings = settingsBuilder.listTagsSettings().build();
        this.getTagSettings = settingsBuilder.getTagSettings().build();
        this.createTagSettings = settingsBuilder.createTagSettings().build();
        this.updateTagSettings = settingsBuilder.updateTagSettings().build();
        this.deleteTagSettings = settingsBuilder.deleteTagSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ArtifactRegistryStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListRepositoriesRequest, ListRepositoriesResponse, ArtifactRegistryClient.ListRepositoriesPagedResponse> listRepositoriesSettings;
        private final UnaryCallSettings.Builder<GetRepositoryRequest, Repository> getRepositorySettings;
        private final UnaryCallSettings.Builder<CreateRepositoryRequest, Operation> createRepositorySettings;
        private final OperationCallSettings.Builder<CreateRepositoryRequest, Repository, OperationMetadata> createRepositoryOperationSettings;
        private final UnaryCallSettings.Builder<UpdateRepositoryRequest, Repository> updateRepositorySettings;
        private final UnaryCallSettings.Builder<DeleteRepositoryRequest, Operation> deleteRepositorySettings;
        private final OperationCallSettings.Builder<DeleteRepositoryRequest, Empty, OperationMetadata> deleteRepositoryOperationSettings;
        private final PagedCallSettings.Builder<ListPackagesRequest, ListPackagesResponse, ArtifactRegistryClient.ListPackagesPagedResponse> listPackagesSettings;
        private final UnaryCallSettings.Builder<GetPackageRequest, Package> getPackageSettings;
        private final UnaryCallSettings.Builder<DeletePackageRequest, Operation> deletePackageSettings;
        private final OperationCallSettings.Builder<DeletePackageRequest, Empty, OperationMetadata> deletePackageOperationSettings;
        private final PagedCallSettings.Builder<ListVersionsRequest, ListVersionsResponse, ArtifactRegistryClient.ListVersionsPagedResponse> listVersionsSettings;
        private final UnaryCallSettings.Builder<GetVersionRequest, Version> getVersionSettings;
        private final UnaryCallSettings.Builder<DeleteVersionRequest, Operation> deleteVersionSettings;
        private final OperationCallSettings.Builder<DeleteVersionRequest, Empty, OperationMetadata> deleteVersionOperationSettings;
        private final PagedCallSettings.Builder<ListFilesRequest, ListFilesResponse, ArtifactRegistryClient.ListFilesPagedResponse> listFilesSettings;
        private final UnaryCallSettings.Builder<GetFileRequest, File> getFileSettings;
        private final PagedCallSettings.Builder<ListTagsRequest, ListTagsResponse, ArtifactRegistryClient.ListTagsPagedResponse> listTagsSettings;
        private final UnaryCallSettings.Builder<GetTagRequest, Tag> getTagSettings;
        private final UnaryCallSettings.Builder<CreateTagRequest, Tag> createTagSettings;
        private final UnaryCallSettings.Builder<UpdateTagRequest, Tag> updateTagSettings;
        private final UnaryCallSettings.Builder<DeleteTagRequest, Empty> deleteTagSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listRepositoriesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_REPOSITORIES_PAGE_STR_FACT);
            this.getRepositorySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createRepositorySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createRepositoryOperationSettings = OperationCallSettings.newBuilder();
            this.updateRepositorySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteRepositorySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteRepositoryOperationSettings = OperationCallSettings.newBuilder();
            this.listPackagesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PACKAGES_PAGE_STR_FACT);
            this.getPackageSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deletePackageSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deletePackageOperationSettings = OperationCallSettings.newBuilder();
            this.listVersionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_VERSIONS_PAGE_STR_FACT);
            this.getVersionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteVersionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteVersionOperationSettings = OperationCallSettings.newBuilder();
            this.listFilesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_FILES_PAGE_STR_FACT);
            this.getFileSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listTagsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TAGS_PAGE_STR_FACT);
            this.getTagSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createTagSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateTagSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteTagSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listRepositoriesSettings, this.getRepositorySettings, this.createRepositorySettings, this.updateRepositorySettings, this.deleteRepositorySettings, this.listPackagesSettings, this.getPackageSettings, this.deletePackageSettings, this.listVersionsSettings, this.getVersionSettings, this.deleteVersionSettings, this.listFilesSettings, (Object[])new UnaryCallSettings.Builder[]{this.getFileSettings, this.listTagsSettings, this.getTagSettings, this.createTagSettings, this.updateTagSettings, this.deleteTagSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
            Builder.initDefaults(this);
        }

        protected Builder(ArtifactRegistryStubSettings settings) {
            super((StubSettings)settings);
            this.listRepositoriesSettings = settings.listRepositoriesSettings.toBuilder();
            this.getRepositorySettings = settings.getRepositorySettings.toBuilder();
            this.createRepositorySettings = settings.createRepositorySettings.toBuilder();
            this.createRepositoryOperationSettings = settings.createRepositoryOperationSettings.toBuilder();
            this.updateRepositorySettings = settings.updateRepositorySettings.toBuilder();
            this.deleteRepositorySettings = settings.deleteRepositorySettings.toBuilder();
            this.deleteRepositoryOperationSettings = settings.deleteRepositoryOperationSettings.toBuilder();
            this.listPackagesSettings = settings.listPackagesSettings.toBuilder();
            this.getPackageSettings = settings.getPackageSettings.toBuilder();
            this.deletePackageSettings = settings.deletePackageSettings.toBuilder();
            this.deletePackageOperationSettings = settings.deletePackageOperationSettings.toBuilder();
            this.listVersionsSettings = settings.listVersionsSettings.toBuilder();
            this.getVersionSettings = settings.getVersionSettings.toBuilder();
            this.deleteVersionSettings = settings.deleteVersionSettings.toBuilder();
            this.deleteVersionOperationSettings = settings.deleteVersionOperationSettings.toBuilder();
            this.listFilesSettings = settings.listFilesSettings.toBuilder();
            this.getFileSettings = settings.getFileSettings.toBuilder();
            this.listTagsSettings = settings.listTagsSettings.toBuilder();
            this.getTagSettings = settings.getTagSettings.toBuilder();
            this.createTagSettings = settings.createTagSettings.toBuilder();
            this.updateTagSettings = settings.updateTagSettings.toBuilder();
            this.deleteTagSettings = settings.deleteTagSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listRepositoriesSettings, this.getRepositorySettings, this.createRepositorySettings, this.updateRepositorySettings, this.deleteRepositorySettings, this.listPackagesSettings, this.getPackageSettings, this.deletePackageSettings, this.listVersionsSettings, this.getVersionSettings, this.deleteVersionSettings, this.listFilesSettings, (Object[])new UnaryCallSettings.Builder[]{this.getFileSettings, this.listTagsSettings, this.getTagSettings, this.createTagSettings, this.updateTagSettings, this.deleteTagSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ArtifactRegistryStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ArtifactRegistryStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ArtifactRegistryStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(ArtifactRegistryStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(ArtifactRegistryStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listRepositoriesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getRepositorySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createRepositorySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateRepositorySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteRepositorySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listPackagesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getPackageSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deletePackageSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listVersionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getVersionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteVersionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listFilesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getFileSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listTagsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getTagSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createTagSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateTagSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteTagSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.createRepositoryOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Repository.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteRepositoryOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deletePackageOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteVersionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListRepositoriesRequest, ListRepositoriesResponse, ArtifactRegistryClient.ListRepositoriesPagedResponse> listRepositoriesSettings() {
            return this.listRepositoriesSettings;
        }

        public UnaryCallSettings.Builder<GetRepositoryRequest, Repository> getRepositorySettings() {
            return this.getRepositorySettings;
        }

        public UnaryCallSettings.Builder<CreateRepositoryRequest, Operation> createRepositorySettings() {
            return this.createRepositorySettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateRepositoryRequest, Repository, OperationMetadata> createRepositoryOperationSettings() {
            return this.createRepositoryOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateRepositoryRequest, Repository> updateRepositorySettings() {
            return this.updateRepositorySettings;
        }

        public UnaryCallSettings.Builder<DeleteRepositoryRequest, Operation> deleteRepositorySettings() {
            return this.deleteRepositorySettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteRepositoryRequest, Empty, OperationMetadata> deleteRepositoryOperationSettings() {
            return this.deleteRepositoryOperationSettings;
        }

        public PagedCallSettings.Builder<ListPackagesRequest, ListPackagesResponse, ArtifactRegistryClient.ListPackagesPagedResponse> listPackagesSettings() {
            return this.listPackagesSettings;
        }

        public UnaryCallSettings.Builder<GetPackageRequest, Package> getPackageSettings() {
            return this.getPackageSettings;
        }

        public UnaryCallSettings.Builder<DeletePackageRequest, Operation> deletePackageSettings() {
            return this.deletePackageSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeletePackageRequest, Empty, OperationMetadata> deletePackageOperationSettings() {
            return this.deletePackageOperationSettings;
        }

        public PagedCallSettings.Builder<ListVersionsRequest, ListVersionsResponse, ArtifactRegistryClient.ListVersionsPagedResponse> listVersionsSettings() {
            return this.listVersionsSettings;
        }

        public UnaryCallSettings.Builder<GetVersionRequest, Version> getVersionSettings() {
            return this.getVersionSettings;
        }

        public UnaryCallSettings.Builder<DeleteVersionRequest, Operation> deleteVersionSettings() {
            return this.deleteVersionSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteVersionRequest, Empty, OperationMetadata> deleteVersionOperationSettings() {
            return this.deleteVersionOperationSettings;
        }

        public PagedCallSettings.Builder<ListFilesRequest, ListFilesResponse, ArtifactRegistryClient.ListFilesPagedResponse> listFilesSettings() {
            return this.listFilesSettings;
        }

        public UnaryCallSettings.Builder<GetFileRequest, File> getFileSettings() {
            return this.getFileSettings;
        }

        public PagedCallSettings.Builder<ListTagsRequest, ListTagsResponse, ArtifactRegistryClient.ListTagsPagedResponse> listTagsSettings() {
            return this.listTagsSettings;
        }

        public UnaryCallSettings.Builder<GetTagRequest, Tag> getTagSettings() {
            return this.getTagSettings;
        }

        public UnaryCallSettings.Builder<CreateTagRequest, Tag> createTagSettings() {
            return this.createTagSettings;
        }

        public UnaryCallSettings.Builder<UpdateTagRequest, Tag> updateTagSettings() {
            return this.updateTagSettings;
        }

        public UnaryCallSettings.Builder<DeleteTagRequest, Empty> deleteTagSettings() {
            return this.deleteTagSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public ArtifactRegistryStubSettings build() throws IOException {
            return new ArtifactRegistryStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)30000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)30000L)).setTotalTimeout(Duration.ofMillis((long)30000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)30000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)30000L)).setTotalTimeout(Duration.ofMillis((long)30000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

