/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apphub.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.apphub.v1.AppHubSettings;
import com.google.cloud.apphub.v1.Application;
import com.google.cloud.apphub.v1.ApplicationName;
import com.google.cloud.apphub.v1.CreateApplicationRequest;
import com.google.cloud.apphub.v1.CreateServiceProjectAttachmentRequest;
import com.google.cloud.apphub.v1.CreateServiceRequest;
import com.google.cloud.apphub.v1.CreateWorkloadRequest;
import com.google.cloud.apphub.v1.DeleteApplicationRequest;
import com.google.cloud.apphub.v1.DeleteServiceProjectAttachmentRequest;
import com.google.cloud.apphub.v1.DeleteServiceRequest;
import com.google.cloud.apphub.v1.DeleteWorkloadRequest;
import com.google.cloud.apphub.v1.DetachServiceProjectAttachmentRequest;
import com.google.cloud.apphub.v1.DetachServiceProjectAttachmentResponse;
import com.google.cloud.apphub.v1.DiscoveredService;
import com.google.cloud.apphub.v1.DiscoveredServiceName;
import com.google.cloud.apphub.v1.DiscoveredWorkload;
import com.google.cloud.apphub.v1.DiscoveredWorkloadName;
import com.google.cloud.apphub.v1.GetApplicationRequest;
import com.google.cloud.apphub.v1.GetDiscoveredServiceRequest;
import com.google.cloud.apphub.v1.GetDiscoveredWorkloadRequest;
import com.google.cloud.apphub.v1.GetServiceProjectAttachmentRequest;
import com.google.cloud.apphub.v1.GetServiceRequest;
import com.google.cloud.apphub.v1.GetWorkloadRequest;
import com.google.cloud.apphub.v1.ListApplicationsRequest;
import com.google.cloud.apphub.v1.ListApplicationsResponse;
import com.google.cloud.apphub.v1.ListDiscoveredServicesRequest;
import com.google.cloud.apphub.v1.ListDiscoveredServicesResponse;
import com.google.cloud.apphub.v1.ListDiscoveredWorkloadsRequest;
import com.google.cloud.apphub.v1.ListDiscoveredWorkloadsResponse;
import com.google.cloud.apphub.v1.ListServiceProjectAttachmentsRequest;
import com.google.cloud.apphub.v1.ListServiceProjectAttachmentsResponse;
import com.google.cloud.apphub.v1.ListServicesRequest;
import com.google.cloud.apphub.v1.ListServicesResponse;
import com.google.cloud.apphub.v1.ListWorkloadsRequest;
import com.google.cloud.apphub.v1.ListWorkloadsResponse;
import com.google.cloud.apphub.v1.LocationName;
import com.google.cloud.apphub.v1.LookupDiscoveredServiceRequest;
import com.google.cloud.apphub.v1.LookupDiscoveredServiceResponse;
import com.google.cloud.apphub.v1.LookupDiscoveredWorkloadRequest;
import com.google.cloud.apphub.v1.LookupDiscoveredWorkloadResponse;
import com.google.cloud.apphub.v1.LookupServiceProjectAttachmentRequest;
import com.google.cloud.apphub.v1.LookupServiceProjectAttachmentResponse;
import com.google.cloud.apphub.v1.OperationMetadata;
import com.google.cloud.apphub.v1.Service;
import com.google.cloud.apphub.v1.ServiceName;
import com.google.cloud.apphub.v1.ServiceProjectAttachment;
import com.google.cloud.apphub.v1.ServiceProjectAttachmentName;
import com.google.cloud.apphub.v1.UpdateApplicationRequest;
import com.google.cloud.apphub.v1.UpdateServiceRequest;
import com.google.cloud.apphub.v1.UpdateWorkloadRequest;
import com.google.cloud.apphub.v1.Workload;
import com.google.cloud.apphub.v1.WorkloadName;
import com.google.cloud.apphub.v1.stub.AppHubStub;
import com.google.cloud.apphub.v1.stub.AppHubStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class AppHubClient
implements BackgroundResource {
    private final AppHubSettings settings;
    private final AppHubStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final AppHubClient create() throws IOException {
        return AppHubClient.create(AppHubSettings.newBuilder().build());
    }

    public static final AppHubClient create(AppHubSettings settings) throws IOException {
        return new AppHubClient(settings);
    }

    public static final AppHubClient create(AppHubStub stub) {
        return new AppHubClient(stub);
    }

    protected AppHubClient(AppHubSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AppHubStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected AppHubClient(AppHubStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final AppHubSettings getSettings() {
        return this.settings;
    }

    public AppHubStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final LookupServiceProjectAttachmentResponse lookupServiceProjectAttachment(LocationName name) {
        LookupServiceProjectAttachmentRequest request = LookupServiceProjectAttachmentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.lookupServiceProjectAttachment(request);
    }

    public final LookupServiceProjectAttachmentResponse lookupServiceProjectAttachment(String name) {
        LookupServiceProjectAttachmentRequest request = LookupServiceProjectAttachmentRequest.newBuilder().setName(name).build();
        return this.lookupServiceProjectAttachment(request);
    }

    public final LookupServiceProjectAttachmentResponse lookupServiceProjectAttachment(LookupServiceProjectAttachmentRequest request) {
        return (LookupServiceProjectAttachmentResponse)this.lookupServiceProjectAttachmentCallable().call((Object)request);
    }

    public final UnaryCallable<LookupServiceProjectAttachmentRequest, LookupServiceProjectAttachmentResponse> lookupServiceProjectAttachmentCallable() {
        return this.stub.lookupServiceProjectAttachmentCallable();
    }

    public final ListServiceProjectAttachmentsPagedResponse listServiceProjectAttachments(LocationName parent) {
        ListServiceProjectAttachmentsRequest request = ListServiceProjectAttachmentsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listServiceProjectAttachments(request);
    }

    public final ListServiceProjectAttachmentsPagedResponse listServiceProjectAttachments(String parent) {
        ListServiceProjectAttachmentsRequest request = ListServiceProjectAttachmentsRequest.newBuilder().setParent(parent).build();
        return this.listServiceProjectAttachments(request);
    }

    public final ListServiceProjectAttachmentsPagedResponse listServiceProjectAttachments(ListServiceProjectAttachmentsRequest request) {
        return (ListServiceProjectAttachmentsPagedResponse)((Object)this.listServiceProjectAttachmentsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListServiceProjectAttachmentsRequest, ListServiceProjectAttachmentsPagedResponse> listServiceProjectAttachmentsPagedCallable() {
        return this.stub.listServiceProjectAttachmentsPagedCallable();
    }

    public final UnaryCallable<ListServiceProjectAttachmentsRequest, ListServiceProjectAttachmentsResponse> listServiceProjectAttachmentsCallable() {
        return this.stub.listServiceProjectAttachmentsCallable();
    }

    public final OperationFuture<ServiceProjectAttachment, OperationMetadata> createServiceProjectAttachmentAsync(LocationName parent, ServiceProjectAttachment serviceProjectAttachment, String serviceProjectAttachmentId) {
        CreateServiceProjectAttachmentRequest request = CreateServiceProjectAttachmentRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setServiceProjectAttachment(serviceProjectAttachment).setServiceProjectAttachmentId(serviceProjectAttachmentId).build();
        return this.createServiceProjectAttachmentAsync(request);
    }

    public final OperationFuture<ServiceProjectAttachment, OperationMetadata> createServiceProjectAttachmentAsync(String parent, ServiceProjectAttachment serviceProjectAttachment, String serviceProjectAttachmentId) {
        CreateServiceProjectAttachmentRequest request = CreateServiceProjectAttachmentRequest.newBuilder().setParent(parent).setServiceProjectAttachment(serviceProjectAttachment).setServiceProjectAttachmentId(serviceProjectAttachmentId).build();
        return this.createServiceProjectAttachmentAsync(request);
    }

    public final OperationFuture<ServiceProjectAttachment, OperationMetadata> createServiceProjectAttachmentAsync(CreateServiceProjectAttachmentRequest request) {
        return this.createServiceProjectAttachmentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateServiceProjectAttachmentRequest, ServiceProjectAttachment, OperationMetadata> createServiceProjectAttachmentOperationCallable() {
        return this.stub.createServiceProjectAttachmentOperationCallable();
    }

    public final UnaryCallable<CreateServiceProjectAttachmentRequest, Operation> createServiceProjectAttachmentCallable() {
        return this.stub.createServiceProjectAttachmentCallable();
    }

    public final ServiceProjectAttachment getServiceProjectAttachment(ServiceProjectAttachmentName name) {
        GetServiceProjectAttachmentRequest request = GetServiceProjectAttachmentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getServiceProjectAttachment(request);
    }

    public final ServiceProjectAttachment getServiceProjectAttachment(String name) {
        GetServiceProjectAttachmentRequest request = GetServiceProjectAttachmentRequest.newBuilder().setName(name).build();
        return this.getServiceProjectAttachment(request);
    }

    public final ServiceProjectAttachment getServiceProjectAttachment(GetServiceProjectAttachmentRequest request) {
        return (ServiceProjectAttachment)this.getServiceProjectAttachmentCallable().call((Object)request);
    }

    public final UnaryCallable<GetServiceProjectAttachmentRequest, ServiceProjectAttachment> getServiceProjectAttachmentCallable() {
        return this.stub.getServiceProjectAttachmentCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteServiceProjectAttachmentAsync(ServiceProjectAttachmentName name) {
        DeleteServiceProjectAttachmentRequest request = DeleteServiceProjectAttachmentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteServiceProjectAttachmentAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteServiceProjectAttachmentAsync(String name) {
        DeleteServiceProjectAttachmentRequest request = DeleteServiceProjectAttachmentRequest.newBuilder().setName(name).build();
        return this.deleteServiceProjectAttachmentAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteServiceProjectAttachmentAsync(DeleteServiceProjectAttachmentRequest request) {
        return this.deleteServiceProjectAttachmentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteServiceProjectAttachmentRequest, Empty, OperationMetadata> deleteServiceProjectAttachmentOperationCallable() {
        return this.stub.deleteServiceProjectAttachmentOperationCallable();
    }

    public final UnaryCallable<DeleteServiceProjectAttachmentRequest, Operation> deleteServiceProjectAttachmentCallable() {
        return this.stub.deleteServiceProjectAttachmentCallable();
    }

    public final DetachServiceProjectAttachmentResponse detachServiceProjectAttachment(LocationName name) {
        DetachServiceProjectAttachmentRequest request = DetachServiceProjectAttachmentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.detachServiceProjectAttachment(request);
    }

    public final DetachServiceProjectAttachmentResponse detachServiceProjectAttachment(String name) {
        DetachServiceProjectAttachmentRequest request = DetachServiceProjectAttachmentRequest.newBuilder().setName(name).build();
        return this.detachServiceProjectAttachment(request);
    }

    public final DetachServiceProjectAttachmentResponse detachServiceProjectAttachment(DetachServiceProjectAttachmentRequest request) {
        return (DetachServiceProjectAttachmentResponse)this.detachServiceProjectAttachmentCallable().call((Object)request);
    }

    public final UnaryCallable<DetachServiceProjectAttachmentRequest, DetachServiceProjectAttachmentResponse> detachServiceProjectAttachmentCallable() {
        return this.stub.detachServiceProjectAttachmentCallable();
    }

    public final ListDiscoveredServicesPagedResponse listDiscoveredServices(LocationName parent) {
        ListDiscoveredServicesRequest request = ListDiscoveredServicesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDiscoveredServices(request);
    }

    public final ListDiscoveredServicesPagedResponse listDiscoveredServices(String parent) {
        ListDiscoveredServicesRequest request = ListDiscoveredServicesRequest.newBuilder().setParent(parent).build();
        return this.listDiscoveredServices(request);
    }

    public final ListDiscoveredServicesPagedResponse listDiscoveredServices(ListDiscoveredServicesRequest request) {
        return (ListDiscoveredServicesPagedResponse)((Object)this.listDiscoveredServicesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDiscoveredServicesRequest, ListDiscoveredServicesPagedResponse> listDiscoveredServicesPagedCallable() {
        return this.stub.listDiscoveredServicesPagedCallable();
    }

    public final UnaryCallable<ListDiscoveredServicesRequest, ListDiscoveredServicesResponse> listDiscoveredServicesCallable() {
        return this.stub.listDiscoveredServicesCallable();
    }

    public final DiscoveredService getDiscoveredService(DiscoveredServiceName name) {
        GetDiscoveredServiceRequest request = GetDiscoveredServiceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDiscoveredService(request);
    }

    public final DiscoveredService getDiscoveredService(String name) {
        GetDiscoveredServiceRequest request = GetDiscoveredServiceRequest.newBuilder().setName(name).build();
        return this.getDiscoveredService(request);
    }

    public final DiscoveredService getDiscoveredService(GetDiscoveredServiceRequest request) {
        return (DiscoveredService)this.getDiscoveredServiceCallable().call((Object)request);
    }

    public final UnaryCallable<GetDiscoveredServiceRequest, DiscoveredService> getDiscoveredServiceCallable() {
        return this.stub.getDiscoveredServiceCallable();
    }

    public final LookupDiscoveredServiceResponse lookupDiscoveredService(LocationName parent, String uri) {
        LookupDiscoveredServiceRequest request = LookupDiscoveredServiceRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setUri(uri).build();
        return this.lookupDiscoveredService(request);
    }

    public final LookupDiscoveredServiceResponse lookupDiscoveredService(String parent, String uri) {
        LookupDiscoveredServiceRequest request = LookupDiscoveredServiceRequest.newBuilder().setParent(parent).setUri(uri).build();
        return this.lookupDiscoveredService(request);
    }

    public final LookupDiscoveredServiceResponse lookupDiscoveredService(LookupDiscoveredServiceRequest request) {
        return (LookupDiscoveredServiceResponse)this.lookupDiscoveredServiceCallable().call((Object)request);
    }

    public final UnaryCallable<LookupDiscoveredServiceRequest, LookupDiscoveredServiceResponse> lookupDiscoveredServiceCallable() {
        return this.stub.lookupDiscoveredServiceCallable();
    }

    public final ListServicesPagedResponse listServices(ApplicationName parent) {
        ListServicesRequest request = ListServicesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listServices(request);
    }

    public final ListServicesPagedResponse listServices(String parent) {
        ListServicesRequest request = ListServicesRequest.newBuilder().setParent(parent).build();
        return this.listServices(request);
    }

    public final ListServicesPagedResponse listServices(ListServicesRequest request) {
        return (ListServicesPagedResponse)((Object)this.listServicesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListServicesRequest, ListServicesPagedResponse> listServicesPagedCallable() {
        return this.stub.listServicesPagedCallable();
    }

    public final UnaryCallable<ListServicesRequest, ListServicesResponse> listServicesCallable() {
        return this.stub.listServicesCallable();
    }

    public final OperationFuture<Service, OperationMetadata> createServiceAsync(ApplicationName parent, Service service, String serviceId) {
        CreateServiceRequest request = CreateServiceRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setService(service).setServiceId(serviceId).build();
        return this.createServiceAsync(request);
    }

    public final OperationFuture<Service, OperationMetadata> createServiceAsync(String parent, Service service, String serviceId) {
        CreateServiceRequest request = CreateServiceRequest.newBuilder().setParent(parent).setService(service).setServiceId(serviceId).build();
        return this.createServiceAsync(request);
    }

    public final OperationFuture<Service, OperationMetadata> createServiceAsync(CreateServiceRequest request) {
        return this.createServiceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateServiceRequest, Service, OperationMetadata> createServiceOperationCallable() {
        return this.stub.createServiceOperationCallable();
    }

    public final UnaryCallable<CreateServiceRequest, Operation> createServiceCallable() {
        return this.stub.createServiceCallable();
    }

    public final Service getService(ServiceName name) {
        GetServiceRequest request = GetServiceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getService(request);
    }

    public final Service getService(String name) {
        GetServiceRequest request = GetServiceRequest.newBuilder().setName(name).build();
        return this.getService(request);
    }

    public final Service getService(GetServiceRequest request) {
        return (Service)this.getServiceCallable().call((Object)request);
    }

    public final UnaryCallable<GetServiceRequest, Service> getServiceCallable() {
        return this.stub.getServiceCallable();
    }

    public final OperationFuture<Service, OperationMetadata> updateServiceAsync(Service service, FieldMask updateMask) {
        UpdateServiceRequest request = UpdateServiceRequest.newBuilder().setService(service).setUpdateMask(updateMask).build();
        return this.updateServiceAsync(request);
    }

    public final OperationFuture<Service, OperationMetadata> updateServiceAsync(UpdateServiceRequest request) {
        return this.updateServiceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateServiceRequest, Service, OperationMetadata> updateServiceOperationCallable() {
        return this.stub.updateServiceOperationCallable();
    }

    public final UnaryCallable<UpdateServiceRequest, Operation> updateServiceCallable() {
        return this.stub.updateServiceCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteServiceAsync(ServiceName name) {
        DeleteServiceRequest request = DeleteServiceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteServiceAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteServiceAsync(String name) {
        DeleteServiceRequest request = DeleteServiceRequest.newBuilder().setName(name).build();
        return this.deleteServiceAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteServiceAsync(DeleteServiceRequest request) {
        return this.deleteServiceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteServiceRequest, Empty, OperationMetadata> deleteServiceOperationCallable() {
        return this.stub.deleteServiceOperationCallable();
    }

    public final UnaryCallable<DeleteServiceRequest, Operation> deleteServiceCallable() {
        return this.stub.deleteServiceCallable();
    }

    public final ListDiscoveredWorkloadsPagedResponse listDiscoveredWorkloads(LocationName parent) {
        ListDiscoveredWorkloadsRequest request = ListDiscoveredWorkloadsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDiscoveredWorkloads(request);
    }

    public final ListDiscoveredWorkloadsPagedResponse listDiscoveredWorkloads(String parent) {
        ListDiscoveredWorkloadsRequest request = ListDiscoveredWorkloadsRequest.newBuilder().setParent(parent).build();
        return this.listDiscoveredWorkloads(request);
    }

    public final ListDiscoveredWorkloadsPagedResponse listDiscoveredWorkloads(ListDiscoveredWorkloadsRequest request) {
        return (ListDiscoveredWorkloadsPagedResponse)((Object)this.listDiscoveredWorkloadsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDiscoveredWorkloadsRequest, ListDiscoveredWorkloadsPagedResponse> listDiscoveredWorkloadsPagedCallable() {
        return this.stub.listDiscoveredWorkloadsPagedCallable();
    }

    public final UnaryCallable<ListDiscoveredWorkloadsRequest, ListDiscoveredWorkloadsResponse> listDiscoveredWorkloadsCallable() {
        return this.stub.listDiscoveredWorkloadsCallable();
    }

    public final DiscoveredWorkload getDiscoveredWorkload(DiscoveredWorkloadName name) {
        GetDiscoveredWorkloadRequest request = GetDiscoveredWorkloadRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDiscoveredWorkload(request);
    }

    public final DiscoveredWorkload getDiscoveredWorkload(String name) {
        GetDiscoveredWorkloadRequest request = GetDiscoveredWorkloadRequest.newBuilder().setName(name).build();
        return this.getDiscoveredWorkload(request);
    }

    public final DiscoveredWorkload getDiscoveredWorkload(GetDiscoveredWorkloadRequest request) {
        return (DiscoveredWorkload)this.getDiscoveredWorkloadCallable().call((Object)request);
    }

    public final UnaryCallable<GetDiscoveredWorkloadRequest, DiscoveredWorkload> getDiscoveredWorkloadCallable() {
        return this.stub.getDiscoveredWorkloadCallable();
    }

    public final LookupDiscoveredWorkloadResponse lookupDiscoveredWorkload(LocationName parent, String uri) {
        LookupDiscoveredWorkloadRequest request = LookupDiscoveredWorkloadRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setUri(uri).build();
        return this.lookupDiscoveredWorkload(request);
    }

    public final LookupDiscoveredWorkloadResponse lookupDiscoveredWorkload(String parent, String uri) {
        LookupDiscoveredWorkloadRequest request = LookupDiscoveredWorkloadRequest.newBuilder().setParent(parent).setUri(uri).build();
        return this.lookupDiscoveredWorkload(request);
    }

    public final LookupDiscoveredWorkloadResponse lookupDiscoveredWorkload(LookupDiscoveredWorkloadRequest request) {
        return (LookupDiscoveredWorkloadResponse)this.lookupDiscoveredWorkloadCallable().call((Object)request);
    }

    public final UnaryCallable<LookupDiscoveredWorkloadRequest, LookupDiscoveredWorkloadResponse> lookupDiscoveredWorkloadCallable() {
        return this.stub.lookupDiscoveredWorkloadCallable();
    }

    public final ListWorkloadsPagedResponse listWorkloads(ApplicationName parent) {
        ListWorkloadsRequest request = ListWorkloadsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listWorkloads(request);
    }

    public final ListWorkloadsPagedResponse listWorkloads(String parent) {
        ListWorkloadsRequest request = ListWorkloadsRequest.newBuilder().setParent(parent).build();
        return this.listWorkloads(request);
    }

    public final ListWorkloadsPagedResponse listWorkloads(ListWorkloadsRequest request) {
        return (ListWorkloadsPagedResponse)((Object)this.listWorkloadsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListWorkloadsRequest, ListWorkloadsPagedResponse> listWorkloadsPagedCallable() {
        return this.stub.listWorkloadsPagedCallable();
    }

    public final UnaryCallable<ListWorkloadsRequest, ListWorkloadsResponse> listWorkloadsCallable() {
        return this.stub.listWorkloadsCallable();
    }

    public final OperationFuture<Workload, OperationMetadata> createWorkloadAsync(ApplicationName parent, Workload workload, String workloadId) {
        CreateWorkloadRequest request = CreateWorkloadRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setWorkload(workload).setWorkloadId(workloadId).build();
        return this.createWorkloadAsync(request);
    }

    public final OperationFuture<Workload, OperationMetadata> createWorkloadAsync(String parent, Workload workload, String workloadId) {
        CreateWorkloadRequest request = CreateWorkloadRequest.newBuilder().setParent(parent).setWorkload(workload).setWorkloadId(workloadId).build();
        return this.createWorkloadAsync(request);
    }

    public final OperationFuture<Workload, OperationMetadata> createWorkloadAsync(CreateWorkloadRequest request) {
        return this.createWorkloadOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateWorkloadRequest, Workload, OperationMetadata> createWorkloadOperationCallable() {
        return this.stub.createWorkloadOperationCallable();
    }

    public final UnaryCallable<CreateWorkloadRequest, Operation> createWorkloadCallable() {
        return this.stub.createWorkloadCallable();
    }

    public final Workload getWorkload(WorkloadName name) {
        GetWorkloadRequest request = GetWorkloadRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getWorkload(request);
    }

    public final Workload getWorkload(String name) {
        GetWorkloadRequest request = GetWorkloadRequest.newBuilder().setName(name).build();
        return this.getWorkload(request);
    }

    public final Workload getWorkload(GetWorkloadRequest request) {
        return (Workload)this.getWorkloadCallable().call((Object)request);
    }

    public final UnaryCallable<GetWorkloadRequest, Workload> getWorkloadCallable() {
        return this.stub.getWorkloadCallable();
    }

    public final OperationFuture<Workload, OperationMetadata> updateWorkloadAsync(Workload workload, FieldMask updateMask) {
        UpdateWorkloadRequest request = UpdateWorkloadRequest.newBuilder().setWorkload(workload).setUpdateMask(updateMask).build();
        return this.updateWorkloadAsync(request);
    }

    public final OperationFuture<Workload, OperationMetadata> updateWorkloadAsync(UpdateWorkloadRequest request) {
        return this.updateWorkloadOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateWorkloadRequest, Workload, OperationMetadata> updateWorkloadOperationCallable() {
        return this.stub.updateWorkloadOperationCallable();
    }

    public final UnaryCallable<UpdateWorkloadRequest, Operation> updateWorkloadCallable() {
        return this.stub.updateWorkloadCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteWorkloadAsync(WorkloadName name) {
        DeleteWorkloadRequest request = DeleteWorkloadRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteWorkloadAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteWorkloadAsync(String name) {
        DeleteWorkloadRequest request = DeleteWorkloadRequest.newBuilder().setName(name).build();
        return this.deleteWorkloadAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteWorkloadAsync(DeleteWorkloadRequest request) {
        return this.deleteWorkloadOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteWorkloadRequest, Empty, OperationMetadata> deleteWorkloadOperationCallable() {
        return this.stub.deleteWorkloadOperationCallable();
    }

    public final UnaryCallable<DeleteWorkloadRequest, Operation> deleteWorkloadCallable() {
        return this.stub.deleteWorkloadCallable();
    }

    public final ListApplicationsPagedResponse listApplications(LocationName parent) {
        ListApplicationsRequest request = ListApplicationsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listApplications(request);
    }

    public final ListApplicationsPagedResponse listApplications(String parent) {
        ListApplicationsRequest request = ListApplicationsRequest.newBuilder().setParent(parent).build();
        return this.listApplications(request);
    }

    public final ListApplicationsPagedResponse listApplications(ListApplicationsRequest request) {
        return (ListApplicationsPagedResponse)((Object)this.listApplicationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListApplicationsRequest, ListApplicationsPagedResponse> listApplicationsPagedCallable() {
        return this.stub.listApplicationsPagedCallable();
    }

    public final UnaryCallable<ListApplicationsRequest, ListApplicationsResponse> listApplicationsCallable() {
        return this.stub.listApplicationsCallable();
    }

    public final OperationFuture<Application, OperationMetadata> createApplicationAsync(LocationName parent, Application application, String applicationId) {
        CreateApplicationRequest request = CreateApplicationRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setApplication(application).setApplicationId(applicationId).build();
        return this.createApplicationAsync(request);
    }

    public final OperationFuture<Application, OperationMetadata> createApplicationAsync(String parent, Application application, String applicationId) {
        CreateApplicationRequest request = CreateApplicationRequest.newBuilder().setParent(parent).setApplication(application).setApplicationId(applicationId).build();
        return this.createApplicationAsync(request);
    }

    public final OperationFuture<Application, OperationMetadata> createApplicationAsync(CreateApplicationRequest request) {
        return this.createApplicationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateApplicationRequest, Application, OperationMetadata> createApplicationOperationCallable() {
        return this.stub.createApplicationOperationCallable();
    }

    public final UnaryCallable<CreateApplicationRequest, Operation> createApplicationCallable() {
        return this.stub.createApplicationCallable();
    }

    public final Application getApplication(ApplicationName name) {
        GetApplicationRequest request = GetApplicationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getApplication(request);
    }

    public final Application getApplication(String name) {
        GetApplicationRequest request = GetApplicationRequest.newBuilder().setName(name).build();
        return this.getApplication(request);
    }

    public final Application getApplication(GetApplicationRequest request) {
        return (Application)this.getApplicationCallable().call((Object)request);
    }

    public final UnaryCallable<GetApplicationRequest, Application> getApplicationCallable() {
        return this.stub.getApplicationCallable();
    }

    public final OperationFuture<Application, OperationMetadata> updateApplicationAsync(Application application, FieldMask updateMask) {
        UpdateApplicationRequest request = UpdateApplicationRequest.newBuilder().setApplication(application).setUpdateMask(updateMask).build();
        return this.updateApplicationAsync(request);
    }

    public final OperationFuture<Application, OperationMetadata> updateApplicationAsync(UpdateApplicationRequest request) {
        return this.updateApplicationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateApplicationRequest, Application, OperationMetadata> updateApplicationOperationCallable() {
        return this.stub.updateApplicationOperationCallable();
    }

    public final UnaryCallable<UpdateApplicationRequest, Operation> updateApplicationCallable() {
        return this.stub.updateApplicationCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteApplicationAsync(ApplicationName name) {
        DeleteApplicationRequest request = DeleteApplicationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteApplicationAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteApplicationAsync(String name) {
        DeleteApplicationRequest request = DeleteApplicationRequest.newBuilder().setName(name).build();
        return this.deleteApplicationAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteApplicationAsync(DeleteApplicationRequest request) {
        return this.deleteApplicationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteApplicationRequest, Empty, OperationMetadata> deleteApplicationOperationCallable() {
        return this.stub.deleteApplicationOperationCallable();
    }

    public final UnaryCallable<DeleteApplicationRequest, Operation> deleteApplicationCallable() {
        return this.stub.deleteApplicationCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListApplicationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListApplicationsRequest, ListApplicationsResponse, Application, ListApplicationsPage, ListApplicationsFixedSizeCollection> {
        private ListApplicationsFixedSizeCollection(List<ListApplicationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListApplicationsFixedSizeCollection createEmptyCollection() {
            return new ListApplicationsFixedSizeCollection(null, 0);
        }

        protected ListApplicationsFixedSizeCollection createCollection(List<ListApplicationsPage> pages, int collectionSize) {
            return new ListApplicationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListApplicationsPage
    extends AbstractPage<ListApplicationsRequest, ListApplicationsResponse, Application, ListApplicationsPage> {
        private ListApplicationsPage(PageContext<ListApplicationsRequest, ListApplicationsResponse, Application> context, ListApplicationsResponse response) {
            super(context, (Object)response);
        }

        private static ListApplicationsPage createEmptyPage() {
            return new ListApplicationsPage(null, null);
        }

        protected ListApplicationsPage createPage(PageContext<ListApplicationsRequest, ListApplicationsResponse, Application> context, ListApplicationsResponse response) {
            return new ListApplicationsPage(context, response);
        }

        public ApiFuture<ListApplicationsPage> createPageAsync(PageContext<ListApplicationsRequest, ListApplicationsResponse, Application> context, ApiFuture<ListApplicationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListApplicationsPagedResponse
    extends AbstractPagedListResponse<ListApplicationsRequest, ListApplicationsResponse, Application, ListApplicationsPage, ListApplicationsFixedSizeCollection> {
        public static ApiFuture<ListApplicationsPagedResponse> createAsync(PageContext<ListApplicationsRequest, ListApplicationsResponse, Application> context, ApiFuture<ListApplicationsResponse> futureResponse) {
            ApiFuture<ListApplicationsPage> futurePage = ListApplicationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListApplicationsPagedResponse((ListApplicationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListApplicationsPagedResponse(ListApplicationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListApplicationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListWorkloadsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListWorkloadsRequest, ListWorkloadsResponse, Workload, ListWorkloadsPage, ListWorkloadsFixedSizeCollection> {
        private ListWorkloadsFixedSizeCollection(List<ListWorkloadsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListWorkloadsFixedSizeCollection createEmptyCollection() {
            return new ListWorkloadsFixedSizeCollection(null, 0);
        }

        protected ListWorkloadsFixedSizeCollection createCollection(List<ListWorkloadsPage> pages, int collectionSize) {
            return new ListWorkloadsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListWorkloadsPage
    extends AbstractPage<ListWorkloadsRequest, ListWorkloadsResponse, Workload, ListWorkloadsPage> {
        private ListWorkloadsPage(PageContext<ListWorkloadsRequest, ListWorkloadsResponse, Workload> context, ListWorkloadsResponse response) {
            super(context, (Object)response);
        }

        private static ListWorkloadsPage createEmptyPage() {
            return new ListWorkloadsPage(null, null);
        }

        protected ListWorkloadsPage createPage(PageContext<ListWorkloadsRequest, ListWorkloadsResponse, Workload> context, ListWorkloadsResponse response) {
            return new ListWorkloadsPage(context, response);
        }

        public ApiFuture<ListWorkloadsPage> createPageAsync(PageContext<ListWorkloadsRequest, ListWorkloadsResponse, Workload> context, ApiFuture<ListWorkloadsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListWorkloadsPagedResponse
    extends AbstractPagedListResponse<ListWorkloadsRequest, ListWorkloadsResponse, Workload, ListWorkloadsPage, ListWorkloadsFixedSizeCollection> {
        public static ApiFuture<ListWorkloadsPagedResponse> createAsync(PageContext<ListWorkloadsRequest, ListWorkloadsResponse, Workload> context, ApiFuture<ListWorkloadsResponse> futureResponse) {
            ApiFuture<ListWorkloadsPage> futurePage = ListWorkloadsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListWorkloadsPagedResponse((ListWorkloadsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListWorkloadsPagedResponse(ListWorkloadsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListWorkloadsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDiscoveredWorkloadsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDiscoveredWorkloadsRequest, ListDiscoveredWorkloadsResponse, DiscoveredWorkload, ListDiscoveredWorkloadsPage, ListDiscoveredWorkloadsFixedSizeCollection> {
        private ListDiscoveredWorkloadsFixedSizeCollection(List<ListDiscoveredWorkloadsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDiscoveredWorkloadsFixedSizeCollection createEmptyCollection() {
            return new ListDiscoveredWorkloadsFixedSizeCollection(null, 0);
        }

        protected ListDiscoveredWorkloadsFixedSizeCollection createCollection(List<ListDiscoveredWorkloadsPage> pages, int collectionSize) {
            return new ListDiscoveredWorkloadsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDiscoveredWorkloadsPage
    extends AbstractPage<ListDiscoveredWorkloadsRequest, ListDiscoveredWorkloadsResponse, DiscoveredWorkload, ListDiscoveredWorkloadsPage> {
        private ListDiscoveredWorkloadsPage(PageContext<ListDiscoveredWorkloadsRequest, ListDiscoveredWorkloadsResponse, DiscoveredWorkload> context, ListDiscoveredWorkloadsResponse response) {
            super(context, (Object)response);
        }

        private static ListDiscoveredWorkloadsPage createEmptyPage() {
            return new ListDiscoveredWorkloadsPage(null, null);
        }

        protected ListDiscoveredWorkloadsPage createPage(PageContext<ListDiscoveredWorkloadsRequest, ListDiscoveredWorkloadsResponse, DiscoveredWorkload> context, ListDiscoveredWorkloadsResponse response) {
            return new ListDiscoveredWorkloadsPage(context, response);
        }

        public ApiFuture<ListDiscoveredWorkloadsPage> createPageAsync(PageContext<ListDiscoveredWorkloadsRequest, ListDiscoveredWorkloadsResponse, DiscoveredWorkload> context, ApiFuture<ListDiscoveredWorkloadsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDiscoveredWorkloadsPagedResponse
    extends AbstractPagedListResponse<ListDiscoveredWorkloadsRequest, ListDiscoveredWorkloadsResponse, DiscoveredWorkload, ListDiscoveredWorkloadsPage, ListDiscoveredWorkloadsFixedSizeCollection> {
        public static ApiFuture<ListDiscoveredWorkloadsPagedResponse> createAsync(PageContext<ListDiscoveredWorkloadsRequest, ListDiscoveredWorkloadsResponse, DiscoveredWorkload> context, ApiFuture<ListDiscoveredWorkloadsResponse> futureResponse) {
            ApiFuture<ListDiscoveredWorkloadsPage> futurePage = ListDiscoveredWorkloadsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDiscoveredWorkloadsPagedResponse((ListDiscoveredWorkloadsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDiscoveredWorkloadsPagedResponse(ListDiscoveredWorkloadsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDiscoveredWorkloadsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListServicesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListServicesRequest, ListServicesResponse, Service, ListServicesPage, ListServicesFixedSizeCollection> {
        private ListServicesFixedSizeCollection(List<ListServicesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListServicesFixedSizeCollection createEmptyCollection() {
            return new ListServicesFixedSizeCollection(null, 0);
        }

        protected ListServicesFixedSizeCollection createCollection(List<ListServicesPage> pages, int collectionSize) {
            return new ListServicesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListServicesPage
    extends AbstractPage<ListServicesRequest, ListServicesResponse, Service, ListServicesPage> {
        private ListServicesPage(PageContext<ListServicesRequest, ListServicesResponse, Service> context, ListServicesResponse response) {
            super(context, (Object)response);
        }

        private static ListServicesPage createEmptyPage() {
            return new ListServicesPage(null, null);
        }

        protected ListServicesPage createPage(PageContext<ListServicesRequest, ListServicesResponse, Service> context, ListServicesResponse response) {
            return new ListServicesPage(context, response);
        }

        public ApiFuture<ListServicesPage> createPageAsync(PageContext<ListServicesRequest, ListServicesResponse, Service> context, ApiFuture<ListServicesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListServicesPagedResponse
    extends AbstractPagedListResponse<ListServicesRequest, ListServicesResponse, Service, ListServicesPage, ListServicesFixedSizeCollection> {
        public static ApiFuture<ListServicesPagedResponse> createAsync(PageContext<ListServicesRequest, ListServicesResponse, Service> context, ApiFuture<ListServicesResponse> futureResponse) {
            ApiFuture<ListServicesPage> futurePage = ListServicesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListServicesPagedResponse((ListServicesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListServicesPagedResponse(ListServicesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListServicesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDiscoveredServicesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDiscoveredServicesRequest, ListDiscoveredServicesResponse, DiscoveredService, ListDiscoveredServicesPage, ListDiscoveredServicesFixedSizeCollection> {
        private ListDiscoveredServicesFixedSizeCollection(List<ListDiscoveredServicesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDiscoveredServicesFixedSizeCollection createEmptyCollection() {
            return new ListDiscoveredServicesFixedSizeCollection(null, 0);
        }

        protected ListDiscoveredServicesFixedSizeCollection createCollection(List<ListDiscoveredServicesPage> pages, int collectionSize) {
            return new ListDiscoveredServicesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDiscoveredServicesPage
    extends AbstractPage<ListDiscoveredServicesRequest, ListDiscoveredServicesResponse, DiscoveredService, ListDiscoveredServicesPage> {
        private ListDiscoveredServicesPage(PageContext<ListDiscoveredServicesRequest, ListDiscoveredServicesResponse, DiscoveredService> context, ListDiscoveredServicesResponse response) {
            super(context, (Object)response);
        }

        private static ListDiscoveredServicesPage createEmptyPage() {
            return new ListDiscoveredServicesPage(null, null);
        }

        protected ListDiscoveredServicesPage createPage(PageContext<ListDiscoveredServicesRequest, ListDiscoveredServicesResponse, DiscoveredService> context, ListDiscoveredServicesResponse response) {
            return new ListDiscoveredServicesPage(context, response);
        }

        public ApiFuture<ListDiscoveredServicesPage> createPageAsync(PageContext<ListDiscoveredServicesRequest, ListDiscoveredServicesResponse, DiscoveredService> context, ApiFuture<ListDiscoveredServicesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDiscoveredServicesPagedResponse
    extends AbstractPagedListResponse<ListDiscoveredServicesRequest, ListDiscoveredServicesResponse, DiscoveredService, ListDiscoveredServicesPage, ListDiscoveredServicesFixedSizeCollection> {
        public static ApiFuture<ListDiscoveredServicesPagedResponse> createAsync(PageContext<ListDiscoveredServicesRequest, ListDiscoveredServicesResponse, DiscoveredService> context, ApiFuture<ListDiscoveredServicesResponse> futureResponse) {
            ApiFuture<ListDiscoveredServicesPage> futurePage = ListDiscoveredServicesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDiscoveredServicesPagedResponse((ListDiscoveredServicesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDiscoveredServicesPagedResponse(ListDiscoveredServicesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDiscoveredServicesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListServiceProjectAttachmentsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListServiceProjectAttachmentsRequest, ListServiceProjectAttachmentsResponse, ServiceProjectAttachment, ListServiceProjectAttachmentsPage, ListServiceProjectAttachmentsFixedSizeCollection> {
        private ListServiceProjectAttachmentsFixedSizeCollection(List<ListServiceProjectAttachmentsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListServiceProjectAttachmentsFixedSizeCollection createEmptyCollection() {
            return new ListServiceProjectAttachmentsFixedSizeCollection(null, 0);
        }

        protected ListServiceProjectAttachmentsFixedSizeCollection createCollection(List<ListServiceProjectAttachmentsPage> pages, int collectionSize) {
            return new ListServiceProjectAttachmentsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListServiceProjectAttachmentsPage
    extends AbstractPage<ListServiceProjectAttachmentsRequest, ListServiceProjectAttachmentsResponse, ServiceProjectAttachment, ListServiceProjectAttachmentsPage> {
        private ListServiceProjectAttachmentsPage(PageContext<ListServiceProjectAttachmentsRequest, ListServiceProjectAttachmentsResponse, ServiceProjectAttachment> context, ListServiceProjectAttachmentsResponse response) {
            super(context, (Object)response);
        }

        private static ListServiceProjectAttachmentsPage createEmptyPage() {
            return new ListServiceProjectAttachmentsPage(null, null);
        }

        protected ListServiceProjectAttachmentsPage createPage(PageContext<ListServiceProjectAttachmentsRequest, ListServiceProjectAttachmentsResponse, ServiceProjectAttachment> context, ListServiceProjectAttachmentsResponse response) {
            return new ListServiceProjectAttachmentsPage(context, response);
        }

        public ApiFuture<ListServiceProjectAttachmentsPage> createPageAsync(PageContext<ListServiceProjectAttachmentsRequest, ListServiceProjectAttachmentsResponse, ServiceProjectAttachment> context, ApiFuture<ListServiceProjectAttachmentsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListServiceProjectAttachmentsPagedResponse
    extends AbstractPagedListResponse<ListServiceProjectAttachmentsRequest, ListServiceProjectAttachmentsResponse, ServiceProjectAttachment, ListServiceProjectAttachmentsPage, ListServiceProjectAttachmentsFixedSizeCollection> {
        public static ApiFuture<ListServiceProjectAttachmentsPagedResponse> createAsync(PageContext<ListServiceProjectAttachmentsRequest, ListServiceProjectAttachmentsResponse, ServiceProjectAttachment> context, ApiFuture<ListServiceProjectAttachmentsResponse> futureResponse) {
            ApiFuture<ListServiceProjectAttachmentsPage> futurePage = ListServiceProjectAttachmentsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListServiceProjectAttachmentsPagedResponse((ListServiceProjectAttachmentsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListServiceProjectAttachmentsPagedResponse(ListServiceProjectAttachmentsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListServiceProjectAttachmentsFixedSizeCollection.createEmptyCollection());
        }
    }
}

