/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.appengine.v1.BatchUpdateIngressRulesRequest;
import com.google.appengine.v1.BatchUpdateIngressRulesResponse;
import com.google.appengine.v1.CreateIngressRuleRequest;
import com.google.appengine.v1.DeleteIngressRuleRequest;
import com.google.appengine.v1.FirewallClient;
import com.google.appengine.v1.GetIngressRuleRequest;
import com.google.appengine.v1.ListIngressRulesRequest;
import com.google.appengine.v1.ListIngressRulesResponse;
import com.google.appengine.v1.UpdateIngressRuleRequest;
import com.google.appengine.v1.firewall.FirewallRule;
import com.google.appengine.v1.stub.FirewallStub;
import com.google.appengine.v1.stub.GrpcFirewallStub;
import com.google.appengine.v1.stub.HttpJsonFirewallStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class FirewallStubSettings
extends StubSettings<FirewallStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/appengine.admin").add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/cloud-platform.read-only").build();
    private final PagedCallSettings<ListIngressRulesRequest, ListIngressRulesResponse, FirewallClient.ListIngressRulesPagedResponse> listIngressRulesSettings;
    private final UnaryCallSettings<BatchUpdateIngressRulesRequest, BatchUpdateIngressRulesResponse> batchUpdateIngressRulesSettings;
    private final UnaryCallSettings<CreateIngressRuleRequest, FirewallRule> createIngressRuleSettings;
    private final UnaryCallSettings<GetIngressRuleRequest, FirewallRule> getIngressRuleSettings;
    private final UnaryCallSettings<UpdateIngressRuleRequest, FirewallRule> updateIngressRuleSettings;
    private final UnaryCallSettings<DeleteIngressRuleRequest, Empty> deleteIngressRuleSettings;
    private static final PagedListDescriptor<ListIngressRulesRequest, ListIngressRulesResponse, FirewallRule> LIST_INGRESS_RULES_PAGE_STR_DESC = new PagedListDescriptor<ListIngressRulesRequest, ListIngressRulesResponse, FirewallRule>(){

        public String emptyToken() {
            return "";
        }

        public ListIngressRulesRequest injectToken(ListIngressRulesRequest payload, String token) {
            return ListIngressRulesRequest.newBuilder((ListIngressRulesRequest)payload).setPageToken(token).build();
        }

        public ListIngressRulesRequest injectPageSize(ListIngressRulesRequest payload, int pageSize) {
            return ListIngressRulesRequest.newBuilder((ListIngressRulesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListIngressRulesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListIngressRulesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<FirewallRule> extractResources(ListIngressRulesResponse payload) {
            return payload.getIngressRulesList() == null ? ImmutableList.of() : payload.getIngressRulesList();
        }
    };
    private static final PagedListResponseFactory<ListIngressRulesRequest, ListIngressRulesResponse, FirewallClient.ListIngressRulesPagedResponse> LIST_INGRESS_RULES_PAGE_STR_FACT = new PagedListResponseFactory<ListIngressRulesRequest, ListIngressRulesResponse, FirewallClient.ListIngressRulesPagedResponse>(){

        public ApiFuture<FirewallClient.ListIngressRulesPagedResponse> getFuturePagedResponse(UnaryCallable<ListIngressRulesRequest, ListIngressRulesResponse> callable, ListIngressRulesRequest request, ApiCallContext context, ApiFuture<ListIngressRulesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_INGRESS_RULES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return FirewallClient.ListIngressRulesPagedResponse.createAsync((PageContext<ListIngressRulesRequest, ListIngressRulesResponse, FirewallRule>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListIngressRulesRequest, ListIngressRulesResponse, FirewallClient.ListIngressRulesPagedResponse> listIngressRulesSettings() {
        return this.listIngressRulesSettings;
    }

    public UnaryCallSettings<BatchUpdateIngressRulesRequest, BatchUpdateIngressRulesResponse> batchUpdateIngressRulesSettings() {
        return this.batchUpdateIngressRulesSettings;
    }

    public UnaryCallSettings<CreateIngressRuleRequest, FirewallRule> createIngressRuleSettings() {
        return this.createIngressRuleSettings;
    }

    public UnaryCallSettings<GetIngressRuleRequest, FirewallRule> getIngressRuleSettings() {
        return this.getIngressRuleSettings;
    }

    public UnaryCallSettings<UpdateIngressRuleRequest, FirewallRule> updateIngressRuleSettings() {
        return this.updateIngressRuleSettings;
    }

    public UnaryCallSettings<DeleteIngressRuleRequest, Empty> deleteIngressRuleSettings() {
        return this.deleteIngressRuleSettings;
    }

    public FirewallStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcFirewallStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonFirewallStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "appengine";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "appengine.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "appengine.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return FirewallStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(FirewallStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(FirewallStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return FirewallStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected FirewallStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listIngressRulesSettings = settingsBuilder.listIngressRulesSettings().build();
        this.batchUpdateIngressRulesSettings = settingsBuilder.batchUpdateIngressRulesSettings().build();
        this.createIngressRuleSettings = settingsBuilder.createIngressRuleSettings().build();
        this.getIngressRuleSettings = settingsBuilder.getIngressRuleSettings().build();
        this.updateIngressRuleSettings = settingsBuilder.updateIngressRuleSettings().build();
        this.deleteIngressRuleSettings = settingsBuilder.deleteIngressRuleSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<FirewallStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListIngressRulesRequest, ListIngressRulesResponse, FirewallClient.ListIngressRulesPagedResponse> listIngressRulesSettings;
        private final UnaryCallSettings.Builder<BatchUpdateIngressRulesRequest, BatchUpdateIngressRulesResponse> batchUpdateIngressRulesSettings;
        private final UnaryCallSettings.Builder<CreateIngressRuleRequest, FirewallRule> createIngressRuleSettings;
        private final UnaryCallSettings.Builder<GetIngressRuleRequest, FirewallRule> getIngressRuleSettings;
        private final UnaryCallSettings.Builder<UpdateIngressRuleRequest, FirewallRule> updateIngressRuleSettings;
        private final UnaryCallSettings.Builder<DeleteIngressRuleRequest, Empty> deleteIngressRuleSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listIngressRulesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_INGRESS_RULES_PAGE_STR_FACT);
            this.batchUpdateIngressRulesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createIngressRuleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIngressRuleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateIngressRuleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteIngressRuleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listIngressRulesSettings, this.batchUpdateIngressRulesSettings, this.createIngressRuleSettings, this.getIngressRuleSettings, this.updateIngressRuleSettings, this.deleteIngressRuleSettings);
            Builder.initDefaults(this);
        }

        protected Builder(FirewallStubSettings settings) {
            super((StubSettings)settings);
            this.listIngressRulesSettings = settings.listIngressRulesSettings.toBuilder();
            this.batchUpdateIngressRulesSettings = settings.batchUpdateIngressRulesSettings.toBuilder();
            this.createIngressRuleSettings = settings.createIngressRuleSettings.toBuilder();
            this.getIngressRuleSettings = settings.getIngressRuleSettings.toBuilder();
            this.updateIngressRuleSettings = settings.updateIngressRuleSettings.toBuilder();
            this.deleteIngressRuleSettings = settings.deleteIngressRuleSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listIngressRulesSettings, this.batchUpdateIngressRulesSettings, this.createIngressRuleSettings, this.getIngressRuleSettings, this.updateIngressRuleSettings, this.deleteIngressRuleSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(FirewallStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)FirewallStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)FirewallStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(FirewallStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)FirewallStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)FirewallStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)FirewallStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(FirewallStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listIngressRulesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.batchUpdateIngressRulesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createIngressRuleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getIngressRuleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.updateIngressRuleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.deleteIngressRuleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListIngressRulesRequest, ListIngressRulesResponse, FirewallClient.ListIngressRulesPagedResponse> listIngressRulesSettings() {
            return this.listIngressRulesSettings;
        }

        public UnaryCallSettings.Builder<BatchUpdateIngressRulesRequest, BatchUpdateIngressRulesResponse> batchUpdateIngressRulesSettings() {
            return this.batchUpdateIngressRulesSettings;
        }

        public UnaryCallSettings.Builder<CreateIngressRuleRequest, FirewallRule> createIngressRuleSettings() {
            return this.createIngressRuleSettings;
        }

        public UnaryCallSettings.Builder<GetIngressRuleRequest, FirewallRule> getIngressRuleSettings() {
            return this.getIngressRuleSettings;
        }

        public UnaryCallSettings.Builder<UpdateIngressRuleRequest, FirewallRule> updateIngressRuleSettings() {
            return this.updateIngressRuleSettings;
        }

        public UnaryCallSettings.Builder<DeleteIngressRuleRequest, Empty> deleteIngressRuleSettings() {
            return this.deleteIngressRuleSettings;
        }

        public FirewallStubSettings build() throws IOException {
            return new FirewallStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

