/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.appengine.v1.DebugInstanceRequest;
import com.google.appengine.v1.DeleteInstanceRequest;
import com.google.appengine.v1.GetInstanceRequest;
import com.google.appengine.v1.Instance;
import com.google.appengine.v1.InstancesClient;
import com.google.appengine.v1.ListInstancesRequest;
import com.google.appengine.v1.ListInstancesResponse;
import com.google.appengine.v1.OperationMetadataV1;
import com.google.appengine.v1.stub.GrpcInstancesCallableFactory;
import com.google.appengine.v1.stub.InstancesStub;
import com.google.appengine.v1.stub.InstancesStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GrpcInstancesStub
extends InstancesStub {
    private static final MethodDescriptor<ListInstancesRequest, ListInstancesResponse> listInstancesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.appengine.v1.Instances/ListInstances").setRequestMarshaller(ProtoUtils.marshaller((Message)ListInstancesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListInstancesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetInstanceRequest, Instance> getInstanceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.appengine.v1.Instances/GetInstance").setRequestMarshaller(ProtoUtils.marshaller((Message)GetInstanceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Instance.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteInstanceRequest, Operation> deleteInstanceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.appengine.v1.Instances/DeleteInstance").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteInstanceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DebugInstanceRequest, Operation> debugInstanceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.appengine.v1.Instances/DebugInstance").setRequestMarshaller(ProtoUtils.marshaller((Message)DebugInstanceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private final UnaryCallable<ListInstancesRequest, ListInstancesResponse> listInstancesCallable;
    private final UnaryCallable<ListInstancesRequest, InstancesClient.ListInstancesPagedResponse> listInstancesPagedCallable;
    private final UnaryCallable<GetInstanceRequest, Instance> getInstanceCallable;
    private final UnaryCallable<DeleteInstanceRequest, Operation> deleteInstanceCallable;
    private final OperationCallable<DeleteInstanceRequest, Empty, OperationMetadataV1> deleteInstanceOperationCallable;
    private final UnaryCallable<DebugInstanceRequest, Operation> debugInstanceCallable;
    private final OperationCallable<DebugInstanceRequest, Instance, OperationMetadataV1> debugInstanceOperationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcInstancesStub create(InstancesStubSettings settings) throws IOException {
        return new GrpcInstancesStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcInstancesStub create(ClientContext clientContext) throws IOException {
        return new GrpcInstancesStub(InstancesStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcInstancesStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcInstancesStub(InstancesStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcInstancesStub(InstancesStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcInstancesCallableFactory());
    }

    protected GrpcInstancesStub(InstancesStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listInstancesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listInstancesMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ListInstancesRequest>(){

            public Map<String, String> extract(ListInstancesRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings getInstanceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getInstanceMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetInstanceRequest>(){

            public Map<String, String> extract(GetInstanceRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings deleteInstanceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteInstanceMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<DeleteInstanceRequest>(){

            public Map<String, String> extract(DeleteInstanceRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings debugInstanceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(debugInstanceMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<DebugInstanceRequest>(){

            public Map<String, String> extract(DebugInstanceRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        this.listInstancesCallable = callableFactory.createUnaryCallable(listInstancesTransportSettings, settings.listInstancesSettings(), clientContext);
        this.listInstancesPagedCallable = callableFactory.createPagedCallable(listInstancesTransportSettings, settings.listInstancesSettings(), clientContext);
        this.getInstanceCallable = callableFactory.createUnaryCallable(getInstanceTransportSettings, settings.getInstanceSettings(), clientContext);
        this.deleteInstanceCallable = callableFactory.createUnaryCallable(deleteInstanceTransportSettings, settings.deleteInstanceSettings(), clientContext);
        this.deleteInstanceOperationCallable = callableFactory.createOperationCallable(deleteInstanceTransportSettings, settings.deleteInstanceOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.debugInstanceCallable = callableFactory.createUnaryCallable(debugInstanceTransportSettings, settings.debugInstanceSettings(), clientContext);
        this.debugInstanceOperationCallable = callableFactory.createOperationCallable(debugInstanceTransportSettings, settings.debugInstanceOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListInstancesRequest, ListInstancesResponse> listInstancesCallable() {
        return this.listInstancesCallable;
    }

    @Override
    public UnaryCallable<ListInstancesRequest, InstancesClient.ListInstancesPagedResponse> listInstancesPagedCallable() {
        return this.listInstancesPagedCallable;
    }

    @Override
    public UnaryCallable<GetInstanceRequest, Instance> getInstanceCallable() {
        return this.getInstanceCallable;
    }

    @Override
    public UnaryCallable<DeleteInstanceRequest, Operation> deleteInstanceCallable() {
        return this.deleteInstanceCallable;
    }

    @Override
    public OperationCallable<DeleteInstanceRequest, Empty, OperationMetadataV1> deleteInstanceOperationCallable() {
        return this.deleteInstanceOperationCallable;
    }

    @Override
    public UnaryCallable<DebugInstanceRequest, Operation> debugInstanceCallable() {
        return this.debugInstanceCallable;
    }

    @Override
    public OperationCallable<DebugInstanceRequest, Instance, OperationMetadataV1> debugInstanceOperationCallable() {
        return this.debugInstanceOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

