/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.appengine.v1.DeleteServiceRequest;
import com.google.appengine.v1.GetServiceRequest;
import com.google.appengine.v1.ListServicesRequest;
import com.google.appengine.v1.ListServicesResponse;
import com.google.appengine.v1.OperationMetadataV1;
import com.google.appengine.v1.Service;
import com.google.appengine.v1.ServicesClient;
import com.google.appengine.v1.UpdateServiceRequest;
import com.google.appengine.v1.stub.GrpcServicesCallableFactory;
import com.google.appengine.v1.stub.ServicesStub;
import com.google.appengine.v1.stub.ServicesStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GrpcServicesStub
extends ServicesStub {
    private static final MethodDescriptor<ListServicesRequest, ListServicesResponse> listServicesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.appengine.v1.Services/ListServices").setRequestMarshaller(ProtoUtils.marshaller((Message)ListServicesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListServicesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetServiceRequest, Service> getServiceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.appengine.v1.Services/GetService").setRequestMarshaller(ProtoUtils.marshaller((Message)GetServiceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Service.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateServiceRequest, Operation> updateServiceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.appengine.v1.Services/UpdateService").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateServiceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteServiceRequest, Operation> deleteServiceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.appengine.v1.Services/DeleteService").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteServiceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private final UnaryCallable<ListServicesRequest, ListServicesResponse> listServicesCallable;
    private final UnaryCallable<ListServicesRequest, ServicesClient.ListServicesPagedResponse> listServicesPagedCallable;
    private final UnaryCallable<GetServiceRequest, Service> getServiceCallable;
    private final UnaryCallable<UpdateServiceRequest, Operation> updateServiceCallable;
    private final OperationCallable<UpdateServiceRequest, Service, OperationMetadataV1> updateServiceOperationCallable;
    private final UnaryCallable<DeleteServiceRequest, Operation> deleteServiceCallable;
    private final OperationCallable<DeleteServiceRequest, Empty, OperationMetadataV1> deleteServiceOperationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcServicesStub create(ServicesStubSettings settings) throws IOException {
        return new GrpcServicesStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcServicesStub create(ClientContext clientContext) throws IOException {
        return new GrpcServicesStub(ServicesStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcServicesStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcServicesStub(ServicesStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcServicesStub(ServicesStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcServicesCallableFactory());
    }

    protected GrpcServicesStub(ServicesStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listServicesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listServicesMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ListServicesRequest>(){

            public Map<String, String> extract(ListServicesRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings getServiceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getServiceMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetServiceRequest>(){

            public Map<String, String> extract(GetServiceRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings updateServiceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateServiceMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<UpdateServiceRequest>(){

            public Map<String, String> extract(UpdateServiceRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings deleteServiceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteServiceMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<DeleteServiceRequest>(){

            public Map<String, String> extract(DeleteServiceRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        this.listServicesCallable = callableFactory.createUnaryCallable(listServicesTransportSettings, settings.listServicesSettings(), clientContext);
        this.listServicesPagedCallable = callableFactory.createPagedCallable(listServicesTransportSettings, settings.listServicesSettings(), clientContext);
        this.getServiceCallable = callableFactory.createUnaryCallable(getServiceTransportSettings, settings.getServiceSettings(), clientContext);
        this.updateServiceCallable = callableFactory.createUnaryCallable(updateServiceTransportSettings, settings.updateServiceSettings(), clientContext);
        this.updateServiceOperationCallable = callableFactory.createOperationCallable(updateServiceTransportSettings, settings.updateServiceOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteServiceCallable = callableFactory.createUnaryCallable(deleteServiceTransportSettings, settings.deleteServiceSettings(), clientContext);
        this.deleteServiceOperationCallable = callableFactory.createOperationCallable(deleteServiceTransportSettings, settings.deleteServiceOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListServicesRequest, ListServicesResponse> listServicesCallable() {
        return this.listServicesCallable;
    }

    @Override
    public UnaryCallable<ListServicesRequest, ServicesClient.ListServicesPagedResponse> listServicesPagedCallable() {
        return this.listServicesPagedCallable;
    }

    @Override
    public UnaryCallable<GetServiceRequest, Service> getServiceCallable() {
        return this.getServiceCallable;
    }

    @Override
    public UnaryCallable<UpdateServiceRequest, Operation> updateServiceCallable() {
        return this.updateServiceCallable;
    }

    @Override
    public OperationCallable<UpdateServiceRequest, Service, OperationMetadataV1> updateServiceOperationCallable() {
        return this.updateServiceOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteServiceRequest, Operation> deleteServiceCallable() {
        return this.deleteServiceCallable;
    }

    @Override
    public OperationCallable<DeleteServiceRequest, Empty, OperationMetadataV1> deleteServiceOperationCallable() {
        return this.deleteServiceOperationCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

