/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apihub.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.apihub.v1.CreateRuntimeProjectAttachmentRequest;
import com.google.cloud.apihub.v1.DeleteRuntimeProjectAttachmentRequest;
import com.google.cloud.apihub.v1.GetRuntimeProjectAttachmentRequest;
import com.google.cloud.apihub.v1.ListRuntimeProjectAttachmentsRequest;
import com.google.cloud.apihub.v1.ListRuntimeProjectAttachmentsResponse;
import com.google.cloud.apihub.v1.LocationName;
import com.google.cloud.apihub.v1.LookupRuntimeProjectAttachmentRequest;
import com.google.cloud.apihub.v1.LookupRuntimeProjectAttachmentResponse;
import com.google.cloud.apihub.v1.RuntimeProjectAttachment;
import com.google.cloud.apihub.v1.RuntimeProjectAttachmentName;
import com.google.cloud.apihub.v1.RuntimeProjectAttachmentServiceSettings;
import com.google.cloud.apihub.v1.stub.RuntimeProjectAttachmentServiceStub;
import com.google.cloud.apihub.v1.stub.RuntimeProjectAttachmentServiceStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class RuntimeProjectAttachmentServiceClient
implements BackgroundResource {
    private final RuntimeProjectAttachmentServiceSettings settings;
    private final RuntimeProjectAttachmentServiceStub stub;

    public static final RuntimeProjectAttachmentServiceClient create() throws IOException {
        return RuntimeProjectAttachmentServiceClient.create(RuntimeProjectAttachmentServiceSettings.newBuilder().build());
    }

    public static final RuntimeProjectAttachmentServiceClient create(RuntimeProjectAttachmentServiceSettings settings) throws IOException {
        return new RuntimeProjectAttachmentServiceClient(settings);
    }

    public static final RuntimeProjectAttachmentServiceClient create(RuntimeProjectAttachmentServiceStub stub) {
        return new RuntimeProjectAttachmentServiceClient(stub);
    }

    protected RuntimeProjectAttachmentServiceClient(RuntimeProjectAttachmentServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RuntimeProjectAttachmentServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected RuntimeProjectAttachmentServiceClient(RuntimeProjectAttachmentServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RuntimeProjectAttachmentServiceSettings getSettings() {
        return this.settings;
    }

    public RuntimeProjectAttachmentServiceStub getStub() {
        return this.stub;
    }

    public final RuntimeProjectAttachment createRuntimeProjectAttachment(LocationName parent, RuntimeProjectAttachment runtimeProjectAttachment, String runtimeProjectAttachmentId) {
        CreateRuntimeProjectAttachmentRequest request = CreateRuntimeProjectAttachmentRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setRuntimeProjectAttachment(runtimeProjectAttachment).setRuntimeProjectAttachmentId(runtimeProjectAttachmentId).build();
        return this.createRuntimeProjectAttachment(request);
    }

    public final RuntimeProjectAttachment createRuntimeProjectAttachment(String parent, RuntimeProjectAttachment runtimeProjectAttachment, String runtimeProjectAttachmentId) {
        CreateRuntimeProjectAttachmentRequest request = CreateRuntimeProjectAttachmentRequest.newBuilder().setParent(parent).setRuntimeProjectAttachment(runtimeProjectAttachment).setRuntimeProjectAttachmentId(runtimeProjectAttachmentId).build();
        return this.createRuntimeProjectAttachment(request);
    }

    public final RuntimeProjectAttachment createRuntimeProjectAttachment(CreateRuntimeProjectAttachmentRequest request) {
        return (RuntimeProjectAttachment)this.createRuntimeProjectAttachmentCallable().call((Object)request);
    }

    public final UnaryCallable<CreateRuntimeProjectAttachmentRequest, RuntimeProjectAttachment> createRuntimeProjectAttachmentCallable() {
        return this.stub.createRuntimeProjectAttachmentCallable();
    }

    public final RuntimeProjectAttachment getRuntimeProjectAttachment(RuntimeProjectAttachmentName name) {
        GetRuntimeProjectAttachmentRequest request = GetRuntimeProjectAttachmentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getRuntimeProjectAttachment(request);
    }

    public final RuntimeProjectAttachment getRuntimeProjectAttachment(String name) {
        GetRuntimeProjectAttachmentRequest request = GetRuntimeProjectAttachmentRequest.newBuilder().setName(name).build();
        return this.getRuntimeProjectAttachment(request);
    }

    public final RuntimeProjectAttachment getRuntimeProjectAttachment(GetRuntimeProjectAttachmentRequest request) {
        return (RuntimeProjectAttachment)this.getRuntimeProjectAttachmentCallable().call((Object)request);
    }

    public final UnaryCallable<GetRuntimeProjectAttachmentRequest, RuntimeProjectAttachment> getRuntimeProjectAttachmentCallable() {
        return this.stub.getRuntimeProjectAttachmentCallable();
    }

    public final ListRuntimeProjectAttachmentsPagedResponse listRuntimeProjectAttachments(LocationName parent) {
        ListRuntimeProjectAttachmentsRequest request = ListRuntimeProjectAttachmentsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listRuntimeProjectAttachments(request);
    }

    public final ListRuntimeProjectAttachmentsPagedResponse listRuntimeProjectAttachments(String parent) {
        ListRuntimeProjectAttachmentsRequest request = ListRuntimeProjectAttachmentsRequest.newBuilder().setParent(parent).build();
        return this.listRuntimeProjectAttachments(request);
    }

    public final ListRuntimeProjectAttachmentsPagedResponse listRuntimeProjectAttachments(ListRuntimeProjectAttachmentsRequest request) {
        return (ListRuntimeProjectAttachmentsPagedResponse)((Object)this.listRuntimeProjectAttachmentsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRuntimeProjectAttachmentsRequest, ListRuntimeProjectAttachmentsPagedResponse> listRuntimeProjectAttachmentsPagedCallable() {
        return this.stub.listRuntimeProjectAttachmentsPagedCallable();
    }

    public final UnaryCallable<ListRuntimeProjectAttachmentsRequest, ListRuntimeProjectAttachmentsResponse> listRuntimeProjectAttachmentsCallable() {
        return this.stub.listRuntimeProjectAttachmentsCallable();
    }

    public final void deleteRuntimeProjectAttachment(RuntimeProjectAttachmentName name) {
        DeleteRuntimeProjectAttachmentRequest request = DeleteRuntimeProjectAttachmentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteRuntimeProjectAttachment(request);
    }

    public final void deleteRuntimeProjectAttachment(String name) {
        DeleteRuntimeProjectAttachmentRequest request = DeleteRuntimeProjectAttachmentRequest.newBuilder().setName(name).build();
        this.deleteRuntimeProjectAttachment(request);
    }

    public final void deleteRuntimeProjectAttachment(DeleteRuntimeProjectAttachmentRequest request) {
        this.deleteRuntimeProjectAttachmentCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteRuntimeProjectAttachmentRequest, Empty> deleteRuntimeProjectAttachmentCallable() {
        return this.stub.deleteRuntimeProjectAttachmentCallable();
    }

    public final LookupRuntimeProjectAttachmentResponse lookupRuntimeProjectAttachment(LocationName name) {
        LookupRuntimeProjectAttachmentRequest request = LookupRuntimeProjectAttachmentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.lookupRuntimeProjectAttachment(request);
    }

    public final LookupRuntimeProjectAttachmentResponse lookupRuntimeProjectAttachment(String name) {
        LookupRuntimeProjectAttachmentRequest request = LookupRuntimeProjectAttachmentRequest.newBuilder().setName(name).build();
        return this.lookupRuntimeProjectAttachment(request);
    }

    public final LookupRuntimeProjectAttachmentResponse lookupRuntimeProjectAttachment(LookupRuntimeProjectAttachmentRequest request) {
        return (LookupRuntimeProjectAttachmentResponse)this.lookupRuntimeProjectAttachmentCallable().call((Object)request);
    }

    public final UnaryCallable<LookupRuntimeProjectAttachmentRequest, LookupRuntimeProjectAttachmentResponse> lookupRuntimeProjectAttachmentCallable() {
        return this.stub.lookupRuntimeProjectAttachmentCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListRuntimeProjectAttachmentsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRuntimeProjectAttachmentsRequest, ListRuntimeProjectAttachmentsResponse, RuntimeProjectAttachment, ListRuntimeProjectAttachmentsPage, ListRuntimeProjectAttachmentsFixedSizeCollection> {
        private ListRuntimeProjectAttachmentsFixedSizeCollection(List<ListRuntimeProjectAttachmentsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRuntimeProjectAttachmentsFixedSizeCollection createEmptyCollection() {
            return new ListRuntimeProjectAttachmentsFixedSizeCollection(null, 0);
        }

        protected ListRuntimeProjectAttachmentsFixedSizeCollection createCollection(List<ListRuntimeProjectAttachmentsPage> pages, int collectionSize) {
            return new ListRuntimeProjectAttachmentsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRuntimeProjectAttachmentsPage
    extends AbstractPage<ListRuntimeProjectAttachmentsRequest, ListRuntimeProjectAttachmentsResponse, RuntimeProjectAttachment, ListRuntimeProjectAttachmentsPage> {
        private ListRuntimeProjectAttachmentsPage(PageContext<ListRuntimeProjectAttachmentsRequest, ListRuntimeProjectAttachmentsResponse, RuntimeProjectAttachment> context, ListRuntimeProjectAttachmentsResponse response) {
            super(context, (Object)response);
        }

        private static ListRuntimeProjectAttachmentsPage createEmptyPage() {
            return new ListRuntimeProjectAttachmentsPage(null, null);
        }

        protected ListRuntimeProjectAttachmentsPage createPage(PageContext<ListRuntimeProjectAttachmentsRequest, ListRuntimeProjectAttachmentsResponse, RuntimeProjectAttachment> context, ListRuntimeProjectAttachmentsResponse response) {
            return new ListRuntimeProjectAttachmentsPage(context, response);
        }

        public ApiFuture<ListRuntimeProjectAttachmentsPage> createPageAsync(PageContext<ListRuntimeProjectAttachmentsRequest, ListRuntimeProjectAttachmentsResponse, RuntimeProjectAttachment> context, ApiFuture<ListRuntimeProjectAttachmentsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRuntimeProjectAttachmentsPagedResponse
    extends AbstractPagedListResponse<ListRuntimeProjectAttachmentsRequest, ListRuntimeProjectAttachmentsResponse, RuntimeProjectAttachment, ListRuntimeProjectAttachmentsPage, ListRuntimeProjectAttachmentsFixedSizeCollection> {
        public static ApiFuture<ListRuntimeProjectAttachmentsPagedResponse> createAsync(PageContext<ListRuntimeProjectAttachmentsRequest, ListRuntimeProjectAttachmentsResponse, RuntimeProjectAttachment> context, ApiFuture<ListRuntimeProjectAttachmentsResponse> futureResponse) {
            ApiFuture<ListRuntimeProjectAttachmentsPage> futurePage = ListRuntimeProjectAttachmentsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListRuntimeProjectAttachmentsPagedResponse((ListRuntimeProjectAttachmentsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListRuntimeProjectAttachmentsPagedResponse(ListRuntimeProjectAttachmentsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRuntimeProjectAttachmentsFixedSizeCollection.createEmptyCollection());
        }
    }
}

