/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apihub.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.apihub.v1.ApiHubDependenciesClient;
import com.google.cloud.apihub.v1.CreateDependencyRequest;
import com.google.cloud.apihub.v1.DeleteDependencyRequest;
import com.google.cloud.apihub.v1.Dependency;
import com.google.cloud.apihub.v1.GetDependencyRequest;
import com.google.cloud.apihub.v1.ListDependenciesRequest;
import com.google.cloud.apihub.v1.ListDependenciesResponse;
import com.google.cloud.apihub.v1.UpdateDependencyRequest;
import com.google.cloud.apihub.v1.stub.ApiHubDependenciesStub;
import com.google.cloud.apihub.v1.stub.HttpJsonApiHubDependenciesStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class ApiHubDependenciesStubSettings
extends StubSettings<ApiHubDependenciesStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateDependencyRequest, Dependency> createDependencySettings;
    private final UnaryCallSettings<GetDependencyRequest, Dependency> getDependencySettings;
    private final UnaryCallSettings<UpdateDependencyRequest, Dependency> updateDependencySettings;
    private final UnaryCallSettings<DeleteDependencyRequest, Empty> deleteDependencySettings;
    private final PagedCallSettings<ListDependenciesRequest, ListDependenciesResponse, ApiHubDependenciesClient.ListDependenciesPagedResponse> listDependenciesSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, ApiHubDependenciesClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListDependenciesRequest, ListDependenciesResponse, Dependency> LIST_DEPENDENCIES_PAGE_STR_DESC = new PagedListDescriptor<ListDependenciesRequest, ListDependenciesResponse, Dependency>(){

        public String emptyToken() {
            return "";
        }

        public ListDependenciesRequest injectToken(ListDependenciesRequest payload, String token) {
            return ListDependenciesRequest.newBuilder((ListDependenciesRequest)payload).setPageToken(token).build();
        }

        public ListDependenciesRequest injectPageSize(ListDependenciesRequest payload, int pageSize) {
            return ListDependenciesRequest.newBuilder((ListDependenciesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDependenciesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDependenciesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Dependency> extractResources(ListDependenciesResponse payload) {
            return payload.getDependenciesList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListDependenciesRequest, ListDependenciesResponse, ApiHubDependenciesClient.ListDependenciesPagedResponse> LIST_DEPENDENCIES_PAGE_STR_FACT = new PagedListResponseFactory<ListDependenciesRequest, ListDependenciesResponse, ApiHubDependenciesClient.ListDependenciesPagedResponse>(){

        public ApiFuture<ApiHubDependenciesClient.ListDependenciesPagedResponse> getFuturePagedResponse(UnaryCallable<ListDependenciesRequest, ListDependenciesResponse> callable, ListDependenciesRequest request, ApiCallContext context, ApiFuture<ListDependenciesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DEPENDENCIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ApiHubDependenciesClient.ListDependenciesPagedResponse.createAsync((PageContext<ListDependenciesRequest, ListDependenciesResponse, Dependency>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, ApiHubDependenciesClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, ApiHubDependenciesClient.ListLocationsPagedResponse>(){

        public ApiFuture<ApiHubDependenciesClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ApiHubDependenciesClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateDependencyRequest, Dependency> createDependencySettings() {
        return this.createDependencySettings;
    }

    public UnaryCallSettings<GetDependencyRequest, Dependency> getDependencySettings() {
        return this.getDependencySettings;
    }

    public UnaryCallSettings<UpdateDependencyRequest, Dependency> updateDependencySettings() {
        return this.updateDependencySettings;
    }

    public UnaryCallSettings<DeleteDependencyRequest, Empty> deleteDependencySettings() {
        return this.deleteDependencySettings;
    }

    public PagedCallSettings<ListDependenciesRequest, ListDependenciesResponse, ApiHubDependenciesClient.ListDependenciesPagedResponse> listDependenciesSettings() {
        return this.listDependenciesSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, ApiHubDependenciesClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public ApiHubDependenciesStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonApiHubDependenciesStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "apihub";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "apihub.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "apihub.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ApiHubDependenciesStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ApiHubDependenciesStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ApiHubDependenciesStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createDependencySettings = settingsBuilder.createDependencySettings().build();
        this.getDependencySettings = settingsBuilder.getDependencySettings().build();
        this.updateDependencySettings = settingsBuilder.updateDependencySettings().build();
        this.deleteDependencySettings = settingsBuilder.deleteDependencySettings().build();
        this.listDependenciesSettings = settingsBuilder.listDependenciesSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ApiHubDependenciesStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateDependencyRequest, Dependency> createDependencySettings;
        private final UnaryCallSettings.Builder<GetDependencyRequest, Dependency> getDependencySettings;
        private final UnaryCallSettings.Builder<UpdateDependencyRequest, Dependency> updateDependencySettings;
        private final UnaryCallSettings.Builder<DeleteDependencyRequest, Empty> deleteDependencySettings;
        private final PagedCallSettings.Builder<ListDependenciesRequest, ListDependenciesResponse, ApiHubDependenciesClient.ListDependenciesPagedResponse> listDependenciesSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, ApiHubDependenciesClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createDependencySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getDependencySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateDependencySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteDependencySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listDependenciesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DEPENDENCIES_PAGE_STR_FACT);
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createDependencySettings, this.getDependencySettings, this.updateDependencySettings, this.deleteDependencySettings, this.listDependenciesSettings, this.listLocationsSettings, this.getLocationSettings);
            Builder.initDefaults(this);
        }

        protected Builder(ApiHubDependenciesStubSettings settings) {
            super((StubSettings)settings);
            this.createDependencySettings = settings.createDependencySettings.toBuilder();
            this.getDependencySettings = settings.getDependencySettings.toBuilder();
            this.updateDependencySettings = settings.updateDependencySettings.toBuilder();
            this.deleteDependencySettings = settings.deleteDependencySettings.toBuilder();
            this.listDependenciesSettings = settings.listDependenciesSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createDependencySettings, this.getDependencySettings, this.updateDependencySettings, this.deleteDependencySettings, this.listDependenciesSettings, this.listLocationsSettings, this.getLocationSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ApiHubDependenciesStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ApiHubDependenciesStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ApiHubDependenciesStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ApiHubDependenciesStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createDependencySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getDependencySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateDependencySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteDependencySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listDependenciesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateDependencyRequest, Dependency> createDependencySettings() {
            return this.createDependencySettings;
        }

        public UnaryCallSettings.Builder<GetDependencyRequest, Dependency> getDependencySettings() {
            return this.getDependencySettings;
        }

        public UnaryCallSettings.Builder<UpdateDependencyRequest, Dependency> updateDependencySettings() {
            return this.updateDependencySettings;
        }

        public UnaryCallSettings.Builder<DeleteDependencyRequest, Empty> deleteDependencySettings() {
            return this.deleteDependencySettings;
        }

        public PagedCallSettings.Builder<ListDependenciesRequest, ListDependenciesResponse, ApiHubDependenciesClient.ListDependenciesPagedResponse> listDependenciesSettings() {
            return this.listDependenciesSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, ApiHubDependenciesClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public ApiHubDependenciesStubSettings build() throws IOException {
            return new ApiHubDependenciesStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

