/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apigeeconnect.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.cloud.apigeeconnect.v1.EgressRequest;
import com.google.cloud.apigeeconnect.v1.EgressResponse;
import com.google.cloud.apigeeconnect.v1.stub.GrpcTetherCallableFactory;
import com.google.cloud.apigeeconnect.v1.stub.TetherStub;
import com.google.cloud.apigeeconnect.v1.stub.TetherStubSettings;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcTetherStub
extends TetherStub {
    private static final MethodDescriptor<EgressResponse, EgressRequest> egressMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.BIDI_STREAMING).setFullMethodName("google.cloud.apigeeconnect.v1.Tether/Egress").setRequestMarshaller(ProtoUtils.marshaller((Message)EgressResponse.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)EgressRequest.getDefaultInstance())).build();
    private final BidiStreamingCallable<EgressResponse, EgressRequest> egressCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcTetherStub create(TetherStubSettings settings) throws IOException {
        return new GrpcTetherStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcTetherStub create(ClientContext clientContext) throws IOException {
        return new GrpcTetherStub(TetherStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcTetherStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcTetherStub(TetherStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcTetherStub(TetherStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcTetherCallableFactory());
    }

    protected GrpcTetherStub(TetherStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings egressTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(egressMethodDescriptor).build();
        this.egressCallable = callableFactory.createBidiStreamingCallable(egressTransportSettings, settings.egressSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public BidiStreamingCallable<EgressResponse, EgressRequest> egressCallable() {
        return this.egressCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

