/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apigateway.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.apigateway.v1.Api;
import com.google.cloud.apigateway.v1.ApiConfig;
import com.google.cloud.apigateway.v1.ApiConfigName;
import com.google.cloud.apigateway.v1.ApiGatewayServiceSettings;
import com.google.cloud.apigateway.v1.ApiName;
import com.google.cloud.apigateway.v1.CreateApiConfigRequest;
import com.google.cloud.apigateway.v1.CreateApiRequest;
import com.google.cloud.apigateway.v1.CreateGatewayRequest;
import com.google.cloud.apigateway.v1.DeleteApiConfigRequest;
import com.google.cloud.apigateway.v1.DeleteApiRequest;
import com.google.cloud.apigateway.v1.DeleteGatewayRequest;
import com.google.cloud.apigateway.v1.Gateway;
import com.google.cloud.apigateway.v1.GatewayName;
import com.google.cloud.apigateway.v1.GetApiConfigRequest;
import com.google.cloud.apigateway.v1.GetApiRequest;
import com.google.cloud.apigateway.v1.GetGatewayRequest;
import com.google.cloud.apigateway.v1.ListApiConfigsRequest;
import com.google.cloud.apigateway.v1.ListApiConfigsResponse;
import com.google.cloud.apigateway.v1.ListApisRequest;
import com.google.cloud.apigateway.v1.ListApisResponse;
import com.google.cloud.apigateway.v1.ListGatewaysRequest;
import com.google.cloud.apigateway.v1.ListGatewaysResponse;
import com.google.cloud.apigateway.v1.LocationName;
import com.google.cloud.apigateway.v1.OperationMetadata;
import com.google.cloud.apigateway.v1.UpdateApiConfigRequest;
import com.google.cloud.apigateway.v1.UpdateApiRequest;
import com.google.cloud.apigateway.v1.UpdateGatewayRequest;
import com.google.cloud.apigateway.v1.stub.ApiGatewayServiceStub;
import com.google.cloud.apigateway.v1.stub.ApiGatewayServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ApiGatewayServiceClient
implements BackgroundResource {
    private final ApiGatewayServiceSettings settings;
    private final ApiGatewayServiceStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final ApiGatewayServiceClient create() throws IOException {
        return ApiGatewayServiceClient.create(ApiGatewayServiceSettings.newBuilder().build());
    }

    public static final ApiGatewayServiceClient create(ApiGatewayServiceSettings settings) throws IOException {
        return new ApiGatewayServiceClient(settings);
    }

    public static final ApiGatewayServiceClient create(ApiGatewayServiceStub stub) {
        return new ApiGatewayServiceClient(stub);
    }

    protected ApiGatewayServiceClient(ApiGatewayServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ApiGatewayServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected ApiGatewayServiceClient(ApiGatewayServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final ApiGatewayServiceSettings getSettings() {
        return this.settings;
    }

    public ApiGatewayServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final ListGatewaysPagedResponse listGateways(LocationName parent) {
        ListGatewaysRequest request = ListGatewaysRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listGateways(request);
    }

    public final ListGatewaysPagedResponse listGateways(String parent) {
        ListGatewaysRequest request = ListGatewaysRequest.newBuilder().setParent(parent).build();
        return this.listGateways(request);
    }

    public final ListGatewaysPagedResponse listGateways(ListGatewaysRequest request) {
        return (ListGatewaysPagedResponse)((Object)this.listGatewaysPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListGatewaysRequest, ListGatewaysPagedResponse> listGatewaysPagedCallable() {
        return this.stub.listGatewaysPagedCallable();
    }

    public final UnaryCallable<ListGatewaysRequest, ListGatewaysResponse> listGatewaysCallable() {
        return this.stub.listGatewaysCallable();
    }

    public final Gateway getGateway(GatewayName name) {
        GetGatewayRequest request = GetGatewayRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getGateway(request);
    }

    public final Gateway getGateway(String name) {
        GetGatewayRequest request = GetGatewayRequest.newBuilder().setName(name).build();
        return this.getGateway(request);
    }

    public final Gateway getGateway(GetGatewayRequest request) {
        return (Gateway)this.getGatewayCallable().call((Object)request);
    }

    public final UnaryCallable<GetGatewayRequest, Gateway> getGatewayCallable() {
        return this.stub.getGatewayCallable();
    }

    public final OperationFuture<Gateway, OperationMetadata> createGatewayAsync(LocationName parent, Gateway gateway, String gatewayId) {
        CreateGatewayRequest request = CreateGatewayRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setGateway(gateway).setGatewayId(gatewayId).build();
        return this.createGatewayAsync(request);
    }

    public final OperationFuture<Gateway, OperationMetadata> createGatewayAsync(String parent, Gateway gateway, String gatewayId) {
        CreateGatewayRequest request = CreateGatewayRequest.newBuilder().setParent(parent).setGateway(gateway).setGatewayId(gatewayId).build();
        return this.createGatewayAsync(request);
    }

    public final OperationFuture<Gateway, OperationMetadata> createGatewayAsync(CreateGatewayRequest request) {
        return this.createGatewayOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateGatewayRequest, Gateway, OperationMetadata> createGatewayOperationCallable() {
        return this.stub.createGatewayOperationCallable();
    }

    public final UnaryCallable<CreateGatewayRequest, Operation> createGatewayCallable() {
        return this.stub.createGatewayCallable();
    }

    public final OperationFuture<Gateway, OperationMetadata> updateGatewayAsync(Gateway gateway, FieldMask updateMask) {
        UpdateGatewayRequest request = UpdateGatewayRequest.newBuilder().setGateway(gateway).setUpdateMask(updateMask).build();
        return this.updateGatewayAsync(request);
    }

    public final OperationFuture<Gateway, OperationMetadata> updateGatewayAsync(UpdateGatewayRequest request) {
        return this.updateGatewayOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateGatewayRequest, Gateway, OperationMetadata> updateGatewayOperationCallable() {
        return this.stub.updateGatewayOperationCallable();
    }

    public final UnaryCallable<UpdateGatewayRequest, Operation> updateGatewayCallable() {
        return this.stub.updateGatewayCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteGatewayAsync(GatewayName name) {
        DeleteGatewayRequest request = DeleteGatewayRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteGatewayAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteGatewayAsync(String name) {
        DeleteGatewayRequest request = DeleteGatewayRequest.newBuilder().setName(name).build();
        return this.deleteGatewayAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteGatewayAsync(DeleteGatewayRequest request) {
        return this.deleteGatewayOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteGatewayRequest, Empty, OperationMetadata> deleteGatewayOperationCallable() {
        return this.stub.deleteGatewayOperationCallable();
    }

    public final UnaryCallable<DeleteGatewayRequest, Operation> deleteGatewayCallable() {
        return this.stub.deleteGatewayCallable();
    }

    public final ListApisPagedResponse listApis(LocationName parent) {
        ListApisRequest request = ListApisRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listApis(request);
    }

    public final ListApisPagedResponse listApis(String parent) {
        ListApisRequest request = ListApisRequest.newBuilder().setParent(parent).build();
        return this.listApis(request);
    }

    public final ListApisPagedResponse listApis(ListApisRequest request) {
        return (ListApisPagedResponse)((Object)this.listApisPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListApisRequest, ListApisPagedResponse> listApisPagedCallable() {
        return this.stub.listApisPagedCallable();
    }

    public final UnaryCallable<ListApisRequest, ListApisResponse> listApisCallable() {
        return this.stub.listApisCallable();
    }

    public final Api getApi(ApiName name) {
        GetApiRequest request = GetApiRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getApi(request);
    }

    public final Api getApi(String name) {
        GetApiRequest request = GetApiRequest.newBuilder().setName(name).build();
        return this.getApi(request);
    }

    public final Api getApi(GetApiRequest request) {
        return (Api)this.getApiCallable().call((Object)request);
    }

    public final UnaryCallable<GetApiRequest, Api> getApiCallable() {
        return this.stub.getApiCallable();
    }

    public final OperationFuture<Api, OperationMetadata> createApiAsync(LocationName parent, Api api, String apiId) {
        CreateApiRequest request = CreateApiRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setApi(api).setApiId(apiId).build();
        return this.createApiAsync(request);
    }

    public final OperationFuture<Api, OperationMetadata> createApiAsync(String parent, Api api, String apiId) {
        CreateApiRequest request = CreateApiRequest.newBuilder().setParent(parent).setApi(api).setApiId(apiId).build();
        return this.createApiAsync(request);
    }

    public final OperationFuture<Api, OperationMetadata> createApiAsync(CreateApiRequest request) {
        return this.createApiOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateApiRequest, Api, OperationMetadata> createApiOperationCallable() {
        return this.stub.createApiOperationCallable();
    }

    public final UnaryCallable<CreateApiRequest, Operation> createApiCallable() {
        return this.stub.createApiCallable();
    }

    public final OperationFuture<Api, OperationMetadata> updateApiAsync(Api api, FieldMask updateMask) {
        UpdateApiRequest request = UpdateApiRequest.newBuilder().setApi(api).setUpdateMask(updateMask).build();
        return this.updateApiAsync(request);
    }

    public final OperationFuture<Api, OperationMetadata> updateApiAsync(UpdateApiRequest request) {
        return this.updateApiOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateApiRequest, Api, OperationMetadata> updateApiOperationCallable() {
        return this.stub.updateApiOperationCallable();
    }

    public final UnaryCallable<UpdateApiRequest, Operation> updateApiCallable() {
        return this.stub.updateApiCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteApiAsync(ApiName name) {
        DeleteApiRequest request = DeleteApiRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteApiAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteApiAsync(String name) {
        DeleteApiRequest request = DeleteApiRequest.newBuilder().setName(name).build();
        return this.deleteApiAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteApiAsync(DeleteApiRequest request) {
        return this.deleteApiOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteApiRequest, Empty, OperationMetadata> deleteApiOperationCallable() {
        return this.stub.deleteApiOperationCallable();
    }

    public final UnaryCallable<DeleteApiRequest, Operation> deleteApiCallable() {
        return this.stub.deleteApiCallable();
    }

    public final ListApiConfigsPagedResponse listApiConfigs(ApiName parent) {
        ListApiConfigsRequest request = ListApiConfigsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listApiConfigs(request);
    }

    public final ListApiConfigsPagedResponse listApiConfigs(String parent) {
        ListApiConfigsRequest request = ListApiConfigsRequest.newBuilder().setParent(parent).build();
        return this.listApiConfigs(request);
    }

    public final ListApiConfigsPagedResponse listApiConfigs(ListApiConfigsRequest request) {
        return (ListApiConfigsPagedResponse)((Object)this.listApiConfigsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListApiConfigsRequest, ListApiConfigsPagedResponse> listApiConfigsPagedCallable() {
        return this.stub.listApiConfigsPagedCallable();
    }

    public final UnaryCallable<ListApiConfigsRequest, ListApiConfigsResponse> listApiConfigsCallable() {
        return this.stub.listApiConfigsCallable();
    }

    public final ApiConfig getApiConfig(ApiConfigName name) {
        GetApiConfigRequest request = GetApiConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getApiConfig(request);
    }

    public final ApiConfig getApiConfig(String name) {
        GetApiConfigRequest request = GetApiConfigRequest.newBuilder().setName(name).build();
        return this.getApiConfig(request);
    }

    public final ApiConfig getApiConfig(GetApiConfigRequest request) {
        return (ApiConfig)this.getApiConfigCallable().call((Object)request);
    }

    public final UnaryCallable<GetApiConfigRequest, ApiConfig> getApiConfigCallable() {
        return this.stub.getApiConfigCallable();
    }

    public final OperationFuture<ApiConfig, OperationMetadata> createApiConfigAsync(ApiName parent, ApiConfig apiConfig, String apiConfigId) {
        CreateApiConfigRequest request = CreateApiConfigRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setApiConfig(apiConfig).setApiConfigId(apiConfigId).build();
        return this.createApiConfigAsync(request);
    }

    public final OperationFuture<ApiConfig, OperationMetadata> createApiConfigAsync(String parent, ApiConfig apiConfig, String apiConfigId) {
        CreateApiConfigRequest request = CreateApiConfigRequest.newBuilder().setParent(parent).setApiConfig(apiConfig).setApiConfigId(apiConfigId).build();
        return this.createApiConfigAsync(request);
    }

    public final OperationFuture<ApiConfig, OperationMetadata> createApiConfigAsync(CreateApiConfigRequest request) {
        return this.createApiConfigOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateApiConfigRequest, ApiConfig, OperationMetadata> createApiConfigOperationCallable() {
        return this.stub.createApiConfigOperationCallable();
    }

    public final UnaryCallable<CreateApiConfigRequest, Operation> createApiConfigCallable() {
        return this.stub.createApiConfigCallable();
    }

    public final OperationFuture<ApiConfig, OperationMetadata> updateApiConfigAsync(ApiConfig apiConfig, FieldMask updateMask) {
        UpdateApiConfigRequest request = UpdateApiConfigRequest.newBuilder().setApiConfig(apiConfig).setUpdateMask(updateMask).build();
        return this.updateApiConfigAsync(request);
    }

    public final OperationFuture<ApiConfig, OperationMetadata> updateApiConfigAsync(UpdateApiConfigRequest request) {
        return this.updateApiConfigOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateApiConfigRequest, ApiConfig, OperationMetadata> updateApiConfigOperationCallable() {
        return this.stub.updateApiConfigOperationCallable();
    }

    public final UnaryCallable<UpdateApiConfigRequest, Operation> updateApiConfigCallable() {
        return this.stub.updateApiConfigCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteApiConfigAsync(ApiConfigName name) {
        DeleteApiConfigRequest request = DeleteApiConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteApiConfigAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteApiConfigAsync(String name) {
        DeleteApiConfigRequest request = DeleteApiConfigRequest.newBuilder().setName(name).build();
        return this.deleteApiConfigAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteApiConfigAsync(DeleteApiConfigRequest request) {
        return this.deleteApiConfigOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteApiConfigRequest, Empty, OperationMetadata> deleteApiConfigOperationCallable() {
        return this.stub.deleteApiConfigOperationCallable();
    }

    public final UnaryCallable<DeleteApiConfigRequest, Operation> deleteApiConfigCallable() {
        return this.stub.deleteApiConfigCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListApiConfigsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListApiConfigsRequest, ListApiConfigsResponse, ApiConfig, ListApiConfigsPage, ListApiConfigsFixedSizeCollection> {
        private ListApiConfigsFixedSizeCollection(List<ListApiConfigsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListApiConfigsFixedSizeCollection createEmptyCollection() {
            return new ListApiConfigsFixedSizeCollection(null, 0);
        }

        protected ListApiConfigsFixedSizeCollection createCollection(List<ListApiConfigsPage> pages, int collectionSize) {
            return new ListApiConfigsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListApiConfigsPage
    extends AbstractPage<ListApiConfigsRequest, ListApiConfigsResponse, ApiConfig, ListApiConfigsPage> {
        private ListApiConfigsPage(PageContext<ListApiConfigsRequest, ListApiConfigsResponse, ApiConfig> context, ListApiConfigsResponse response) {
            super(context, (Object)response);
        }

        private static ListApiConfigsPage createEmptyPage() {
            return new ListApiConfigsPage(null, null);
        }

        protected ListApiConfigsPage createPage(PageContext<ListApiConfigsRequest, ListApiConfigsResponse, ApiConfig> context, ListApiConfigsResponse response) {
            return new ListApiConfigsPage(context, response);
        }

        public ApiFuture<ListApiConfigsPage> createPageAsync(PageContext<ListApiConfigsRequest, ListApiConfigsResponse, ApiConfig> context, ApiFuture<ListApiConfigsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListApiConfigsPagedResponse
    extends AbstractPagedListResponse<ListApiConfigsRequest, ListApiConfigsResponse, ApiConfig, ListApiConfigsPage, ListApiConfigsFixedSizeCollection> {
        public static ApiFuture<ListApiConfigsPagedResponse> createAsync(PageContext<ListApiConfigsRequest, ListApiConfigsResponse, ApiConfig> context, ApiFuture<ListApiConfigsResponse> futureResponse) {
            ApiFuture<ListApiConfigsPage> futurePage = ListApiConfigsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListApiConfigsPagedResponse((ListApiConfigsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListApiConfigsPagedResponse(ListApiConfigsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListApiConfigsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListApisFixedSizeCollection
    extends AbstractFixedSizeCollection<ListApisRequest, ListApisResponse, Api, ListApisPage, ListApisFixedSizeCollection> {
        private ListApisFixedSizeCollection(List<ListApisPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListApisFixedSizeCollection createEmptyCollection() {
            return new ListApisFixedSizeCollection(null, 0);
        }

        protected ListApisFixedSizeCollection createCollection(List<ListApisPage> pages, int collectionSize) {
            return new ListApisFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListApisPage
    extends AbstractPage<ListApisRequest, ListApisResponse, Api, ListApisPage> {
        private ListApisPage(PageContext<ListApisRequest, ListApisResponse, Api> context, ListApisResponse response) {
            super(context, (Object)response);
        }

        private static ListApisPage createEmptyPage() {
            return new ListApisPage(null, null);
        }

        protected ListApisPage createPage(PageContext<ListApisRequest, ListApisResponse, Api> context, ListApisResponse response) {
            return new ListApisPage(context, response);
        }

        public ApiFuture<ListApisPage> createPageAsync(PageContext<ListApisRequest, ListApisResponse, Api> context, ApiFuture<ListApisResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListApisPagedResponse
    extends AbstractPagedListResponse<ListApisRequest, ListApisResponse, Api, ListApisPage, ListApisFixedSizeCollection> {
        public static ApiFuture<ListApisPagedResponse> createAsync(PageContext<ListApisRequest, ListApisResponse, Api> context, ApiFuture<ListApisResponse> futureResponse) {
            ApiFuture<ListApisPage> futurePage = ListApisPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListApisPagedResponse((ListApisPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListApisPagedResponse(ListApisPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListApisFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListGatewaysFixedSizeCollection
    extends AbstractFixedSizeCollection<ListGatewaysRequest, ListGatewaysResponse, Gateway, ListGatewaysPage, ListGatewaysFixedSizeCollection> {
        private ListGatewaysFixedSizeCollection(List<ListGatewaysPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListGatewaysFixedSizeCollection createEmptyCollection() {
            return new ListGatewaysFixedSizeCollection(null, 0);
        }

        protected ListGatewaysFixedSizeCollection createCollection(List<ListGatewaysPage> pages, int collectionSize) {
            return new ListGatewaysFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListGatewaysPage
    extends AbstractPage<ListGatewaysRequest, ListGatewaysResponse, Gateway, ListGatewaysPage> {
        private ListGatewaysPage(PageContext<ListGatewaysRequest, ListGatewaysResponse, Gateway> context, ListGatewaysResponse response) {
            super(context, (Object)response);
        }

        private static ListGatewaysPage createEmptyPage() {
            return new ListGatewaysPage(null, null);
        }

        protected ListGatewaysPage createPage(PageContext<ListGatewaysRequest, ListGatewaysResponse, Gateway> context, ListGatewaysResponse response) {
            return new ListGatewaysPage(context, response);
        }

        public ApiFuture<ListGatewaysPage> createPageAsync(PageContext<ListGatewaysRequest, ListGatewaysResponse, Gateway> context, ApiFuture<ListGatewaysResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListGatewaysPagedResponse
    extends AbstractPagedListResponse<ListGatewaysRequest, ListGatewaysResponse, Gateway, ListGatewaysPage, ListGatewaysFixedSizeCollection> {
        public static ApiFuture<ListGatewaysPagedResponse> createAsync(PageContext<ListGatewaysRequest, ListGatewaysResponse, Gateway> context, ApiFuture<ListGatewaysResponse> futureResponse) {
            ApiFuture<ListGatewaysPage> futurePage = ListGatewaysPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListGatewaysPagedResponse((ListGatewaysPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListGatewaysPagedResponse(ListGatewaysPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListGatewaysFixedSizeCollection.createEmptyCollection());
        }
    }
}

