/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.analyticshub.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.resourcenames.ResourceName;
import com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubServiceSettings;
import com.google.cloud.bigquery.analyticshub.v1.ApproveQueryTemplateRequest;
import com.google.cloud.bigquery.analyticshub.v1.CreateDataExchangeRequest;
import com.google.cloud.bigquery.analyticshub.v1.CreateListingRequest;
import com.google.cloud.bigquery.analyticshub.v1.CreateQueryTemplateRequest;
import com.google.cloud.bigquery.analyticshub.v1.DataExchange;
import com.google.cloud.bigquery.analyticshub.v1.DataExchangeName;
import com.google.cloud.bigquery.analyticshub.v1.DeleteDataExchangeRequest;
import com.google.cloud.bigquery.analyticshub.v1.DeleteListingRequest;
import com.google.cloud.bigquery.analyticshub.v1.DeleteQueryTemplateRequest;
import com.google.cloud.bigquery.analyticshub.v1.DeleteSubscriptionRequest;
import com.google.cloud.bigquery.analyticshub.v1.GetDataExchangeRequest;
import com.google.cloud.bigquery.analyticshub.v1.GetListingRequest;
import com.google.cloud.bigquery.analyticshub.v1.GetQueryTemplateRequest;
import com.google.cloud.bigquery.analyticshub.v1.GetSubscriptionRequest;
import com.google.cloud.bigquery.analyticshub.v1.ListDataExchangesRequest;
import com.google.cloud.bigquery.analyticshub.v1.ListDataExchangesResponse;
import com.google.cloud.bigquery.analyticshub.v1.ListListingsRequest;
import com.google.cloud.bigquery.analyticshub.v1.ListListingsResponse;
import com.google.cloud.bigquery.analyticshub.v1.ListOrgDataExchangesRequest;
import com.google.cloud.bigquery.analyticshub.v1.ListOrgDataExchangesResponse;
import com.google.cloud.bigquery.analyticshub.v1.ListQueryTemplatesRequest;
import com.google.cloud.bigquery.analyticshub.v1.ListQueryTemplatesResponse;
import com.google.cloud.bigquery.analyticshub.v1.ListSharedResourceSubscriptionsRequest;
import com.google.cloud.bigquery.analyticshub.v1.ListSharedResourceSubscriptionsResponse;
import com.google.cloud.bigquery.analyticshub.v1.ListSubscriptionsRequest;
import com.google.cloud.bigquery.analyticshub.v1.ListSubscriptionsResponse;
import com.google.cloud.bigquery.analyticshub.v1.Listing;
import com.google.cloud.bigquery.analyticshub.v1.ListingName;
import com.google.cloud.bigquery.analyticshub.v1.LocationName;
import com.google.cloud.bigquery.analyticshub.v1.OperationMetadata;
import com.google.cloud.bigquery.analyticshub.v1.QueryTemplate;
import com.google.cloud.bigquery.analyticshub.v1.QueryTemplateName;
import com.google.cloud.bigquery.analyticshub.v1.RefreshSubscriptionRequest;
import com.google.cloud.bigquery.analyticshub.v1.RefreshSubscriptionResponse;
import com.google.cloud.bigquery.analyticshub.v1.RevokeSubscriptionRequest;
import com.google.cloud.bigquery.analyticshub.v1.RevokeSubscriptionResponse;
import com.google.cloud.bigquery.analyticshub.v1.SubmitQueryTemplateRequest;
import com.google.cloud.bigquery.analyticshub.v1.SubscribeDataExchangeRequest;
import com.google.cloud.bigquery.analyticshub.v1.SubscribeDataExchangeResponse;
import com.google.cloud.bigquery.analyticshub.v1.SubscribeListingRequest;
import com.google.cloud.bigquery.analyticshub.v1.SubscribeListingResponse;
import com.google.cloud.bigquery.analyticshub.v1.Subscription;
import com.google.cloud.bigquery.analyticshub.v1.SubscriptionName;
import com.google.cloud.bigquery.analyticshub.v1.UpdateDataExchangeRequest;
import com.google.cloud.bigquery.analyticshub.v1.UpdateListingRequest;
import com.google.cloud.bigquery.analyticshub.v1.UpdateQueryTemplateRequest;
import com.google.cloud.bigquery.analyticshub.v1.stub.AnalyticsHubServiceStub;
import com.google.cloud.bigquery.analyticshub.v1.stub.AnalyticsHubServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class AnalyticsHubServiceClient
implements BackgroundResource {
    private final AnalyticsHubServiceSettings settings;
    private final AnalyticsHubServiceStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final AnalyticsHubServiceClient create() throws IOException {
        return AnalyticsHubServiceClient.create(AnalyticsHubServiceSettings.newBuilder().build());
    }

    public static final AnalyticsHubServiceClient create(AnalyticsHubServiceSettings settings) throws IOException {
        return new AnalyticsHubServiceClient(settings);
    }

    public static final AnalyticsHubServiceClient create(AnalyticsHubServiceStub stub) {
        return new AnalyticsHubServiceClient(stub);
    }

    protected AnalyticsHubServiceClient(AnalyticsHubServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AnalyticsHubServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected AnalyticsHubServiceClient(AnalyticsHubServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final AnalyticsHubServiceSettings getSettings() {
        return this.settings;
    }

    public AnalyticsHubServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final ListDataExchangesPagedResponse listDataExchanges(LocationName parent) {
        ListDataExchangesRequest request = ListDataExchangesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDataExchanges(request);
    }

    public final ListDataExchangesPagedResponse listDataExchanges(String parent) {
        ListDataExchangesRequest request = ListDataExchangesRequest.newBuilder().setParent(parent).build();
        return this.listDataExchanges(request);
    }

    public final ListDataExchangesPagedResponse listDataExchanges(ListDataExchangesRequest request) {
        return (ListDataExchangesPagedResponse)((Object)this.listDataExchangesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDataExchangesRequest, ListDataExchangesPagedResponse> listDataExchangesPagedCallable() {
        return this.stub.listDataExchangesPagedCallable();
    }

    public final UnaryCallable<ListDataExchangesRequest, ListDataExchangesResponse> listDataExchangesCallable() {
        return this.stub.listDataExchangesCallable();
    }

    public final ListOrgDataExchangesPagedResponse listOrgDataExchanges(String organization) {
        ListOrgDataExchangesRequest request = ListOrgDataExchangesRequest.newBuilder().setOrganization(organization).build();
        return this.listOrgDataExchanges(request);
    }

    public final ListOrgDataExchangesPagedResponse listOrgDataExchanges(ListOrgDataExchangesRequest request) {
        return (ListOrgDataExchangesPagedResponse)((Object)this.listOrgDataExchangesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListOrgDataExchangesRequest, ListOrgDataExchangesPagedResponse> listOrgDataExchangesPagedCallable() {
        return this.stub.listOrgDataExchangesPagedCallable();
    }

    public final UnaryCallable<ListOrgDataExchangesRequest, ListOrgDataExchangesResponse> listOrgDataExchangesCallable() {
        return this.stub.listOrgDataExchangesCallable();
    }

    public final DataExchange getDataExchange(DataExchangeName name) {
        GetDataExchangeRequest request = GetDataExchangeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDataExchange(request);
    }

    public final DataExchange getDataExchange(String name) {
        GetDataExchangeRequest request = GetDataExchangeRequest.newBuilder().setName(name).build();
        return this.getDataExchange(request);
    }

    public final DataExchange getDataExchange(GetDataExchangeRequest request) {
        return (DataExchange)this.getDataExchangeCallable().call((Object)request);
    }

    public final UnaryCallable<GetDataExchangeRequest, DataExchange> getDataExchangeCallable() {
        return this.stub.getDataExchangeCallable();
    }

    public final DataExchange createDataExchange(LocationName parent, DataExchange dataExchange) {
        CreateDataExchangeRequest request = CreateDataExchangeRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setDataExchange(dataExchange).build();
        return this.createDataExchange(request);
    }

    public final DataExchange createDataExchange(String parent, DataExchange dataExchange) {
        CreateDataExchangeRequest request = CreateDataExchangeRequest.newBuilder().setParent(parent).setDataExchange(dataExchange).build();
        return this.createDataExchange(request);
    }

    public final DataExchange createDataExchange(CreateDataExchangeRequest request) {
        return (DataExchange)this.createDataExchangeCallable().call((Object)request);
    }

    public final UnaryCallable<CreateDataExchangeRequest, DataExchange> createDataExchangeCallable() {
        return this.stub.createDataExchangeCallable();
    }

    public final DataExchange updateDataExchange(DataExchange dataExchange, FieldMask updateMask) {
        UpdateDataExchangeRequest request = UpdateDataExchangeRequest.newBuilder().setDataExchange(dataExchange).setUpdateMask(updateMask).build();
        return this.updateDataExchange(request);
    }

    public final DataExchange updateDataExchange(UpdateDataExchangeRequest request) {
        return (DataExchange)this.updateDataExchangeCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateDataExchangeRequest, DataExchange> updateDataExchangeCallable() {
        return this.stub.updateDataExchangeCallable();
    }

    public final void deleteDataExchange(DataExchangeName name) {
        DeleteDataExchangeRequest request = DeleteDataExchangeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteDataExchange(request);
    }

    public final void deleteDataExchange(String name) {
        DeleteDataExchangeRequest request = DeleteDataExchangeRequest.newBuilder().setName(name).build();
        this.deleteDataExchange(request);
    }

    public final void deleteDataExchange(DeleteDataExchangeRequest request) {
        this.deleteDataExchangeCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteDataExchangeRequest, Empty> deleteDataExchangeCallable() {
        return this.stub.deleteDataExchangeCallable();
    }

    public final ListListingsPagedResponse listListings(DataExchangeName parent) {
        ListListingsRequest request = ListListingsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listListings(request);
    }

    public final ListListingsPagedResponse listListings(String parent) {
        ListListingsRequest request = ListListingsRequest.newBuilder().setParent(parent).build();
        return this.listListings(request);
    }

    public final ListListingsPagedResponse listListings(ListListingsRequest request) {
        return (ListListingsPagedResponse)((Object)this.listListingsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListListingsRequest, ListListingsPagedResponse> listListingsPagedCallable() {
        return this.stub.listListingsPagedCallable();
    }

    public final UnaryCallable<ListListingsRequest, ListListingsResponse> listListingsCallable() {
        return this.stub.listListingsCallable();
    }

    public final Listing getListing(ListingName name) {
        GetListingRequest request = GetListingRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getListing(request);
    }

    public final Listing getListing(String name) {
        GetListingRequest request = GetListingRequest.newBuilder().setName(name).build();
        return this.getListing(request);
    }

    public final Listing getListing(GetListingRequest request) {
        return (Listing)this.getListingCallable().call((Object)request);
    }

    public final UnaryCallable<GetListingRequest, Listing> getListingCallable() {
        return this.stub.getListingCallable();
    }

    public final Listing createListing(DataExchangeName parent, Listing listing) {
        CreateListingRequest request = CreateListingRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setListing(listing).build();
        return this.createListing(request);
    }

    public final Listing createListing(String parent, Listing listing) {
        CreateListingRequest request = CreateListingRequest.newBuilder().setParent(parent).setListing(listing).build();
        return this.createListing(request);
    }

    public final Listing createListing(CreateListingRequest request) {
        return (Listing)this.createListingCallable().call((Object)request);
    }

    public final UnaryCallable<CreateListingRequest, Listing> createListingCallable() {
        return this.stub.createListingCallable();
    }

    public final Listing updateListing(Listing listing, FieldMask updateMask) {
        UpdateListingRequest request = UpdateListingRequest.newBuilder().setListing(listing).setUpdateMask(updateMask).build();
        return this.updateListing(request);
    }

    public final Listing updateListing(UpdateListingRequest request) {
        return (Listing)this.updateListingCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateListingRequest, Listing> updateListingCallable() {
        return this.stub.updateListingCallable();
    }

    public final void deleteListing(ListingName name) {
        DeleteListingRequest request = DeleteListingRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteListing(request);
    }

    public final void deleteListing(String name) {
        DeleteListingRequest request = DeleteListingRequest.newBuilder().setName(name).build();
        this.deleteListing(request);
    }

    public final void deleteListing(DeleteListingRequest request) {
        this.deleteListingCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteListingRequest, Empty> deleteListingCallable() {
        return this.stub.deleteListingCallable();
    }

    public final SubscribeListingResponse subscribeListing(ListingName name) {
        SubscribeListingRequest request = SubscribeListingRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.subscribeListing(request);
    }

    public final SubscribeListingResponse subscribeListing(String name) {
        SubscribeListingRequest request = SubscribeListingRequest.newBuilder().setName(name).build();
        return this.subscribeListing(request);
    }

    public final SubscribeListingResponse subscribeListing(SubscribeListingRequest request) {
        return (SubscribeListingResponse)this.subscribeListingCallable().call((Object)request);
    }

    public final UnaryCallable<SubscribeListingRequest, SubscribeListingResponse> subscribeListingCallable() {
        return this.stub.subscribeListingCallable();
    }

    public final OperationFuture<SubscribeDataExchangeResponse, OperationMetadata> subscribeDataExchangeAsync(DataExchangeName name) {
        SubscribeDataExchangeRequest request = SubscribeDataExchangeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.subscribeDataExchangeAsync(request);
    }

    public final OperationFuture<SubscribeDataExchangeResponse, OperationMetadata> subscribeDataExchangeAsync(String name) {
        SubscribeDataExchangeRequest request = SubscribeDataExchangeRequest.newBuilder().setName(name).build();
        return this.subscribeDataExchangeAsync(request);
    }

    public final OperationFuture<SubscribeDataExchangeResponse, OperationMetadata> subscribeDataExchangeAsync(SubscribeDataExchangeRequest request) {
        return this.subscribeDataExchangeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<SubscribeDataExchangeRequest, SubscribeDataExchangeResponse, OperationMetadata> subscribeDataExchangeOperationCallable() {
        return this.stub.subscribeDataExchangeOperationCallable();
    }

    public final UnaryCallable<SubscribeDataExchangeRequest, Operation> subscribeDataExchangeCallable() {
        return this.stub.subscribeDataExchangeCallable();
    }

    public final OperationFuture<RefreshSubscriptionResponse, OperationMetadata> refreshSubscriptionAsync(SubscriptionName name) {
        RefreshSubscriptionRequest request = RefreshSubscriptionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.refreshSubscriptionAsync(request);
    }

    public final OperationFuture<RefreshSubscriptionResponse, OperationMetadata> refreshSubscriptionAsync(String name) {
        RefreshSubscriptionRequest request = RefreshSubscriptionRequest.newBuilder().setName(name).build();
        return this.refreshSubscriptionAsync(request);
    }

    public final OperationFuture<RefreshSubscriptionResponse, OperationMetadata> refreshSubscriptionAsync(RefreshSubscriptionRequest request) {
        return this.refreshSubscriptionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RefreshSubscriptionRequest, RefreshSubscriptionResponse, OperationMetadata> refreshSubscriptionOperationCallable() {
        return this.stub.refreshSubscriptionOperationCallable();
    }

    public final UnaryCallable<RefreshSubscriptionRequest, Operation> refreshSubscriptionCallable() {
        return this.stub.refreshSubscriptionCallable();
    }

    public final Subscription getSubscription(SubscriptionName name) {
        GetSubscriptionRequest request = GetSubscriptionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSubscription(request);
    }

    public final Subscription getSubscription(String name) {
        GetSubscriptionRequest request = GetSubscriptionRequest.newBuilder().setName(name).build();
        return this.getSubscription(request);
    }

    public final Subscription getSubscription(GetSubscriptionRequest request) {
        return (Subscription)this.getSubscriptionCallable().call((Object)request);
    }

    public final UnaryCallable<GetSubscriptionRequest, Subscription> getSubscriptionCallable() {
        return this.stub.getSubscriptionCallable();
    }

    public final ListSubscriptionsPagedResponse listSubscriptions(LocationName parent) {
        ListSubscriptionsRequest request = ListSubscriptionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listSubscriptions(request);
    }

    public final ListSubscriptionsPagedResponse listSubscriptions(String parent) {
        ListSubscriptionsRequest request = ListSubscriptionsRequest.newBuilder().setParent(parent).build();
        return this.listSubscriptions(request);
    }

    public final ListSubscriptionsPagedResponse listSubscriptions(ListSubscriptionsRequest request) {
        return (ListSubscriptionsPagedResponse)((Object)this.listSubscriptionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSubscriptionsRequest, ListSubscriptionsPagedResponse> listSubscriptionsPagedCallable() {
        return this.stub.listSubscriptionsPagedCallable();
    }

    public final UnaryCallable<ListSubscriptionsRequest, ListSubscriptionsResponse> listSubscriptionsCallable() {
        return this.stub.listSubscriptionsCallable();
    }

    public final ListSharedResourceSubscriptionsPagedResponse listSharedResourceSubscriptions(ResourceName resource) {
        ListSharedResourceSubscriptionsRequest request = ListSharedResourceSubscriptionsRequest.newBuilder().setResource(resource == null ? null : resource.toString()).build();
        return this.listSharedResourceSubscriptions(request);
    }

    public final ListSharedResourceSubscriptionsPagedResponse listSharedResourceSubscriptions(String resource) {
        ListSharedResourceSubscriptionsRequest request = ListSharedResourceSubscriptionsRequest.newBuilder().setResource(resource).build();
        return this.listSharedResourceSubscriptions(request);
    }

    public final ListSharedResourceSubscriptionsPagedResponse listSharedResourceSubscriptions(ListSharedResourceSubscriptionsRequest request) {
        return (ListSharedResourceSubscriptionsPagedResponse)((Object)this.listSharedResourceSubscriptionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSharedResourceSubscriptionsRequest, ListSharedResourceSubscriptionsPagedResponse> listSharedResourceSubscriptionsPagedCallable() {
        return this.stub.listSharedResourceSubscriptionsPagedCallable();
    }

    public final UnaryCallable<ListSharedResourceSubscriptionsRequest, ListSharedResourceSubscriptionsResponse> listSharedResourceSubscriptionsCallable() {
        return this.stub.listSharedResourceSubscriptionsCallable();
    }

    public final RevokeSubscriptionResponse revokeSubscription(SubscriptionName name) {
        RevokeSubscriptionRequest request = RevokeSubscriptionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.revokeSubscription(request);
    }

    public final RevokeSubscriptionResponse revokeSubscription(String name) {
        RevokeSubscriptionRequest request = RevokeSubscriptionRequest.newBuilder().setName(name).build();
        return this.revokeSubscription(request);
    }

    public final RevokeSubscriptionResponse revokeSubscription(RevokeSubscriptionRequest request) {
        return (RevokeSubscriptionResponse)this.revokeSubscriptionCallable().call((Object)request);
    }

    public final UnaryCallable<RevokeSubscriptionRequest, RevokeSubscriptionResponse> revokeSubscriptionCallable() {
        return this.stub.revokeSubscriptionCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteSubscriptionAsync(SubscriptionName name) {
        DeleteSubscriptionRequest request = DeleteSubscriptionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteSubscriptionAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteSubscriptionAsync(String name) {
        DeleteSubscriptionRequest request = DeleteSubscriptionRequest.newBuilder().setName(name).build();
        return this.deleteSubscriptionAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteSubscriptionAsync(DeleteSubscriptionRequest request) {
        return this.deleteSubscriptionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteSubscriptionRequest, Empty, OperationMetadata> deleteSubscriptionOperationCallable() {
        return this.stub.deleteSubscriptionOperationCallable();
    }

    public final UnaryCallable<DeleteSubscriptionRequest, Operation> deleteSubscriptionCallable() {
        return this.stub.deleteSubscriptionCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final QueryTemplate createQueryTemplate(DataExchangeName parent, QueryTemplate queryTemplate, String queryTemplateId) {
        CreateQueryTemplateRequest request = CreateQueryTemplateRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setQueryTemplate(queryTemplate).setQueryTemplateId(queryTemplateId).build();
        return this.createQueryTemplate(request);
    }

    public final QueryTemplate createQueryTemplate(String parent, QueryTemplate queryTemplate, String queryTemplateId) {
        CreateQueryTemplateRequest request = CreateQueryTemplateRequest.newBuilder().setParent(parent).setQueryTemplate(queryTemplate).setQueryTemplateId(queryTemplateId).build();
        return this.createQueryTemplate(request);
    }

    public final QueryTemplate createQueryTemplate(CreateQueryTemplateRequest request) {
        return (QueryTemplate)this.createQueryTemplateCallable().call((Object)request);
    }

    public final UnaryCallable<CreateQueryTemplateRequest, QueryTemplate> createQueryTemplateCallable() {
        return this.stub.createQueryTemplateCallable();
    }

    public final QueryTemplate getQueryTemplate(QueryTemplateName name) {
        GetQueryTemplateRequest request = GetQueryTemplateRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getQueryTemplate(request);
    }

    public final QueryTemplate getQueryTemplate(String name) {
        GetQueryTemplateRequest request = GetQueryTemplateRequest.newBuilder().setName(name).build();
        return this.getQueryTemplate(request);
    }

    public final QueryTemplate getQueryTemplate(GetQueryTemplateRequest request) {
        return (QueryTemplate)this.getQueryTemplateCallable().call((Object)request);
    }

    public final UnaryCallable<GetQueryTemplateRequest, QueryTemplate> getQueryTemplateCallable() {
        return this.stub.getQueryTemplateCallable();
    }

    public final ListQueryTemplatesPagedResponse listQueryTemplates(DataExchangeName parent) {
        ListQueryTemplatesRequest request = ListQueryTemplatesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listQueryTemplates(request);
    }

    public final ListQueryTemplatesPagedResponse listQueryTemplates(String parent) {
        ListQueryTemplatesRequest request = ListQueryTemplatesRequest.newBuilder().setParent(parent).build();
        return this.listQueryTemplates(request);
    }

    public final ListQueryTemplatesPagedResponse listQueryTemplates(ListQueryTemplatesRequest request) {
        return (ListQueryTemplatesPagedResponse)((Object)this.listQueryTemplatesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListQueryTemplatesRequest, ListQueryTemplatesPagedResponse> listQueryTemplatesPagedCallable() {
        return this.stub.listQueryTemplatesPagedCallable();
    }

    public final UnaryCallable<ListQueryTemplatesRequest, ListQueryTemplatesResponse> listQueryTemplatesCallable() {
        return this.stub.listQueryTemplatesCallable();
    }

    public final QueryTemplate updateQueryTemplate(QueryTemplate queryTemplate, FieldMask updateMask) {
        UpdateQueryTemplateRequest request = UpdateQueryTemplateRequest.newBuilder().setQueryTemplate(queryTemplate).setUpdateMask(updateMask).build();
        return this.updateQueryTemplate(request);
    }

    public final QueryTemplate updateQueryTemplate(UpdateQueryTemplateRequest request) {
        return (QueryTemplate)this.updateQueryTemplateCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateQueryTemplateRequest, QueryTemplate> updateQueryTemplateCallable() {
        return this.stub.updateQueryTemplateCallable();
    }

    public final void deleteQueryTemplate(QueryTemplateName name) {
        DeleteQueryTemplateRequest request = DeleteQueryTemplateRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteQueryTemplate(request);
    }

    public final void deleteQueryTemplate(String name) {
        DeleteQueryTemplateRequest request = DeleteQueryTemplateRequest.newBuilder().setName(name).build();
        this.deleteQueryTemplate(request);
    }

    public final void deleteQueryTemplate(DeleteQueryTemplateRequest request) {
        this.deleteQueryTemplateCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteQueryTemplateRequest, Empty> deleteQueryTemplateCallable() {
        return this.stub.deleteQueryTemplateCallable();
    }

    public final QueryTemplate submitQueryTemplate(QueryTemplateName name) {
        SubmitQueryTemplateRequest request = SubmitQueryTemplateRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.submitQueryTemplate(request);
    }

    public final QueryTemplate submitQueryTemplate(String name) {
        SubmitQueryTemplateRequest request = SubmitQueryTemplateRequest.newBuilder().setName(name).build();
        return this.submitQueryTemplate(request);
    }

    public final QueryTemplate submitQueryTemplate(SubmitQueryTemplateRequest request) {
        return (QueryTemplate)this.submitQueryTemplateCallable().call((Object)request);
    }

    public final UnaryCallable<SubmitQueryTemplateRequest, QueryTemplate> submitQueryTemplateCallable() {
        return this.stub.submitQueryTemplateCallable();
    }

    public final QueryTemplate approveQueryTemplate(QueryTemplateName name) {
        ApproveQueryTemplateRequest request = ApproveQueryTemplateRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.approveQueryTemplate(request);
    }

    public final QueryTemplate approveQueryTemplate(String name) {
        ApproveQueryTemplateRequest request = ApproveQueryTemplateRequest.newBuilder().setName(name).build();
        return this.approveQueryTemplate(request);
    }

    public final QueryTemplate approveQueryTemplate(ApproveQueryTemplateRequest request) {
        return (QueryTemplate)this.approveQueryTemplateCallable().call((Object)request);
    }

    public final UnaryCallable<ApproveQueryTemplateRequest, QueryTemplate> approveQueryTemplateCallable() {
        return this.stub.approveQueryTemplateCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListQueryTemplatesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListQueryTemplatesRequest, ListQueryTemplatesResponse, QueryTemplate, ListQueryTemplatesPage, ListQueryTemplatesFixedSizeCollection> {
        private ListQueryTemplatesFixedSizeCollection(List<ListQueryTemplatesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListQueryTemplatesFixedSizeCollection createEmptyCollection() {
            return new ListQueryTemplatesFixedSizeCollection(null, 0);
        }

        protected ListQueryTemplatesFixedSizeCollection createCollection(List<ListQueryTemplatesPage> pages, int collectionSize) {
            return new ListQueryTemplatesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListQueryTemplatesPage
    extends AbstractPage<ListQueryTemplatesRequest, ListQueryTemplatesResponse, QueryTemplate, ListQueryTemplatesPage> {
        private ListQueryTemplatesPage(PageContext<ListQueryTemplatesRequest, ListQueryTemplatesResponse, QueryTemplate> context, ListQueryTemplatesResponse response) {
            super(context, (Object)response);
        }

        private static ListQueryTemplatesPage createEmptyPage() {
            return new ListQueryTemplatesPage(null, null);
        }

        protected ListQueryTemplatesPage createPage(PageContext<ListQueryTemplatesRequest, ListQueryTemplatesResponse, QueryTemplate> context, ListQueryTemplatesResponse response) {
            return new ListQueryTemplatesPage(context, response);
        }

        public ApiFuture<ListQueryTemplatesPage> createPageAsync(PageContext<ListQueryTemplatesRequest, ListQueryTemplatesResponse, QueryTemplate> context, ApiFuture<ListQueryTemplatesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListQueryTemplatesPagedResponse
    extends AbstractPagedListResponse<ListQueryTemplatesRequest, ListQueryTemplatesResponse, QueryTemplate, ListQueryTemplatesPage, ListQueryTemplatesFixedSizeCollection> {
        public static ApiFuture<ListQueryTemplatesPagedResponse> createAsync(PageContext<ListQueryTemplatesRequest, ListQueryTemplatesResponse, QueryTemplate> context, ApiFuture<ListQueryTemplatesResponse> futureResponse) {
            ApiFuture<ListQueryTemplatesPage> futurePage = ListQueryTemplatesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListQueryTemplatesPagedResponse((ListQueryTemplatesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListQueryTemplatesPagedResponse(ListQueryTemplatesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListQueryTemplatesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListSharedResourceSubscriptionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSharedResourceSubscriptionsRequest, ListSharedResourceSubscriptionsResponse, Subscription, ListSharedResourceSubscriptionsPage, ListSharedResourceSubscriptionsFixedSizeCollection> {
        private ListSharedResourceSubscriptionsFixedSizeCollection(List<ListSharedResourceSubscriptionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSharedResourceSubscriptionsFixedSizeCollection createEmptyCollection() {
            return new ListSharedResourceSubscriptionsFixedSizeCollection(null, 0);
        }

        protected ListSharedResourceSubscriptionsFixedSizeCollection createCollection(List<ListSharedResourceSubscriptionsPage> pages, int collectionSize) {
            return new ListSharedResourceSubscriptionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSharedResourceSubscriptionsPage
    extends AbstractPage<ListSharedResourceSubscriptionsRequest, ListSharedResourceSubscriptionsResponse, Subscription, ListSharedResourceSubscriptionsPage> {
        private ListSharedResourceSubscriptionsPage(PageContext<ListSharedResourceSubscriptionsRequest, ListSharedResourceSubscriptionsResponse, Subscription> context, ListSharedResourceSubscriptionsResponse response) {
            super(context, (Object)response);
        }

        private static ListSharedResourceSubscriptionsPage createEmptyPage() {
            return new ListSharedResourceSubscriptionsPage(null, null);
        }

        protected ListSharedResourceSubscriptionsPage createPage(PageContext<ListSharedResourceSubscriptionsRequest, ListSharedResourceSubscriptionsResponse, Subscription> context, ListSharedResourceSubscriptionsResponse response) {
            return new ListSharedResourceSubscriptionsPage(context, response);
        }

        public ApiFuture<ListSharedResourceSubscriptionsPage> createPageAsync(PageContext<ListSharedResourceSubscriptionsRequest, ListSharedResourceSubscriptionsResponse, Subscription> context, ApiFuture<ListSharedResourceSubscriptionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSharedResourceSubscriptionsPagedResponse
    extends AbstractPagedListResponse<ListSharedResourceSubscriptionsRequest, ListSharedResourceSubscriptionsResponse, Subscription, ListSharedResourceSubscriptionsPage, ListSharedResourceSubscriptionsFixedSizeCollection> {
        public static ApiFuture<ListSharedResourceSubscriptionsPagedResponse> createAsync(PageContext<ListSharedResourceSubscriptionsRequest, ListSharedResourceSubscriptionsResponse, Subscription> context, ApiFuture<ListSharedResourceSubscriptionsResponse> futureResponse) {
            ApiFuture<ListSharedResourceSubscriptionsPage> futurePage = ListSharedResourceSubscriptionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListSharedResourceSubscriptionsPagedResponse((ListSharedResourceSubscriptionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListSharedResourceSubscriptionsPagedResponse(ListSharedResourceSubscriptionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSharedResourceSubscriptionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListSubscriptionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSubscriptionsRequest, ListSubscriptionsResponse, Subscription, ListSubscriptionsPage, ListSubscriptionsFixedSizeCollection> {
        private ListSubscriptionsFixedSizeCollection(List<ListSubscriptionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSubscriptionsFixedSizeCollection createEmptyCollection() {
            return new ListSubscriptionsFixedSizeCollection(null, 0);
        }

        protected ListSubscriptionsFixedSizeCollection createCollection(List<ListSubscriptionsPage> pages, int collectionSize) {
            return new ListSubscriptionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSubscriptionsPage
    extends AbstractPage<ListSubscriptionsRequest, ListSubscriptionsResponse, Subscription, ListSubscriptionsPage> {
        private ListSubscriptionsPage(PageContext<ListSubscriptionsRequest, ListSubscriptionsResponse, Subscription> context, ListSubscriptionsResponse response) {
            super(context, (Object)response);
        }

        private static ListSubscriptionsPage createEmptyPage() {
            return new ListSubscriptionsPage(null, null);
        }

        protected ListSubscriptionsPage createPage(PageContext<ListSubscriptionsRequest, ListSubscriptionsResponse, Subscription> context, ListSubscriptionsResponse response) {
            return new ListSubscriptionsPage(context, response);
        }

        public ApiFuture<ListSubscriptionsPage> createPageAsync(PageContext<ListSubscriptionsRequest, ListSubscriptionsResponse, Subscription> context, ApiFuture<ListSubscriptionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSubscriptionsPagedResponse
    extends AbstractPagedListResponse<ListSubscriptionsRequest, ListSubscriptionsResponse, Subscription, ListSubscriptionsPage, ListSubscriptionsFixedSizeCollection> {
        public static ApiFuture<ListSubscriptionsPagedResponse> createAsync(PageContext<ListSubscriptionsRequest, ListSubscriptionsResponse, Subscription> context, ApiFuture<ListSubscriptionsResponse> futureResponse) {
            ApiFuture<ListSubscriptionsPage> futurePage = ListSubscriptionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListSubscriptionsPagedResponse((ListSubscriptionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListSubscriptionsPagedResponse(ListSubscriptionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSubscriptionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListListingsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListListingsRequest, ListListingsResponse, Listing, ListListingsPage, ListListingsFixedSizeCollection> {
        private ListListingsFixedSizeCollection(List<ListListingsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListListingsFixedSizeCollection createEmptyCollection() {
            return new ListListingsFixedSizeCollection(null, 0);
        }

        protected ListListingsFixedSizeCollection createCollection(List<ListListingsPage> pages, int collectionSize) {
            return new ListListingsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListListingsPage
    extends AbstractPage<ListListingsRequest, ListListingsResponse, Listing, ListListingsPage> {
        private ListListingsPage(PageContext<ListListingsRequest, ListListingsResponse, Listing> context, ListListingsResponse response) {
            super(context, (Object)response);
        }

        private static ListListingsPage createEmptyPage() {
            return new ListListingsPage(null, null);
        }

        protected ListListingsPage createPage(PageContext<ListListingsRequest, ListListingsResponse, Listing> context, ListListingsResponse response) {
            return new ListListingsPage(context, response);
        }

        public ApiFuture<ListListingsPage> createPageAsync(PageContext<ListListingsRequest, ListListingsResponse, Listing> context, ApiFuture<ListListingsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListListingsPagedResponse
    extends AbstractPagedListResponse<ListListingsRequest, ListListingsResponse, Listing, ListListingsPage, ListListingsFixedSizeCollection> {
        public static ApiFuture<ListListingsPagedResponse> createAsync(PageContext<ListListingsRequest, ListListingsResponse, Listing> context, ApiFuture<ListListingsResponse> futureResponse) {
            ApiFuture<ListListingsPage> futurePage = ListListingsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListListingsPagedResponse((ListListingsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListListingsPagedResponse(ListListingsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListListingsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListOrgDataExchangesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListOrgDataExchangesRequest, ListOrgDataExchangesResponse, DataExchange, ListOrgDataExchangesPage, ListOrgDataExchangesFixedSizeCollection> {
        private ListOrgDataExchangesFixedSizeCollection(List<ListOrgDataExchangesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListOrgDataExchangesFixedSizeCollection createEmptyCollection() {
            return new ListOrgDataExchangesFixedSizeCollection(null, 0);
        }

        protected ListOrgDataExchangesFixedSizeCollection createCollection(List<ListOrgDataExchangesPage> pages, int collectionSize) {
            return new ListOrgDataExchangesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListOrgDataExchangesPage
    extends AbstractPage<ListOrgDataExchangesRequest, ListOrgDataExchangesResponse, DataExchange, ListOrgDataExchangesPage> {
        private ListOrgDataExchangesPage(PageContext<ListOrgDataExchangesRequest, ListOrgDataExchangesResponse, DataExchange> context, ListOrgDataExchangesResponse response) {
            super(context, (Object)response);
        }

        private static ListOrgDataExchangesPage createEmptyPage() {
            return new ListOrgDataExchangesPage(null, null);
        }

        protected ListOrgDataExchangesPage createPage(PageContext<ListOrgDataExchangesRequest, ListOrgDataExchangesResponse, DataExchange> context, ListOrgDataExchangesResponse response) {
            return new ListOrgDataExchangesPage(context, response);
        }

        public ApiFuture<ListOrgDataExchangesPage> createPageAsync(PageContext<ListOrgDataExchangesRequest, ListOrgDataExchangesResponse, DataExchange> context, ApiFuture<ListOrgDataExchangesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListOrgDataExchangesPagedResponse
    extends AbstractPagedListResponse<ListOrgDataExchangesRequest, ListOrgDataExchangesResponse, DataExchange, ListOrgDataExchangesPage, ListOrgDataExchangesFixedSizeCollection> {
        public static ApiFuture<ListOrgDataExchangesPagedResponse> createAsync(PageContext<ListOrgDataExchangesRequest, ListOrgDataExchangesResponse, DataExchange> context, ApiFuture<ListOrgDataExchangesResponse> futureResponse) {
            ApiFuture<ListOrgDataExchangesPage> futurePage = ListOrgDataExchangesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListOrgDataExchangesPagedResponse((ListOrgDataExchangesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListOrgDataExchangesPagedResponse(ListOrgDataExchangesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListOrgDataExchangesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDataExchangesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDataExchangesRequest, ListDataExchangesResponse, DataExchange, ListDataExchangesPage, ListDataExchangesFixedSizeCollection> {
        private ListDataExchangesFixedSizeCollection(List<ListDataExchangesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDataExchangesFixedSizeCollection createEmptyCollection() {
            return new ListDataExchangesFixedSizeCollection(null, 0);
        }

        protected ListDataExchangesFixedSizeCollection createCollection(List<ListDataExchangesPage> pages, int collectionSize) {
            return new ListDataExchangesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDataExchangesPage
    extends AbstractPage<ListDataExchangesRequest, ListDataExchangesResponse, DataExchange, ListDataExchangesPage> {
        private ListDataExchangesPage(PageContext<ListDataExchangesRequest, ListDataExchangesResponse, DataExchange> context, ListDataExchangesResponse response) {
            super(context, (Object)response);
        }

        private static ListDataExchangesPage createEmptyPage() {
            return new ListDataExchangesPage(null, null);
        }

        protected ListDataExchangesPage createPage(PageContext<ListDataExchangesRequest, ListDataExchangesResponse, DataExchange> context, ListDataExchangesResponse response) {
            return new ListDataExchangesPage(context, response);
        }

        public ApiFuture<ListDataExchangesPage> createPageAsync(PageContext<ListDataExchangesRequest, ListDataExchangesResponse, DataExchange> context, ApiFuture<ListDataExchangesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDataExchangesPagedResponse
    extends AbstractPagedListResponse<ListDataExchangesRequest, ListDataExchangesResponse, DataExchange, ListDataExchangesPage, ListDataExchangesFixedSizeCollection> {
        public static ApiFuture<ListDataExchangesPagedResponse> createAsync(PageContext<ListDataExchangesRequest, ListDataExchangesResponse, DataExchange> context, ApiFuture<ListDataExchangesResponse> futureResponse) {
            ApiFuture<ListDataExchangesPage> futurePage = ListDataExchangesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDataExchangesPagedResponse((ListDataExchangesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDataExchangesPagedResponse(ListDataExchangesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDataExchangesFixedSizeCollection.createEmptyCollection());
        }
    }
}

