/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.alloydb.v1alpha;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.alloydb.v1alpha.AlloyDBAdminSettings;
import com.google.cloud.alloydb.v1alpha.Backup;
import com.google.cloud.alloydb.v1alpha.BackupName;
import com.google.cloud.alloydb.v1alpha.BatchCreateInstancesRequest;
import com.google.cloud.alloydb.v1alpha.BatchCreateInstancesResponse;
import com.google.cloud.alloydb.v1alpha.Cluster;
import com.google.cloud.alloydb.v1alpha.ClusterName;
import com.google.cloud.alloydb.v1alpha.ConnectionInfo;
import com.google.cloud.alloydb.v1alpha.CreateBackupRequest;
import com.google.cloud.alloydb.v1alpha.CreateClusterRequest;
import com.google.cloud.alloydb.v1alpha.CreateInstanceRequest;
import com.google.cloud.alloydb.v1alpha.CreateSecondaryClusterRequest;
import com.google.cloud.alloydb.v1alpha.CreateSecondaryInstanceRequest;
import com.google.cloud.alloydb.v1alpha.CreateUserRequest;
import com.google.cloud.alloydb.v1alpha.Database;
import com.google.cloud.alloydb.v1alpha.DatabaseVersion;
import com.google.cloud.alloydb.v1alpha.DeleteBackupRequest;
import com.google.cloud.alloydb.v1alpha.DeleteClusterRequest;
import com.google.cloud.alloydb.v1alpha.DeleteInstanceRequest;
import com.google.cloud.alloydb.v1alpha.DeleteUserRequest;
import com.google.cloud.alloydb.v1alpha.ExecuteSqlRequest;
import com.google.cloud.alloydb.v1alpha.ExecuteSqlResponse;
import com.google.cloud.alloydb.v1alpha.FailoverInstanceRequest;
import com.google.cloud.alloydb.v1alpha.GenerateClientCertificateRequest;
import com.google.cloud.alloydb.v1alpha.GenerateClientCertificateResponse;
import com.google.cloud.alloydb.v1alpha.GetBackupRequest;
import com.google.cloud.alloydb.v1alpha.GetClusterRequest;
import com.google.cloud.alloydb.v1alpha.GetConnectionInfoRequest;
import com.google.cloud.alloydb.v1alpha.GetInstanceRequest;
import com.google.cloud.alloydb.v1alpha.GetUserRequest;
import com.google.cloud.alloydb.v1alpha.InjectFaultRequest;
import com.google.cloud.alloydb.v1alpha.Instance;
import com.google.cloud.alloydb.v1alpha.InstanceName;
import com.google.cloud.alloydb.v1alpha.ListBackupsRequest;
import com.google.cloud.alloydb.v1alpha.ListBackupsResponse;
import com.google.cloud.alloydb.v1alpha.ListClustersRequest;
import com.google.cloud.alloydb.v1alpha.ListClustersResponse;
import com.google.cloud.alloydb.v1alpha.ListDatabasesRequest;
import com.google.cloud.alloydb.v1alpha.ListDatabasesResponse;
import com.google.cloud.alloydb.v1alpha.ListInstancesRequest;
import com.google.cloud.alloydb.v1alpha.ListInstancesResponse;
import com.google.cloud.alloydb.v1alpha.ListSupportedDatabaseFlagsRequest;
import com.google.cloud.alloydb.v1alpha.ListSupportedDatabaseFlagsResponse;
import com.google.cloud.alloydb.v1alpha.ListUsersRequest;
import com.google.cloud.alloydb.v1alpha.ListUsersResponse;
import com.google.cloud.alloydb.v1alpha.LocationName;
import com.google.cloud.alloydb.v1alpha.OperationMetadata;
import com.google.cloud.alloydb.v1alpha.PromoteClusterRequest;
import com.google.cloud.alloydb.v1alpha.RestartInstanceRequest;
import com.google.cloud.alloydb.v1alpha.RestoreClusterRequest;
import com.google.cloud.alloydb.v1alpha.SupportedDatabaseFlag;
import com.google.cloud.alloydb.v1alpha.SwitchoverClusterRequest;
import com.google.cloud.alloydb.v1alpha.UpdateBackupRequest;
import com.google.cloud.alloydb.v1alpha.UpdateClusterRequest;
import com.google.cloud.alloydb.v1alpha.UpdateInstanceRequest;
import com.google.cloud.alloydb.v1alpha.UpdateUserRequest;
import com.google.cloud.alloydb.v1alpha.UpgradeClusterRequest;
import com.google.cloud.alloydb.v1alpha.UpgradeClusterResponse;
import com.google.cloud.alloydb.v1alpha.User;
import com.google.cloud.alloydb.v1alpha.UserName;
import com.google.cloud.alloydb.v1alpha.stub.AlloyDBAdminStub;
import com.google.cloud.alloydb.v1alpha.stub.AlloyDBAdminStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class AlloyDBAdminClient
implements BackgroundResource {
    private final AlloyDBAdminSettings settings;
    private final AlloyDBAdminStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final AlloyDBAdminClient create() throws IOException {
        return AlloyDBAdminClient.create(AlloyDBAdminSettings.newBuilder().build());
    }

    public static final AlloyDBAdminClient create(AlloyDBAdminSettings settings) throws IOException {
        return new AlloyDBAdminClient(settings);
    }

    public static final AlloyDBAdminClient create(AlloyDBAdminStub stub) {
        return new AlloyDBAdminClient(stub);
    }

    protected AlloyDBAdminClient(AlloyDBAdminSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AlloyDBAdminStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected AlloyDBAdminClient(AlloyDBAdminStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final AlloyDBAdminSettings getSettings() {
        return this.settings;
    }

    public AlloyDBAdminStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final ListClustersPagedResponse listClusters(LocationName parent) {
        ListClustersRequest request = ListClustersRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listClusters(request);
    }

    public final ListClustersPagedResponse listClusters(String parent) {
        ListClustersRequest request = ListClustersRequest.newBuilder().setParent(parent).build();
        return this.listClusters(request);
    }

    public final ListClustersPagedResponse listClusters(ListClustersRequest request) {
        return (ListClustersPagedResponse)((Object)this.listClustersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListClustersRequest, ListClustersPagedResponse> listClustersPagedCallable() {
        return this.stub.listClustersPagedCallable();
    }

    public final UnaryCallable<ListClustersRequest, ListClustersResponse> listClustersCallable() {
        return this.stub.listClustersCallable();
    }

    public final Cluster getCluster(ClusterName name) {
        GetClusterRequest request = GetClusterRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCluster(request);
    }

    public final Cluster getCluster(String name) {
        GetClusterRequest request = GetClusterRequest.newBuilder().setName(name).build();
        return this.getCluster(request);
    }

    public final Cluster getCluster(GetClusterRequest request) {
        return (Cluster)this.getClusterCallable().call((Object)request);
    }

    public final UnaryCallable<GetClusterRequest, Cluster> getClusterCallable() {
        return this.stub.getClusterCallable();
    }

    public final OperationFuture<Cluster, OperationMetadata> createClusterAsync(LocationName parent, Cluster cluster, String clusterId) {
        CreateClusterRequest request = CreateClusterRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setCluster(cluster).setClusterId(clusterId).build();
        return this.createClusterAsync(request);
    }

    public final OperationFuture<Cluster, OperationMetadata> createClusterAsync(String parent, Cluster cluster, String clusterId) {
        CreateClusterRequest request = CreateClusterRequest.newBuilder().setParent(parent).setCluster(cluster).setClusterId(clusterId).build();
        return this.createClusterAsync(request);
    }

    public final OperationFuture<Cluster, OperationMetadata> createClusterAsync(CreateClusterRequest request) {
        return this.createClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateClusterRequest, Cluster, OperationMetadata> createClusterOperationCallable() {
        return this.stub.createClusterOperationCallable();
    }

    public final UnaryCallable<CreateClusterRequest, Operation> createClusterCallable() {
        return this.stub.createClusterCallable();
    }

    public final OperationFuture<Cluster, OperationMetadata> updateClusterAsync(Cluster cluster, FieldMask updateMask) {
        UpdateClusterRequest request = UpdateClusterRequest.newBuilder().setCluster(cluster).setUpdateMask(updateMask).build();
        return this.updateClusterAsync(request);
    }

    public final OperationFuture<Cluster, OperationMetadata> updateClusterAsync(UpdateClusterRequest request) {
        return this.updateClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateClusterRequest, Cluster, OperationMetadata> updateClusterOperationCallable() {
        return this.stub.updateClusterOperationCallable();
    }

    public final UnaryCallable<UpdateClusterRequest, Operation> updateClusterCallable() {
        return this.stub.updateClusterCallable();
    }

    public final OperationFuture<UpgradeClusterResponse, OperationMetadata> upgradeClusterAsync(ClusterName name, DatabaseVersion version) {
        UpgradeClusterRequest request = UpgradeClusterRequest.newBuilder().setName(name == null ? null : name.toString()).setVersion(version).build();
        return this.upgradeClusterAsync(request);
    }

    public final OperationFuture<UpgradeClusterResponse, OperationMetadata> upgradeClusterAsync(String name, DatabaseVersion version) {
        UpgradeClusterRequest request = UpgradeClusterRequest.newBuilder().setName(name).setVersion(version).build();
        return this.upgradeClusterAsync(request);
    }

    public final OperationFuture<UpgradeClusterResponse, OperationMetadata> upgradeClusterAsync(UpgradeClusterRequest request) {
        return this.upgradeClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpgradeClusterRequest, UpgradeClusterResponse, OperationMetadata> upgradeClusterOperationCallable() {
        return this.stub.upgradeClusterOperationCallable();
    }

    public final UnaryCallable<UpgradeClusterRequest, Operation> upgradeClusterCallable() {
        return this.stub.upgradeClusterCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteClusterAsync(ClusterName name) {
        DeleteClusterRequest request = DeleteClusterRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteClusterAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteClusterAsync(String name) {
        DeleteClusterRequest request = DeleteClusterRequest.newBuilder().setName(name).build();
        return this.deleteClusterAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteClusterAsync(DeleteClusterRequest request) {
        return this.deleteClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteClusterRequest, Empty, OperationMetadata> deleteClusterOperationCallable() {
        return this.stub.deleteClusterOperationCallable();
    }

    public final UnaryCallable<DeleteClusterRequest, Operation> deleteClusterCallable() {
        return this.stub.deleteClusterCallable();
    }

    public final OperationFuture<Cluster, OperationMetadata> promoteClusterAsync(ClusterName name) {
        PromoteClusterRequest request = PromoteClusterRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.promoteClusterAsync(request);
    }

    public final OperationFuture<Cluster, OperationMetadata> promoteClusterAsync(String name) {
        PromoteClusterRequest request = PromoteClusterRequest.newBuilder().setName(name).build();
        return this.promoteClusterAsync(request);
    }

    public final OperationFuture<Cluster, OperationMetadata> promoteClusterAsync(PromoteClusterRequest request) {
        return this.promoteClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PromoteClusterRequest, Cluster, OperationMetadata> promoteClusterOperationCallable() {
        return this.stub.promoteClusterOperationCallable();
    }

    public final UnaryCallable<PromoteClusterRequest, Operation> promoteClusterCallable() {
        return this.stub.promoteClusterCallable();
    }

    public final OperationFuture<Cluster, OperationMetadata> switchoverClusterAsync(ClusterName name) {
        SwitchoverClusterRequest request = SwitchoverClusterRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.switchoverClusterAsync(request);
    }

    public final OperationFuture<Cluster, OperationMetadata> switchoverClusterAsync(String name) {
        SwitchoverClusterRequest request = SwitchoverClusterRequest.newBuilder().setName(name).build();
        return this.switchoverClusterAsync(request);
    }

    public final OperationFuture<Cluster, OperationMetadata> switchoverClusterAsync(SwitchoverClusterRequest request) {
        return this.switchoverClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<SwitchoverClusterRequest, Cluster, OperationMetadata> switchoverClusterOperationCallable() {
        return this.stub.switchoverClusterOperationCallable();
    }

    public final UnaryCallable<SwitchoverClusterRequest, Operation> switchoverClusterCallable() {
        return this.stub.switchoverClusterCallable();
    }

    public final OperationFuture<Cluster, OperationMetadata> restoreClusterAsync(RestoreClusterRequest request) {
        return this.restoreClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RestoreClusterRequest, Cluster, OperationMetadata> restoreClusterOperationCallable() {
        return this.stub.restoreClusterOperationCallable();
    }

    public final UnaryCallable<RestoreClusterRequest, Operation> restoreClusterCallable() {
        return this.stub.restoreClusterCallable();
    }

    public final OperationFuture<Cluster, OperationMetadata> createSecondaryClusterAsync(LocationName parent, Cluster cluster, String clusterId) {
        CreateSecondaryClusterRequest request = CreateSecondaryClusterRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setCluster(cluster).setClusterId(clusterId).build();
        return this.createSecondaryClusterAsync(request);
    }

    public final OperationFuture<Cluster, OperationMetadata> createSecondaryClusterAsync(String parent, Cluster cluster, String clusterId) {
        CreateSecondaryClusterRequest request = CreateSecondaryClusterRequest.newBuilder().setParent(parent).setCluster(cluster).setClusterId(clusterId).build();
        return this.createSecondaryClusterAsync(request);
    }

    public final OperationFuture<Cluster, OperationMetadata> createSecondaryClusterAsync(CreateSecondaryClusterRequest request) {
        return this.createSecondaryClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateSecondaryClusterRequest, Cluster, OperationMetadata> createSecondaryClusterOperationCallable() {
        return this.stub.createSecondaryClusterOperationCallable();
    }

    public final UnaryCallable<CreateSecondaryClusterRequest, Operation> createSecondaryClusterCallable() {
        return this.stub.createSecondaryClusterCallable();
    }

    public final ListInstancesPagedResponse listInstances(ClusterName parent) {
        ListInstancesRequest request = ListInstancesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listInstances(request);
    }

    public final ListInstancesPagedResponse listInstances(String parent) {
        ListInstancesRequest request = ListInstancesRequest.newBuilder().setParent(parent).build();
        return this.listInstances(request);
    }

    public final ListInstancesPagedResponse listInstances(ListInstancesRequest request) {
        return (ListInstancesPagedResponse)((Object)this.listInstancesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListInstancesRequest, ListInstancesPagedResponse> listInstancesPagedCallable() {
        return this.stub.listInstancesPagedCallable();
    }

    public final UnaryCallable<ListInstancesRequest, ListInstancesResponse> listInstancesCallable() {
        return this.stub.listInstancesCallable();
    }

    public final Instance getInstance(InstanceName name) {
        GetInstanceRequest request = GetInstanceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getInstance(request);
    }

    public final Instance getInstance(String name) {
        GetInstanceRequest request = GetInstanceRequest.newBuilder().setName(name).build();
        return this.getInstance(request);
    }

    public final Instance getInstance(GetInstanceRequest request) {
        return (Instance)this.getInstanceCallable().call((Object)request);
    }

    public final UnaryCallable<GetInstanceRequest, Instance> getInstanceCallable() {
        return this.stub.getInstanceCallable();
    }

    public final OperationFuture<Instance, OperationMetadata> createInstanceAsync(ClusterName parent, Instance instance, String instanceId) {
        CreateInstanceRequest request = CreateInstanceRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setInstance(instance).setInstanceId(instanceId).build();
        return this.createInstanceAsync(request);
    }

    public final OperationFuture<Instance, OperationMetadata> createInstanceAsync(String parent, Instance instance, String instanceId) {
        CreateInstanceRequest request = CreateInstanceRequest.newBuilder().setParent(parent).setInstance(instance).setInstanceId(instanceId).build();
        return this.createInstanceAsync(request);
    }

    public final OperationFuture<Instance, OperationMetadata> createInstanceAsync(CreateInstanceRequest request) {
        return this.createInstanceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateInstanceRequest, Instance, OperationMetadata> createInstanceOperationCallable() {
        return this.stub.createInstanceOperationCallable();
    }

    public final UnaryCallable<CreateInstanceRequest, Operation> createInstanceCallable() {
        return this.stub.createInstanceCallable();
    }

    public final OperationFuture<Instance, OperationMetadata> createSecondaryInstanceAsync(ClusterName parent, Instance instance, String instanceId) {
        CreateSecondaryInstanceRequest request = CreateSecondaryInstanceRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setInstance(instance).setInstanceId(instanceId).build();
        return this.createSecondaryInstanceAsync(request);
    }

    public final OperationFuture<Instance, OperationMetadata> createSecondaryInstanceAsync(String parent, Instance instance, String instanceId) {
        CreateSecondaryInstanceRequest request = CreateSecondaryInstanceRequest.newBuilder().setParent(parent).setInstance(instance).setInstanceId(instanceId).build();
        return this.createSecondaryInstanceAsync(request);
    }

    public final OperationFuture<Instance, OperationMetadata> createSecondaryInstanceAsync(CreateSecondaryInstanceRequest request) {
        return this.createSecondaryInstanceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateSecondaryInstanceRequest, Instance, OperationMetadata> createSecondaryInstanceOperationCallable() {
        return this.stub.createSecondaryInstanceOperationCallable();
    }

    public final UnaryCallable<CreateSecondaryInstanceRequest, Operation> createSecondaryInstanceCallable() {
        return this.stub.createSecondaryInstanceCallable();
    }

    public final OperationFuture<BatchCreateInstancesResponse, OperationMetadata> batchCreateInstancesAsync(BatchCreateInstancesRequest request) {
        return this.batchCreateInstancesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<BatchCreateInstancesRequest, BatchCreateInstancesResponse, OperationMetadata> batchCreateInstancesOperationCallable() {
        return this.stub.batchCreateInstancesOperationCallable();
    }

    public final UnaryCallable<BatchCreateInstancesRequest, Operation> batchCreateInstancesCallable() {
        return this.stub.batchCreateInstancesCallable();
    }

    public final OperationFuture<Instance, OperationMetadata> updateInstanceAsync(Instance instance, FieldMask updateMask) {
        UpdateInstanceRequest request = UpdateInstanceRequest.newBuilder().setInstance(instance).setUpdateMask(updateMask).build();
        return this.updateInstanceAsync(request);
    }

    public final OperationFuture<Instance, OperationMetadata> updateInstanceAsync(UpdateInstanceRequest request) {
        return this.updateInstanceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateInstanceRequest, Instance, OperationMetadata> updateInstanceOperationCallable() {
        return this.stub.updateInstanceOperationCallable();
    }

    public final UnaryCallable<UpdateInstanceRequest, Operation> updateInstanceCallable() {
        return this.stub.updateInstanceCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteInstanceAsync(InstanceName name) {
        DeleteInstanceRequest request = DeleteInstanceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteInstanceAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteInstanceAsync(String name) {
        DeleteInstanceRequest request = DeleteInstanceRequest.newBuilder().setName(name).build();
        return this.deleteInstanceAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteInstanceAsync(DeleteInstanceRequest request) {
        return this.deleteInstanceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteInstanceRequest, Empty, OperationMetadata> deleteInstanceOperationCallable() {
        return this.stub.deleteInstanceOperationCallable();
    }

    public final UnaryCallable<DeleteInstanceRequest, Operation> deleteInstanceCallable() {
        return this.stub.deleteInstanceCallable();
    }

    public final OperationFuture<Instance, OperationMetadata> failoverInstanceAsync(InstanceName name) {
        FailoverInstanceRequest request = FailoverInstanceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.failoverInstanceAsync(request);
    }

    public final OperationFuture<Instance, OperationMetadata> failoverInstanceAsync(String name) {
        FailoverInstanceRequest request = FailoverInstanceRequest.newBuilder().setName(name).build();
        return this.failoverInstanceAsync(request);
    }

    public final OperationFuture<Instance, OperationMetadata> failoverInstanceAsync(FailoverInstanceRequest request) {
        return this.failoverInstanceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<FailoverInstanceRequest, Instance, OperationMetadata> failoverInstanceOperationCallable() {
        return this.stub.failoverInstanceOperationCallable();
    }

    public final UnaryCallable<FailoverInstanceRequest, Operation> failoverInstanceCallable() {
        return this.stub.failoverInstanceCallable();
    }

    public final OperationFuture<Instance, OperationMetadata> injectFaultAsync(InjectFaultRequest.FaultType faultType, InstanceName name) {
        InjectFaultRequest request = InjectFaultRequest.newBuilder().setFaultType(faultType).setName(name == null ? null : name.toString()).build();
        return this.injectFaultAsync(request);
    }

    public final OperationFuture<Instance, OperationMetadata> injectFaultAsync(InjectFaultRequest.FaultType faultType, String name) {
        InjectFaultRequest request = InjectFaultRequest.newBuilder().setFaultType(faultType).setName(name).build();
        return this.injectFaultAsync(request);
    }

    public final OperationFuture<Instance, OperationMetadata> injectFaultAsync(InjectFaultRequest request) {
        return this.injectFaultOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<InjectFaultRequest, Instance, OperationMetadata> injectFaultOperationCallable() {
        return this.stub.injectFaultOperationCallable();
    }

    public final UnaryCallable<InjectFaultRequest, Operation> injectFaultCallable() {
        return this.stub.injectFaultCallable();
    }

    public final OperationFuture<Instance, OperationMetadata> restartInstanceAsync(InstanceName name) {
        RestartInstanceRequest request = RestartInstanceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.restartInstanceAsync(request);
    }

    public final OperationFuture<Instance, OperationMetadata> restartInstanceAsync(String name) {
        RestartInstanceRequest request = RestartInstanceRequest.newBuilder().setName(name).build();
        return this.restartInstanceAsync(request);
    }

    public final OperationFuture<Instance, OperationMetadata> restartInstanceAsync(RestartInstanceRequest request) {
        return this.restartInstanceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RestartInstanceRequest, Instance, OperationMetadata> restartInstanceOperationCallable() {
        return this.stub.restartInstanceOperationCallable();
    }

    public final UnaryCallable<RestartInstanceRequest, Operation> restartInstanceCallable() {
        return this.stub.restartInstanceCallable();
    }

    public final ExecuteSqlResponse executeSql(InstanceName instance, String database, String user, String sqlStatement, String password) {
        ExecuteSqlRequest request = ExecuteSqlRequest.newBuilder().setInstance(instance == null ? null : instance.toString()).setDatabase(database).setUser(user).setSqlStatement(sqlStatement).setPassword(password).build();
        return this.executeSql(request);
    }

    public final ExecuteSqlResponse executeSql(String instance, String database, String user, String sqlStatement, String password) {
        ExecuteSqlRequest request = ExecuteSqlRequest.newBuilder().setInstance(instance).setDatabase(database).setUser(user).setSqlStatement(sqlStatement).setPassword(password).build();
        return this.executeSql(request);
    }

    public final ExecuteSqlResponse executeSql(ExecuteSqlRequest request) {
        return (ExecuteSqlResponse)this.executeSqlCallable().call((Object)request);
    }

    public final UnaryCallable<ExecuteSqlRequest, ExecuteSqlResponse> executeSqlCallable() {
        return this.stub.executeSqlCallable();
    }

    public final ListBackupsPagedResponse listBackups(LocationName parent) {
        ListBackupsRequest request = ListBackupsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listBackups(request);
    }

    public final ListBackupsPagedResponse listBackups(String parent) {
        ListBackupsRequest request = ListBackupsRequest.newBuilder().setParent(parent).build();
        return this.listBackups(request);
    }

    public final ListBackupsPagedResponse listBackups(ListBackupsRequest request) {
        return (ListBackupsPagedResponse)((Object)this.listBackupsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListBackupsRequest, ListBackupsPagedResponse> listBackupsPagedCallable() {
        return this.stub.listBackupsPagedCallable();
    }

    public final UnaryCallable<ListBackupsRequest, ListBackupsResponse> listBackupsCallable() {
        return this.stub.listBackupsCallable();
    }

    public final Backup getBackup(BackupName name) {
        GetBackupRequest request = GetBackupRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getBackup(request);
    }

    public final Backup getBackup(String name) {
        GetBackupRequest request = GetBackupRequest.newBuilder().setName(name).build();
        return this.getBackup(request);
    }

    public final Backup getBackup(GetBackupRequest request) {
        return (Backup)this.getBackupCallable().call((Object)request);
    }

    public final UnaryCallable<GetBackupRequest, Backup> getBackupCallable() {
        return this.stub.getBackupCallable();
    }

    public final OperationFuture<Backup, OperationMetadata> createBackupAsync(LocationName parent, Backup backup, String backupId) {
        CreateBackupRequest request = CreateBackupRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setBackup(backup).setBackupId(backupId).build();
        return this.createBackupAsync(request);
    }

    public final OperationFuture<Backup, OperationMetadata> createBackupAsync(String parent, Backup backup, String backupId) {
        CreateBackupRequest request = CreateBackupRequest.newBuilder().setParent(parent).setBackup(backup).setBackupId(backupId).build();
        return this.createBackupAsync(request);
    }

    public final OperationFuture<Backup, OperationMetadata> createBackupAsync(CreateBackupRequest request) {
        return this.createBackupOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateBackupRequest, Backup, OperationMetadata> createBackupOperationCallable() {
        return this.stub.createBackupOperationCallable();
    }

    public final UnaryCallable<CreateBackupRequest, Operation> createBackupCallable() {
        return this.stub.createBackupCallable();
    }

    public final OperationFuture<Backup, OperationMetadata> updateBackupAsync(Backup backup, FieldMask updateMask) {
        UpdateBackupRequest request = UpdateBackupRequest.newBuilder().setBackup(backup).setUpdateMask(updateMask).build();
        return this.updateBackupAsync(request);
    }

    public final OperationFuture<Backup, OperationMetadata> updateBackupAsync(UpdateBackupRequest request) {
        return this.updateBackupOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateBackupRequest, Backup, OperationMetadata> updateBackupOperationCallable() {
        return this.stub.updateBackupOperationCallable();
    }

    public final UnaryCallable<UpdateBackupRequest, Operation> updateBackupCallable() {
        return this.stub.updateBackupCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteBackupAsync(BackupName name) {
        DeleteBackupRequest request = DeleteBackupRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteBackupAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteBackupAsync(String name) {
        DeleteBackupRequest request = DeleteBackupRequest.newBuilder().setName(name).build();
        return this.deleteBackupAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteBackupAsync(DeleteBackupRequest request) {
        return this.deleteBackupOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteBackupRequest, Empty, OperationMetadata> deleteBackupOperationCallable() {
        return this.stub.deleteBackupOperationCallable();
    }

    public final UnaryCallable<DeleteBackupRequest, Operation> deleteBackupCallable() {
        return this.stub.deleteBackupCallable();
    }

    public final ListSupportedDatabaseFlagsPagedResponse listSupportedDatabaseFlags(LocationName parent) {
        ListSupportedDatabaseFlagsRequest request = ListSupportedDatabaseFlagsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listSupportedDatabaseFlags(request);
    }

    public final ListSupportedDatabaseFlagsPagedResponse listSupportedDatabaseFlags(String parent) {
        ListSupportedDatabaseFlagsRequest request = ListSupportedDatabaseFlagsRequest.newBuilder().setParent(parent).build();
        return this.listSupportedDatabaseFlags(request);
    }

    public final ListSupportedDatabaseFlagsPagedResponse listSupportedDatabaseFlags(ListSupportedDatabaseFlagsRequest request) {
        return (ListSupportedDatabaseFlagsPagedResponse)((Object)this.listSupportedDatabaseFlagsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSupportedDatabaseFlagsRequest, ListSupportedDatabaseFlagsPagedResponse> listSupportedDatabaseFlagsPagedCallable() {
        return this.stub.listSupportedDatabaseFlagsPagedCallable();
    }

    public final UnaryCallable<ListSupportedDatabaseFlagsRequest, ListSupportedDatabaseFlagsResponse> listSupportedDatabaseFlagsCallable() {
        return this.stub.listSupportedDatabaseFlagsCallable();
    }

    public final GenerateClientCertificateResponse generateClientCertificate(ClusterName parent) {
        GenerateClientCertificateRequest request = GenerateClientCertificateRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.generateClientCertificate(request);
    }

    public final GenerateClientCertificateResponse generateClientCertificate(String parent) {
        GenerateClientCertificateRequest request = GenerateClientCertificateRequest.newBuilder().setParent(parent).build();
        return this.generateClientCertificate(request);
    }

    public final GenerateClientCertificateResponse generateClientCertificate(GenerateClientCertificateRequest request) {
        return (GenerateClientCertificateResponse)this.generateClientCertificateCallable().call((Object)request);
    }

    public final UnaryCallable<GenerateClientCertificateRequest, GenerateClientCertificateResponse> generateClientCertificateCallable() {
        return this.stub.generateClientCertificateCallable();
    }

    public final ConnectionInfo getConnectionInfo(InstanceName parent) {
        GetConnectionInfoRequest request = GetConnectionInfoRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.getConnectionInfo(request);
    }

    public final ConnectionInfo getConnectionInfo(String parent) {
        GetConnectionInfoRequest request = GetConnectionInfoRequest.newBuilder().setParent(parent).build();
        return this.getConnectionInfo(request);
    }

    public final ConnectionInfo getConnectionInfo(GetConnectionInfoRequest request) {
        return (ConnectionInfo)this.getConnectionInfoCallable().call((Object)request);
    }

    public final UnaryCallable<GetConnectionInfoRequest, ConnectionInfo> getConnectionInfoCallable() {
        return this.stub.getConnectionInfoCallable();
    }

    public final ListUsersPagedResponse listUsers(ClusterName parent) {
        ListUsersRequest request = ListUsersRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listUsers(request);
    }

    public final ListUsersPagedResponse listUsers(String parent) {
        ListUsersRequest request = ListUsersRequest.newBuilder().setParent(parent).build();
        return this.listUsers(request);
    }

    public final ListUsersPagedResponse listUsers(ListUsersRequest request) {
        return (ListUsersPagedResponse)((Object)this.listUsersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListUsersRequest, ListUsersPagedResponse> listUsersPagedCallable() {
        return this.stub.listUsersPagedCallable();
    }

    public final UnaryCallable<ListUsersRequest, ListUsersResponse> listUsersCallable() {
        return this.stub.listUsersCallable();
    }

    public final User getUser(UserName name) {
        GetUserRequest request = GetUserRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getUser(request);
    }

    public final User getUser(String name) {
        GetUserRequest request = GetUserRequest.newBuilder().setName(name).build();
        return this.getUser(request);
    }

    public final User getUser(GetUserRequest request) {
        return (User)this.getUserCallable().call((Object)request);
    }

    public final UnaryCallable<GetUserRequest, User> getUserCallable() {
        return this.stub.getUserCallable();
    }

    public final User createUser(ClusterName parent, User user, String userId) {
        CreateUserRequest request = CreateUserRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setUser(user).setUserId(userId).build();
        return this.createUser(request);
    }

    public final User createUser(String parent, User user, String userId) {
        CreateUserRequest request = CreateUserRequest.newBuilder().setParent(parent).setUser(user).setUserId(userId).build();
        return this.createUser(request);
    }

    public final User createUser(CreateUserRequest request) {
        return (User)this.createUserCallable().call((Object)request);
    }

    public final UnaryCallable<CreateUserRequest, User> createUserCallable() {
        return this.stub.createUserCallable();
    }

    public final User updateUser(User user, FieldMask updateMask) {
        UpdateUserRequest request = UpdateUserRequest.newBuilder().setUser(user).setUpdateMask(updateMask).build();
        return this.updateUser(request);
    }

    public final User updateUser(UpdateUserRequest request) {
        return (User)this.updateUserCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateUserRequest, User> updateUserCallable() {
        return this.stub.updateUserCallable();
    }

    public final void deleteUser(UserName name) {
        DeleteUserRequest request = DeleteUserRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteUser(request);
    }

    public final void deleteUser(String name) {
        DeleteUserRequest request = DeleteUserRequest.newBuilder().setName(name).build();
        this.deleteUser(request);
    }

    public final void deleteUser(DeleteUserRequest request) {
        this.deleteUserCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteUserRequest, Empty> deleteUserCallable() {
        return this.stub.deleteUserCallable();
    }

    public final ListDatabasesPagedResponse listDatabases(ClusterName parent) {
        ListDatabasesRequest request = ListDatabasesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDatabases(request);
    }

    public final ListDatabasesPagedResponse listDatabases(String parent) {
        ListDatabasesRequest request = ListDatabasesRequest.newBuilder().setParent(parent).build();
        return this.listDatabases(request);
    }

    public final ListDatabasesPagedResponse listDatabases(ListDatabasesRequest request) {
        return (ListDatabasesPagedResponse)((Object)this.listDatabasesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDatabasesRequest, ListDatabasesPagedResponse> listDatabasesPagedCallable() {
        return this.stub.listDatabasesPagedCallable();
    }

    public final UnaryCallable<ListDatabasesRequest, ListDatabasesResponse> listDatabasesCallable() {
        return this.stub.listDatabasesCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDatabasesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDatabasesRequest, ListDatabasesResponse, Database, ListDatabasesPage, ListDatabasesFixedSizeCollection> {
        private ListDatabasesFixedSizeCollection(List<ListDatabasesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDatabasesFixedSizeCollection createEmptyCollection() {
            return new ListDatabasesFixedSizeCollection(null, 0);
        }

        protected ListDatabasesFixedSizeCollection createCollection(List<ListDatabasesPage> pages, int collectionSize) {
            return new ListDatabasesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDatabasesPage
    extends AbstractPage<ListDatabasesRequest, ListDatabasesResponse, Database, ListDatabasesPage> {
        private ListDatabasesPage(PageContext<ListDatabasesRequest, ListDatabasesResponse, Database> context, ListDatabasesResponse response) {
            super(context, (Object)response);
        }

        private static ListDatabasesPage createEmptyPage() {
            return new ListDatabasesPage(null, null);
        }

        protected ListDatabasesPage createPage(PageContext<ListDatabasesRequest, ListDatabasesResponse, Database> context, ListDatabasesResponse response) {
            return new ListDatabasesPage(context, response);
        }

        public ApiFuture<ListDatabasesPage> createPageAsync(PageContext<ListDatabasesRequest, ListDatabasesResponse, Database> context, ApiFuture<ListDatabasesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDatabasesPagedResponse
    extends AbstractPagedListResponse<ListDatabasesRequest, ListDatabasesResponse, Database, ListDatabasesPage, ListDatabasesFixedSizeCollection> {
        public static ApiFuture<ListDatabasesPagedResponse> createAsync(PageContext<ListDatabasesRequest, ListDatabasesResponse, Database> context, ApiFuture<ListDatabasesResponse> futureResponse) {
            ApiFuture<ListDatabasesPage> futurePage = ListDatabasesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDatabasesPagedResponse((ListDatabasesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDatabasesPagedResponse(ListDatabasesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDatabasesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListUsersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListUsersRequest, ListUsersResponse, User, ListUsersPage, ListUsersFixedSizeCollection> {
        private ListUsersFixedSizeCollection(List<ListUsersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListUsersFixedSizeCollection createEmptyCollection() {
            return new ListUsersFixedSizeCollection(null, 0);
        }

        protected ListUsersFixedSizeCollection createCollection(List<ListUsersPage> pages, int collectionSize) {
            return new ListUsersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListUsersPage
    extends AbstractPage<ListUsersRequest, ListUsersResponse, User, ListUsersPage> {
        private ListUsersPage(PageContext<ListUsersRequest, ListUsersResponse, User> context, ListUsersResponse response) {
            super(context, (Object)response);
        }

        private static ListUsersPage createEmptyPage() {
            return new ListUsersPage(null, null);
        }

        protected ListUsersPage createPage(PageContext<ListUsersRequest, ListUsersResponse, User> context, ListUsersResponse response) {
            return new ListUsersPage(context, response);
        }

        public ApiFuture<ListUsersPage> createPageAsync(PageContext<ListUsersRequest, ListUsersResponse, User> context, ApiFuture<ListUsersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListUsersPagedResponse
    extends AbstractPagedListResponse<ListUsersRequest, ListUsersResponse, User, ListUsersPage, ListUsersFixedSizeCollection> {
        public static ApiFuture<ListUsersPagedResponse> createAsync(PageContext<ListUsersRequest, ListUsersResponse, User> context, ApiFuture<ListUsersResponse> futureResponse) {
            ApiFuture<ListUsersPage> futurePage = ListUsersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListUsersPagedResponse((ListUsersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListUsersPagedResponse(ListUsersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListUsersFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListSupportedDatabaseFlagsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSupportedDatabaseFlagsRequest, ListSupportedDatabaseFlagsResponse, SupportedDatabaseFlag, ListSupportedDatabaseFlagsPage, ListSupportedDatabaseFlagsFixedSizeCollection> {
        private ListSupportedDatabaseFlagsFixedSizeCollection(List<ListSupportedDatabaseFlagsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSupportedDatabaseFlagsFixedSizeCollection createEmptyCollection() {
            return new ListSupportedDatabaseFlagsFixedSizeCollection(null, 0);
        }

        protected ListSupportedDatabaseFlagsFixedSizeCollection createCollection(List<ListSupportedDatabaseFlagsPage> pages, int collectionSize) {
            return new ListSupportedDatabaseFlagsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSupportedDatabaseFlagsPage
    extends AbstractPage<ListSupportedDatabaseFlagsRequest, ListSupportedDatabaseFlagsResponse, SupportedDatabaseFlag, ListSupportedDatabaseFlagsPage> {
        private ListSupportedDatabaseFlagsPage(PageContext<ListSupportedDatabaseFlagsRequest, ListSupportedDatabaseFlagsResponse, SupportedDatabaseFlag> context, ListSupportedDatabaseFlagsResponse response) {
            super(context, (Object)response);
        }

        private static ListSupportedDatabaseFlagsPage createEmptyPage() {
            return new ListSupportedDatabaseFlagsPage(null, null);
        }

        protected ListSupportedDatabaseFlagsPage createPage(PageContext<ListSupportedDatabaseFlagsRequest, ListSupportedDatabaseFlagsResponse, SupportedDatabaseFlag> context, ListSupportedDatabaseFlagsResponse response) {
            return new ListSupportedDatabaseFlagsPage(context, response);
        }

        public ApiFuture<ListSupportedDatabaseFlagsPage> createPageAsync(PageContext<ListSupportedDatabaseFlagsRequest, ListSupportedDatabaseFlagsResponse, SupportedDatabaseFlag> context, ApiFuture<ListSupportedDatabaseFlagsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSupportedDatabaseFlagsPagedResponse
    extends AbstractPagedListResponse<ListSupportedDatabaseFlagsRequest, ListSupportedDatabaseFlagsResponse, SupportedDatabaseFlag, ListSupportedDatabaseFlagsPage, ListSupportedDatabaseFlagsFixedSizeCollection> {
        public static ApiFuture<ListSupportedDatabaseFlagsPagedResponse> createAsync(PageContext<ListSupportedDatabaseFlagsRequest, ListSupportedDatabaseFlagsResponse, SupportedDatabaseFlag> context, ApiFuture<ListSupportedDatabaseFlagsResponse> futureResponse) {
            ApiFuture<ListSupportedDatabaseFlagsPage> futurePage = ListSupportedDatabaseFlagsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListSupportedDatabaseFlagsPagedResponse((ListSupportedDatabaseFlagsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListSupportedDatabaseFlagsPagedResponse(ListSupportedDatabaseFlagsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSupportedDatabaseFlagsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListBackupsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListBackupsRequest, ListBackupsResponse, Backup, ListBackupsPage, ListBackupsFixedSizeCollection> {
        private ListBackupsFixedSizeCollection(List<ListBackupsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListBackupsFixedSizeCollection createEmptyCollection() {
            return new ListBackupsFixedSizeCollection(null, 0);
        }

        protected ListBackupsFixedSizeCollection createCollection(List<ListBackupsPage> pages, int collectionSize) {
            return new ListBackupsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListBackupsPage
    extends AbstractPage<ListBackupsRequest, ListBackupsResponse, Backup, ListBackupsPage> {
        private ListBackupsPage(PageContext<ListBackupsRequest, ListBackupsResponse, Backup> context, ListBackupsResponse response) {
            super(context, (Object)response);
        }

        private static ListBackupsPage createEmptyPage() {
            return new ListBackupsPage(null, null);
        }

        protected ListBackupsPage createPage(PageContext<ListBackupsRequest, ListBackupsResponse, Backup> context, ListBackupsResponse response) {
            return new ListBackupsPage(context, response);
        }

        public ApiFuture<ListBackupsPage> createPageAsync(PageContext<ListBackupsRequest, ListBackupsResponse, Backup> context, ApiFuture<ListBackupsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListBackupsPagedResponse
    extends AbstractPagedListResponse<ListBackupsRequest, ListBackupsResponse, Backup, ListBackupsPage, ListBackupsFixedSizeCollection> {
        public static ApiFuture<ListBackupsPagedResponse> createAsync(PageContext<ListBackupsRequest, ListBackupsResponse, Backup> context, ApiFuture<ListBackupsResponse> futureResponse) {
            ApiFuture<ListBackupsPage> futurePage = ListBackupsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListBackupsPagedResponse((ListBackupsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListBackupsPagedResponse(ListBackupsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListBackupsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListInstancesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListInstancesRequest, ListInstancesResponse, Instance, ListInstancesPage, ListInstancesFixedSizeCollection> {
        private ListInstancesFixedSizeCollection(List<ListInstancesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListInstancesFixedSizeCollection createEmptyCollection() {
            return new ListInstancesFixedSizeCollection(null, 0);
        }

        protected ListInstancesFixedSizeCollection createCollection(List<ListInstancesPage> pages, int collectionSize) {
            return new ListInstancesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListInstancesPage
    extends AbstractPage<ListInstancesRequest, ListInstancesResponse, Instance, ListInstancesPage> {
        private ListInstancesPage(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ListInstancesResponse response) {
            super(context, (Object)response);
        }

        private static ListInstancesPage createEmptyPage() {
            return new ListInstancesPage(null, null);
        }

        protected ListInstancesPage createPage(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ListInstancesResponse response) {
            return new ListInstancesPage(context, response);
        }

        public ApiFuture<ListInstancesPage> createPageAsync(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ApiFuture<ListInstancesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListInstancesPagedResponse
    extends AbstractPagedListResponse<ListInstancesRequest, ListInstancesResponse, Instance, ListInstancesPage, ListInstancesFixedSizeCollection> {
        public static ApiFuture<ListInstancesPagedResponse> createAsync(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ApiFuture<ListInstancesResponse> futureResponse) {
            ApiFuture<ListInstancesPage> futurePage = ListInstancesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListInstancesPagedResponse((ListInstancesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListInstancesPagedResponse(ListInstancesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListInstancesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListClustersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListClustersRequest, ListClustersResponse, Cluster, ListClustersPage, ListClustersFixedSizeCollection> {
        private ListClustersFixedSizeCollection(List<ListClustersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListClustersFixedSizeCollection createEmptyCollection() {
            return new ListClustersFixedSizeCollection(null, 0);
        }

        protected ListClustersFixedSizeCollection createCollection(List<ListClustersPage> pages, int collectionSize) {
            return new ListClustersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListClustersPage
    extends AbstractPage<ListClustersRequest, ListClustersResponse, Cluster, ListClustersPage> {
        private ListClustersPage(PageContext<ListClustersRequest, ListClustersResponse, Cluster> context, ListClustersResponse response) {
            super(context, (Object)response);
        }

        private static ListClustersPage createEmptyPage() {
            return new ListClustersPage(null, null);
        }

        protected ListClustersPage createPage(PageContext<ListClustersRequest, ListClustersResponse, Cluster> context, ListClustersResponse response) {
            return new ListClustersPage(context, response);
        }

        public ApiFuture<ListClustersPage> createPageAsync(PageContext<ListClustersRequest, ListClustersResponse, Cluster> context, ApiFuture<ListClustersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListClustersPagedResponse
    extends AbstractPagedListResponse<ListClustersRequest, ListClustersResponse, Cluster, ListClustersPage, ListClustersFixedSizeCollection> {
        public static ApiFuture<ListClustersPagedResponse> createAsync(PageContext<ListClustersRequest, ListClustersResponse, Cluster> context, ApiFuture<ListClustersResponse> futureResponse) {
            ApiFuture<ListClustersPage> futurePage = ListClustersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListClustersPagedResponse((ListClustersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListClustersPagedResponse(ListClustersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListClustersFixedSizeCollection.createEmptyCollection());
        }
    }
}

