/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1.CreateIndexOperationMetadata;
import com.google.cloud.aiplatform.v1.CreateIndexRequest;
import com.google.cloud.aiplatform.v1.DeleteIndexRequest;
import com.google.cloud.aiplatform.v1.DeleteOperationMetadata;
import com.google.cloud.aiplatform.v1.GetIndexRequest;
import com.google.cloud.aiplatform.v1.Index;
import com.google.cloud.aiplatform.v1.IndexServiceClient;
import com.google.cloud.aiplatform.v1.ListIndexesRequest;
import com.google.cloud.aiplatform.v1.ListIndexesResponse;
import com.google.cloud.aiplatform.v1.RemoveDatapointsRequest;
import com.google.cloud.aiplatform.v1.RemoveDatapointsResponse;
import com.google.cloud.aiplatform.v1.UpdateIndexOperationMetadata;
import com.google.cloud.aiplatform.v1.UpdateIndexRequest;
import com.google.cloud.aiplatform.v1.UpsertDatapointsRequest;
import com.google.cloud.aiplatform.v1.UpsertDatapointsResponse;
import com.google.cloud.aiplatform.v1.stub.GrpcIndexServiceCallableFactory;
import com.google.cloud.aiplatform.v1.stub.IndexServiceStub;
import com.google.cloud.aiplatform.v1.stub.IndexServiceStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcIndexServiceStub
extends IndexServiceStub {
    private static final MethodDescriptor<CreateIndexRequest, Operation> createIndexMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.IndexService/CreateIndex").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateIndexRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetIndexRequest, Index> getIndexMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.IndexService/GetIndex").setRequestMarshaller(ProtoUtils.marshaller((Message)GetIndexRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Index.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListIndexesRequest, ListIndexesResponse> listIndexesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.IndexService/ListIndexes").setRequestMarshaller(ProtoUtils.marshaller((Message)ListIndexesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListIndexesResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateIndexRequest, Operation> updateIndexMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.IndexService/UpdateIndex").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateIndexRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteIndexRequest, Operation> deleteIndexMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.IndexService/DeleteIndex").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteIndexRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpsertDatapointsRequest, UpsertDatapointsResponse> upsertDatapointsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.IndexService/UpsertDatapoints").setRequestMarshaller(ProtoUtils.marshaller((Message)UpsertDatapointsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)UpsertDatapointsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<RemoveDatapointsRequest, RemoveDatapointsResponse> removeDatapointsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.IndexService/RemoveDatapoints").setRequestMarshaller(ProtoUtils.marshaller((Message)RemoveDatapointsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)RemoveDatapointsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/SetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)SetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/GetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)GetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/TestIamPermissions").setRequestMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<CreateIndexRequest, Operation> createIndexCallable;
    private final OperationCallable<CreateIndexRequest, Index, CreateIndexOperationMetadata> createIndexOperationCallable;
    private final UnaryCallable<GetIndexRequest, Index> getIndexCallable;
    private final UnaryCallable<ListIndexesRequest, ListIndexesResponse> listIndexesCallable;
    private final UnaryCallable<ListIndexesRequest, IndexServiceClient.ListIndexesPagedResponse> listIndexesPagedCallable;
    private final UnaryCallable<UpdateIndexRequest, Operation> updateIndexCallable;
    private final OperationCallable<UpdateIndexRequest, Index, UpdateIndexOperationMetadata> updateIndexOperationCallable;
    private final UnaryCallable<DeleteIndexRequest, Operation> deleteIndexCallable;
    private final OperationCallable<DeleteIndexRequest, Empty, DeleteOperationMetadata> deleteIndexOperationCallable;
    private final UnaryCallable<UpsertDatapointsRequest, UpsertDatapointsResponse> upsertDatapointsCallable;
    private final UnaryCallable<RemoveDatapointsRequest, RemoveDatapointsResponse> removeDatapointsCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, IndexServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcIndexServiceStub create(IndexServiceStubSettings settings) throws IOException {
        return new GrpcIndexServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcIndexServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcIndexServiceStub(IndexServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcIndexServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcIndexServiceStub(IndexServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcIndexServiceStub(IndexServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcIndexServiceCallableFactory());
    }

    protected GrpcIndexServiceStub(IndexServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createIndexTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createIndexMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getIndexTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getIndexMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listIndexesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listIndexesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updateIndexTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateIndexMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("index.name", String.valueOf(request.getIndex().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteIndexTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteIndexMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings upsertDatapointsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(upsertDatapointsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("index", String.valueOf(request.getIndex()));
            return builder.build();
        }).build();
        GrpcCallSettings removeDatapointsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(removeDatapointsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("index", String.valueOf(request.getIndex()));
            return builder.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings setIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings getIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings testIamPermissionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        this.createIndexCallable = callableFactory.createUnaryCallable(createIndexTransportSettings, settings.createIndexSettings(), clientContext);
        this.createIndexOperationCallable = callableFactory.createOperationCallable(createIndexTransportSettings, settings.createIndexOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getIndexCallable = callableFactory.createUnaryCallable(getIndexTransportSettings, settings.getIndexSettings(), clientContext);
        this.listIndexesCallable = callableFactory.createUnaryCallable(listIndexesTransportSettings, settings.listIndexesSettings(), clientContext);
        this.listIndexesPagedCallable = callableFactory.createPagedCallable(listIndexesTransportSettings, settings.listIndexesSettings(), clientContext);
        this.updateIndexCallable = callableFactory.createUnaryCallable(updateIndexTransportSettings, settings.updateIndexSettings(), clientContext);
        this.updateIndexOperationCallable = callableFactory.createOperationCallable(updateIndexTransportSettings, settings.updateIndexOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteIndexCallable = callableFactory.createUnaryCallable(deleteIndexTransportSettings, settings.deleteIndexSettings(), clientContext);
        this.deleteIndexOperationCallable = callableFactory.createOperationCallable(deleteIndexTransportSettings, settings.deleteIndexOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.upsertDatapointsCallable = callableFactory.createUnaryCallable(upsertDatapointsTransportSettings, settings.upsertDatapointsSettings(), clientContext);
        this.removeDatapointsCallable = callableFactory.createUnaryCallable(removeDatapointsTransportSettings, settings.removeDatapointsSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateIndexRequest, Operation> createIndexCallable() {
        return this.createIndexCallable;
    }

    @Override
    public OperationCallable<CreateIndexRequest, Index, CreateIndexOperationMetadata> createIndexOperationCallable() {
        return this.createIndexOperationCallable;
    }

    @Override
    public UnaryCallable<GetIndexRequest, Index> getIndexCallable() {
        return this.getIndexCallable;
    }

    @Override
    public UnaryCallable<ListIndexesRequest, ListIndexesResponse> listIndexesCallable() {
        return this.listIndexesCallable;
    }

    @Override
    public UnaryCallable<ListIndexesRequest, IndexServiceClient.ListIndexesPagedResponse> listIndexesPagedCallable() {
        return this.listIndexesPagedCallable;
    }

    @Override
    public UnaryCallable<UpdateIndexRequest, Operation> updateIndexCallable() {
        return this.updateIndexCallable;
    }

    @Override
    public OperationCallable<UpdateIndexRequest, Index, UpdateIndexOperationMetadata> updateIndexOperationCallable() {
        return this.updateIndexOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteIndexRequest, Operation> deleteIndexCallable() {
        return this.deleteIndexCallable;
    }

    @Override
    public OperationCallable<DeleteIndexRequest, Empty, DeleteOperationMetadata> deleteIndexOperationCallable() {
        return this.deleteIndexOperationCallable;
    }

    @Override
    public UnaryCallable<UpsertDatapointsRequest, UpsertDatapointsResponse> upsertDatapointsCallable() {
        return this.upsertDatapointsCallable;
    }

    @Override
    public UnaryCallable<RemoveDatapointsRequest, RemoveDatapointsResponse> removeDatapointsCallable() {
        return this.removeDatapointsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, IndexServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

