/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1beta1.CreateIndexEndpointOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.CreateIndexEndpointRequest;
import com.google.cloud.aiplatform.v1beta1.DeleteIndexEndpointRequest;
import com.google.cloud.aiplatform.v1beta1.DeleteOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.DeployIndexOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.DeployIndexRequest;
import com.google.cloud.aiplatform.v1beta1.DeployIndexResponse;
import com.google.cloud.aiplatform.v1beta1.GetIndexEndpointRequest;
import com.google.cloud.aiplatform.v1beta1.IndexEndpoint;
import com.google.cloud.aiplatform.v1beta1.IndexEndpointServiceClient;
import com.google.cloud.aiplatform.v1beta1.ListIndexEndpointsRequest;
import com.google.cloud.aiplatform.v1beta1.ListIndexEndpointsResponse;
import com.google.cloud.aiplatform.v1beta1.MutateDeployedIndexOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.MutateDeployedIndexRequest;
import com.google.cloud.aiplatform.v1beta1.MutateDeployedIndexResponse;
import com.google.cloud.aiplatform.v1beta1.UndeployIndexOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.UndeployIndexRequest;
import com.google.cloud.aiplatform.v1beta1.UndeployIndexResponse;
import com.google.cloud.aiplatform.v1beta1.UpdateIndexEndpointRequest;
import com.google.cloud.aiplatform.v1beta1.stub.GrpcIndexEndpointServiceStub;
import com.google.cloud.aiplatform.v1beta1.stub.IndexEndpointServiceStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class IndexEndpointServiceStubSettings
extends StubSettings<IndexEndpointServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateIndexEndpointRequest, Operation> createIndexEndpointSettings;
    private final OperationCallSettings<CreateIndexEndpointRequest, IndexEndpoint, CreateIndexEndpointOperationMetadata> createIndexEndpointOperationSettings;
    private final UnaryCallSettings<GetIndexEndpointRequest, IndexEndpoint> getIndexEndpointSettings;
    private final PagedCallSettings<ListIndexEndpointsRequest, ListIndexEndpointsResponse, IndexEndpointServiceClient.ListIndexEndpointsPagedResponse> listIndexEndpointsSettings;
    private final UnaryCallSettings<UpdateIndexEndpointRequest, IndexEndpoint> updateIndexEndpointSettings;
    private final UnaryCallSettings<DeleteIndexEndpointRequest, Operation> deleteIndexEndpointSettings;
    private final OperationCallSettings<DeleteIndexEndpointRequest, Empty, DeleteOperationMetadata> deleteIndexEndpointOperationSettings;
    private final UnaryCallSettings<DeployIndexRequest, Operation> deployIndexSettings;
    private final OperationCallSettings<DeployIndexRequest, DeployIndexResponse, DeployIndexOperationMetadata> deployIndexOperationSettings;
    private final UnaryCallSettings<UndeployIndexRequest, Operation> undeployIndexSettings;
    private final OperationCallSettings<UndeployIndexRequest, UndeployIndexResponse, UndeployIndexOperationMetadata> undeployIndexOperationSettings;
    private final UnaryCallSettings<MutateDeployedIndexRequest, Operation> mutateDeployedIndexSettings;
    private final OperationCallSettings<MutateDeployedIndexRequest, MutateDeployedIndexResponse, MutateDeployedIndexOperationMetadata> mutateDeployedIndexOperationSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, IndexEndpointServiceClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListIndexEndpointsRequest, ListIndexEndpointsResponse, IndexEndpoint> LIST_INDEX_ENDPOINTS_PAGE_STR_DESC = new PagedListDescriptor<ListIndexEndpointsRequest, ListIndexEndpointsResponse, IndexEndpoint>(){

        public String emptyToken() {
            return "";
        }

        public ListIndexEndpointsRequest injectToken(ListIndexEndpointsRequest payload, String token) {
            return ListIndexEndpointsRequest.newBuilder((ListIndexEndpointsRequest)payload).setPageToken(token).build();
        }

        public ListIndexEndpointsRequest injectPageSize(ListIndexEndpointsRequest payload, int pageSize) {
            return ListIndexEndpointsRequest.newBuilder((ListIndexEndpointsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListIndexEndpointsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListIndexEndpointsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<IndexEndpoint> extractResources(ListIndexEndpointsResponse payload) {
            return payload.getIndexEndpointsList() == null ? ImmutableList.of() : payload.getIndexEndpointsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList() == null ? ImmutableList.of() : payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListIndexEndpointsRequest, ListIndexEndpointsResponse, IndexEndpointServiceClient.ListIndexEndpointsPagedResponse> LIST_INDEX_ENDPOINTS_PAGE_STR_FACT = new PagedListResponseFactory<ListIndexEndpointsRequest, ListIndexEndpointsResponse, IndexEndpointServiceClient.ListIndexEndpointsPagedResponse>(){

        public ApiFuture<IndexEndpointServiceClient.ListIndexEndpointsPagedResponse> getFuturePagedResponse(UnaryCallable<ListIndexEndpointsRequest, ListIndexEndpointsResponse> callable, ListIndexEndpointsRequest request, ApiCallContext context, ApiFuture<ListIndexEndpointsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_INDEX_ENDPOINTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return IndexEndpointServiceClient.ListIndexEndpointsPagedResponse.createAsync((PageContext<ListIndexEndpointsRequest, ListIndexEndpointsResponse, IndexEndpoint>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, IndexEndpointServiceClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, IndexEndpointServiceClient.ListLocationsPagedResponse>(){

        public ApiFuture<IndexEndpointServiceClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return IndexEndpointServiceClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateIndexEndpointRequest, Operation> createIndexEndpointSettings() {
        return this.createIndexEndpointSettings;
    }

    public OperationCallSettings<CreateIndexEndpointRequest, IndexEndpoint, CreateIndexEndpointOperationMetadata> createIndexEndpointOperationSettings() {
        return this.createIndexEndpointOperationSettings;
    }

    public UnaryCallSettings<GetIndexEndpointRequest, IndexEndpoint> getIndexEndpointSettings() {
        return this.getIndexEndpointSettings;
    }

    public PagedCallSettings<ListIndexEndpointsRequest, ListIndexEndpointsResponse, IndexEndpointServiceClient.ListIndexEndpointsPagedResponse> listIndexEndpointsSettings() {
        return this.listIndexEndpointsSettings;
    }

    public UnaryCallSettings<UpdateIndexEndpointRequest, IndexEndpoint> updateIndexEndpointSettings() {
        return this.updateIndexEndpointSettings;
    }

    public UnaryCallSettings<DeleteIndexEndpointRequest, Operation> deleteIndexEndpointSettings() {
        return this.deleteIndexEndpointSettings;
    }

    public OperationCallSettings<DeleteIndexEndpointRequest, Empty, DeleteOperationMetadata> deleteIndexEndpointOperationSettings() {
        return this.deleteIndexEndpointOperationSettings;
    }

    public UnaryCallSettings<DeployIndexRequest, Operation> deployIndexSettings() {
        return this.deployIndexSettings;
    }

    public OperationCallSettings<DeployIndexRequest, DeployIndexResponse, DeployIndexOperationMetadata> deployIndexOperationSettings() {
        return this.deployIndexOperationSettings;
    }

    public UnaryCallSettings<UndeployIndexRequest, Operation> undeployIndexSettings() {
        return this.undeployIndexSettings;
    }

    public OperationCallSettings<UndeployIndexRequest, UndeployIndexResponse, UndeployIndexOperationMetadata> undeployIndexOperationSettings() {
        return this.undeployIndexOperationSettings;
    }

    public UnaryCallSettings<MutateDeployedIndexRequest, Operation> mutateDeployedIndexSettings() {
        return this.mutateDeployedIndexSettings;
    }

    public OperationCallSettings<MutateDeployedIndexRequest, MutateDeployedIndexResponse, MutateDeployedIndexOperationMetadata> mutateDeployedIndexOperationSettings() {
        return this.mutateDeployedIndexOperationSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, IndexEndpointServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public IndexEndpointServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcIndexEndpointServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return IndexEndpointServiceStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "aiplatform";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "aiplatform.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "aiplatform.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return IndexEndpointServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(IndexEndpointServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected IndexEndpointServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createIndexEndpointSettings = settingsBuilder.createIndexEndpointSettings().build();
        this.createIndexEndpointOperationSettings = settingsBuilder.createIndexEndpointOperationSettings().build();
        this.getIndexEndpointSettings = settingsBuilder.getIndexEndpointSettings().build();
        this.listIndexEndpointsSettings = settingsBuilder.listIndexEndpointsSettings().build();
        this.updateIndexEndpointSettings = settingsBuilder.updateIndexEndpointSettings().build();
        this.deleteIndexEndpointSettings = settingsBuilder.deleteIndexEndpointSettings().build();
        this.deleteIndexEndpointOperationSettings = settingsBuilder.deleteIndexEndpointOperationSettings().build();
        this.deployIndexSettings = settingsBuilder.deployIndexSettings().build();
        this.deployIndexOperationSettings = settingsBuilder.deployIndexOperationSettings().build();
        this.undeployIndexSettings = settingsBuilder.undeployIndexSettings().build();
        this.undeployIndexOperationSettings = settingsBuilder.undeployIndexOperationSettings().build();
        this.mutateDeployedIndexSettings = settingsBuilder.mutateDeployedIndexSettings().build();
        this.mutateDeployedIndexOperationSettings = settingsBuilder.mutateDeployedIndexOperationSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<IndexEndpointServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateIndexEndpointRequest, Operation> createIndexEndpointSettings;
        private final OperationCallSettings.Builder<CreateIndexEndpointRequest, IndexEndpoint, CreateIndexEndpointOperationMetadata> createIndexEndpointOperationSettings;
        private final UnaryCallSettings.Builder<GetIndexEndpointRequest, IndexEndpoint> getIndexEndpointSettings;
        private final PagedCallSettings.Builder<ListIndexEndpointsRequest, ListIndexEndpointsResponse, IndexEndpointServiceClient.ListIndexEndpointsPagedResponse> listIndexEndpointsSettings;
        private final UnaryCallSettings.Builder<UpdateIndexEndpointRequest, IndexEndpoint> updateIndexEndpointSettings;
        private final UnaryCallSettings.Builder<DeleteIndexEndpointRequest, Operation> deleteIndexEndpointSettings;
        private final OperationCallSettings.Builder<DeleteIndexEndpointRequest, Empty, DeleteOperationMetadata> deleteIndexEndpointOperationSettings;
        private final UnaryCallSettings.Builder<DeployIndexRequest, Operation> deployIndexSettings;
        private final OperationCallSettings.Builder<DeployIndexRequest, DeployIndexResponse, DeployIndexOperationMetadata> deployIndexOperationSettings;
        private final UnaryCallSettings.Builder<UndeployIndexRequest, Operation> undeployIndexSettings;
        private final OperationCallSettings.Builder<UndeployIndexRequest, UndeployIndexResponse, UndeployIndexOperationMetadata> undeployIndexOperationSettings;
        private final UnaryCallSettings.Builder<MutateDeployedIndexRequest, Operation> mutateDeployedIndexSettings;
        private final OperationCallSettings.Builder<MutateDeployedIndexRequest, MutateDeployedIndexResponse, MutateDeployedIndexOperationMetadata> mutateDeployedIndexOperationSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, IndexEndpointServiceClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createIndexEndpointSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createIndexEndpointOperationSettings = OperationCallSettings.newBuilder();
            this.getIndexEndpointSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listIndexEndpointsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_INDEX_ENDPOINTS_PAGE_STR_FACT);
            this.updateIndexEndpointSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteIndexEndpointSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteIndexEndpointOperationSettings = OperationCallSettings.newBuilder();
            this.deployIndexSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deployIndexOperationSettings = OperationCallSettings.newBuilder();
            this.undeployIndexSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.undeployIndexOperationSettings = OperationCallSettings.newBuilder();
            this.mutateDeployedIndexSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.mutateDeployedIndexOperationSettings = OperationCallSettings.newBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createIndexEndpointSettings, this.getIndexEndpointSettings, this.listIndexEndpointsSettings, this.updateIndexEndpointSettings, this.deleteIndexEndpointSettings, this.deployIndexSettings, this.undeployIndexSettings, this.mutateDeployedIndexSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, (Object[])new UnaryCallSettings.Builder[]{this.testIamPermissionsSettings});
            Builder.initDefaults(this);
        }

        protected Builder(IndexEndpointServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createIndexEndpointSettings = settings.createIndexEndpointSettings.toBuilder();
            this.createIndexEndpointOperationSettings = settings.createIndexEndpointOperationSettings.toBuilder();
            this.getIndexEndpointSettings = settings.getIndexEndpointSettings.toBuilder();
            this.listIndexEndpointsSettings = settings.listIndexEndpointsSettings.toBuilder();
            this.updateIndexEndpointSettings = settings.updateIndexEndpointSettings.toBuilder();
            this.deleteIndexEndpointSettings = settings.deleteIndexEndpointSettings.toBuilder();
            this.deleteIndexEndpointOperationSettings = settings.deleteIndexEndpointOperationSettings.toBuilder();
            this.deployIndexSettings = settings.deployIndexSettings.toBuilder();
            this.deployIndexOperationSettings = settings.deployIndexOperationSettings.toBuilder();
            this.undeployIndexSettings = settings.undeployIndexSettings.toBuilder();
            this.undeployIndexOperationSettings = settings.undeployIndexOperationSettings.toBuilder();
            this.mutateDeployedIndexSettings = settings.mutateDeployedIndexSettings.toBuilder();
            this.mutateDeployedIndexOperationSettings = settings.mutateDeployedIndexOperationSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createIndexEndpointSettings, this.getIndexEndpointSettings, this.listIndexEndpointsSettings, this.updateIndexEndpointSettings, this.deleteIndexEndpointSettings, this.deployIndexSettings, this.undeployIndexSettings, this.mutateDeployedIndexSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, (Object[])new UnaryCallSettings.Builder[]{this.testIamPermissionsSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(IndexEndpointServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)IndexEndpointServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)IndexEndpointServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(IndexEndpointServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createIndexEndpointSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_3_params"));
            builder.getIndexEndpointSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_3_params"));
            builder.listIndexEndpointsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_3_params"));
            builder.updateIndexEndpointSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_3_params"));
            builder.deleteIndexEndpointSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_3_params"));
            builder.deployIndexSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_3_params"));
            builder.undeployIndexSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_3_params"));
            builder.mutateDeployedIndexSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createIndexEndpointOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_3_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(IndexEndpoint.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CreateIndexEndpointOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteIndexEndpointOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_3_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(DeleteOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deployIndexOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_3_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(DeployIndexResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(DeployIndexOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.undeployIndexOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_3_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(UndeployIndexResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(UndeployIndexOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.mutateDeployedIndexOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(MutateDeployedIndexResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(MutateDeployedIndexOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateIndexEndpointRequest, Operation> createIndexEndpointSettings() {
            return this.createIndexEndpointSettings;
        }

        public OperationCallSettings.Builder<CreateIndexEndpointRequest, IndexEndpoint, CreateIndexEndpointOperationMetadata> createIndexEndpointOperationSettings() {
            return this.createIndexEndpointOperationSettings;
        }

        public UnaryCallSettings.Builder<GetIndexEndpointRequest, IndexEndpoint> getIndexEndpointSettings() {
            return this.getIndexEndpointSettings;
        }

        public PagedCallSettings.Builder<ListIndexEndpointsRequest, ListIndexEndpointsResponse, IndexEndpointServiceClient.ListIndexEndpointsPagedResponse> listIndexEndpointsSettings() {
            return this.listIndexEndpointsSettings;
        }

        public UnaryCallSettings.Builder<UpdateIndexEndpointRequest, IndexEndpoint> updateIndexEndpointSettings() {
            return this.updateIndexEndpointSettings;
        }

        public UnaryCallSettings.Builder<DeleteIndexEndpointRequest, Operation> deleteIndexEndpointSettings() {
            return this.deleteIndexEndpointSettings;
        }

        public OperationCallSettings.Builder<DeleteIndexEndpointRequest, Empty, DeleteOperationMetadata> deleteIndexEndpointOperationSettings() {
            return this.deleteIndexEndpointOperationSettings;
        }

        public UnaryCallSettings.Builder<DeployIndexRequest, Operation> deployIndexSettings() {
            return this.deployIndexSettings;
        }

        public OperationCallSettings.Builder<DeployIndexRequest, DeployIndexResponse, DeployIndexOperationMetadata> deployIndexOperationSettings() {
            return this.deployIndexOperationSettings;
        }

        public UnaryCallSettings.Builder<UndeployIndexRequest, Operation> undeployIndexSettings() {
            return this.undeployIndexSettings;
        }

        public OperationCallSettings.Builder<UndeployIndexRequest, UndeployIndexResponse, UndeployIndexOperationMetadata> undeployIndexOperationSettings() {
            return this.undeployIndexOperationSettings;
        }

        public UnaryCallSettings.Builder<MutateDeployedIndexRequest, Operation> mutateDeployedIndexSettings() {
            return this.mutateDeployedIndexSettings;
        }

        public OperationCallSettings.Builder<MutateDeployedIndexRequest, MutateDeployedIndexResponse, MutateDeployedIndexOperationMetadata> mutateDeployedIndexOperationSettings() {
            return this.mutateDeployedIndexOperationSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, IndexEndpointServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return IndexEndpointServiceStubSettings.getDefaultEndpoint();
        }

        public IndexEndpointServiceStubSettings build() throws IOException {
            return new IndexEndpointServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_3_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)5000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)5000L)).setTotalTimeout(Duration.ofMillis((long)5000L)).build();
            definitions.put((Object)"no_retry_3_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

