/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1beta1.CreatePersistentResourceOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.CreatePersistentResourceRequest;
import com.google.cloud.aiplatform.v1beta1.DeleteOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.DeletePersistentResourceRequest;
import com.google.cloud.aiplatform.v1beta1.GetPersistentResourceRequest;
import com.google.cloud.aiplatform.v1beta1.ListPersistentResourcesRequest;
import com.google.cloud.aiplatform.v1beta1.ListPersistentResourcesResponse;
import com.google.cloud.aiplatform.v1beta1.PersistentResource;
import com.google.cloud.aiplatform.v1beta1.PersistentResourceServiceClient;
import com.google.cloud.aiplatform.v1beta1.stub.GrpcPersistentResourceServiceStub;
import com.google.cloud.aiplatform.v1beta1.stub.PersistentResourceServiceStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class PersistentResourceServiceStubSettings
extends StubSettings<PersistentResourceServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreatePersistentResourceRequest, Operation> createPersistentResourceSettings;
    private final OperationCallSettings<CreatePersistentResourceRequest, PersistentResource, CreatePersistentResourceOperationMetadata> createPersistentResourceOperationSettings;
    private final UnaryCallSettings<GetPersistentResourceRequest, PersistentResource> getPersistentResourceSettings;
    private final PagedCallSettings<ListPersistentResourcesRequest, ListPersistentResourcesResponse, PersistentResourceServiceClient.ListPersistentResourcesPagedResponse> listPersistentResourcesSettings;
    private final UnaryCallSettings<DeletePersistentResourceRequest, Operation> deletePersistentResourceSettings;
    private final OperationCallSettings<DeletePersistentResourceRequest, Empty, DeleteOperationMetadata> deletePersistentResourceOperationSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, PersistentResourceServiceClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListPersistentResourcesRequest, ListPersistentResourcesResponse, PersistentResource> LIST_PERSISTENT_RESOURCES_PAGE_STR_DESC = new PagedListDescriptor<ListPersistentResourcesRequest, ListPersistentResourcesResponse, PersistentResource>(){

        public String emptyToken() {
            return "";
        }

        public ListPersistentResourcesRequest injectToken(ListPersistentResourcesRequest payload, String token) {
            return ListPersistentResourcesRequest.newBuilder((ListPersistentResourcesRequest)payload).setPageToken(token).build();
        }

        public ListPersistentResourcesRequest injectPageSize(ListPersistentResourcesRequest payload, int pageSize) {
            return ListPersistentResourcesRequest.newBuilder((ListPersistentResourcesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListPersistentResourcesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListPersistentResourcesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<PersistentResource> extractResources(ListPersistentResourcesResponse payload) {
            return payload.getPersistentResourcesList() == null ? ImmutableList.of() : payload.getPersistentResourcesList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList() == null ? ImmutableList.of() : payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListPersistentResourcesRequest, ListPersistentResourcesResponse, PersistentResourceServiceClient.ListPersistentResourcesPagedResponse> LIST_PERSISTENT_RESOURCES_PAGE_STR_FACT = new PagedListResponseFactory<ListPersistentResourcesRequest, ListPersistentResourcesResponse, PersistentResourceServiceClient.ListPersistentResourcesPagedResponse>(){

        public ApiFuture<PersistentResourceServiceClient.ListPersistentResourcesPagedResponse> getFuturePagedResponse(UnaryCallable<ListPersistentResourcesRequest, ListPersistentResourcesResponse> callable, ListPersistentResourcesRequest request, ApiCallContext context, ApiFuture<ListPersistentResourcesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PERSISTENT_RESOURCES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return PersistentResourceServiceClient.ListPersistentResourcesPagedResponse.createAsync((PageContext<ListPersistentResourcesRequest, ListPersistentResourcesResponse, PersistentResource>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, PersistentResourceServiceClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, PersistentResourceServiceClient.ListLocationsPagedResponse>(){

        public ApiFuture<PersistentResourceServiceClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return PersistentResourceServiceClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreatePersistentResourceRequest, Operation> createPersistentResourceSettings() {
        return this.createPersistentResourceSettings;
    }

    public OperationCallSettings<CreatePersistentResourceRequest, PersistentResource, CreatePersistentResourceOperationMetadata> createPersistentResourceOperationSettings() {
        return this.createPersistentResourceOperationSettings;
    }

    public UnaryCallSettings<GetPersistentResourceRequest, PersistentResource> getPersistentResourceSettings() {
        return this.getPersistentResourceSettings;
    }

    public PagedCallSettings<ListPersistentResourcesRequest, ListPersistentResourcesResponse, PersistentResourceServiceClient.ListPersistentResourcesPagedResponse> listPersistentResourcesSettings() {
        return this.listPersistentResourcesSettings;
    }

    public UnaryCallSettings<DeletePersistentResourceRequest, Operation> deletePersistentResourceSettings() {
        return this.deletePersistentResourceSettings;
    }

    public OperationCallSettings<DeletePersistentResourceRequest, Empty, DeleteOperationMetadata> deletePersistentResourceOperationSettings() {
        return this.deletePersistentResourceOperationSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, PersistentResourceServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public PersistentResourceServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcPersistentResourceServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "aiplatform.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "aiplatform.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return PersistentResourceServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(PersistentResourceServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected PersistentResourceServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createPersistentResourceSettings = settingsBuilder.createPersistentResourceSettings().build();
        this.createPersistentResourceOperationSettings = settingsBuilder.createPersistentResourceOperationSettings().build();
        this.getPersistentResourceSettings = settingsBuilder.getPersistentResourceSettings().build();
        this.listPersistentResourcesSettings = settingsBuilder.listPersistentResourcesSettings().build();
        this.deletePersistentResourceSettings = settingsBuilder.deletePersistentResourceSettings().build();
        this.deletePersistentResourceOperationSettings = settingsBuilder.deletePersistentResourceOperationSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<PersistentResourceServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreatePersistentResourceRequest, Operation> createPersistentResourceSettings;
        private final OperationCallSettings.Builder<CreatePersistentResourceRequest, PersistentResource, CreatePersistentResourceOperationMetadata> createPersistentResourceOperationSettings;
        private final UnaryCallSettings.Builder<GetPersistentResourceRequest, PersistentResource> getPersistentResourceSettings;
        private final PagedCallSettings.Builder<ListPersistentResourcesRequest, ListPersistentResourcesResponse, PersistentResourceServiceClient.ListPersistentResourcesPagedResponse> listPersistentResourcesSettings;
        private final UnaryCallSettings.Builder<DeletePersistentResourceRequest, Operation> deletePersistentResourceSettings;
        private final OperationCallSettings.Builder<DeletePersistentResourceRequest, Empty, DeleteOperationMetadata> deletePersistentResourceOperationSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, PersistentResourceServiceClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createPersistentResourceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createPersistentResourceOperationSettings = OperationCallSettings.newBuilder();
            this.getPersistentResourceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listPersistentResourcesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PERSISTENT_RESOURCES_PAGE_STR_FACT);
            this.deletePersistentResourceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deletePersistentResourceOperationSettings = OperationCallSettings.newBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createPersistentResourceSettings, this.getPersistentResourceSettings, this.listPersistentResourcesSettings, this.deletePersistentResourceSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(PersistentResourceServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createPersistentResourceSettings = settings.createPersistentResourceSettings.toBuilder();
            this.createPersistentResourceOperationSettings = settings.createPersistentResourceOperationSettings.toBuilder();
            this.getPersistentResourceSettings = settings.getPersistentResourceSettings.toBuilder();
            this.listPersistentResourcesSettings = settings.listPersistentResourcesSettings.toBuilder();
            this.deletePersistentResourceSettings = settings.deletePersistentResourceSettings.toBuilder();
            this.deletePersistentResourceOperationSettings = settings.deletePersistentResourceOperationSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createPersistentResourceSettings, this.getPersistentResourceSettings, this.listPersistentResourcesSettings, this.deletePersistentResourceSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(PersistentResourceServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)PersistentResourceServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)PersistentResourceServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(PersistentResourceServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(PersistentResourceServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createPersistentResourceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getPersistentResourceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listPersistentResourcesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deletePersistentResourceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createPersistentResourceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(PersistentResource.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CreatePersistentResourceOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deletePersistentResourceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(DeleteOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreatePersistentResourceRequest, Operation> createPersistentResourceSettings() {
            return this.createPersistentResourceSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreatePersistentResourceRequest, PersistentResource, CreatePersistentResourceOperationMetadata> createPersistentResourceOperationSettings() {
            return this.createPersistentResourceOperationSettings;
        }

        public UnaryCallSettings.Builder<GetPersistentResourceRequest, PersistentResource> getPersistentResourceSettings() {
            return this.getPersistentResourceSettings;
        }

        public PagedCallSettings.Builder<ListPersistentResourcesRequest, ListPersistentResourcesResponse, PersistentResourceServiceClient.ListPersistentResourcesPagedResponse> listPersistentResourcesSettings() {
            return this.listPersistentResourcesSettings;
        }

        public UnaryCallSettings.Builder<DeletePersistentResourceRequest, Operation> deletePersistentResourceSettings() {
            return this.deletePersistentResourceSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeletePersistentResourceRequest, Empty, DeleteOperationMetadata> deletePersistentResourceOperationSettings() {
            return this.deletePersistentResourceOperationSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, PersistentResourceServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public PersistentResourceServiceStubSettings build() throws IOException {
            return new PersistentResourceServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

