/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1.BatchMigrateResourcesOperationMetadata;
import com.google.cloud.aiplatform.v1.BatchMigrateResourcesRequest;
import com.google.cloud.aiplatform.v1.BatchMigrateResourcesResponse;
import com.google.cloud.aiplatform.v1.LocationName;
import com.google.cloud.aiplatform.v1.MigratableResource;
import com.google.cloud.aiplatform.v1.MigrateResourceRequest;
import com.google.cloud.aiplatform.v1.MigrationServiceSettings;
import com.google.cloud.aiplatform.v1.SearchMigratableResourcesRequest;
import com.google.cloud.aiplatform.v1.SearchMigratableResourcesResponse;
import com.google.cloud.aiplatform.v1.stub.MigrationServiceStub;
import com.google.cloud.aiplatform.v1.stub.MigrationServiceStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class MigrationServiceClient
implements BackgroundResource {
    private final MigrationServiceSettings settings;
    private final MigrationServiceStub stub;
    private final OperationsClient operationsClient;

    public static final MigrationServiceClient create() throws IOException {
        return MigrationServiceClient.create(MigrationServiceSettings.newBuilder().build());
    }

    public static final MigrationServiceClient create(MigrationServiceSettings settings) throws IOException {
        return new MigrationServiceClient(settings);
    }

    public static final MigrationServiceClient create(MigrationServiceStub stub) {
        return new MigrationServiceClient(stub);
    }

    protected MigrationServiceClient(MigrationServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((MigrationServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    protected MigrationServiceClient(MigrationServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final MigrationServiceSettings getSettings() {
        return this.settings;
    }

    public MigrationServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final SearchMigratableResourcesPagedResponse searchMigratableResources(LocationName parent) {
        SearchMigratableResourcesRequest request = SearchMigratableResourcesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.searchMigratableResources(request);
    }

    public final SearchMigratableResourcesPagedResponse searchMigratableResources(String parent) {
        SearchMigratableResourcesRequest request = SearchMigratableResourcesRequest.newBuilder().setParent(parent).build();
        return this.searchMigratableResources(request);
    }

    public final SearchMigratableResourcesPagedResponse searchMigratableResources(SearchMigratableResourcesRequest request) {
        return (SearchMigratableResourcesPagedResponse)((Object)this.searchMigratableResourcesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<SearchMigratableResourcesRequest, SearchMigratableResourcesPagedResponse> searchMigratableResourcesPagedCallable() {
        return this.stub.searchMigratableResourcesPagedCallable();
    }

    public final UnaryCallable<SearchMigratableResourcesRequest, SearchMigratableResourcesResponse> searchMigratableResourcesCallable() {
        return this.stub.searchMigratableResourcesCallable();
    }

    public final OperationFuture<BatchMigrateResourcesResponse, BatchMigrateResourcesOperationMetadata> batchMigrateResourcesAsync(LocationName parent, List<MigrateResourceRequest> migrateResourceRequests) {
        BatchMigrateResourcesRequest request = BatchMigrateResourcesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).addAllMigrateResourceRequests(migrateResourceRequests).build();
        return this.batchMigrateResourcesAsync(request);
    }

    public final OperationFuture<BatchMigrateResourcesResponse, BatchMigrateResourcesOperationMetadata> batchMigrateResourcesAsync(String parent, List<MigrateResourceRequest> migrateResourceRequests) {
        BatchMigrateResourcesRequest request = BatchMigrateResourcesRequest.newBuilder().setParent(parent).addAllMigrateResourceRequests(migrateResourceRequests).build();
        return this.batchMigrateResourcesAsync(request);
    }

    public final OperationFuture<BatchMigrateResourcesResponse, BatchMigrateResourcesOperationMetadata> batchMigrateResourcesAsync(BatchMigrateResourcesRequest request) {
        return this.batchMigrateResourcesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<BatchMigrateResourcesRequest, BatchMigrateResourcesResponse, BatchMigrateResourcesOperationMetadata> batchMigrateResourcesOperationCallable() {
        return this.stub.batchMigrateResourcesOperationCallable();
    }

    public final UnaryCallable<BatchMigrateResourcesRequest, Operation> batchMigrateResourcesCallable() {
        return this.stub.batchMigrateResourcesCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class SearchMigratableResourcesFixedSizeCollection
    extends AbstractFixedSizeCollection<SearchMigratableResourcesRequest, SearchMigratableResourcesResponse, MigratableResource, SearchMigratableResourcesPage, SearchMigratableResourcesFixedSizeCollection> {
        private SearchMigratableResourcesFixedSizeCollection(List<SearchMigratableResourcesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static SearchMigratableResourcesFixedSizeCollection createEmptyCollection() {
            return new SearchMigratableResourcesFixedSizeCollection(null, 0);
        }

        protected SearchMigratableResourcesFixedSizeCollection createCollection(List<SearchMigratableResourcesPage> pages, int collectionSize) {
            return new SearchMigratableResourcesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class SearchMigratableResourcesPage
    extends AbstractPage<SearchMigratableResourcesRequest, SearchMigratableResourcesResponse, MigratableResource, SearchMigratableResourcesPage> {
        private SearchMigratableResourcesPage(PageContext<SearchMigratableResourcesRequest, SearchMigratableResourcesResponse, MigratableResource> context, SearchMigratableResourcesResponse response) {
            super(context, (Object)response);
        }

        private static SearchMigratableResourcesPage createEmptyPage() {
            return new SearchMigratableResourcesPage(null, null);
        }

        protected SearchMigratableResourcesPage createPage(PageContext<SearchMigratableResourcesRequest, SearchMigratableResourcesResponse, MigratableResource> context, SearchMigratableResourcesResponse response) {
            return new SearchMigratableResourcesPage(context, response);
        }

        public ApiFuture<SearchMigratableResourcesPage> createPageAsync(PageContext<SearchMigratableResourcesRequest, SearchMigratableResourcesResponse, MigratableResource> context, ApiFuture<SearchMigratableResourcesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class SearchMigratableResourcesPagedResponse
    extends AbstractPagedListResponse<SearchMigratableResourcesRequest, SearchMigratableResourcesResponse, MigratableResource, SearchMigratableResourcesPage, SearchMigratableResourcesFixedSizeCollection> {
        public static ApiFuture<SearchMigratableResourcesPagedResponse> createAsync(PageContext<SearchMigratableResourcesRequest, SearchMigratableResourcesResponse, MigratableResource> context, ApiFuture<SearchMigratableResourcesResponse> futureResponse) {
            ApiFuture<SearchMigratableResourcesPage> futurePage = SearchMigratableResourcesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new SearchMigratableResourcesPagedResponse((SearchMigratableResourcesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private SearchMigratableResourcesPagedResponse(SearchMigratableResourcesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)SearchMigratableResourcesFixedSizeCollection.createEmptyCollection());
        }
    }
}

