/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1.FeaturestoreOnlineServingServiceClient;
import com.google.cloud.aiplatform.v1.ReadFeatureValuesRequest;
import com.google.cloud.aiplatform.v1.ReadFeatureValuesResponse;
import com.google.cloud.aiplatform.v1.StreamingReadFeatureValuesRequest;
import com.google.cloud.aiplatform.v1.WriteFeatureValuesRequest;
import com.google.cloud.aiplatform.v1.WriteFeatureValuesResponse;
import com.google.cloud.aiplatform.v1.stub.FeaturestoreOnlineServingServiceStub;
import com.google.cloud.aiplatform.v1.stub.FeaturestoreOnlineServingServiceStubSettings;
import com.google.cloud.aiplatform.v1.stub.GrpcFeaturestoreOnlineServingServiceCallableFactory;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableMap;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcFeaturestoreOnlineServingServiceStub
extends FeaturestoreOnlineServingServiceStub {
    private static final MethodDescriptor<ReadFeatureValuesRequest, ReadFeatureValuesResponse> readFeatureValuesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.FeaturestoreOnlineServingService/ReadFeatureValues").setRequestMarshaller(ProtoUtils.marshaller((Message)ReadFeatureValuesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ReadFeatureValuesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<StreamingReadFeatureValuesRequest, ReadFeatureValuesResponse> streamingReadFeatureValuesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.SERVER_STREAMING).setFullMethodName("google.cloud.aiplatform.v1.FeaturestoreOnlineServingService/StreamingReadFeatureValues").setRequestMarshaller(ProtoUtils.marshaller((Message)StreamingReadFeatureValuesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ReadFeatureValuesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<WriteFeatureValuesRequest, WriteFeatureValuesResponse> writeFeatureValuesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.FeaturestoreOnlineServingService/WriteFeatureValues").setRequestMarshaller(ProtoUtils.marshaller((Message)WriteFeatureValuesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)WriteFeatureValuesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).build();
    private static final MethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/SetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)SetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/GetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)GetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/TestIamPermissions").setRequestMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsResponse.getDefaultInstance())).build();
    private final UnaryCallable<ReadFeatureValuesRequest, ReadFeatureValuesResponse> readFeatureValuesCallable;
    private final ServerStreamingCallable<StreamingReadFeatureValuesRequest, ReadFeatureValuesResponse> streamingReadFeatureValuesCallable;
    private final UnaryCallable<WriteFeatureValuesRequest, WriteFeatureValuesResponse> writeFeatureValuesCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, FeaturestoreOnlineServingServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcFeaturestoreOnlineServingServiceStub create(FeaturestoreOnlineServingServiceStubSettings settings) throws IOException {
        return new GrpcFeaturestoreOnlineServingServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcFeaturestoreOnlineServingServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcFeaturestoreOnlineServingServiceStub(FeaturestoreOnlineServingServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcFeaturestoreOnlineServingServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcFeaturestoreOnlineServingServiceStub(FeaturestoreOnlineServingServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcFeaturestoreOnlineServingServiceStub(FeaturestoreOnlineServingServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcFeaturestoreOnlineServingServiceCallableFactory());
    }

    protected GrpcFeaturestoreOnlineServingServiceStub(FeaturestoreOnlineServingServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings readFeatureValuesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(readFeatureValuesMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"entity_type", (Object)String.valueOf(request.getEntityType()));
            return params.build();
        }).build();
        GrpcCallSettings streamingReadFeatureValuesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(streamingReadFeatureValuesMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"entity_type", (Object)String.valueOf(request.getEntityType()));
            return params.build();
        }).build();
        GrpcCallSettings writeFeatureValuesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(writeFeatureValuesMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"entity_type", (Object)String.valueOf(request.getEntityType()));
            return params.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings setIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"resource", (Object)String.valueOf(request.getResource()));
            return params.build();
        }).build();
        GrpcCallSettings getIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"resource", (Object)String.valueOf(request.getResource()));
            return params.build();
        }).build();
        GrpcCallSettings testIamPermissionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"resource", (Object)String.valueOf(request.getResource()));
            return params.build();
        }).build();
        this.readFeatureValuesCallable = callableFactory.createUnaryCallable(readFeatureValuesTransportSettings, settings.readFeatureValuesSettings(), clientContext);
        this.streamingReadFeatureValuesCallable = callableFactory.createServerStreamingCallable(streamingReadFeatureValuesTransportSettings, settings.streamingReadFeatureValuesSettings(), clientContext);
        this.writeFeatureValuesCallable = callableFactory.createUnaryCallable(writeFeatureValuesTransportSettings, settings.writeFeatureValuesSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ReadFeatureValuesRequest, ReadFeatureValuesResponse> readFeatureValuesCallable() {
        return this.readFeatureValuesCallable;
    }

    @Override
    public ServerStreamingCallable<StreamingReadFeatureValuesRequest, ReadFeatureValuesResponse> streamingReadFeatureValuesCallable() {
        return this.streamingReadFeatureValuesCallable;
    }

    @Override
    public UnaryCallable<WriteFeatureValuesRequest, WriteFeatureValuesResponse> writeFeatureValuesCallable() {
        return this.writeFeatureValuesCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, FeaturestoreOnlineServingServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

