/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesRequest;
import com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesResponse;
import com.google.cloud.aiplatform.v1beta1.MigrationServiceClient;
import com.google.cloud.aiplatform.v1beta1.SearchMigratableResourcesRequest;
import com.google.cloud.aiplatform.v1beta1.SearchMigratableResourcesResponse;
import com.google.cloud.aiplatform.v1beta1.stub.GrpcMigrationServiceCallableFactory;
import com.google.cloud.aiplatform.v1beta1.stub.MigrationServiceStub;
import com.google.cloud.aiplatform.v1beta1.stub.MigrationServiceStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcMigrationServiceStub
extends MigrationServiceStub {
    private static final MethodDescriptor<SearchMigratableResourcesRequest, SearchMigratableResourcesResponse> searchMigratableResourcesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.MigrationService/SearchMigratableResources").setRequestMarshaller(ProtoUtils.marshaller((Message)SearchMigratableResourcesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SearchMigratableResourcesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<BatchMigrateResourcesRequest, Operation> batchMigrateResourcesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.MigrationService/BatchMigrateResources").setRequestMarshaller(ProtoUtils.marshaller((Message)BatchMigrateResourcesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private final UnaryCallable<SearchMigratableResourcesRequest, SearchMigratableResourcesResponse> searchMigratableResourcesCallable;
    private final UnaryCallable<SearchMigratableResourcesRequest, MigrationServiceClient.SearchMigratableResourcesPagedResponse> searchMigratableResourcesPagedCallable;
    private final UnaryCallable<BatchMigrateResourcesRequest, Operation> batchMigrateResourcesCallable;
    private final OperationCallable<BatchMigrateResourcesRequest, BatchMigrateResourcesResponse, BatchMigrateResourcesOperationMetadata> batchMigrateResourcesOperationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcMigrationServiceStub create(MigrationServiceStubSettings settings) throws IOException {
        return new GrpcMigrationServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcMigrationServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcMigrationServiceStub(MigrationServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcMigrationServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcMigrationServiceStub(MigrationServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcMigrationServiceStub(MigrationServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcMigrationServiceCallableFactory());
    }

    protected GrpcMigrationServiceStub(MigrationServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings searchMigratableResourcesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(searchMigratableResourcesMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings batchMigrateResourcesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(batchMigrateResourcesMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        this.searchMigratableResourcesCallable = callableFactory.createUnaryCallable(searchMigratableResourcesTransportSettings, settings.searchMigratableResourcesSettings(), clientContext);
        this.searchMigratableResourcesPagedCallable = callableFactory.createPagedCallable(searchMigratableResourcesTransportSettings, settings.searchMigratableResourcesSettings(), clientContext);
        this.batchMigrateResourcesCallable = callableFactory.createUnaryCallable(batchMigrateResourcesTransportSettings, settings.batchMigrateResourcesSettings(), clientContext);
        this.batchMigrateResourcesOperationCallable = callableFactory.createOperationCallable(batchMigrateResourcesTransportSettings, settings.batchMigrateResourcesOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<SearchMigratableResourcesRequest, SearchMigratableResourcesResponse> searchMigratableResourcesCallable() {
        return this.searchMigratableResourcesCallable;
    }

    @Override
    public UnaryCallable<SearchMigratableResourcesRequest, MigrationServiceClient.SearchMigratableResourcesPagedResponse> searchMigratableResourcesPagedCallable() {
        return this.searchMigratableResourcesPagedCallable;
    }

    @Override
    public UnaryCallable<BatchMigrateResourcesRequest, Operation> batchMigrateResourcesCallable() {
        return this.batchMigrateResourcesCallable;
    }

    @Override
    public OperationCallable<BatchMigrateResourcesRequest, BatchMigrateResourcesResponse, BatchMigrateResourcesOperationMetadata> batchMigrateResourcesOperationCallable() {
        return this.batchMigrateResourcesOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

