/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.ServerStreamingCallSettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.cloud.aiplatform.v1beta1.ReadFeatureValuesRequest;
import com.google.cloud.aiplatform.v1beta1.ReadFeatureValuesResponse;
import com.google.cloud.aiplatform.v1beta1.StreamingReadFeatureValuesRequest;
import com.google.cloud.aiplatform.v1beta1.stub.FeaturestoreOnlineServingServiceStub;
import com.google.cloud.aiplatform.v1beta1.stub.GrpcFeaturestoreOnlineServingServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class FeaturestoreOnlineServingServiceStubSettings
extends StubSettings<FeaturestoreOnlineServingServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<ReadFeatureValuesRequest, ReadFeatureValuesResponse> readFeatureValuesSettings;
    private final ServerStreamingCallSettings<StreamingReadFeatureValuesRequest, ReadFeatureValuesResponse> streamingReadFeatureValuesSettings;

    public UnaryCallSettings<ReadFeatureValuesRequest, ReadFeatureValuesResponse> readFeatureValuesSettings() {
        return this.readFeatureValuesSettings;
    }

    public ServerStreamingCallSettings<StreamingReadFeatureValuesRequest, ReadFeatureValuesResponse> streamingReadFeatureValuesSettings() {
        return this.streamingReadFeatureValuesSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public FeaturestoreOnlineServingServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcFeaturestoreOnlineServingServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "aiplatform.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "aiplatform.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return FeaturestoreOnlineServingServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(FeaturestoreOnlineServingServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected FeaturestoreOnlineServingServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.readFeatureValuesSettings = settingsBuilder.readFeatureValuesSettings().build();
        this.streamingReadFeatureValuesSettings = settingsBuilder.streamingReadFeatureValuesSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<FeaturestoreOnlineServingServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<ReadFeatureValuesRequest, ReadFeatureValuesResponse> readFeatureValuesSettings;
        private final ServerStreamingCallSettings.Builder<StreamingReadFeatureValuesRequest, ReadFeatureValuesResponse> streamingReadFeatureValuesSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.readFeatureValuesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.streamingReadFeatureValuesSettings = ServerStreamingCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.readFeatureValuesSettings);
            Builder.initDefaults(this);
        }

        protected Builder(FeaturestoreOnlineServingServiceStubSettings settings) {
            super((StubSettings)settings);
            this.readFeatureValuesSettings = settings.readFeatureValuesSettings.toBuilder();
            this.streamingReadFeatureValuesSettings = settings.streamingReadFeatureValuesSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.readFeatureValuesSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(FeaturestoreOnlineServingServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)FeaturestoreOnlineServingServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)FeaturestoreOnlineServingServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(FeaturestoreOnlineServingServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(FeaturestoreOnlineServingServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.readFeatureValuesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_13_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_13_params"));
            builder.streamingReadFeatureValuesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_13_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_13_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<ReadFeatureValuesRequest, ReadFeatureValuesResponse> readFeatureValuesSettings() {
            return this.readFeatureValuesSettings;
        }

        public ServerStreamingCallSettings.Builder<StreamingReadFeatureValuesRequest, ReadFeatureValuesResponse> streamingReadFeatureValuesSettings() {
            return this.streamingReadFeatureValuesSettings;
        }

        public FeaturestoreOnlineServingServiceStubSettings build() throws IOException {
            return new FeaturestoreOnlineServingServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_13_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)5000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)5000L)).setTotalTimeout(Duration.ofMillis((long)5000L)).build();
            definitions.put((Object)"no_retry_13_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

