/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1.AddContextArtifactsAndExecutionsRequest;
import com.google.cloud.aiplatform.v1.AddContextArtifactsAndExecutionsResponse;
import com.google.cloud.aiplatform.v1.AddContextChildrenRequest;
import com.google.cloud.aiplatform.v1.AddContextChildrenResponse;
import com.google.cloud.aiplatform.v1.AddExecutionEventsRequest;
import com.google.cloud.aiplatform.v1.AddExecutionEventsResponse;
import com.google.cloud.aiplatform.v1.Artifact;
import com.google.cloud.aiplatform.v1.ArtifactName;
import com.google.cloud.aiplatform.v1.Context;
import com.google.cloud.aiplatform.v1.ContextName;
import com.google.cloud.aiplatform.v1.CreateArtifactRequest;
import com.google.cloud.aiplatform.v1.CreateContextRequest;
import com.google.cloud.aiplatform.v1.CreateExecutionRequest;
import com.google.cloud.aiplatform.v1.CreateMetadataSchemaRequest;
import com.google.cloud.aiplatform.v1.CreateMetadataStoreOperationMetadata;
import com.google.cloud.aiplatform.v1.CreateMetadataStoreRequest;
import com.google.cloud.aiplatform.v1.DeleteArtifactRequest;
import com.google.cloud.aiplatform.v1.DeleteContextRequest;
import com.google.cloud.aiplatform.v1.DeleteExecutionRequest;
import com.google.cloud.aiplatform.v1.DeleteMetadataStoreOperationMetadata;
import com.google.cloud.aiplatform.v1.DeleteMetadataStoreRequest;
import com.google.cloud.aiplatform.v1.DeleteOperationMetadata;
import com.google.cloud.aiplatform.v1.Event;
import com.google.cloud.aiplatform.v1.Execution;
import com.google.cloud.aiplatform.v1.ExecutionName;
import com.google.cloud.aiplatform.v1.GetArtifactRequest;
import com.google.cloud.aiplatform.v1.GetContextRequest;
import com.google.cloud.aiplatform.v1.GetExecutionRequest;
import com.google.cloud.aiplatform.v1.GetMetadataSchemaRequest;
import com.google.cloud.aiplatform.v1.GetMetadataStoreRequest;
import com.google.cloud.aiplatform.v1.LineageSubgraph;
import com.google.cloud.aiplatform.v1.ListArtifactsRequest;
import com.google.cloud.aiplatform.v1.ListArtifactsResponse;
import com.google.cloud.aiplatform.v1.ListContextsRequest;
import com.google.cloud.aiplatform.v1.ListContextsResponse;
import com.google.cloud.aiplatform.v1.ListExecutionsRequest;
import com.google.cloud.aiplatform.v1.ListExecutionsResponse;
import com.google.cloud.aiplatform.v1.ListMetadataSchemasRequest;
import com.google.cloud.aiplatform.v1.ListMetadataSchemasResponse;
import com.google.cloud.aiplatform.v1.ListMetadataStoresRequest;
import com.google.cloud.aiplatform.v1.ListMetadataStoresResponse;
import com.google.cloud.aiplatform.v1.LocationName;
import com.google.cloud.aiplatform.v1.MetadataSchema;
import com.google.cloud.aiplatform.v1.MetadataSchemaName;
import com.google.cloud.aiplatform.v1.MetadataServiceSettings;
import com.google.cloud.aiplatform.v1.MetadataStore;
import com.google.cloud.aiplatform.v1.MetadataStoreName;
import com.google.cloud.aiplatform.v1.PurgeArtifactsMetadata;
import com.google.cloud.aiplatform.v1.PurgeArtifactsRequest;
import com.google.cloud.aiplatform.v1.PurgeArtifactsResponse;
import com.google.cloud.aiplatform.v1.PurgeContextsMetadata;
import com.google.cloud.aiplatform.v1.PurgeContextsRequest;
import com.google.cloud.aiplatform.v1.PurgeContextsResponse;
import com.google.cloud.aiplatform.v1.PurgeExecutionsMetadata;
import com.google.cloud.aiplatform.v1.PurgeExecutionsRequest;
import com.google.cloud.aiplatform.v1.PurgeExecutionsResponse;
import com.google.cloud.aiplatform.v1.QueryArtifactLineageSubgraphRequest;
import com.google.cloud.aiplatform.v1.QueryContextLineageSubgraphRequest;
import com.google.cloud.aiplatform.v1.QueryExecutionInputsAndOutputsRequest;
import com.google.cloud.aiplatform.v1.UpdateArtifactRequest;
import com.google.cloud.aiplatform.v1.UpdateContextRequest;
import com.google.cloud.aiplatform.v1.UpdateExecutionRequest;
import com.google.cloud.aiplatform.v1.stub.MetadataServiceStub;
import com.google.cloud.aiplatform.v1.stub.MetadataServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class MetadataServiceClient
implements BackgroundResource {
    private final MetadataServiceSettings settings;
    private final MetadataServiceStub stub;
    private final OperationsClient operationsClient;

    public static final MetadataServiceClient create() throws IOException {
        return MetadataServiceClient.create(MetadataServiceSettings.newBuilder().build());
    }

    public static final MetadataServiceClient create(MetadataServiceSettings settings) throws IOException {
        return new MetadataServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final MetadataServiceClient create(MetadataServiceStub stub) {
        return new MetadataServiceClient(stub);
    }

    protected MetadataServiceClient(MetadataServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((MetadataServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected MetadataServiceClient(MetadataServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final MetadataServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public MetadataServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final OperationFuture<MetadataStore, CreateMetadataStoreOperationMetadata> createMetadataStoreAsync(LocationName parent, MetadataStore metadataStore, String metadataStoreId) {
        CreateMetadataStoreRequest request = CreateMetadataStoreRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setMetadataStore(metadataStore).setMetadataStoreId(metadataStoreId).build();
        return this.createMetadataStoreAsync(request);
    }

    public final OperationFuture<MetadataStore, CreateMetadataStoreOperationMetadata> createMetadataStoreAsync(String parent, MetadataStore metadataStore, String metadataStoreId) {
        CreateMetadataStoreRequest request = CreateMetadataStoreRequest.newBuilder().setParent(parent).setMetadataStore(metadataStore).setMetadataStoreId(metadataStoreId).build();
        return this.createMetadataStoreAsync(request);
    }

    public final OperationFuture<MetadataStore, CreateMetadataStoreOperationMetadata> createMetadataStoreAsync(CreateMetadataStoreRequest request) {
        return this.createMetadataStoreOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateMetadataStoreRequest, MetadataStore, CreateMetadataStoreOperationMetadata> createMetadataStoreOperationCallable() {
        return this.stub.createMetadataStoreOperationCallable();
    }

    public final UnaryCallable<CreateMetadataStoreRequest, Operation> createMetadataStoreCallable() {
        return this.stub.createMetadataStoreCallable();
    }

    public final MetadataStore getMetadataStore(MetadataStoreName name) {
        GetMetadataStoreRequest request = GetMetadataStoreRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getMetadataStore(request);
    }

    public final MetadataStore getMetadataStore(String name) {
        GetMetadataStoreRequest request = GetMetadataStoreRequest.newBuilder().setName(name).build();
        return this.getMetadataStore(request);
    }

    public final MetadataStore getMetadataStore(GetMetadataStoreRequest request) {
        return (MetadataStore)this.getMetadataStoreCallable().call((Object)request);
    }

    public final UnaryCallable<GetMetadataStoreRequest, MetadataStore> getMetadataStoreCallable() {
        return this.stub.getMetadataStoreCallable();
    }

    public final ListMetadataStoresPagedResponse listMetadataStores(LocationName parent) {
        ListMetadataStoresRequest request = ListMetadataStoresRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listMetadataStores(request);
    }

    public final ListMetadataStoresPagedResponse listMetadataStores(String parent) {
        ListMetadataStoresRequest request = ListMetadataStoresRequest.newBuilder().setParent(parent).build();
        return this.listMetadataStores(request);
    }

    public final ListMetadataStoresPagedResponse listMetadataStores(ListMetadataStoresRequest request) {
        return (ListMetadataStoresPagedResponse)((Object)this.listMetadataStoresPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListMetadataStoresRequest, ListMetadataStoresPagedResponse> listMetadataStoresPagedCallable() {
        return this.stub.listMetadataStoresPagedCallable();
    }

    public final UnaryCallable<ListMetadataStoresRequest, ListMetadataStoresResponse> listMetadataStoresCallable() {
        return this.stub.listMetadataStoresCallable();
    }

    public final OperationFuture<Empty, DeleteMetadataStoreOperationMetadata> deleteMetadataStoreAsync(MetadataStoreName name) {
        DeleteMetadataStoreRequest request = DeleteMetadataStoreRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteMetadataStoreAsync(request);
    }

    public final OperationFuture<Empty, DeleteMetadataStoreOperationMetadata> deleteMetadataStoreAsync(String name) {
        DeleteMetadataStoreRequest request = DeleteMetadataStoreRequest.newBuilder().setName(name).build();
        return this.deleteMetadataStoreAsync(request);
    }

    public final OperationFuture<Empty, DeleteMetadataStoreOperationMetadata> deleteMetadataStoreAsync(DeleteMetadataStoreRequest request) {
        return this.deleteMetadataStoreOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteMetadataStoreRequest, Empty, DeleteMetadataStoreOperationMetadata> deleteMetadataStoreOperationCallable() {
        return this.stub.deleteMetadataStoreOperationCallable();
    }

    public final UnaryCallable<DeleteMetadataStoreRequest, Operation> deleteMetadataStoreCallable() {
        return this.stub.deleteMetadataStoreCallable();
    }

    public final Artifact createArtifact(MetadataStoreName parent, Artifact artifact, String artifactId) {
        CreateArtifactRequest request = CreateArtifactRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setArtifact(artifact).setArtifactId(artifactId).build();
        return this.createArtifact(request);
    }

    public final Artifact createArtifact(String parent, Artifact artifact, String artifactId) {
        CreateArtifactRequest request = CreateArtifactRequest.newBuilder().setParent(parent).setArtifact(artifact).setArtifactId(artifactId).build();
        return this.createArtifact(request);
    }

    public final Artifact createArtifact(CreateArtifactRequest request) {
        return (Artifact)this.createArtifactCallable().call((Object)request);
    }

    public final UnaryCallable<CreateArtifactRequest, Artifact> createArtifactCallable() {
        return this.stub.createArtifactCallable();
    }

    public final Artifact getArtifact(ArtifactName name) {
        GetArtifactRequest request = GetArtifactRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getArtifact(request);
    }

    public final Artifact getArtifact(String name) {
        GetArtifactRequest request = GetArtifactRequest.newBuilder().setName(name).build();
        return this.getArtifact(request);
    }

    public final Artifact getArtifact(GetArtifactRequest request) {
        return (Artifact)this.getArtifactCallable().call((Object)request);
    }

    public final UnaryCallable<GetArtifactRequest, Artifact> getArtifactCallable() {
        return this.stub.getArtifactCallable();
    }

    public final ListArtifactsPagedResponse listArtifacts(MetadataStoreName parent) {
        ListArtifactsRequest request = ListArtifactsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listArtifacts(request);
    }

    public final ListArtifactsPagedResponse listArtifacts(String parent) {
        ListArtifactsRequest request = ListArtifactsRequest.newBuilder().setParent(parent).build();
        return this.listArtifacts(request);
    }

    public final ListArtifactsPagedResponse listArtifacts(ListArtifactsRequest request) {
        return (ListArtifactsPagedResponse)((Object)this.listArtifactsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListArtifactsRequest, ListArtifactsPagedResponse> listArtifactsPagedCallable() {
        return this.stub.listArtifactsPagedCallable();
    }

    public final UnaryCallable<ListArtifactsRequest, ListArtifactsResponse> listArtifactsCallable() {
        return this.stub.listArtifactsCallable();
    }

    public final Artifact updateArtifact(Artifact artifact, FieldMask updateMask) {
        UpdateArtifactRequest request = UpdateArtifactRequest.newBuilder().setArtifact(artifact).setUpdateMask(updateMask).build();
        return this.updateArtifact(request);
    }

    public final Artifact updateArtifact(UpdateArtifactRequest request) {
        return (Artifact)this.updateArtifactCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateArtifactRequest, Artifact> updateArtifactCallable() {
        return this.stub.updateArtifactCallable();
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteArtifactAsync(ArtifactName name) {
        DeleteArtifactRequest request = DeleteArtifactRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteArtifactAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteArtifactAsync(String name) {
        DeleteArtifactRequest request = DeleteArtifactRequest.newBuilder().setName(name).build();
        return this.deleteArtifactAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteArtifactAsync(DeleteArtifactRequest request) {
        return this.deleteArtifactOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteArtifactRequest, Empty, DeleteOperationMetadata> deleteArtifactOperationCallable() {
        return this.stub.deleteArtifactOperationCallable();
    }

    public final UnaryCallable<DeleteArtifactRequest, Operation> deleteArtifactCallable() {
        return this.stub.deleteArtifactCallable();
    }

    public final OperationFuture<PurgeArtifactsResponse, PurgeArtifactsMetadata> purgeArtifactsAsync(MetadataStoreName parent) {
        PurgeArtifactsRequest request = PurgeArtifactsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.purgeArtifactsAsync(request);
    }

    public final OperationFuture<PurgeArtifactsResponse, PurgeArtifactsMetadata> purgeArtifactsAsync(String parent) {
        PurgeArtifactsRequest request = PurgeArtifactsRequest.newBuilder().setParent(parent).build();
        return this.purgeArtifactsAsync(request);
    }

    public final OperationFuture<PurgeArtifactsResponse, PurgeArtifactsMetadata> purgeArtifactsAsync(PurgeArtifactsRequest request) {
        return this.purgeArtifactsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PurgeArtifactsRequest, PurgeArtifactsResponse, PurgeArtifactsMetadata> purgeArtifactsOperationCallable() {
        return this.stub.purgeArtifactsOperationCallable();
    }

    public final UnaryCallable<PurgeArtifactsRequest, Operation> purgeArtifactsCallable() {
        return this.stub.purgeArtifactsCallable();
    }

    public final Context createContext(MetadataStoreName parent, Context context, String contextId) {
        CreateContextRequest request = CreateContextRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setContext(context).setContextId(contextId).build();
        return this.createContext(request);
    }

    public final Context createContext(String parent, Context context, String contextId) {
        CreateContextRequest request = CreateContextRequest.newBuilder().setParent(parent).setContext(context).setContextId(contextId).build();
        return this.createContext(request);
    }

    public final Context createContext(CreateContextRequest request) {
        return (Context)this.createContextCallable().call((Object)request);
    }

    public final UnaryCallable<CreateContextRequest, Context> createContextCallable() {
        return this.stub.createContextCallable();
    }

    public final Context getContext(ContextName name) {
        GetContextRequest request = GetContextRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getContext(request);
    }

    public final Context getContext(String name) {
        GetContextRequest request = GetContextRequest.newBuilder().setName(name).build();
        return this.getContext(request);
    }

    public final Context getContext(GetContextRequest request) {
        return (Context)this.getContextCallable().call((Object)request);
    }

    public final UnaryCallable<GetContextRequest, Context> getContextCallable() {
        return this.stub.getContextCallable();
    }

    public final ListContextsPagedResponse listContexts(MetadataStoreName parent) {
        ListContextsRequest request = ListContextsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listContexts(request);
    }

    public final ListContextsPagedResponse listContexts(String parent) {
        ListContextsRequest request = ListContextsRequest.newBuilder().setParent(parent).build();
        return this.listContexts(request);
    }

    public final ListContextsPagedResponse listContexts(ListContextsRequest request) {
        return (ListContextsPagedResponse)((Object)this.listContextsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListContextsRequest, ListContextsPagedResponse> listContextsPagedCallable() {
        return this.stub.listContextsPagedCallable();
    }

    public final UnaryCallable<ListContextsRequest, ListContextsResponse> listContextsCallable() {
        return this.stub.listContextsCallable();
    }

    public final Context updateContext(Context context, FieldMask updateMask) {
        UpdateContextRequest request = UpdateContextRequest.newBuilder().setContext(context).setUpdateMask(updateMask).build();
        return this.updateContext(request);
    }

    public final Context updateContext(UpdateContextRequest request) {
        return (Context)this.updateContextCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateContextRequest, Context> updateContextCallable() {
        return this.stub.updateContextCallable();
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteContextAsync(ContextName name) {
        DeleteContextRequest request = DeleteContextRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteContextAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteContextAsync(String name) {
        DeleteContextRequest request = DeleteContextRequest.newBuilder().setName(name).build();
        return this.deleteContextAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteContextAsync(DeleteContextRequest request) {
        return this.deleteContextOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteContextRequest, Empty, DeleteOperationMetadata> deleteContextOperationCallable() {
        return this.stub.deleteContextOperationCallable();
    }

    public final UnaryCallable<DeleteContextRequest, Operation> deleteContextCallable() {
        return this.stub.deleteContextCallable();
    }

    public final OperationFuture<PurgeContextsResponse, PurgeContextsMetadata> purgeContextsAsync(MetadataStoreName parent) {
        PurgeContextsRequest request = PurgeContextsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.purgeContextsAsync(request);
    }

    public final OperationFuture<PurgeContextsResponse, PurgeContextsMetadata> purgeContextsAsync(String parent) {
        PurgeContextsRequest request = PurgeContextsRequest.newBuilder().setParent(parent).build();
        return this.purgeContextsAsync(request);
    }

    public final OperationFuture<PurgeContextsResponse, PurgeContextsMetadata> purgeContextsAsync(PurgeContextsRequest request) {
        return this.purgeContextsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PurgeContextsRequest, PurgeContextsResponse, PurgeContextsMetadata> purgeContextsOperationCallable() {
        return this.stub.purgeContextsOperationCallable();
    }

    public final UnaryCallable<PurgeContextsRequest, Operation> purgeContextsCallable() {
        return this.stub.purgeContextsCallable();
    }

    public final AddContextArtifactsAndExecutionsResponse addContextArtifactsAndExecutions(ContextName context, List<String> artifacts, List<String> executions) {
        AddContextArtifactsAndExecutionsRequest request = AddContextArtifactsAndExecutionsRequest.newBuilder().setContext(context == null ? null : context.toString()).addAllArtifacts(artifacts).addAllExecutions(executions).build();
        return this.addContextArtifactsAndExecutions(request);
    }

    public final AddContextArtifactsAndExecutionsResponse addContextArtifactsAndExecutions(String context, List<String> artifacts, List<String> executions) {
        AddContextArtifactsAndExecutionsRequest request = AddContextArtifactsAndExecutionsRequest.newBuilder().setContext(context).addAllArtifacts(artifacts).addAllExecutions(executions).build();
        return this.addContextArtifactsAndExecutions(request);
    }

    public final AddContextArtifactsAndExecutionsResponse addContextArtifactsAndExecutions(AddContextArtifactsAndExecutionsRequest request) {
        return (AddContextArtifactsAndExecutionsResponse)this.addContextArtifactsAndExecutionsCallable().call((Object)request);
    }

    public final UnaryCallable<AddContextArtifactsAndExecutionsRequest, AddContextArtifactsAndExecutionsResponse> addContextArtifactsAndExecutionsCallable() {
        return this.stub.addContextArtifactsAndExecutionsCallable();
    }

    public final AddContextChildrenResponse addContextChildren(ContextName context, List<String> childContexts) {
        AddContextChildrenRequest request = AddContextChildrenRequest.newBuilder().setContext(context == null ? null : context.toString()).addAllChildContexts(childContexts).build();
        return this.addContextChildren(request);
    }

    public final AddContextChildrenResponse addContextChildren(String context, List<String> childContexts) {
        AddContextChildrenRequest request = AddContextChildrenRequest.newBuilder().setContext(context).addAllChildContexts(childContexts).build();
        return this.addContextChildren(request);
    }

    public final AddContextChildrenResponse addContextChildren(AddContextChildrenRequest request) {
        return (AddContextChildrenResponse)this.addContextChildrenCallable().call((Object)request);
    }

    public final UnaryCallable<AddContextChildrenRequest, AddContextChildrenResponse> addContextChildrenCallable() {
        return this.stub.addContextChildrenCallable();
    }

    public final LineageSubgraph queryContextLineageSubgraph(ContextName context) {
        QueryContextLineageSubgraphRequest request = QueryContextLineageSubgraphRequest.newBuilder().setContext(context == null ? null : context.toString()).build();
        return this.queryContextLineageSubgraph(request);
    }

    public final LineageSubgraph queryContextLineageSubgraph(String context) {
        QueryContextLineageSubgraphRequest request = QueryContextLineageSubgraphRequest.newBuilder().setContext(context).build();
        return this.queryContextLineageSubgraph(request);
    }

    public final LineageSubgraph queryContextLineageSubgraph(QueryContextLineageSubgraphRequest request) {
        return (LineageSubgraph)this.queryContextLineageSubgraphCallable().call((Object)request);
    }

    public final UnaryCallable<QueryContextLineageSubgraphRequest, LineageSubgraph> queryContextLineageSubgraphCallable() {
        return this.stub.queryContextLineageSubgraphCallable();
    }

    public final Execution createExecution(MetadataStoreName parent, Execution execution, String executionId) {
        CreateExecutionRequest request = CreateExecutionRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setExecution(execution).setExecutionId(executionId).build();
        return this.createExecution(request);
    }

    public final Execution createExecution(String parent, Execution execution, String executionId) {
        CreateExecutionRequest request = CreateExecutionRequest.newBuilder().setParent(parent).setExecution(execution).setExecutionId(executionId).build();
        return this.createExecution(request);
    }

    public final Execution createExecution(CreateExecutionRequest request) {
        return (Execution)this.createExecutionCallable().call((Object)request);
    }

    public final UnaryCallable<CreateExecutionRequest, Execution> createExecutionCallable() {
        return this.stub.createExecutionCallable();
    }

    public final Execution getExecution(ExecutionName name) {
        GetExecutionRequest request = GetExecutionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getExecution(request);
    }

    public final Execution getExecution(String name) {
        GetExecutionRequest request = GetExecutionRequest.newBuilder().setName(name).build();
        return this.getExecution(request);
    }

    public final Execution getExecution(GetExecutionRequest request) {
        return (Execution)this.getExecutionCallable().call((Object)request);
    }

    public final UnaryCallable<GetExecutionRequest, Execution> getExecutionCallable() {
        return this.stub.getExecutionCallable();
    }

    public final ListExecutionsPagedResponse listExecutions(MetadataStoreName parent) {
        ListExecutionsRequest request = ListExecutionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listExecutions(request);
    }

    public final ListExecutionsPagedResponse listExecutions(String parent) {
        ListExecutionsRequest request = ListExecutionsRequest.newBuilder().setParent(parent).build();
        return this.listExecutions(request);
    }

    public final ListExecutionsPagedResponse listExecutions(ListExecutionsRequest request) {
        return (ListExecutionsPagedResponse)((Object)this.listExecutionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListExecutionsRequest, ListExecutionsPagedResponse> listExecutionsPagedCallable() {
        return this.stub.listExecutionsPagedCallable();
    }

    public final UnaryCallable<ListExecutionsRequest, ListExecutionsResponse> listExecutionsCallable() {
        return this.stub.listExecutionsCallable();
    }

    public final Execution updateExecution(Execution execution, FieldMask updateMask) {
        UpdateExecutionRequest request = UpdateExecutionRequest.newBuilder().setExecution(execution).setUpdateMask(updateMask).build();
        return this.updateExecution(request);
    }

    public final Execution updateExecution(UpdateExecutionRequest request) {
        return (Execution)this.updateExecutionCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateExecutionRequest, Execution> updateExecutionCallable() {
        return this.stub.updateExecutionCallable();
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteExecutionAsync(ExecutionName name) {
        DeleteExecutionRequest request = DeleteExecutionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteExecutionAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteExecutionAsync(String name) {
        DeleteExecutionRequest request = DeleteExecutionRequest.newBuilder().setName(name).build();
        return this.deleteExecutionAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteExecutionAsync(DeleteExecutionRequest request) {
        return this.deleteExecutionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteExecutionRequest, Empty, DeleteOperationMetadata> deleteExecutionOperationCallable() {
        return this.stub.deleteExecutionOperationCallable();
    }

    public final UnaryCallable<DeleteExecutionRequest, Operation> deleteExecutionCallable() {
        return this.stub.deleteExecutionCallable();
    }

    public final OperationFuture<PurgeExecutionsResponse, PurgeExecutionsMetadata> purgeExecutionsAsync(MetadataStoreName parent) {
        PurgeExecutionsRequest request = PurgeExecutionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.purgeExecutionsAsync(request);
    }

    public final OperationFuture<PurgeExecutionsResponse, PurgeExecutionsMetadata> purgeExecutionsAsync(String parent) {
        PurgeExecutionsRequest request = PurgeExecutionsRequest.newBuilder().setParent(parent).build();
        return this.purgeExecutionsAsync(request);
    }

    public final OperationFuture<PurgeExecutionsResponse, PurgeExecutionsMetadata> purgeExecutionsAsync(PurgeExecutionsRequest request) {
        return this.purgeExecutionsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PurgeExecutionsRequest, PurgeExecutionsResponse, PurgeExecutionsMetadata> purgeExecutionsOperationCallable() {
        return this.stub.purgeExecutionsOperationCallable();
    }

    public final UnaryCallable<PurgeExecutionsRequest, Operation> purgeExecutionsCallable() {
        return this.stub.purgeExecutionsCallable();
    }

    public final AddExecutionEventsResponse addExecutionEvents(ExecutionName execution, List<Event> events) {
        AddExecutionEventsRequest request = AddExecutionEventsRequest.newBuilder().setExecution(execution == null ? null : execution.toString()).addAllEvents(events).build();
        return this.addExecutionEvents(request);
    }

    public final AddExecutionEventsResponse addExecutionEvents(String execution, List<Event> events) {
        AddExecutionEventsRequest request = AddExecutionEventsRequest.newBuilder().setExecution(execution).addAllEvents(events).build();
        return this.addExecutionEvents(request);
    }

    public final AddExecutionEventsResponse addExecutionEvents(AddExecutionEventsRequest request) {
        return (AddExecutionEventsResponse)this.addExecutionEventsCallable().call((Object)request);
    }

    public final UnaryCallable<AddExecutionEventsRequest, AddExecutionEventsResponse> addExecutionEventsCallable() {
        return this.stub.addExecutionEventsCallable();
    }

    public final LineageSubgraph queryExecutionInputsAndOutputs(ExecutionName execution) {
        QueryExecutionInputsAndOutputsRequest request = QueryExecutionInputsAndOutputsRequest.newBuilder().setExecution(execution == null ? null : execution.toString()).build();
        return this.queryExecutionInputsAndOutputs(request);
    }

    public final LineageSubgraph queryExecutionInputsAndOutputs(String execution) {
        QueryExecutionInputsAndOutputsRequest request = QueryExecutionInputsAndOutputsRequest.newBuilder().setExecution(execution).build();
        return this.queryExecutionInputsAndOutputs(request);
    }

    public final LineageSubgraph queryExecutionInputsAndOutputs(QueryExecutionInputsAndOutputsRequest request) {
        return (LineageSubgraph)this.queryExecutionInputsAndOutputsCallable().call((Object)request);
    }

    public final UnaryCallable<QueryExecutionInputsAndOutputsRequest, LineageSubgraph> queryExecutionInputsAndOutputsCallable() {
        return this.stub.queryExecutionInputsAndOutputsCallable();
    }

    public final MetadataSchema createMetadataSchema(MetadataStoreName parent, MetadataSchema metadataSchema, String metadataSchemaId) {
        CreateMetadataSchemaRequest request = CreateMetadataSchemaRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setMetadataSchema(metadataSchema).setMetadataSchemaId(metadataSchemaId).build();
        return this.createMetadataSchema(request);
    }

    public final MetadataSchema createMetadataSchema(String parent, MetadataSchema metadataSchema, String metadataSchemaId) {
        CreateMetadataSchemaRequest request = CreateMetadataSchemaRequest.newBuilder().setParent(parent).setMetadataSchema(metadataSchema).setMetadataSchemaId(metadataSchemaId).build();
        return this.createMetadataSchema(request);
    }

    public final MetadataSchema createMetadataSchema(CreateMetadataSchemaRequest request) {
        return (MetadataSchema)this.createMetadataSchemaCallable().call((Object)request);
    }

    public final UnaryCallable<CreateMetadataSchemaRequest, MetadataSchema> createMetadataSchemaCallable() {
        return this.stub.createMetadataSchemaCallable();
    }

    public final MetadataSchema getMetadataSchema(MetadataSchemaName name) {
        GetMetadataSchemaRequest request = GetMetadataSchemaRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getMetadataSchema(request);
    }

    public final MetadataSchema getMetadataSchema(String name) {
        GetMetadataSchemaRequest request = GetMetadataSchemaRequest.newBuilder().setName(name).build();
        return this.getMetadataSchema(request);
    }

    public final MetadataSchema getMetadataSchema(GetMetadataSchemaRequest request) {
        return (MetadataSchema)this.getMetadataSchemaCallable().call((Object)request);
    }

    public final UnaryCallable<GetMetadataSchemaRequest, MetadataSchema> getMetadataSchemaCallable() {
        return this.stub.getMetadataSchemaCallable();
    }

    public final ListMetadataSchemasPagedResponse listMetadataSchemas(MetadataStoreName parent) {
        ListMetadataSchemasRequest request = ListMetadataSchemasRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listMetadataSchemas(request);
    }

    public final ListMetadataSchemasPagedResponse listMetadataSchemas(String parent) {
        ListMetadataSchemasRequest request = ListMetadataSchemasRequest.newBuilder().setParent(parent).build();
        return this.listMetadataSchemas(request);
    }

    public final ListMetadataSchemasPagedResponse listMetadataSchemas(ListMetadataSchemasRequest request) {
        return (ListMetadataSchemasPagedResponse)((Object)this.listMetadataSchemasPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListMetadataSchemasRequest, ListMetadataSchemasPagedResponse> listMetadataSchemasPagedCallable() {
        return this.stub.listMetadataSchemasPagedCallable();
    }

    public final UnaryCallable<ListMetadataSchemasRequest, ListMetadataSchemasResponse> listMetadataSchemasCallable() {
        return this.stub.listMetadataSchemasCallable();
    }

    public final LineageSubgraph queryArtifactLineageSubgraph(ArtifactName artifact) {
        QueryArtifactLineageSubgraphRequest request = QueryArtifactLineageSubgraphRequest.newBuilder().setArtifact(artifact == null ? null : artifact.toString()).build();
        return this.queryArtifactLineageSubgraph(request);
    }

    public final LineageSubgraph queryArtifactLineageSubgraph(String artifact) {
        QueryArtifactLineageSubgraphRequest request = QueryArtifactLineageSubgraphRequest.newBuilder().setArtifact(artifact).build();
        return this.queryArtifactLineageSubgraph(request);
    }

    public final LineageSubgraph queryArtifactLineageSubgraph(QueryArtifactLineageSubgraphRequest request) {
        return (LineageSubgraph)this.queryArtifactLineageSubgraphCallable().call((Object)request);
    }

    public final UnaryCallable<QueryArtifactLineageSubgraphRequest, LineageSubgraph> queryArtifactLineageSubgraphCallable() {
        return this.stub.queryArtifactLineageSubgraphCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListMetadataSchemasFixedSizeCollection
    extends AbstractFixedSizeCollection<ListMetadataSchemasRequest, ListMetadataSchemasResponse, MetadataSchema, ListMetadataSchemasPage, ListMetadataSchemasFixedSizeCollection> {
        private ListMetadataSchemasFixedSizeCollection(List<ListMetadataSchemasPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListMetadataSchemasFixedSizeCollection createEmptyCollection() {
            return new ListMetadataSchemasFixedSizeCollection(null, 0);
        }

        protected ListMetadataSchemasFixedSizeCollection createCollection(List<ListMetadataSchemasPage> pages, int collectionSize) {
            return new ListMetadataSchemasFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListMetadataSchemasPage
    extends AbstractPage<ListMetadataSchemasRequest, ListMetadataSchemasResponse, MetadataSchema, ListMetadataSchemasPage> {
        private ListMetadataSchemasPage(PageContext<ListMetadataSchemasRequest, ListMetadataSchemasResponse, MetadataSchema> context, ListMetadataSchemasResponse response) {
            super(context, (Object)response);
        }

        private static ListMetadataSchemasPage createEmptyPage() {
            return new ListMetadataSchemasPage(null, null);
        }

        protected ListMetadataSchemasPage createPage(PageContext<ListMetadataSchemasRequest, ListMetadataSchemasResponse, MetadataSchema> context, ListMetadataSchemasResponse response) {
            return new ListMetadataSchemasPage(context, response);
        }

        public ApiFuture<ListMetadataSchemasPage> createPageAsync(PageContext<ListMetadataSchemasRequest, ListMetadataSchemasResponse, MetadataSchema> context, ApiFuture<ListMetadataSchemasResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListMetadataSchemasPagedResponse
    extends AbstractPagedListResponse<ListMetadataSchemasRequest, ListMetadataSchemasResponse, MetadataSchema, ListMetadataSchemasPage, ListMetadataSchemasFixedSizeCollection> {
        public static ApiFuture<ListMetadataSchemasPagedResponse> createAsync(PageContext<ListMetadataSchemasRequest, ListMetadataSchemasResponse, MetadataSchema> context, ApiFuture<ListMetadataSchemasResponse> futureResponse) {
            ApiFuture<ListMetadataSchemasPage> futurePage = ListMetadataSchemasPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListMetadataSchemasPagedResponse((ListMetadataSchemasPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListMetadataSchemasPagedResponse(ListMetadataSchemasPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListMetadataSchemasFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListExecutionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListExecutionsRequest, ListExecutionsResponse, Execution, ListExecutionsPage, ListExecutionsFixedSizeCollection> {
        private ListExecutionsFixedSizeCollection(List<ListExecutionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListExecutionsFixedSizeCollection createEmptyCollection() {
            return new ListExecutionsFixedSizeCollection(null, 0);
        }

        protected ListExecutionsFixedSizeCollection createCollection(List<ListExecutionsPage> pages, int collectionSize) {
            return new ListExecutionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListExecutionsPage
    extends AbstractPage<ListExecutionsRequest, ListExecutionsResponse, Execution, ListExecutionsPage> {
        private ListExecutionsPage(PageContext<ListExecutionsRequest, ListExecutionsResponse, Execution> context, ListExecutionsResponse response) {
            super(context, (Object)response);
        }

        private static ListExecutionsPage createEmptyPage() {
            return new ListExecutionsPage(null, null);
        }

        protected ListExecutionsPage createPage(PageContext<ListExecutionsRequest, ListExecutionsResponse, Execution> context, ListExecutionsResponse response) {
            return new ListExecutionsPage(context, response);
        }

        public ApiFuture<ListExecutionsPage> createPageAsync(PageContext<ListExecutionsRequest, ListExecutionsResponse, Execution> context, ApiFuture<ListExecutionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListExecutionsPagedResponse
    extends AbstractPagedListResponse<ListExecutionsRequest, ListExecutionsResponse, Execution, ListExecutionsPage, ListExecutionsFixedSizeCollection> {
        public static ApiFuture<ListExecutionsPagedResponse> createAsync(PageContext<ListExecutionsRequest, ListExecutionsResponse, Execution> context, ApiFuture<ListExecutionsResponse> futureResponse) {
            ApiFuture<ListExecutionsPage> futurePage = ListExecutionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListExecutionsPagedResponse((ListExecutionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListExecutionsPagedResponse(ListExecutionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListExecutionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListContextsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListContextsRequest, ListContextsResponse, Context, ListContextsPage, ListContextsFixedSizeCollection> {
        private ListContextsFixedSizeCollection(List<ListContextsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListContextsFixedSizeCollection createEmptyCollection() {
            return new ListContextsFixedSizeCollection(null, 0);
        }

        protected ListContextsFixedSizeCollection createCollection(List<ListContextsPage> pages, int collectionSize) {
            return new ListContextsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListContextsPage
    extends AbstractPage<ListContextsRequest, ListContextsResponse, Context, ListContextsPage> {
        private ListContextsPage(PageContext<ListContextsRequest, ListContextsResponse, Context> context, ListContextsResponse response) {
            super(context, (Object)response);
        }

        private static ListContextsPage createEmptyPage() {
            return new ListContextsPage(null, null);
        }

        protected ListContextsPage createPage(PageContext<ListContextsRequest, ListContextsResponse, Context> context, ListContextsResponse response) {
            return new ListContextsPage(context, response);
        }

        public ApiFuture<ListContextsPage> createPageAsync(PageContext<ListContextsRequest, ListContextsResponse, Context> context, ApiFuture<ListContextsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListContextsPagedResponse
    extends AbstractPagedListResponse<ListContextsRequest, ListContextsResponse, Context, ListContextsPage, ListContextsFixedSizeCollection> {
        public static ApiFuture<ListContextsPagedResponse> createAsync(PageContext<ListContextsRequest, ListContextsResponse, Context> context, ApiFuture<ListContextsResponse> futureResponse) {
            ApiFuture<ListContextsPage> futurePage = ListContextsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListContextsPagedResponse((ListContextsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListContextsPagedResponse(ListContextsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListContextsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListArtifactsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListArtifactsRequest, ListArtifactsResponse, Artifact, ListArtifactsPage, ListArtifactsFixedSizeCollection> {
        private ListArtifactsFixedSizeCollection(List<ListArtifactsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListArtifactsFixedSizeCollection createEmptyCollection() {
            return new ListArtifactsFixedSizeCollection(null, 0);
        }

        protected ListArtifactsFixedSizeCollection createCollection(List<ListArtifactsPage> pages, int collectionSize) {
            return new ListArtifactsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListArtifactsPage
    extends AbstractPage<ListArtifactsRequest, ListArtifactsResponse, Artifact, ListArtifactsPage> {
        private ListArtifactsPage(PageContext<ListArtifactsRequest, ListArtifactsResponse, Artifact> context, ListArtifactsResponse response) {
            super(context, (Object)response);
        }

        private static ListArtifactsPage createEmptyPage() {
            return new ListArtifactsPage(null, null);
        }

        protected ListArtifactsPage createPage(PageContext<ListArtifactsRequest, ListArtifactsResponse, Artifact> context, ListArtifactsResponse response) {
            return new ListArtifactsPage(context, response);
        }

        public ApiFuture<ListArtifactsPage> createPageAsync(PageContext<ListArtifactsRequest, ListArtifactsResponse, Artifact> context, ApiFuture<ListArtifactsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListArtifactsPagedResponse
    extends AbstractPagedListResponse<ListArtifactsRequest, ListArtifactsResponse, Artifact, ListArtifactsPage, ListArtifactsFixedSizeCollection> {
        public static ApiFuture<ListArtifactsPagedResponse> createAsync(PageContext<ListArtifactsRequest, ListArtifactsResponse, Artifact> context, ApiFuture<ListArtifactsResponse> futureResponse) {
            ApiFuture<ListArtifactsPage> futurePage = ListArtifactsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListArtifactsPagedResponse((ListArtifactsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListArtifactsPagedResponse(ListArtifactsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListArtifactsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListMetadataStoresFixedSizeCollection
    extends AbstractFixedSizeCollection<ListMetadataStoresRequest, ListMetadataStoresResponse, MetadataStore, ListMetadataStoresPage, ListMetadataStoresFixedSizeCollection> {
        private ListMetadataStoresFixedSizeCollection(List<ListMetadataStoresPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListMetadataStoresFixedSizeCollection createEmptyCollection() {
            return new ListMetadataStoresFixedSizeCollection(null, 0);
        }

        protected ListMetadataStoresFixedSizeCollection createCollection(List<ListMetadataStoresPage> pages, int collectionSize) {
            return new ListMetadataStoresFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListMetadataStoresPage
    extends AbstractPage<ListMetadataStoresRequest, ListMetadataStoresResponse, MetadataStore, ListMetadataStoresPage> {
        private ListMetadataStoresPage(PageContext<ListMetadataStoresRequest, ListMetadataStoresResponse, MetadataStore> context, ListMetadataStoresResponse response) {
            super(context, (Object)response);
        }

        private static ListMetadataStoresPage createEmptyPage() {
            return new ListMetadataStoresPage(null, null);
        }

        protected ListMetadataStoresPage createPage(PageContext<ListMetadataStoresRequest, ListMetadataStoresResponse, MetadataStore> context, ListMetadataStoresResponse response) {
            return new ListMetadataStoresPage(context, response);
        }

        public ApiFuture<ListMetadataStoresPage> createPageAsync(PageContext<ListMetadataStoresRequest, ListMetadataStoresResponse, MetadataStore> context, ApiFuture<ListMetadataStoresResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListMetadataStoresPagedResponse
    extends AbstractPagedListResponse<ListMetadataStoresRequest, ListMetadataStoresResponse, MetadataStore, ListMetadataStoresPage, ListMetadataStoresFixedSizeCollection> {
        public static ApiFuture<ListMetadataStoresPagedResponse> createAsync(PageContext<ListMetadataStoresRequest, ListMetadataStoresResponse, MetadataStore> context, ApiFuture<ListMetadataStoresResponse> futureResponse) {
            ApiFuture<ListMetadataStoresPage> futurePage = ListMetadataStoresPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListMetadataStoresPagedResponse((ListMetadataStoresPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListMetadataStoresPagedResponse(ListMetadataStoresPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListMetadataStoresFixedSizeCollection.createEmptyCollection());
        }
    }
}

