/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1beta1.BatchCreateFeaturesOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.BatchCreateFeaturesRequest;
import com.google.cloud.aiplatform.v1beta1.BatchCreateFeaturesResponse;
import com.google.cloud.aiplatform.v1beta1.BatchReadFeatureValuesOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.BatchReadFeatureValuesRequest;
import com.google.cloud.aiplatform.v1beta1.BatchReadFeatureValuesResponse;
import com.google.cloud.aiplatform.v1beta1.CreateEntityTypeOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.CreateEntityTypeRequest;
import com.google.cloud.aiplatform.v1beta1.CreateFeatureOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.CreateFeatureRequest;
import com.google.cloud.aiplatform.v1beta1.CreateFeaturestoreOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.CreateFeaturestoreRequest;
import com.google.cloud.aiplatform.v1beta1.DeleteEntityTypeRequest;
import com.google.cloud.aiplatform.v1beta1.DeleteFeatureRequest;
import com.google.cloud.aiplatform.v1beta1.DeleteFeaturestoreRequest;
import com.google.cloud.aiplatform.v1beta1.DeleteOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.EntityType;
import com.google.cloud.aiplatform.v1beta1.EntityTypeName;
import com.google.cloud.aiplatform.v1beta1.ExportFeatureValuesOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.ExportFeatureValuesRequest;
import com.google.cloud.aiplatform.v1beta1.ExportFeatureValuesResponse;
import com.google.cloud.aiplatform.v1beta1.Feature;
import com.google.cloud.aiplatform.v1beta1.FeatureName;
import com.google.cloud.aiplatform.v1beta1.Featurestore;
import com.google.cloud.aiplatform.v1beta1.FeaturestoreName;
import com.google.cloud.aiplatform.v1beta1.FeaturestoreServiceSettings;
import com.google.cloud.aiplatform.v1beta1.GetEntityTypeRequest;
import com.google.cloud.aiplatform.v1beta1.GetFeatureRequest;
import com.google.cloud.aiplatform.v1beta1.GetFeaturestoreRequest;
import com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest;
import com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesResponse;
import com.google.cloud.aiplatform.v1beta1.ListEntityTypesRequest;
import com.google.cloud.aiplatform.v1beta1.ListEntityTypesResponse;
import com.google.cloud.aiplatform.v1beta1.ListFeaturesRequest;
import com.google.cloud.aiplatform.v1beta1.ListFeaturesResponse;
import com.google.cloud.aiplatform.v1beta1.ListFeaturestoresRequest;
import com.google.cloud.aiplatform.v1beta1.ListFeaturestoresResponse;
import com.google.cloud.aiplatform.v1beta1.LocationName;
import com.google.cloud.aiplatform.v1beta1.SearchFeaturesRequest;
import com.google.cloud.aiplatform.v1beta1.SearchFeaturesResponse;
import com.google.cloud.aiplatform.v1beta1.UpdateEntityTypeRequest;
import com.google.cloud.aiplatform.v1beta1.UpdateFeatureRequest;
import com.google.cloud.aiplatform.v1beta1.UpdateFeaturestoreOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.UpdateFeaturestoreRequest;
import com.google.cloud.aiplatform.v1beta1.stub.FeaturestoreServiceStub;
import com.google.cloud.aiplatform.v1beta1.stub.FeaturestoreServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class FeaturestoreServiceClient
implements BackgroundResource {
    private final FeaturestoreServiceSettings settings;
    private final FeaturestoreServiceStub stub;
    private final OperationsClient operationsClient;

    public static final FeaturestoreServiceClient create() throws IOException {
        return FeaturestoreServiceClient.create(FeaturestoreServiceSettings.newBuilder().build());
    }

    public static final FeaturestoreServiceClient create(FeaturestoreServiceSettings settings) throws IOException {
        return new FeaturestoreServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final FeaturestoreServiceClient create(FeaturestoreServiceStub stub) {
        return new FeaturestoreServiceClient(stub);
    }

    protected FeaturestoreServiceClient(FeaturestoreServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((FeaturestoreServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected FeaturestoreServiceClient(FeaturestoreServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final FeaturestoreServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public FeaturestoreServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final OperationFuture<Featurestore, CreateFeaturestoreOperationMetadata> createFeaturestoreAsync(LocationName parent, Featurestore featurestore) {
        CreateFeaturestoreRequest request = CreateFeaturestoreRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setFeaturestore(featurestore).build();
        return this.createFeaturestoreAsync(request);
    }

    public final OperationFuture<Featurestore, CreateFeaturestoreOperationMetadata> createFeaturestoreAsync(String parent, Featurestore featurestore) {
        CreateFeaturestoreRequest request = CreateFeaturestoreRequest.newBuilder().setParent(parent).setFeaturestore(featurestore).build();
        return this.createFeaturestoreAsync(request);
    }

    public final OperationFuture<Featurestore, CreateFeaturestoreOperationMetadata> createFeaturestoreAsync(CreateFeaturestoreRequest request) {
        return this.createFeaturestoreOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateFeaturestoreRequest, Featurestore, CreateFeaturestoreOperationMetadata> createFeaturestoreOperationCallable() {
        return this.stub.createFeaturestoreOperationCallable();
    }

    public final UnaryCallable<CreateFeaturestoreRequest, Operation> createFeaturestoreCallable() {
        return this.stub.createFeaturestoreCallable();
    }

    public final Featurestore getFeaturestore(FeaturestoreName name) {
        GetFeaturestoreRequest request = GetFeaturestoreRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getFeaturestore(request);
    }

    public final Featurestore getFeaturestore(String name) {
        GetFeaturestoreRequest request = GetFeaturestoreRequest.newBuilder().setName(name).build();
        return this.getFeaturestore(request);
    }

    public final Featurestore getFeaturestore(GetFeaturestoreRequest request) {
        return (Featurestore)this.getFeaturestoreCallable().call((Object)request);
    }

    public final UnaryCallable<GetFeaturestoreRequest, Featurestore> getFeaturestoreCallable() {
        return this.stub.getFeaturestoreCallable();
    }

    public final ListFeaturestoresPagedResponse listFeaturestores(LocationName parent) {
        ListFeaturestoresRequest request = ListFeaturestoresRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listFeaturestores(request);
    }

    public final ListFeaturestoresPagedResponse listFeaturestores(String parent) {
        ListFeaturestoresRequest request = ListFeaturestoresRequest.newBuilder().setParent(parent).build();
        return this.listFeaturestores(request);
    }

    public final ListFeaturestoresPagedResponse listFeaturestores(ListFeaturestoresRequest request) {
        return (ListFeaturestoresPagedResponse)((Object)this.listFeaturestoresPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListFeaturestoresRequest, ListFeaturestoresPagedResponse> listFeaturestoresPagedCallable() {
        return this.stub.listFeaturestoresPagedCallable();
    }

    public final UnaryCallable<ListFeaturestoresRequest, ListFeaturestoresResponse> listFeaturestoresCallable() {
        return this.stub.listFeaturestoresCallable();
    }

    public final OperationFuture<Featurestore, UpdateFeaturestoreOperationMetadata> updateFeaturestoreAsync(Featurestore featurestore, FieldMask updateMask) {
        UpdateFeaturestoreRequest request = UpdateFeaturestoreRequest.newBuilder().setFeaturestore(featurestore).setUpdateMask(updateMask).build();
        return this.updateFeaturestoreAsync(request);
    }

    public final OperationFuture<Featurestore, UpdateFeaturestoreOperationMetadata> updateFeaturestoreAsync(UpdateFeaturestoreRequest request) {
        return this.updateFeaturestoreOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateFeaturestoreRequest, Featurestore, UpdateFeaturestoreOperationMetadata> updateFeaturestoreOperationCallable() {
        return this.stub.updateFeaturestoreOperationCallable();
    }

    public final UnaryCallable<UpdateFeaturestoreRequest, Operation> updateFeaturestoreCallable() {
        return this.stub.updateFeaturestoreCallable();
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteFeaturestoreAsync(FeaturestoreName name) {
        DeleteFeaturestoreRequest request = DeleteFeaturestoreRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteFeaturestoreAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteFeaturestoreAsync(String name) {
        DeleteFeaturestoreRequest request = DeleteFeaturestoreRequest.newBuilder().setName(name).build();
        return this.deleteFeaturestoreAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteFeaturestoreAsync(DeleteFeaturestoreRequest request) {
        return this.deleteFeaturestoreOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteFeaturestoreRequest, Empty, DeleteOperationMetadata> deleteFeaturestoreOperationCallable() {
        return this.stub.deleteFeaturestoreOperationCallable();
    }

    public final UnaryCallable<DeleteFeaturestoreRequest, Operation> deleteFeaturestoreCallable() {
        return this.stub.deleteFeaturestoreCallable();
    }

    public final OperationFuture<EntityType, CreateEntityTypeOperationMetadata> createEntityTypeAsync(FeaturestoreName parent, EntityType entityType) {
        CreateEntityTypeRequest request = CreateEntityTypeRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setEntityType(entityType).build();
        return this.createEntityTypeAsync(request);
    }

    public final OperationFuture<EntityType, CreateEntityTypeOperationMetadata> createEntityTypeAsync(String parent, EntityType entityType) {
        CreateEntityTypeRequest request = CreateEntityTypeRequest.newBuilder().setParent(parent).setEntityType(entityType).build();
        return this.createEntityTypeAsync(request);
    }

    public final OperationFuture<EntityType, CreateEntityTypeOperationMetadata> createEntityTypeAsync(CreateEntityTypeRequest request) {
        return this.createEntityTypeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateEntityTypeRequest, EntityType, CreateEntityTypeOperationMetadata> createEntityTypeOperationCallable() {
        return this.stub.createEntityTypeOperationCallable();
    }

    public final UnaryCallable<CreateEntityTypeRequest, Operation> createEntityTypeCallable() {
        return this.stub.createEntityTypeCallable();
    }

    public final EntityType getEntityType(EntityTypeName name) {
        GetEntityTypeRequest request = GetEntityTypeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getEntityType(request);
    }

    public final EntityType getEntityType(String name) {
        GetEntityTypeRequest request = GetEntityTypeRequest.newBuilder().setName(name).build();
        return this.getEntityType(request);
    }

    public final EntityType getEntityType(GetEntityTypeRequest request) {
        return (EntityType)this.getEntityTypeCallable().call((Object)request);
    }

    public final UnaryCallable<GetEntityTypeRequest, EntityType> getEntityTypeCallable() {
        return this.stub.getEntityTypeCallable();
    }

    public final ListEntityTypesPagedResponse listEntityTypes(FeaturestoreName parent) {
        ListEntityTypesRequest request = ListEntityTypesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listEntityTypes(request);
    }

    public final ListEntityTypesPagedResponse listEntityTypes(String parent) {
        ListEntityTypesRequest request = ListEntityTypesRequest.newBuilder().setParent(parent).build();
        return this.listEntityTypes(request);
    }

    public final ListEntityTypesPagedResponse listEntityTypes(ListEntityTypesRequest request) {
        return (ListEntityTypesPagedResponse)((Object)this.listEntityTypesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListEntityTypesRequest, ListEntityTypesPagedResponse> listEntityTypesPagedCallable() {
        return this.stub.listEntityTypesPagedCallable();
    }

    public final UnaryCallable<ListEntityTypesRequest, ListEntityTypesResponse> listEntityTypesCallable() {
        return this.stub.listEntityTypesCallable();
    }

    public final EntityType updateEntityType(EntityType entityType, FieldMask updateMask) {
        UpdateEntityTypeRequest request = UpdateEntityTypeRequest.newBuilder().setEntityType(entityType).setUpdateMask(updateMask).build();
        return this.updateEntityType(request);
    }

    public final EntityType updateEntityType(UpdateEntityTypeRequest request) {
        return (EntityType)this.updateEntityTypeCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateEntityTypeRequest, EntityType> updateEntityTypeCallable() {
        return this.stub.updateEntityTypeCallable();
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteEntityTypeAsync(EntityTypeName name) {
        DeleteEntityTypeRequest request = DeleteEntityTypeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteEntityTypeAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteEntityTypeAsync(String name) {
        DeleteEntityTypeRequest request = DeleteEntityTypeRequest.newBuilder().setName(name).build();
        return this.deleteEntityTypeAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteEntityTypeAsync(DeleteEntityTypeRequest request) {
        return this.deleteEntityTypeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteEntityTypeRequest, Empty, DeleteOperationMetadata> deleteEntityTypeOperationCallable() {
        return this.stub.deleteEntityTypeOperationCallable();
    }

    public final UnaryCallable<DeleteEntityTypeRequest, Operation> deleteEntityTypeCallable() {
        return this.stub.deleteEntityTypeCallable();
    }

    public final OperationFuture<Feature, CreateFeatureOperationMetadata> createFeatureAsync(EntityTypeName parent, Feature feature) {
        CreateFeatureRequest request = CreateFeatureRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setFeature(feature).build();
        return this.createFeatureAsync(request);
    }

    public final OperationFuture<Feature, CreateFeatureOperationMetadata> createFeatureAsync(String parent, Feature feature) {
        CreateFeatureRequest request = CreateFeatureRequest.newBuilder().setParent(parent).setFeature(feature).build();
        return this.createFeatureAsync(request);
    }

    public final OperationFuture<Feature, CreateFeatureOperationMetadata> createFeatureAsync(CreateFeatureRequest request) {
        return this.createFeatureOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateFeatureRequest, Feature, CreateFeatureOperationMetadata> createFeatureOperationCallable() {
        return this.stub.createFeatureOperationCallable();
    }

    public final UnaryCallable<CreateFeatureRequest, Operation> createFeatureCallable() {
        return this.stub.createFeatureCallable();
    }

    public final OperationFuture<BatchCreateFeaturesResponse, BatchCreateFeaturesOperationMetadata> batchCreateFeaturesAsync(EntityTypeName parent, List<CreateFeatureRequest> requests) {
        BatchCreateFeaturesRequest request = BatchCreateFeaturesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).addAllRequests(requests).build();
        return this.batchCreateFeaturesAsync(request);
    }

    public final OperationFuture<BatchCreateFeaturesResponse, BatchCreateFeaturesOperationMetadata> batchCreateFeaturesAsync(String parent, List<CreateFeatureRequest> requests) {
        BatchCreateFeaturesRequest request = BatchCreateFeaturesRequest.newBuilder().setParent(parent).addAllRequests(requests).build();
        return this.batchCreateFeaturesAsync(request);
    }

    public final OperationFuture<BatchCreateFeaturesResponse, BatchCreateFeaturesOperationMetadata> batchCreateFeaturesAsync(BatchCreateFeaturesRequest request) {
        return this.batchCreateFeaturesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<BatchCreateFeaturesRequest, BatchCreateFeaturesResponse, BatchCreateFeaturesOperationMetadata> batchCreateFeaturesOperationCallable() {
        return this.stub.batchCreateFeaturesOperationCallable();
    }

    public final UnaryCallable<BatchCreateFeaturesRequest, Operation> batchCreateFeaturesCallable() {
        return this.stub.batchCreateFeaturesCallable();
    }

    public final Feature getFeature(FeatureName name) {
        GetFeatureRequest request = GetFeatureRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getFeature(request);
    }

    public final Feature getFeature(String name) {
        GetFeatureRequest request = GetFeatureRequest.newBuilder().setName(name).build();
        return this.getFeature(request);
    }

    public final Feature getFeature(GetFeatureRequest request) {
        return (Feature)this.getFeatureCallable().call((Object)request);
    }

    public final UnaryCallable<GetFeatureRequest, Feature> getFeatureCallable() {
        return this.stub.getFeatureCallable();
    }

    public final ListFeaturesPagedResponse listFeatures(EntityTypeName parent) {
        ListFeaturesRequest request = ListFeaturesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listFeatures(request);
    }

    public final ListFeaturesPagedResponse listFeatures(String parent) {
        ListFeaturesRequest request = ListFeaturesRequest.newBuilder().setParent(parent).build();
        return this.listFeatures(request);
    }

    public final ListFeaturesPagedResponse listFeatures(ListFeaturesRequest request) {
        return (ListFeaturesPagedResponse)((Object)this.listFeaturesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListFeaturesRequest, ListFeaturesPagedResponse> listFeaturesPagedCallable() {
        return this.stub.listFeaturesPagedCallable();
    }

    public final UnaryCallable<ListFeaturesRequest, ListFeaturesResponse> listFeaturesCallable() {
        return this.stub.listFeaturesCallable();
    }

    public final Feature updateFeature(Feature feature, FieldMask updateMask) {
        UpdateFeatureRequest request = UpdateFeatureRequest.newBuilder().setFeature(feature).setUpdateMask(updateMask).build();
        return this.updateFeature(request);
    }

    public final Feature updateFeature(UpdateFeatureRequest request) {
        return (Feature)this.updateFeatureCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateFeatureRequest, Feature> updateFeatureCallable() {
        return this.stub.updateFeatureCallable();
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteFeatureAsync(FeatureName name) {
        DeleteFeatureRequest request = DeleteFeatureRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteFeatureAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteFeatureAsync(String name) {
        DeleteFeatureRequest request = DeleteFeatureRequest.newBuilder().setName(name).build();
        return this.deleteFeatureAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteFeatureAsync(DeleteFeatureRequest request) {
        return this.deleteFeatureOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteFeatureRequest, Empty, DeleteOperationMetadata> deleteFeatureOperationCallable() {
        return this.stub.deleteFeatureOperationCallable();
    }

    public final UnaryCallable<DeleteFeatureRequest, Operation> deleteFeatureCallable() {
        return this.stub.deleteFeatureCallable();
    }

    public final OperationFuture<ImportFeatureValuesResponse, ImportFeatureValuesOperationMetadata> importFeatureValuesAsync(EntityTypeName entityType) {
        ImportFeatureValuesRequest request = ImportFeatureValuesRequest.newBuilder().setEntityType(entityType == null ? null : entityType.toString()).build();
        return this.importFeatureValuesAsync(request);
    }

    public final OperationFuture<ImportFeatureValuesResponse, ImportFeatureValuesOperationMetadata> importFeatureValuesAsync(String entityType) {
        ImportFeatureValuesRequest request = ImportFeatureValuesRequest.newBuilder().setEntityType(entityType).build();
        return this.importFeatureValuesAsync(request);
    }

    public final OperationFuture<ImportFeatureValuesResponse, ImportFeatureValuesOperationMetadata> importFeatureValuesAsync(ImportFeatureValuesRequest request) {
        return this.importFeatureValuesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ImportFeatureValuesRequest, ImportFeatureValuesResponse, ImportFeatureValuesOperationMetadata> importFeatureValuesOperationCallable() {
        return this.stub.importFeatureValuesOperationCallable();
    }

    public final UnaryCallable<ImportFeatureValuesRequest, Operation> importFeatureValuesCallable() {
        return this.stub.importFeatureValuesCallable();
    }

    public final OperationFuture<BatchReadFeatureValuesResponse, BatchReadFeatureValuesOperationMetadata> batchReadFeatureValuesAsync(FeaturestoreName featurestore) {
        BatchReadFeatureValuesRequest request = BatchReadFeatureValuesRequest.newBuilder().setFeaturestore(featurestore == null ? null : featurestore.toString()).build();
        return this.batchReadFeatureValuesAsync(request);
    }

    public final OperationFuture<BatchReadFeatureValuesResponse, BatchReadFeatureValuesOperationMetadata> batchReadFeatureValuesAsync(String featurestore) {
        BatchReadFeatureValuesRequest request = BatchReadFeatureValuesRequest.newBuilder().setFeaturestore(featurestore).build();
        return this.batchReadFeatureValuesAsync(request);
    }

    public final OperationFuture<BatchReadFeatureValuesResponse, BatchReadFeatureValuesOperationMetadata> batchReadFeatureValuesAsync(BatchReadFeatureValuesRequest request) {
        return this.batchReadFeatureValuesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<BatchReadFeatureValuesRequest, BatchReadFeatureValuesResponse, BatchReadFeatureValuesOperationMetadata> batchReadFeatureValuesOperationCallable() {
        return this.stub.batchReadFeatureValuesOperationCallable();
    }

    public final UnaryCallable<BatchReadFeatureValuesRequest, Operation> batchReadFeatureValuesCallable() {
        return this.stub.batchReadFeatureValuesCallable();
    }

    public final OperationFuture<ExportFeatureValuesResponse, ExportFeatureValuesOperationMetadata> exportFeatureValuesAsync(EntityTypeName entityType) {
        ExportFeatureValuesRequest request = ExportFeatureValuesRequest.newBuilder().setEntityType(entityType == null ? null : entityType.toString()).build();
        return this.exportFeatureValuesAsync(request);
    }

    public final OperationFuture<ExportFeatureValuesResponse, ExportFeatureValuesOperationMetadata> exportFeatureValuesAsync(String entityType) {
        ExportFeatureValuesRequest request = ExportFeatureValuesRequest.newBuilder().setEntityType(entityType).build();
        return this.exportFeatureValuesAsync(request);
    }

    public final OperationFuture<ExportFeatureValuesResponse, ExportFeatureValuesOperationMetadata> exportFeatureValuesAsync(ExportFeatureValuesRequest request) {
        return this.exportFeatureValuesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ExportFeatureValuesRequest, ExportFeatureValuesResponse, ExportFeatureValuesOperationMetadata> exportFeatureValuesOperationCallable() {
        return this.stub.exportFeatureValuesOperationCallable();
    }

    public final UnaryCallable<ExportFeatureValuesRequest, Operation> exportFeatureValuesCallable() {
        return this.stub.exportFeatureValuesCallable();
    }

    public final SearchFeaturesPagedResponse searchFeatures(LocationName location) {
        SearchFeaturesRequest request = SearchFeaturesRequest.newBuilder().setLocation(location == null ? null : location.toString()).build();
        return this.searchFeatures(request);
    }

    public final SearchFeaturesPagedResponse searchFeatures(String location) {
        SearchFeaturesRequest request = SearchFeaturesRequest.newBuilder().setLocation(location).build();
        return this.searchFeatures(request);
    }

    public final SearchFeaturesPagedResponse searchFeatures(SearchFeaturesRequest request) {
        return (SearchFeaturesPagedResponse)((Object)this.searchFeaturesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<SearchFeaturesRequest, SearchFeaturesPagedResponse> searchFeaturesPagedCallable() {
        return this.stub.searchFeaturesPagedCallable();
    }

    public final UnaryCallable<SearchFeaturesRequest, SearchFeaturesResponse> searchFeaturesCallable() {
        return this.stub.searchFeaturesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class SearchFeaturesFixedSizeCollection
    extends AbstractFixedSizeCollection<SearchFeaturesRequest, SearchFeaturesResponse, Feature, SearchFeaturesPage, SearchFeaturesFixedSizeCollection> {
        private SearchFeaturesFixedSizeCollection(List<SearchFeaturesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static SearchFeaturesFixedSizeCollection createEmptyCollection() {
            return new SearchFeaturesFixedSizeCollection(null, 0);
        }

        protected SearchFeaturesFixedSizeCollection createCollection(List<SearchFeaturesPage> pages, int collectionSize) {
            return new SearchFeaturesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class SearchFeaturesPage
    extends AbstractPage<SearchFeaturesRequest, SearchFeaturesResponse, Feature, SearchFeaturesPage> {
        private SearchFeaturesPage(PageContext<SearchFeaturesRequest, SearchFeaturesResponse, Feature> context, SearchFeaturesResponse response) {
            super(context, (Object)response);
        }

        private static SearchFeaturesPage createEmptyPage() {
            return new SearchFeaturesPage(null, null);
        }

        protected SearchFeaturesPage createPage(PageContext<SearchFeaturesRequest, SearchFeaturesResponse, Feature> context, SearchFeaturesResponse response) {
            return new SearchFeaturesPage(context, response);
        }

        public ApiFuture<SearchFeaturesPage> createPageAsync(PageContext<SearchFeaturesRequest, SearchFeaturesResponse, Feature> context, ApiFuture<SearchFeaturesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class SearchFeaturesPagedResponse
    extends AbstractPagedListResponse<SearchFeaturesRequest, SearchFeaturesResponse, Feature, SearchFeaturesPage, SearchFeaturesFixedSizeCollection> {
        public static ApiFuture<SearchFeaturesPagedResponse> createAsync(PageContext<SearchFeaturesRequest, SearchFeaturesResponse, Feature> context, ApiFuture<SearchFeaturesResponse> futureResponse) {
            ApiFuture<SearchFeaturesPage> futurePage = SearchFeaturesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<SearchFeaturesPage, SearchFeaturesPagedResponse>(){

                public SearchFeaturesPagedResponse apply(SearchFeaturesPage input) {
                    return new SearchFeaturesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private SearchFeaturesPagedResponse(SearchFeaturesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)SearchFeaturesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListFeaturesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListFeaturesRequest, ListFeaturesResponse, Feature, ListFeaturesPage, ListFeaturesFixedSizeCollection> {
        private ListFeaturesFixedSizeCollection(List<ListFeaturesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFeaturesFixedSizeCollection createEmptyCollection() {
            return new ListFeaturesFixedSizeCollection(null, 0);
        }

        protected ListFeaturesFixedSizeCollection createCollection(List<ListFeaturesPage> pages, int collectionSize) {
            return new ListFeaturesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListFeaturesPage
    extends AbstractPage<ListFeaturesRequest, ListFeaturesResponse, Feature, ListFeaturesPage> {
        private ListFeaturesPage(PageContext<ListFeaturesRequest, ListFeaturesResponse, Feature> context, ListFeaturesResponse response) {
            super(context, (Object)response);
        }

        private static ListFeaturesPage createEmptyPage() {
            return new ListFeaturesPage(null, null);
        }

        protected ListFeaturesPage createPage(PageContext<ListFeaturesRequest, ListFeaturesResponse, Feature> context, ListFeaturesResponse response) {
            return new ListFeaturesPage(context, response);
        }

        public ApiFuture<ListFeaturesPage> createPageAsync(PageContext<ListFeaturesRequest, ListFeaturesResponse, Feature> context, ApiFuture<ListFeaturesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListFeaturesPagedResponse
    extends AbstractPagedListResponse<ListFeaturesRequest, ListFeaturesResponse, Feature, ListFeaturesPage, ListFeaturesFixedSizeCollection> {
        public static ApiFuture<ListFeaturesPagedResponse> createAsync(PageContext<ListFeaturesRequest, ListFeaturesResponse, Feature> context, ApiFuture<ListFeaturesResponse> futureResponse) {
            ApiFuture<ListFeaturesPage> futurePage = ListFeaturesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListFeaturesPage, ListFeaturesPagedResponse>(){

                public ListFeaturesPagedResponse apply(ListFeaturesPage input) {
                    return new ListFeaturesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListFeaturesPagedResponse(ListFeaturesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFeaturesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListEntityTypesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListEntityTypesRequest, ListEntityTypesResponse, EntityType, ListEntityTypesPage, ListEntityTypesFixedSizeCollection> {
        private ListEntityTypesFixedSizeCollection(List<ListEntityTypesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListEntityTypesFixedSizeCollection createEmptyCollection() {
            return new ListEntityTypesFixedSizeCollection(null, 0);
        }

        protected ListEntityTypesFixedSizeCollection createCollection(List<ListEntityTypesPage> pages, int collectionSize) {
            return new ListEntityTypesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListEntityTypesPage
    extends AbstractPage<ListEntityTypesRequest, ListEntityTypesResponse, EntityType, ListEntityTypesPage> {
        private ListEntityTypesPage(PageContext<ListEntityTypesRequest, ListEntityTypesResponse, EntityType> context, ListEntityTypesResponse response) {
            super(context, (Object)response);
        }

        private static ListEntityTypesPage createEmptyPage() {
            return new ListEntityTypesPage(null, null);
        }

        protected ListEntityTypesPage createPage(PageContext<ListEntityTypesRequest, ListEntityTypesResponse, EntityType> context, ListEntityTypesResponse response) {
            return new ListEntityTypesPage(context, response);
        }

        public ApiFuture<ListEntityTypesPage> createPageAsync(PageContext<ListEntityTypesRequest, ListEntityTypesResponse, EntityType> context, ApiFuture<ListEntityTypesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListEntityTypesPagedResponse
    extends AbstractPagedListResponse<ListEntityTypesRequest, ListEntityTypesResponse, EntityType, ListEntityTypesPage, ListEntityTypesFixedSizeCollection> {
        public static ApiFuture<ListEntityTypesPagedResponse> createAsync(PageContext<ListEntityTypesRequest, ListEntityTypesResponse, EntityType> context, ApiFuture<ListEntityTypesResponse> futureResponse) {
            ApiFuture<ListEntityTypesPage> futurePage = ListEntityTypesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListEntityTypesPage, ListEntityTypesPagedResponse>(){

                public ListEntityTypesPagedResponse apply(ListEntityTypesPage input) {
                    return new ListEntityTypesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListEntityTypesPagedResponse(ListEntityTypesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListEntityTypesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListFeaturestoresFixedSizeCollection
    extends AbstractFixedSizeCollection<ListFeaturestoresRequest, ListFeaturestoresResponse, Featurestore, ListFeaturestoresPage, ListFeaturestoresFixedSizeCollection> {
        private ListFeaturestoresFixedSizeCollection(List<ListFeaturestoresPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFeaturestoresFixedSizeCollection createEmptyCollection() {
            return new ListFeaturestoresFixedSizeCollection(null, 0);
        }

        protected ListFeaturestoresFixedSizeCollection createCollection(List<ListFeaturestoresPage> pages, int collectionSize) {
            return new ListFeaturestoresFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListFeaturestoresPage
    extends AbstractPage<ListFeaturestoresRequest, ListFeaturestoresResponse, Featurestore, ListFeaturestoresPage> {
        private ListFeaturestoresPage(PageContext<ListFeaturestoresRequest, ListFeaturestoresResponse, Featurestore> context, ListFeaturestoresResponse response) {
            super(context, (Object)response);
        }

        private static ListFeaturestoresPage createEmptyPage() {
            return new ListFeaturestoresPage(null, null);
        }

        protected ListFeaturestoresPage createPage(PageContext<ListFeaturestoresRequest, ListFeaturestoresResponse, Featurestore> context, ListFeaturestoresResponse response) {
            return new ListFeaturestoresPage(context, response);
        }

        public ApiFuture<ListFeaturestoresPage> createPageAsync(PageContext<ListFeaturestoresRequest, ListFeaturestoresResponse, Featurestore> context, ApiFuture<ListFeaturestoresResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListFeaturestoresPagedResponse
    extends AbstractPagedListResponse<ListFeaturestoresRequest, ListFeaturestoresResponse, Featurestore, ListFeaturestoresPage, ListFeaturestoresFixedSizeCollection> {
        public static ApiFuture<ListFeaturestoresPagedResponse> createAsync(PageContext<ListFeaturestoresRequest, ListFeaturestoresResponse, Featurestore> context, ApiFuture<ListFeaturestoresResponse> futureResponse) {
            ApiFuture<ListFeaturestoresPage> futurePage = ListFeaturestoresPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListFeaturestoresPage, ListFeaturestoresPagedResponse>(){

                public ListFeaturestoresPagedResponse apply(ListFeaturestoresPage input) {
                    return new ListFeaturestoresPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListFeaturestoresPagedResponse(ListFeaturestoresPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFeaturestoresFixedSizeCollection.createEmptyCollection());
        }
    }
}

