/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1.CreateEndpointOperationMetadata;
import com.google.cloud.aiplatform.v1.CreateEndpointRequest;
import com.google.cloud.aiplatform.v1.DeleteEndpointRequest;
import com.google.cloud.aiplatform.v1.DeleteOperationMetadata;
import com.google.cloud.aiplatform.v1.DeployModelOperationMetadata;
import com.google.cloud.aiplatform.v1.DeployModelRequest;
import com.google.cloud.aiplatform.v1.DeployModelResponse;
import com.google.cloud.aiplatform.v1.Endpoint;
import com.google.cloud.aiplatform.v1.EndpointServiceClient;
import com.google.cloud.aiplatform.v1.GetEndpointRequest;
import com.google.cloud.aiplatform.v1.ListEndpointsRequest;
import com.google.cloud.aiplatform.v1.ListEndpointsResponse;
import com.google.cloud.aiplatform.v1.UndeployModelOperationMetadata;
import com.google.cloud.aiplatform.v1.UndeployModelRequest;
import com.google.cloud.aiplatform.v1.UndeployModelResponse;
import com.google.cloud.aiplatform.v1.UpdateEndpointRequest;
import com.google.cloud.aiplatform.v1.stub.EndpointServiceStub;
import com.google.cloud.aiplatform.v1.stub.EndpointServiceStubSettings;
import com.google.cloud.aiplatform.v1.stub.GrpcEndpointServiceCallableFactory;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GrpcEndpointServiceStub
extends EndpointServiceStub {
    private static final MethodDescriptor<CreateEndpointRequest, Operation> createEndpointMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.EndpointService/CreateEndpoint").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateEndpointRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<GetEndpointRequest, Endpoint> getEndpointMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.EndpointService/GetEndpoint").setRequestMarshaller(ProtoUtils.marshaller((Message)GetEndpointRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Endpoint.getDefaultInstance())).build();
    private static final MethodDescriptor<ListEndpointsRequest, ListEndpointsResponse> listEndpointsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.EndpointService/ListEndpoints").setRequestMarshaller(ProtoUtils.marshaller((Message)ListEndpointsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListEndpointsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateEndpointRequest, Endpoint> updateEndpointMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.EndpointService/UpdateEndpoint").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateEndpointRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Endpoint.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteEndpointRequest, Operation> deleteEndpointMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.EndpointService/DeleteEndpoint").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteEndpointRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeployModelRequest, Operation> deployModelMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.EndpointService/DeployModel").setRequestMarshaller(ProtoUtils.marshaller((Message)DeployModelRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<UndeployModelRequest, Operation> undeployModelMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.EndpointService/UndeployModel").setRequestMarshaller(ProtoUtils.marshaller((Message)UndeployModelRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private final UnaryCallable<CreateEndpointRequest, Operation> createEndpointCallable;
    private final OperationCallable<CreateEndpointRequest, Endpoint, CreateEndpointOperationMetadata> createEndpointOperationCallable;
    private final UnaryCallable<GetEndpointRequest, Endpoint> getEndpointCallable;
    private final UnaryCallable<ListEndpointsRequest, ListEndpointsResponse> listEndpointsCallable;
    private final UnaryCallable<ListEndpointsRequest, EndpointServiceClient.ListEndpointsPagedResponse> listEndpointsPagedCallable;
    private final UnaryCallable<UpdateEndpointRequest, Endpoint> updateEndpointCallable;
    private final UnaryCallable<DeleteEndpointRequest, Operation> deleteEndpointCallable;
    private final OperationCallable<DeleteEndpointRequest, Empty, DeleteOperationMetadata> deleteEndpointOperationCallable;
    private final UnaryCallable<DeployModelRequest, Operation> deployModelCallable;
    private final OperationCallable<DeployModelRequest, DeployModelResponse, DeployModelOperationMetadata> deployModelOperationCallable;
    private final UnaryCallable<UndeployModelRequest, Operation> undeployModelCallable;
    private final OperationCallable<UndeployModelRequest, UndeployModelResponse, UndeployModelOperationMetadata> undeployModelOperationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcEndpointServiceStub create(EndpointServiceStubSettings settings) throws IOException {
        return new GrpcEndpointServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcEndpointServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcEndpointServiceStub(EndpointServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcEndpointServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcEndpointServiceStub(EndpointServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcEndpointServiceStub(EndpointServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcEndpointServiceCallableFactory());
    }

    protected GrpcEndpointServiceStub(EndpointServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createEndpointTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createEndpointMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<CreateEndpointRequest>(){

            public Map<String, String> extract(CreateEndpointRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings getEndpointTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getEndpointMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetEndpointRequest>(){

            public Map<String, String> extract(GetEndpointRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings listEndpointsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listEndpointsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ListEndpointsRequest>(){

            public Map<String, String> extract(ListEndpointsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings updateEndpointTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateEndpointMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<UpdateEndpointRequest>(){

            public Map<String, String> extract(UpdateEndpointRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"endpoint.name", (Object)String.valueOf(request.getEndpoint().getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings deleteEndpointTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteEndpointMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<DeleteEndpointRequest>(){

            public Map<String, String> extract(DeleteEndpointRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings deployModelTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deployModelMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<DeployModelRequest>(){

            public Map<String, String> extract(DeployModelRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"endpoint", (Object)String.valueOf(request.getEndpoint()));
                return params.build();
            }
        }).build();
        GrpcCallSettings undeployModelTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(undeployModelMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<UndeployModelRequest>(){

            public Map<String, String> extract(UndeployModelRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"endpoint", (Object)String.valueOf(request.getEndpoint()));
                return params.build();
            }
        }).build();
        this.createEndpointCallable = callableFactory.createUnaryCallable(createEndpointTransportSettings, settings.createEndpointSettings(), clientContext);
        this.createEndpointOperationCallable = callableFactory.createOperationCallable(createEndpointTransportSettings, settings.createEndpointOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getEndpointCallable = callableFactory.createUnaryCallable(getEndpointTransportSettings, settings.getEndpointSettings(), clientContext);
        this.listEndpointsCallable = callableFactory.createUnaryCallable(listEndpointsTransportSettings, settings.listEndpointsSettings(), clientContext);
        this.listEndpointsPagedCallable = callableFactory.createPagedCallable(listEndpointsTransportSettings, settings.listEndpointsSettings(), clientContext);
        this.updateEndpointCallable = callableFactory.createUnaryCallable(updateEndpointTransportSettings, settings.updateEndpointSettings(), clientContext);
        this.deleteEndpointCallable = callableFactory.createUnaryCallable(deleteEndpointTransportSettings, settings.deleteEndpointSettings(), clientContext);
        this.deleteEndpointOperationCallable = callableFactory.createOperationCallable(deleteEndpointTransportSettings, settings.deleteEndpointOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deployModelCallable = callableFactory.createUnaryCallable(deployModelTransportSettings, settings.deployModelSettings(), clientContext);
        this.deployModelOperationCallable = callableFactory.createOperationCallable(deployModelTransportSettings, settings.deployModelOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.undeployModelCallable = callableFactory.createUnaryCallable(undeployModelTransportSettings, settings.undeployModelSettings(), clientContext);
        this.undeployModelOperationCallable = callableFactory.createOperationCallable(undeployModelTransportSettings, settings.undeployModelOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateEndpointRequest, Operation> createEndpointCallable() {
        return this.createEndpointCallable;
    }

    @Override
    public OperationCallable<CreateEndpointRequest, Endpoint, CreateEndpointOperationMetadata> createEndpointOperationCallable() {
        return this.createEndpointOperationCallable;
    }

    @Override
    public UnaryCallable<GetEndpointRequest, Endpoint> getEndpointCallable() {
        return this.getEndpointCallable;
    }

    @Override
    public UnaryCallable<ListEndpointsRequest, ListEndpointsResponse> listEndpointsCallable() {
        return this.listEndpointsCallable;
    }

    @Override
    public UnaryCallable<ListEndpointsRequest, EndpointServiceClient.ListEndpointsPagedResponse> listEndpointsPagedCallable() {
        return this.listEndpointsPagedCallable;
    }

    @Override
    public UnaryCallable<UpdateEndpointRequest, Endpoint> updateEndpointCallable() {
        return this.updateEndpointCallable;
    }

    @Override
    public UnaryCallable<DeleteEndpointRequest, Operation> deleteEndpointCallable() {
        return this.deleteEndpointCallable;
    }

    @Override
    public OperationCallable<DeleteEndpointRequest, Empty, DeleteOperationMetadata> deleteEndpointOperationCallable() {
        return this.deleteEndpointOperationCallable;
    }

    @Override
    public UnaryCallable<DeployModelRequest, Operation> deployModelCallable() {
        return this.deployModelCallable;
    }

    @Override
    public OperationCallable<DeployModelRequest, DeployModelResponse, DeployModelOperationMetadata> deployModelOperationCallable() {
        return this.deployModelOperationCallable;
    }

    @Override
    public UnaryCallable<UndeployModelRequest, Operation> undeployModelCallable() {
        return this.undeployModelCallable;
    }

    @Override
    public OperationCallable<UndeployModelRequest, UndeployModelResponse, UndeployModelOperationMetadata> undeployModelOperationCallable() {
        return this.undeployModelOperationCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

