/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1.CancelTrainingPipelineRequest;
import com.google.cloud.aiplatform.v1.CreateTrainingPipelineRequest;
import com.google.cloud.aiplatform.v1.DeleteOperationMetadata;
import com.google.cloud.aiplatform.v1.DeleteTrainingPipelineRequest;
import com.google.cloud.aiplatform.v1.GetTrainingPipelineRequest;
import com.google.cloud.aiplatform.v1.ListTrainingPipelinesRequest;
import com.google.cloud.aiplatform.v1.ListTrainingPipelinesResponse;
import com.google.cloud.aiplatform.v1.PipelineServiceClient;
import com.google.cloud.aiplatform.v1.TrainingPipeline;
import com.google.cloud.aiplatform.v1.stub.GrpcPipelineServiceStub;
import com.google.cloud.aiplatform.v1.stub.PipelineServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class PipelineServiceStubSettings
extends StubSettings<PipelineServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateTrainingPipelineRequest, TrainingPipeline> createTrainingPipelineSettings;
    private final UnaryCallSettings<GetTrainingPipelineRequest, TrainingPipeline> getTrainingPipelineSettings;
    private final PagedCallSettings<ListTrainingPipelinesRequest, ListTrainingPipelinesResponse, PipelineServiceClient.ListTrainingPipelinesPagedResponse> listTrainingPipelinesSettings;
    private final UnaryCallSettings<DeleteTrainingPipelineRequest, Operation> deleteTrainingPipelineSettings;
    private final OperationCallSettings<DeleteTrainingPipelineRequest, Empty, DeleteOperationMetadata> deleteTrainingPipelineOperationSettings;
    private final UnaryCallSettings<CancelTrainingPipelineRequest, Empty> cancelTrainingPipelineSettings;
    private static final PagedListDescriptor<ListTrainingPipelinesRequest, ListTrainingPipelinesResponse, TrainingPipeline> LIST_TRAINING_PIPELINES_PAGE_STR_DESC = new PagedListDescriptor<ListTrainingPipelinesRequest, ListTrainingPipelinesResponse, TrainingPipeline>(){

        public String emptyToken() {
            return "";
        }

        public ListTrainingPipelinesRequest injectToken(ListTrainingPipelinesRequest payload, String token) {
            return ListTrainingPipelinesRequest.newBuilder((ListTrainingPipelinesRequest)payload).setPageToken(token).build();
        }

        public ListTrainingPipelinesRequest injectPageSize(ListTrainingPipelinesRequest payload, int pageSize) {
            return ListTrainingPipelinesRequest.newBuilder((ListTrainingPipelinesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListTrainingPipelinesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListTrainingPipelinesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<TrainingPipeline> extractResources(ListTrainingPipelinesResponse payload) {
            return payload.getTrainingPipelinesList() == null ? ImmutableList.of() : payload.getTrainingPipelinesList();
        }
    };
    private static final PagedListResponseFactory<ListTrainingPipelinesRequest, ListTrainingPipelinesResponse, PipelineServiceClient.ListTrainingPipelinesPagedResponse> LIST_TRAINING_PIPELINES_PAGE_STR_FACT = new PagedListResponseFactory<ListTrainingPipelinesRequest, ListTrainingPipelinesResponse, PipelineServiceClient.ListTrainingPipelinesPagedResponse>(){

        public ApiFuture<PipelineServiceClient.ListTrainingPipelinesPagedResponse> getFuturePagedResponse(UnaryCallable<ListTrainingPipelinesRequest, ListTrainingPipelinesResponse> callable, ListTrainingPipelinesRequest request, ApiCallContext context, ApiFuture<ListTrainingPipelinesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TRAINING_PIPELINES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return PipelineServiceClient.ListTrainingPipelinesPagedResponse.createAsync((PageContext<ListTrainingPipelinesRequest, ListTrainingPipelinesResponse, TrainingPipeline>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateTrainingPipelineRequest, TrainingPipeline> createTrainingPipelineSettings() {
        return this.createTrainingPipelineSettings;
    }

    public UnaryCallSettings<GetTrainingPipelineRequest, TrainingPipeline> getTrainingPipelineSettings() {
        return this.getTrainingPipelineSettings;
    }

    public PagedCallSettings<ListTrainingPipelinesRequest, ListTrainingPipelinesResponse, PipelineServiceClient.ListTrainingPipelinesPagedResponse> listTrainingPipelinesSettings() {
        return this.listTrainingPipelinesSettings;
    }

    public UnaryCallSettings<DeleteTrainingPipelineRequest, Operation> deleteTrainingPipelineSettings() {
        return this.deleteTrainingPipelineSettings;
    }

    public OperationCallSettings<DeleteTrainingPipelineRequest, Empty, DeleteOperationMetadata> deleteTrainingPipelineOperationSettings() {
        return this.deleteTrainingPipelineOperationSettings;
    }

    public UnaryCallSettings<CancelTrainingPipelineRequest, Empty> cancelTrainingPipelineSettings() {
        return this.cancelTrainingPipelineSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public PipelineServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcPipelineServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "aiplatform.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return PipelineServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(PipelineServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected PipelineServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createTrainingPipelineSettings = settingsBuilder.createTrainingPipelineSettings().build();
        this.getTrainingPipelineSettings = settingsBuilder.getTrainingPipelineSettings().build();
        this.listTrainingPipelinesSettings = settingsBuilder.listTrainingPipelinesSettings().build();
        this.deleteTrainingPipelineSettings = settingsBuilder.deleteTrainingPipelineSettings().build();
        this.deleteTrainingPipelineOperationSettings = settingsBuilder.deleteTrainingPipelineOperationSettings().build();
        this.cancelTrainingPipelineSettings = settingsBuilder.cancelTrainingPipelineSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<PipelineServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateTrainingPipelineRequest, TrainingPipeline> createTrainingPipelineSettings;
        private final UnaryCallSettings.Builder<GetTrainingPipelineRequest, TrainingPipeline> getTrainingPipelineSettings;
        private final PagedCallSettings.Builder<ListTrainingPipelinesRequest, ListTrainingPipelinesResponse, PipelineServiceClient.ListTrainingPipelinesPagedResponse> listTrainingPipelinesSettings;
        private final UnaryCallSettings.Builder<DeleteTrainingPipelineRequest, Operation> deleteTrainingPipelineSettings;
        private final OperationCallSettings.Builder<DeleteTrainingPipelineRequest, Empty, DeleteOperationMetadata> deleteTrainingPipelineOperationSettings;
        private final UnaryCallSettings.Builder<CancelTrainingPipelineRequest, Empty> cancelTrainingPipelineSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createTrainingPipelineSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getTrainingPipelineSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listTrainingPipelinesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TRAINING_PIPELINES_PAGE_STR_FACT);
            this.deleteTrainingPipelineSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteTrainingPipelineOperationSettings = OperationCallSettings.newBuilder();
            this.cancelTrainingPipelineSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createTrainingPipelineSettings, this.getTrainingPipelineSettings, this.listTrainingPipelinesSettings, this.deleteTrainingPipelineSettings, this.cancelTrainingPipelineSettings);
            Builder.initDefaults(this);
        }

        protected Builder(PipelineServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createTrainingPipelineSettings = settings.createTrainingPipelineSettings.toBuilder();
            this.getTrainingPipelineSettings = settings.getTrainingPipelineSettings.toBuilder();
            this.listTrainingPipelinesSettings = settings.listTrainingPipelinesSettings.toBuilder();
            this.deleteTrainingPipelineSettings = settings.deleteTrainingPipelineSettings.toBuilder();
            this.deleteTrainingPipelineOperationSettings = settings.deleteTrainingPipelineOperationSettings.toBuilder();
            this.cancelTrainingPipelineSettings = settings.cancelTrainingPipelineSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createTrainingPipelineSettings, this.getTrainingPipelineSettings, this.listTrainingPipelinesSettings, this.deleteTrainingPipelineSettings, this.cancelTrainingPipelineSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(PipelineServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)PipelineServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)PipelineServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(PipelineServiceStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createTrainingPipelineSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_4_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_4_params"));
            builder.getTrainingPipelineSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_4_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_4_params"));
            builder.listTrainingPipelinesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_4_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_4_params"));
            builder.deleteTrainingPipelineSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_4_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_4_params"));
            builder.cancelTrainingPipelineSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_4_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_4_params"));
            builder.deleteTrainingPipelineOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_4_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_4_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(DeleteOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateTrainingPipelineRequest, TrainingPipeline> createTrainingPipelineSettings() {
            return this.createTrainingPipelineSettings;
        }

        public UnaryCallSettings.Builder<GetTrainingPipelineRequest, TrainingPipeline> getTrainingPipelineSettings() {
            return this.getTrainingPipelineSettings;
        }

        public PagedCallSettings.Builder<ListTrainingPipelinesRequest, ListTrainingPipelinesResponse, PipelineServiceClient.ListTrainingPipelinesPagedResponse> listTrainingPipelinesSettings() {
            return this.listTrainingPipelinesSettings;
        }

        public UnaryCallSettings.Builder<DeleteTrainingPipelineRequest, Operation> deleteTrainingPipelineSettings() {
            return this.deleteTrainingPipelineSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteTrainingPipelineRequest, Empty, DeleteOperationMetadata> deleteTrainingPipelineOperationSettings() {
            return this.deleteTrainingPipelineOperationSettings;
        }

        public UnaryCallSettings.Builder<CancelTrainingPipelineRequest, Empty> cancelTrainingPipelineSettings() {
            return this.cancelTrainingPipelineSettings;
        }

        public PipelineServiceStubSettings build() throws IOException {
            return new PipelineServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_4_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)5000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)5000L)).setTotalTimeout(Duration.ofMillis((long)5000L)).build();
            definitions.put((Object)"no_retry_4_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

