/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.advisorynotifications.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.advisorynotifications.v1.AdvisoryNotificationsServiceClient;
import com.google.cloud.advisorynotifications.v1.GetNotificationRequest;
import com.google.cloud.advisorynotifications.v1.GetSettingsRequest;
import com.google.cloud.advisorynotifications.v1.ListNotificationsRequest;
import com.google.cloud.advisorynotifications.v1.ListNotificationsResponse;
import com.google.cloud.advisorynotifications.v1.Notification;
import com.google.cloud.advisorynotifications.v1.Settings;
import com.google.cloud.advisorynotifications.v1.UpdateSettingsRequest;
import com.google.cloud.advisorynotifications.v1.stub.AdvisoryNotificationsServiceStub;
import com.google.cloud.advisorynotifications.v1.stub.AdvisoryNotificationsServiceStubSettings;
import com.google.cloud.advisorynotifications.v1.stub.HttpJsonAdvisoryNotificationsServiceCallableFactory;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonAdvisoryNotificationsServiceStub
extends AdvisoryNotificationsServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<ListNotificationsRequest, ListNotificationsResponse> listNotificationsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.advisorynotifications.v1.AdvisoryNotificationsService/ListNotifications").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=organizations/*/locations/*}/notifications", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{parent=projects/*/locations/*}/notifications"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "languageCode", (Object)request.getLanguageCode());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "view", (Object)request.getViewValue());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListNotificationsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetNotificationRequest, Notification> getNotificationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.advisorynotifications.v1.AdvisoryNotificationsService/GetNotification").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=organizations/*/locations/*/notifications/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{name=projects/*/locations/*/notifications/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "languageCode", (Object)request.getLanguageCode());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Notification.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetSettingsRequest, Settings> getSettingsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.advisorynotifications.v1.AdvisoryNotificationsService/GetSettings").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=organizations/*/locations/*/settings}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Settings.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateSettingsRequest, Settings> updateSettingsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.advisorynotifications.v1.AdvisoryNotificationsService/UpdateSettings").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{settings.name=organizations/*/locations/*/settings}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "settings.name", (Object)request.getSettings().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("settings", (Message)request.getSettings(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Settings.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<ListNotificationsRequest, ListNotificationsResponse> listNotificationsCallable;
    private final UnaryCallable<ListNotificationsRequest, AdvisoryNotificationsServiceClient.ListNotificationsPagedResponse> listNotificationsPagedCallable;
    private final UnaryCallable<GetNotificationRequest, Notification> getNotificationCallable;
    private final UnaryCallable<GetSettingsRequest, Settings> getSettingsCallable;
    private final UnaryCallable<UpdateSettingsRequest, Settings> updateSettingsCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonAdvisoryNotificationsServiceStub create(AdvisoryNotificationsServiceStubSettings settings) throws IOException {
        return new HttpJsonAdvisoryNotificationsServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonAdvisoryNotificationsServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonAdvisoryNotificationsServiceStub(AdvisoryNotificationsServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonAdvisoryNotificationsServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonAdvisoryNotificationsServiceStub(AdvisoryNotificationsServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonAdvisoryNotificationsServiceStub(AdvisoryNotificationsServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonAdvisoryNotificationsServiceCallableFactory());
    }

    protected HttpJsonAdvisoryNotificationsServiceStub(AdvisoryNotificationsServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings listNotificationsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listNotificationsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getNotificationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getNotificationMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getSettingsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getSettingsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateSettingsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateSettingsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("settings.name", String.valueOf(request.getSettings().getName()));
            return builder.build();
        }).build();
        this.listNotificationsCallable = callableFactory.createUnaryCallable(listNotificationsTransportSettings, settings.listNotificationsSettings(), clientContext);
        this.listNotificationsPagedCallable = callableFactory.createPagedCallable(listNotificationsTransportSettings, settings.listNotificationsSettings(), clientContext);
        this.getNotificationCallable = callableFactory.createUnaryCallable(getNotificationTransportSettings, settings.getNotificationSettings(), clientContext);
        this.getSettingsCallable = callableFactory.createUnaryCallable(getSettingsTransportSettings, settings.getSettingsSettings(), clientContext);
        this.updateSettingsCallable = callableFactory.createUnaryCallable(updateSettingsTransportSettings, settings.updateSettingsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(listNotificationsMethodDescriptor);
        methodDescriptors.add(getNotificationMethodDescriptor);
        methodDescriptors.add(getSettingsMethodDescriptor);
        methodDescriptors.add(updateSettingsMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<ListNotificationsRequest, ListNotificationsResponse> listNotificationsCallable() {
        return this.listNotificationsCallable;
    }

    @Override
    public UnaryCallable<ListNotificationsRequest, AdvisoryNotificationsServiceClient.ListNotificationsPagedResponse> listNotificationsPagedCallable() {
        return this.listNotificationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetNotificationRequest, Notification> getNotificationCallable() {
        return this.getNotificationCallable;
    }

    @Override
    public UnaryCallable<GetSettingsRequest, Settings> getSettingsCallable() {
        return this.getSettingsCallable;
    }

    @Override
    public UnaryCallable<UpdateSettingsRequest, Settings> updateSettingsCallable() {
        return this.updateSettingsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

