/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.accessapproval.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.accessapproval.v1.AccessApprovalAdminClient;
import com.google.cloud.accessapproval.v1.AccessApprovalServiceAccount;
import com.google.cloud.accessapproval.v1.AccessApprovalSettings;
import com.google.cloud.accessapproval.v1.ApprovalRequest;
import com.google.cloud.accessapproval.v1.ApproveApprovalRequestMessage;
import com.google.cloud.accessapproval.v1.DeleteAccessApprovalSettingsMessage;
import com.google.cloud.accessapproval.v1.DismissApprovalRequestMessage;
import com.google.cloud.accessapproval.v1.GetAccessApprovalServiceAccountMessage;
import com.google.cloud.accessapproval.v1.GetAccessApprovalSettingsMessage;
import com.google.cloud.accessapproval.v1.GetApprovalRequestMessage;
import com.google.cloud.accessapproval.v1.InvalidateApprovalRequestMessage;
import com.google.cloud.accessapproval.v1.ListApprovalRequestsMessage;
import com.google.cloud.accessapproval.v1.ListApprovalRequestsResponse;
import com.google.cloud.accessapproval.v1.UpdateAccessApprovalSettingsMessage;
import com.google.cloud.accessapproval.v1.stub.AccessApprovalStub;
import com.google.cloud.accessapproval.v1.stub.GrpcAccessApprovalStub;
import com.google.cloud.accessapproval.v1.stub.HttpJsonAccessApprovalStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class AccessApprovalStubSettings
extends StubSettings<AccessApprovalStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListApprovalRequestsMessage, ListApprovalRequestsResponse, AccessApprovalAdminClient.ListApprovalRequestsPagedResponse> listApprovalRequestsSettings;
    private final UnaryCallSettings<GetApprovalRequestMessage, ApprovalRequest> getApprovalRequestSettings;
    private final UnaryCallSettings<ApproveApprovalRequestMessage, ApprovalRequest> approveApprovalRequestSettings;
    private final UnaryCallSettings<DismissApprovalRequestMessage, ApprovalRequest> dismissApprovalRequestSettings;
    private final UnaryCallSettings<InvalidateApprovalRequestMessage, ApprovalRequest> invalidateApprovalRequestSettings;
    private final UnaryCallSettings<GetAccessApprovalSettingsMessage, AccessApprovalSettings> getAccessApprovalSettingsSettings;
    private final UnaryCallSettings<UpdateAccessApprovalSettingsMessage, AccessApprovalSettings> updateAccessApprovalSettingsSettings;
    private final UnaryCallSettings<DeleteAccessApprovalSettingsMessage, Empty> deleteAccessApprovalSettingsSettings;
    private final UnaryCallSettings<GetAccessApprovalServiceAccountMessage, AccessApprovalServiceAccount> getAccessApprovalServiceAccountSettings;
    private static final PagedListDescriptor<ListApprovalRequestsMessage, ListApprovalRequestsResponse, ApprovalRequest> LIST_APPROVAL_REQUESTS_PAGE_STR_DESC = new PagedListDescriptor<ListApprovalRequestsMessage, ListApprovalRequestsResponse, ApprovalRequest>(){

        public String emptyToken() {
            return "";
        }

        public ListApprovalRequestsMessage injectToken(ListApprovalRequestsMessage payload, String token) {
            return ListApprovalRequestsMessage.newBuilder((ListApprovalRequestsMessage)payload).setPageToken(token).build();
        }

        public ListApprovalRequestsMessage injectPageSize(ListApprovalRequestsMessage payload, int pageSize) {
            return ListApprovalRequestsMessage.newBuilder((ListApprovalRequestsMessage)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListApprovalRequestsMessage payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListApprovalRequestsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ApprovalRequest> extractResources(ListApprovalRequestsResponse payload) {
            return payload.getApprovalRequestsList() == null ? ImmutableList.of() : payload.getApprovalRequestsList();
        }
    };
    private static final PagedListResponseFactory<ListApprovalRequestsMessage, ListApprovalRequestsResponse, AccessApprovalAdminClient.ListApprovalRequestsPagedResponse> LIST_APPROVAL_REQUESTS_PAGE_STR_FACT = new PagedListResponseFactory<ListApprovalRequestsMessage, ListApprovalRequestsResponse, AccessApprovalAdminClient.ListApprovalRequestsPagedResponse>(){

        public ApiFuture<AccessApprovalAdminClient.ListApprovalRequestsPagedResponse> getFuturePagedResponse(UnaryCallable<ListApprovalRequestsMessage, ListApprovalRequestsResponse> callable, ListApprovalRequestsMessage request, ApiCallContext context, ApiFuture<ListApprovalRequestsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_APPROVAL_REQUESTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AccessApprovalAdminClient.ListApprovalRequestsPagedResponse.createAsync((PageContext<ListApprovalRequestsMessage, ListApprovalRequestsResponse, ApprovalRequest>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListApprovalRequestsMessage, ListApprovalRequestsResponse, AccessApprovalAdminClient.ListApprovalRequestsPagedResponse> listApprovalRequestsSettings() {
        return this.listApprovalRequestsSettings;
    }

    public UnaryCallSettings<GetApprovalRequestMessage, ApprovalRequest> getApprovalRequestSettings() {
        return this.getApprovalRequestSettings;
    }

    public UnaryCallSettings<ApproveApprovalRequestMessage, ApprovalRequest> approveApprovalRequestSettings() {
        return this.approveApprovalRequestSettings;
    }

    public UnaryCallSettings<DismissApprovalRequestMessage, ApprovalRequest> dismissApprovalRequestSettings() {
        return this.dismissApprovalRequestSettings;
    }

    public UnaryCallSettings<InvalidateApprovalRequestMessage, ApprovalRequest> invalidateApprovalRequestSettings() {
        return this.invalidateApprovalRequestSettings;
    }

    public UnaryCallSettings<GetAccessApprovalSettingsMessage, AccessApprovalSettings> getAccessApprovalSettingsSettings() {
        return this.getAccessApprovalSettingsSettings;
    }

    public UnaryCallSettings<UpdateAccessApprovalSettingsMessage, AccessApprovalSettings> updateAccessApprovalSettingsSettings() {
        return this.updateAccessApprovalSettingsSettings;
    }

    public UnaryCallSettings<DeleteAccessApprovalSettingsMessage, Empty> deleteAccessApprovalSettingsSettings() {
        return this.deleteAccessApprovalSettingsSettings;
    }

    public UnaryCallSettings<GetAccessApprovalServiceAccountMessage, AccessApprovalServiceAccount> getAccessApprovalServiceAccountSettings() {
        return this.getAccessApprovalServiceAccountSettings;
    }

    public AccessApprovalStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcAccessApprovalStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonAccessApprovalStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "accessapproval";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "accessapproval.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "accessapproval.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return AccessApprovalStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AccessApprovalStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AccessApprovalStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return AccessApprovalStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected AccessApprovalStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listApprovalRequestsSettings = settingsBuilder.listApprovalRequestsSettings().build();
        this.getApprovalRequestSettings = settingsBuilder.getApprovalRequestSettings().build();
        this.approveApprovalRequestSettings = settingsBuilder.approveApprovalRequestSettings().build();
        this.dismissApprovalRequestSettings = settingsBuilder.dismissApprovalRequestSettings().build();
        this.invalidateApprovalRequestSettings = settingsBuilder.invalidateApprovalRequestSettings().build();
        this.getAccessApprovalSettingsSettings = settingsBuilder.getAccessApprovalSettingsSettings().build();
        this.updateAccessApprovalSettingsSettings = settingsBuilder.updateAccessApprovalSettingsSettings().build();
        this.deleteAccessApprovalSettingsSettings = settingsBuilder.deleteAccessApprovalSettingsSettings().build();
        this.getAccessApprovalServiceAccountSettings = settingsBuilder.getAccessApprovalServiceAccountSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<AccessApprovalStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListApprovalRequestsMessage, ListApprovalRequestsResponse, AccessApprovalAdminClient.ListApprovalRequestsPagedResponse> listApprovalRequestsSettings;
        private final UnaryCallSettings.Builder<GetApprovalRequestMessage, ApprovalRequest> getApprovalRequestSettings;
        private final UnaryCallSettings.Builder<ApproveApprovalRequestMessage, ApprovalRequest> approveApprovalRequestSettings;
        private final UnaryCallSettings.Builder<DismissApprovalRequestMessage, ApprovalRequest> dismissApprovalRequestSettings;
        private final UnaryCallSettings.Builder<InvalidateApprovalRequestMessage, ApprovalRequest> invalidateApprovalRequestSettings;
        private final UnaryCallSettings.Builder<GetAccessApprovalSettingsMessage, AccessApprovalSettings> getAccessApprovalSettingsSettings;
        private final UnaryCallSettings.Builder<UpdateAccessApprovalSettingsMessage, AccessApprovalSettings> updateAccessApprovalSettingsSettings;
        private final UnaryCallSettings.Builder<DeleteAccessApprovalSettingsMessage, Empty> deleteAccessApprovalSettingsSettings;
        private final UnaryCallSettings.Builder<GetAccessApprovalServiceAccountMessage, AccessApprovalServiceAccount> getAccessApprovalServiceAccountSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listApprovalRequestsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_APPROVAL_REQUESTS_PAGE_STR_FACT);
            this.getApprovalRequestSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.approveApprovalRequestSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.dismissApprovalRequestSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.invalidateApprovalRequestSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getAccessApprovalSettingsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateAccessApprovalSettingsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteAccessApprovalSettingsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getAccessApprovalServiceAccountSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listApprovalRequestsSettings, this.getApprovalRequestSettings, this.approveApprovalRequestSettings, this.dismissApprovalRequestSettings, this.invalidateApprovalRequestSettings, this.getAccessApprovalSettingsSettings, this.updateAccessApprovalSettingsSettings, this.deleteAccessApprovalSettingsSettings, this.getAccessApprovalServiceAccountSettings);
            Builder.initDefaults(this);
        }

        protected Builder(AccessApprovalStubSettings settings) {
            super((StubSettings)settings);
            this.listApprovalRequestsSettings = settings.listApprovalRequestsSettings.toBuilder();
            this.getApprovalRequestSettings = settings.getApprovalRequestSettings.toBuilder();
            this.approveApprovalRequestSettings = settings.approveApprovalRequestSettings.toBuilder();
            this.dismissApprovalRequestSettings = settings.dismissApprovalRequestSettings.toBuilder();
            this.invalidateApprovalRequestSettings = settings.invalidateApprovalRequestSettings.toBuilder();
            this.getAccessApprovalSettingsSettings = settings.getAccessApprovalSettingsSettings.toBuilder();
            this.updateAccessApprovalSettingsSettings = settings.updateAccessApprovalSettingsSettings.toBuilder();
            this.deleteAccessApprovalSettingsSettings = settings.deleteAccessApprovalSettingsSettings.toBuilder();
            this.getAccessApprovalServiceAccountSettings = settings.getAccessApprovalServiceAccountSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listApprovalRequestsSettings, this.getApprovalRequestSettings, this.approveApprovalRequestSettings, this.dismissApprovalRequestSettings, this.invalidateApprovalRequestSettings, this.getAccessApprovalSettingsSettings, this.updateAccessApprovalSettingsSettings, this.deleteAccessApprovalSettingsSettings, this.getAccessApprovalServiceAccountSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(AccessApprovalStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)AccessApprovalStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AccessApprovalStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(AccessApprovalStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)AccessApprovalStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)AccessApprovalStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AccessApprovalStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(AccessApprovalStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listApprovalRequestsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getApprovalRequestSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.approveApprovalRequestSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.dismissApprovalRequestSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.invalidateApprovalRequestSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getAccessApprovalSettingsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateAccessApprovalSettingsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteAccessApprovalSettingsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getAccessApprovalServiceAccountSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListApprovalRequestsMessage, ListApprovalRequestsResponse, AccessApprovalAdminClient.ListApprovalRequestsPagedResponse> listApprovalRequestsSettings() {
            return this.listApprovalRequestsSettings;
        }

        public UnaryCallSettings.Builder<GetApprovalRequestMessage, ApprovalRequest> getApprovalRequestSettings() {
            return this.getApprovalRequestSettings;
        }

        public UnaryCallSettings.Builder<ApproveApprovalRequestMessage, ApprovalRequest> approveApprovalRequestSettings() {
            return this.approveApprovalRequestSettings;
        }

        public UnaryCallSettings.Builder<DismissApprovalRequestMessage, ApprovalRequest> dismissApprovalRequestSettings() {
            return this.dismissApprovalRequestSettings;
        }

        public UnaryCallSettings.Builder<InvalidateApprovalRequestMessage, ApprovalRequest> invalidateApprovalRequestSettings() {
            return this.invalidateApprovalRequestSettings;
        }

        public UnaryCallSettings.Builder<GetAccessApprovalSettingsMessage, AccessApprovalSettings> getAccessApprovalSettingsSettings() {
            return this.getAccessApprovalSettingsSettings;
        }

        public UnaryCallSettings.Builder<UpdateAccessApprovalSettingsMessage, AccessApprovalSettings> updateAccessApprovalSettingsSettings() {
            return this.updateAccessApprovalSettingsSettings;
        }

        public UnaryCallSettings.Builder<DeleteAccessApprovalSettingsMessage, Empty> deleteAccessApprovalSettingsSettings() {
            return this.deleteAccessApprovalSettingsSettings;
        }

        public UnaryCallSettings.Builder<GetAccessApprovalServiceAccountMessage, AccessApprovalServiceAccount> getAccessApprovalServiceAccountSettings() {
            return this.getAccessApprovalServiceAccountSettings;
        }

        public AccessApprovalStubSettings build() throws IOException {
            return new AccessApprovalStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

