/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.functions.invoker;

import com.google.cloud.functions.invoker.CloudFunction;
import com.google.cloud.functions.invoker.FunctionSignatureMatcher;

public class FunctionLoader<T extends CloudFunction> {
    private final String functionTarget;
    private final ClassLoader classLoader;
    private final FunctionSignatureMatcher<T> matcher;

    public FunctionLoader(String functionTarget, ClassLoader classLoader, FunctionSignatureMatcher<T> matcher) {
        this.functionTarget = functionTarget;
        this.classLoader = classLoader;
        this.matcher = matcher;
    }

    public T loadUserFunction() throws Exception {
        Class<?> targetClass;
        int lastDotIndex = this.functionTarget.lastIndexOf(".");
        if (lastDotIndex == -1) {
            throw new ClassNotFoundException(this.functionTarget);
        }
        String targetClassName = this.functionTarget.substring(0, lastDotIndex);
        String targetMethodName = this.functionTarget.substring(lastDotIndex + 1);
        try {
            targetClass = this.classLoader.loadClass(targetClassName);
        }
        catch (ClassNotFoundException e) {
            String string = this.functionTarget;
            throw new RuntimeException(new StringBuilder(48 + String.valueOf(string).length() + String.valueOf(targetClassName).length()).append("Could not load either ").append(string).append(" (new form) or ").append(targetClassName).append(" (old form)").toString());
        }
        Object targetInstance = targetClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        return this.matcher.match(targetClass, targetInstance, targetMethodName, this.functionTarget);
    }
}

