/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.functions.invoker;

import com.google.cloud.functions.invoker.BackgroundCloudFunction;
import com.google.cloud.functions.invoker.CloudFunctionsContext;
import com.google.cloud.functions.invoker.Event;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BackgroundFunctionExecutor
extends HttpServlet {
    private final BackgroundCloudFunction function;

    public BackgroundFunctionExecutor(BackgroundCloudFunction function) {
        this.function = function;
    }

    @Override
    public void service(HttpServletRequest req, HttpServletResponse res) throws IOException {
        BufferedReader body = req.getReader();
        TypeAdapter<CloudFunctionsContext> typeAdapter = CloudFunctionsContext.typeAdapter(new Gson());
        Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)CloudFunctionsContext.class), typeAdapter).registerTypeAdapter((Type)((Object)Event.class), new Event.EventDeserializer()).create();
        Event event = gson.fromJson((Reader)body, Event.class);
        try {
            this.function.execute(event.getData(), event.getContext());
            res.setStatus(200);
        }
        catch (InvocationTargetException e) {
            res.setStatus(500);
            e.getCause().printStackTrace();
        }
    }
}

